/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.UpdateDto;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.model.docker.DockerComposeDto;
import at.letto.setupservice.model.docker.DockerComposeServiceDto;
import at.letto.setupservice.model.docker.DockerContainerDto;
import at.letto.setupservice.model.docker.DockerStatusDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.ResourcenService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.UpdateService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.WebGet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateService {
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    public SetupUpdateService setupUpdateService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private ResourcenService resourcenService;
    public DockerService dockerService;
    private static final String downloadSetup = "https://build.letto.at/download/setup";
    private static final String downloadInstall = "https://build.letto.at/download/install";
    public static final String lettoDownloadOld = "https://www.letto.at/download/letto";
    private UpdateDto updateDto = null;
    private volatile boolean loadUpdateDtoRunning = false;

    private void saveByteArrayInFile(byte[] data, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        if (data != null) {
            fos.write(data);
        }
        fos.close();
        this.analyzeService.setOwnerLetto(new File[]{f});
    }

    public String downloadCheckMd5(String url, String md5url, String zieldatei) {
        return this.downloadCheckMd5(url, md5url, new File(zieldatei));
    }

    public String downloadCheckMd5(String url, String md5url, File file) {
        File tempFile;
        block7: {
            tempFile = new File(file.getAbsolutePath() + ".spare");
            try {
                String md5 = WebGet.getUrlString((String)md5url).trim().split(" ")[0];
                if (WebGet.readFileFromURL((String)url, (File)tempFile)) {
                    String downloadMd5 = ENCRYPT.md5((File)tempFile);
                    if (!downloadMd5.equals(md5)) {
                        return "Pr\u00fcfsummenfehler beim Download von " + url;
                    }
                    break block7;
                }
                return "Cannot download File from " + url;
            }
            catch (Exception ex) {
                return "Fehler beim Download von " + url;
            }
        }
        try {
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String downloadBinary(String url, String zieldatei) {
        return this.downloadBinary(url, new File(zieldatei));
    }

    public String downloadBinary(String url, File file) {
        byte[] data = null;
        try {
            data = WebGet.getUrlByteArray((String)url);
        }
        catch (Exception ex) {
            return "Fehler beim Download von " + url;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data);
            }
            fos.close();
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String download(String url, String zieldatei) {
        return this.download(url, new File(zieldatei));
    }

    public String download(String url, File file) {
        try {
            Vector data = WebGet.getUrlStringVector((String)url);
            if (Cmd.writelnfile((Vector)data, (File)file)) {
                return "";
            }
            this.analyzeService.setOwnerLetto(new File[]{file});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.getAbsolutePath() + " kann nicht geschrieben werden!";
    }

    public String updateSetupServiceStable() {
        return this.updateSetupService("https://build.letto.at/download/setup/stable/lettosetup");
    }

    public String updateSetupServiceDaily() {
        return this.updateSetupService("https://build.letto.at/download/setup/daily/lettosetup");
    }

    public String updateSetupService(String url) {
        try {
            File p = new File(this.analyzeService.getRootPath());
            if (p.isDirectory()) {
                String msg = this.downloadCheckMd5(url + ".jar", url + ".md5", p.getAbsolutePath() + "/lettosetup.jar");
                if (msg.length() > 0) {
                    return msg;
                }
                SetupserviceApplication.restart();
                return "ok";
            }
            return "Cannot create directory " + p.getAbsolutePath();
        }
        catch (Exception ex) {
            return "Cannot download from " + url + " : " + ex.getMessage();
        }
        catch (Error ex) {
            return "Cannot download from " + url + " : " + ex.getMessage();
        }
    }

    public UpdateDto getUpdateDto() {
        if (this.updateDto == null) {
            this.loadUpdateDto();
        }
        return this.updateDto;
    }

    public void loadUpdateDtoBackground() {
        Thread t = new Thread(() -> this.loadUpdateDto());
        t.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void loadUpdateDto() {
        if (this.loadUpdateDtoRunning) {
            return;
        }
        this.loadUpdateDtoRunning = true;
        this.dockerService.calcContainerRevisions();
        try {
            UpdateDto loadedUpdateDto = new UpdateDto();
            loadedUpdateDto.setSetupRev(this.analyzeService.getRevision());
            try {
                loadedUpdateDto.setSetupRevBeta(WebGet.getUrlString((String)"https://build.letto.at/download/setup/beta/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                loadedUpdateDto.setSetupRevDaily(WebGet.getUrlString((String)"https://build.letto.at/download/setup/daily/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                loadedUpdateDto.setSetupRevStable(WebGet.getUrlString((String)"https://build.letto.at/download/setup/stable/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadedUpdateDto.setSetupLastUpdate(this.dockerService.dockerConfiguration.getSetupEnvFile().getSetupUpdate());
            this.dockerService.loadSetupYml();
            this.dockerService.loadMysqlYml();
            this.dockerService.loadLettoYml();
            DockerComposeDto mysqlYml = this.dockerService.getMysqlYml();
            DockerComposeDto setupYml = this.dockerService.getSetupYml();
            DockerComposeDto lettoYml = this.dockerService.getLettoYml();
            DockerStatusDto status = this.dockerService.getDockerStatus();
            Object composeServiceDto = null;
            Object container = null;
            HashMap<String, String> dockerRevInfo = new HashMap<String, String>();
            try {
                Pattern p = Pattern.compile("^([^=]+)=(.*)");
                for (String line : WebGet.getUrlStringVector((String)"https://build.letto.at/download/install/docker-rev-info.txt")) {
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    String cn = m.group(1).trim();
                    String rev = m.group(2).trim();
                    if (cn.length() <= 0 || rev.length() <= 0) continue;
                    dockerRevInfo.put(cn, rev);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/mysql" : this.setupUpdateService.getMysqlComposeDir(), this.microServiceConfiguration.getMysqlYmlFile().getName(), mysqlYml.serviceFromName("lettomysql"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/mysql" : this.setupUpdateService.getMysqlComposeDir(), this.microServiceConfiguration.getMysqlYmlFile().getName(), mysqlYml.serviceFromName("lettophpmyadmin"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/setup" : this.setupUpdateService.getSetupComposeDir(), this.microServiceConfiguration.getSetupYmlFile().getName(), setupYml.serviceFromName("setup"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getLettoYmlFile().getName(), lettoYml.serviceFromName("login"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getLettoYmlFile().getName(), lettoYml.serviceFromName("proxy"));
            for (SchuleEnv schule : this.dockerService.dockerConfiguration.getLettoEnvFile().getSchulen()) {
                String school = schule.school;
                DockerComposeDto schoolYml = this.dockerService.getSchoolYml(school);
                this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getSchoolYmlFile(school).getName(), schoolYml.serviceFromImage("lettoserver"));
                this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getSchoolYmlFile(school).getName(), schoolYml.serviceFromImage("letto-service-data"));
            }
            Pattern pattern = Pattern.compile("^docker-service-(.*)\\.yml$");
            String composeDirName = this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir();
            for (File f : new File(composeDirName).listFiles()) {
                String name;
                String filename = f.getName();
                Matcher m = pattern.matcher(filename);
                if (!m.find() || (name = m.group(1)).trim().length() <= 0) continue;
                DockerComposeDto yml = this.dockerService.loadServiceYml(f);
                for (DockerComposeServiceDto dto : yml.getServices()) {
                    String im = dto.getImage().trim();
                    if (!im.startsWith("lettohub/")) continue;
                    UpdateServiceDto updateServiceDto = this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, composeDirName, filename, dto);
                    updateServiceDto.setDeleteable(true);
                }
            }
            for (String name : this.dockerService.getAvailableServices()) {
                String ymlFile = "docker-service-" + name + ".yml";
                if (ymlFile == null || ymlFile.length() <= 0 || name == null || name.length() <= 0 || name.trim().length() <= 0) continue;
                boolean found = false;
                for (UpdateServiceDto dto : loadedUpdateDto.getServices()) {
                    if (!dto.getYmlFilename().trim().equalsIgnoreCase(ymlFile)) continue;
                    found = true;
                }
                if (found) continue;
                loadedUpdateDto.getAvailableServices().add(name);
            }
            this.updateDto = loadedUpdateDto;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        this.loadUpdateDtoRunning = false;
    }

    private UpdateServiceDto loadUpdateDto(UpdateDto us, DockerStatusDto status, HashMap<String, String> dockerRevInfo, String composePath, String ymlFilename, DockerComposeServiceDto composeServiceDto) {
        UpdateServiceDto ser = new UpdateServiceDto();
        ser.setComposePath(composePath);
        ser.setYmlFilename(ymlFilename);
        us.getServices().add(ser);
        if (composeServiceDto != null) {
            try {
                ser.setServicename(composeServiceDto.getName());
                ser.setImage(composeServiceDto.getImage().split(":")[0]);
                if (ser.getImage().startsWith("lettohub/")) {
                    ser.setLettohubImage(ser.getImage().substring(9));
                }
                ser.setPlan(composeServiceDto.getImage().split(":")[1]);
                ser.setContainername(composeServiceDto.getContainername());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (DockerContainerDto dc : this.dockerService.getDockerStatus().getContainers()) {
                    if (!dc.getName().equals(ser.getContainername()) || dc.getRevision() == null || dc.getRevision().length() <= 0) continue;
                    ser.setRevision(dc.getRevision());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DockerContainerDto container = null;
            try {
                container = status.container(ser.getContainername());
            }
            catch (Exception dc) {
                // empty catch block
            }
            if (!this.microServiceConfiguration.getMysqlYmlFile().exists()) {
                ser.setRunning("not installed");
            } else if (container == null) {
                ser.setRunning("not started");
            } else if (container.running() && container.healthy()) {
                ser.setRunning("running");
            } else if (container.running()) {
                ser.setRunning("unhealthy");
            } else {
                ser.setRunning("stopped");
            }
            if (ser.getLettohubImage().length() > 0) {
                String im = ser.getLettohubImage();
                if (dockerRevInfo.containsKey(im + "-daily")) {
                    ser.setDailyVersion(dockerRevInfo.get(im + "-daily"));
                }
                if (dockerRevInfo.containsKey(im + "-stable")) {
                    ser.setStableVersion(dockerRevInfo.get(im + "-stable"));
                }
                if (dockerRevInfo.containsKey(im + "-beta")) {
                    ser.setBetaVersion(dockerRevInfo.get(im + "-beta"));
                }
                if (dockerRevInfo.containsKey(im + "-latest")) {
                    ser.setLatestVersion(dockerRevInfo.get(im + "-latest"));
                }
            }
        } else {
            ser.setRunning("not installed");
        }
        return ser;
    }

    public UpdateServiceDto getService(String serviceName) {
        UpdateServiceDto service = null;
        if (this.getUpdateDto() != null) {
            for (UpdateServiceDto updateServiceDto : this.getUpdateDto().getServices()) {
                if (!updateServiceDto.getContainername().trim().equals("letto-" + serviceName)) continue;
                service = updateServiceDto;
            }
            if (service == null) {
                for (UpdateServiceDto updateServiceDto : this.getUpdateDto().getServices()) {
                    if (!updateServiceDto.getServicename().trim().equals(serviceName)) continue;
                    service = updateServiceDto;
                }
            }
        }
        return service;
    }

    public String setTag(UpdateServiceDto service, String tag) {
        Object rev = tag.trim();
        if (((String)rev).matches("^[0-9]+$") && service.getLettohubImage().length() > 0) {
            rev = "rev" + (String)rev;
        }
        if (((String)rev).length() == 0) {
            return "cannot set empty Tag! Please set revision in top of table!";
        }
        int servicePrefix = 0;
        int dataPrefix = 0;
        boolean firstservice = false;
        boolean firstdata = false;
        String actualservice = "";
        try {
            Vector data = Cmd.readfile((File)service.ymlFile());
            Vector<String> dataout = new Vector<String>();
            for (Object line : data) {
                int prefix;
                int n = prefix = ((String)(line = ((String)line).replaceAll("\\r", "").replaceAll("\\n", ""))).trim().length() > 0 ? ((String)line).indexOf(((String)line).trim().substring(0, 1)) : 0;
                if (!((String)line).trim().startsWith("#") && ((String)line).trim().length() != 0) {
                    if (!firstservice && servicePrefix == 0 && ((String)line).trim().startsWith("services:")) {
                        servicePrefix = ((String)line).indexOf("services");
                        firstservice = true;
                    } else if (firstservice) {
                        servicePrefix = prefix;
                        dataPrefix = 0;
                        firstservice = false;
                        actualservice = ((String)line).trim();
                        actualservice = actualservice.substring(0, actualservice.indexOf(":"));
                        firstdata = true;
                    } else if (servicePrefix > 0 && prefix == servicePrefix) {
                        dataPrefix = 0;
                        actualservice = ((String)line).trim();
                        actualservice = actualservice.substring(0, actualservice.indexOf(":"));
                        firstdata = true;
                    } else if (firstdata) {
                        dataPrefix = prefix;
                        firstdata = false;
                    } else if (prefix < dataPrefix) {
                        dataPrefix = 0;
                    } else if (prefix < servicePrefix) {
                        servicePrefix = 0;
                    }
                    if (servicePrefix > 0 && dataPrefix > 0 && actualservice.equals(service.getServicename()) && prefix == dataPrefix && ((String)line).trim().startsWith("image:")) {
                        line = ((String)line).substring(0, prefix) + "image: " + service.getImage() + ":" + (String)rev;
                    }
                }
                dataout.add((String)line);
            }
            Cmd.writelnfile(dataout, (File)service.ymlFile());
            return service.getYmlFilename() + " with service " + service.getServicename() + " updated tag to " + (String)rev;
        }
        catch (Exception exception) {
            return "cannot set Tag to " + tag;
        }
    }

    public String updateYml(UpdateServiceDto service) {
        return this.updateYml(null, service);
    }

    public String updateYml(CmdThread cmdThread, UpdateServiceDto service) {
        if (cmdThread != null) {
            cmdThread.htmlOut("Compose-Path: " + service.getComposePath() + " YML-File: " + service.getYmlFilename());
        }
        Object msg = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createSetupYml(cmdThread);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createMysqlYml(cmdThread);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createLettoYml(cmdThread);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            msg = this.dockerService.createYml(cmdThread, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-")) {
            Matcher m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename());
            if (m.find()) {
                String school = m.group(1);
                SchuleEnv schule = this.dockerService.getSchuleEnv(school);
                msg = this.dockerService.createSchoolYml(cmdThread, schule);
            }
        } else {
            msg = "cannot create yml for Service " + service.getServicename() + " with yml-File " + service.getYmlFilename();
            if (cmdThread != null) {
                cmdThread.htmlErr((String)msg);
            }
        }
        return msg;
    }

    public String installService(String serviceName) {
        String ymlFileName = "docker-service-" + serviceName + ".yml";
        Object msg = this.dockerService.createYml(ymlFileName);
        if (msg == null || ((String)msg).trim().length() == 0) {
            this.setupUpdateService.dockerServiceRestart(null, ymlFileName);
            msg = "Service " + serviceName + " installed and started in background. ";
        }
        File proxyFile = this.dockerService.isDockerRunning() ? new File("/opt/letto/docker/proxy/" + serviceName + ".conf") : new File(this.dockerService.getProxyPath() + "/" + serviceName + ".conf");
        Vector proxyData = this.resourcenService.loadTextFileFromResource("proxy/" + serviceName + ".conf");
        if (proxyData != null && proxyData.size() > 0) {
            Cmd.writelnfile((Vector)proxyData, (File)proxyFile);
            this.cmdService.cmdBackground("", "", new String[]{"docker restart letto-proxy"});
            msg = (String)msg + "Proxy file " + proxyFile.getAbsolutePath() + " created - proxy restarted in background.";
        }
        this.loadUpdateDto();
        return msg;
    }

    public CmdThread serviceUpdate(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        System.out.println("Update: path:" + service.getComposePath() + " yml:" + service.getYmlFilename());
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupUpdate(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlUpdate(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoUpdate(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceUpdate(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolUpdate(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceRestart(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupRestart(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlRestart(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoRestart(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceRestart(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolRestart(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceStop(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupStop(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlStop(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoStop(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceStop(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolStop(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceDelete(UpdateServiceDto service) {
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceDelete(this.dockerService.updateEP(), service.getYmlFilename());
        }
        return cmdThread;
    }

    public String updateSetup(String rev) {
        if (rev == null) {
            rev = "";
        }
        if (((String)(rev = ((String)rev).trim())).matches("^[0-9]+$")) {
            rev = "rev" + (String)rev;
        }
        if (((String)rev).length() == 0) {
            return "Cannot Update setup to nothing!";
        }
        this.dockerService.dockerConfiguration.getSetupEnvFile().setSetupUpdate((String)rev);
        this.dockerService.dockerConfiguration.saveConfiguration();
        String msg = "";
        if (((String)rev).equals("stable")) {
            msg = this.updateSetupService("https://build.letto.at/download/setup/stable/lettosetup");
        } else if (((String)rev).equals("daily")) {
            msg = this.updateSetupService("https://build.letto.at/download/setup/daily/lettosetup");
        } else if (((String)rev).equals("beta")) {
            msg = this.updateSetupService("https://build.letto.at/download/setup/beta/lettosetup");
        } else if (((String)rev).startsWith("rev")) {
            msg = this.updateSetupService("https://build.letto.at/download/setup/archiv/" + (String)rev + "/lettosetup");
        } else {
            return "Cannot Update setup to " + (String)rev + "!";
        }
        this.loadUpdateDtoBackground();
        return msg;
    }

    public String styleSetupStable() {
        try {
            if (this.updateDto.getSetupRevStable().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevStable())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleSetupDaily() {
        try {
            if (this.updateDto.getSetupRevDaily().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevDaily())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleSetupBeta() {
        try {
            if (this.updateDto.getSetupRevBeta().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevBeta())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleUpdate(String containername) {
        if (this.availableUpdate(containername)) {
            return "background-color:green;";
        }
        return "";
    }

    public boolean isAvailableUpdate() {
        try {
            for (UpdateServiceDto dto : this.updateDto.getServices()) {
                if (!this.availableUpdate(dto.getContainername()) || !dto.getRunning().equals("running")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean availableUpdate(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta") ? dto.getBetaVersion().length() > 0 && !rev.equals(dto.getBetaVersion()) : (plan.equals("daily") ? dto.getDailyVersion().length() > 0 && !rev.equals(dto.getDailyVersion()) : (plan.equals("stable") ? dto.getStableVersion().length() > 0 && !rev.equals(dto.getStableVersion()) : plan.equals("latest") && dto.getLatestVersion().length() > 0 && !rev.equals(dto.getLatestVersion())))) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String availableUpdateRevision(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta")) {
                    return dto.getBetaVersion();
                }
                if (plan.equals("daily")) {
                    return dto.getDailyVersion();
                }
                if (plan.equals("stable")) {
                    return dto.getStableVersion();
                }
                if (plan.equals("latest")) {
                    return dto.getLatestVersion();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleBetaRev(String servicename) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(servicename);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta") && dto.getBetaVersion().length() > 0 && !rev.equals(dto.getBetaVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleStableRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("stable") && dto.getStableVersion().length() > 0 && !rev.equals(dto.getStableVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleDailyRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("daily") && dto.getDailyVersion().length() > 0 && !rev.equals(dto.getDailyVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleLatestRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("latest") && dto.getLatestVersion().length() > 0 && !rev.equals(dto.getLatestVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public UpdateThread startUpdateThread(String backlink, String cmd) {
        String info = cmd;
        switch (cmd) {
            case "docker_update_restart_all": {
                info = "Update all yml-files and update and restart all containers";
                break;
            }
            case "docker_update_all_yaml": {
                info = "Update all yml-files";
                break;
            }
            case "update_stable_alltag": {
                info = "Update all tags to STABLE!";
                break;
            }
            case "update_stable_alltagupdate": {
                info = "Update all tags to STABLE and update containers!";
                break;
            }
            case "update_stable_alltagyml": {
                info = "Update all tags and yml-files to STABLE!";
                break;
            }
            case "update_stable_alltagymlupdate": {
                info = "Update all tags and yml-files to STABLE and update containers!";
                break;
            }
            case "update_daily_alltag": {
                info = "Update all tags to DAILY!";
                break;
            }
            case "update_daily_alltagupdate": {
                info = "Update all tags to DAILY and update containers!";
                break;
            }
            case "update_daily_alltagyml": {
                info = "Update all tags and yml-files to DAILY!";
                break;
            }
            case "update_daily_alltagymlupdate": {
                info = "Update all tags and yml-files to DAILY and update containers!";
            }
        }
        UpdateThread cmdThread = new UpdateThread(this, backlink, cmd, info);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public UpdateThread startUpdateThread(String backlink, String cmd, UpdateServiceDto service, String newplan) {
        Object info = cmd;
        switch (cmd) {
            case "Tag": {
                info = "Service " + service.getServicename() + " new Tag: " + newplan;
                break;
            }
            case "Beta": {
                info = "Service " + service.getServicename() + " new Tag: Beta";
                break;
            }
            case "Daily": {
                info = "Service " + service.getServicename() + " new Tag: Daily";
                break;
            }
            case "Stable": {
                info = "Service " + service.getServicename() + " new Tag: Stable";
                break;
            }
            case "Latest": {
                info = "Service " + service.getServicename() + " new Tag: Latest";
            }
        }
        UpdateThread cmdThread = new UpdateThread(this, backlink, cmd, (String)info, service, newplan);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public void setTag(String tag, CmdThread thread) {
        for (UpdateServiceDto updateServiceDto : this.getUpdateDto().getServices()) {
            if (!updateServiceDto.getImage().startsWith("lettohub/letto") || updateServiceDto.getImage().equals("lettohub/letto-mysql")) continue;
            thread.htmlOut(this.setTag(updateServiceDto, tag));
        }
        thread.htmlOut("Load Update-Information");
        this.loadUpdateDto();
    }

    public void updateAllYml(CmdThread thread) {
        thread.htmlOut("Update all yml-Files");
        this.dockerService.createAllYml(thread);
        if (!this.dockerService.getServiceStatusDto().isV12servicesOk()) {
            thread.htmlOut("install missing services");
            this.installAllMissingServices(thread);
        }
    }

    public void installAllMissingServices(CmdThread thread) {
        List installedServices = this.dockerService.getInstalledServices();
        List availableServices = this.dockerService.getAvailableServices();
        block0: for (String service : DockerService.servicesV12) {
            for (String installedService : installedServices) {
                if (!installedService.equals(service)) continue;
                continue block0;
            }
            thread.htmlOut("install Service " + service);
            this.installService(service);
            thread.htmlOut("start Service " + service);
            String cmdCd = "cd " + this.dockerService.getLettoComposeDir();
            String cmdStart = "docker compose -f docker-service-" + service + ".yml up -d";
            thread.runCmd(new String[]{cmdCd, cmdStart});
        }
        thread.htmlOut("restart proxy");
        thread.runCmd(new String[]{"docker restart letto-proxy"});
    }

    public void updateAll(CmdThread thread) {
        this.setupUpdateService.updateThread(thread, SetupUpdateService.SETUP_CMD.UPDATE_ALL, null);
    }

    public void updateRestartAll(CmdThread thread) {
        this.setupUpdateService.updateThread(thread, SetupUpdateService.SETUP_CMD.UPDATE_RESTART_ALL, null);
    }

    public String createStartScripts() {
        String dockerdir = this.dockerService.getDockerPath();
        String scriptsdir = dockerdir + this.microServiceConfiguration.getPathSeperator() + "scripts";
        File file = new File(dockerdir.replaceAll("\\\\", "/"));
        File scripts = new File(scriptsdir.replaceAll("\\\\", "/"));
        if (!scripts.exists()) {
            scripts.mkdirs();
        }
        if (!(scripts = new File((scriptsdir + "/linux").replaceAll("\\\\", "/"))).exists()) {
            scripts.mkdirs();
        }
        if (this.dockerService.isHostWindows()) {
            scripts = new File((scriptsdir + "/windows").replaceAll("\\\\", "/"));
            if (!scripts.exists()) {
                scripts.mkdirs();
            }
            this.createStartScripts(true, dockerdir, dockerdir + "/scripts/windows/");
            this.createStartScripts(false, "/opt/letto/docker", dockerdir + "/scripts/linux/");
        } else if (this.dockerService.isHostLinux()) {
            this.createStartScripts(false, dockerdir, dockerdir + "/scripts/linux/");
        } else {
            scripts = new File((scriptsdir + "/windows").replaceAll("\\\\", "/"));
            if (!scripts.exists()) {
                scripts.mkdirs();
            }
            this.createStartScripts(true, dockerdir, dockerdir + "/scripts/windows/");
            this.createStartScripts(false, "/opt/letto/docker", dockerdir + "/scripts/linux/");
        }
        return "Startscripts wurden erstellt in " + scriptsdir + " !";
    }

    private void createStartScripts(boolean windows, String dockerdir, String path) {
        Vector<String> updateall = new Vector<String>();
        Vector<String> startall = new Vector<String>();
        Vector<String> stopall = new Vector<String>();
        Vector<String> restartall = new Vector<String>();
        String firstline = windows ? "echo off" : "#!/bin/bash";
        updateall.add(firstline);
        startall.add(firstline);
        stopall.add(firstline);
        restartall.add(firstline);
        updateall.add("");
        startall.add("");
        stopall.add("");
        restartall.add("");
        this.singleScript(windows, path, "mysql", startall, null, null, null, firstline, "cd " + dockerdir + "/compose/mysql", "");
        this.singleScript(windows, path, "proxylogin", startall, stopall, updateall, restartall, firstline, "cd " + dockerdir + "/compose/letto", "");
        this.singleScript(windows, path, "setup", startall, stopall, updateall, restartall, firstline, "cd " + dockerdir + "/compose/setup", "");
        for (SchuleEnv schule : this.dockerService.getSchulenEnv()) {
            String school = schule.school;
            if (school == null || school.trim().length() <= 0) continue;
            school = school.trim();
            this.singleScript(windows, path, "school_" + school, startall, stopall, updateall, restartall, firstline, "cd " + dockerdir + "/compose/letto", "docker-compose-" + school + ".yml");
        }
        for (UpdateServiceDto dto : this.dockerService.getUpdateServiceDtoList()) {
            String ymlFileName = dto.getYmlFilename();
            String servicename = dto.getServicename();
            if (ymlFileName == null || ymlFileName.trim().length() <= 0 || servicename == null || servicename.trim().length() <= 0) continue;
            ymlFileName = ymlFileName.trim();
            this.singleScript(windows, path, "service_" + servicename, startall, stopall, updateall, restartall, firstline, "cd " + dockerdir + "/compose/letto", ymlFileName);
        }
        String extension = windows ? ".bat" : ".sh";
        File file = new File((path + "start_all" + extension).trim().replaceAll("\\\\", "/"));
        try {
            Files.write(file.toPath(), startall, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File((path + "stop_all" + extension).trim().replaceAll("\\\\", "/"));
        try {
            Files.write(file.toPath(), stopall, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File((path + "restart_all" + extension).trim().replaceAll("\\\\", "/"));
        try {
            Files.write(file.toPath(), restartall, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File((path + "update_all" + extension).trim().replaceAll("\\\\", "/"));
        try {
            Files.write(file.toPath(), updateall, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void singleScript(boolean windows, String path, String name, Vector<String> startall, Vector<String> stopall, Vector<String> updateall, Vector<String> restartall, String firstline, String cd, String yml) {
        String extension = windows ? ".bat" : ".sh";
        cd = windows ? cd.replaceAll("/", "\\\\") : cd.replaceAll("\\\\", "/");
        yml = yml != null && ((String)yml).trim().length() > 0 ? "-f " + (String)yml : "";
        String rem = windows ? "rem " : "# ";
        File file = new File((path + "start_" + name + extension).trim().replaceAll("\\\\", "/"));
        Vector<Object> data = new Vector<Object>();
        data.add(firstline);
        data.add("");
        data.add(rem + "START Container");
        data.add("");
        data.add(cd);
        data.add("docker compose " + (String)yml + " up -d");
        try {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (startall != null) {
            startall.add("");
            startall.add(cd);
            startall.add("docker compose " + (String)yml + " up -d");
        }
        file = new File((path + "restart_" + name + extension).trim().replaceAll("\\\\", "/"));
        data = new Vector();
        data.add(firstline);
        data.add("");
        data.add(rem + "RESTART Container");
        data.add("");
        data.add(cd);
        data.add("docker compose " + (String)yml + " down");
        data.add("docker compose " + (String)yml + " up -d");
        try {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (restartall != null) {
            restartall.add("");
            restartall.add(cd);
            restartall.add("docker compose " + (String)yml + " down");
            restartall.add("docker compose " + (String)yml + " up -d");
        }
        file = new File((path + "update_" + name + extension).trim().replaceAll("\\\\", "/"));
        data = new Vector();
        data.add(firstline);
        data.add("");
        data.add(rem + "UPDATE Container");
        data.add("");
        data.add(cd);
        data.add("docker compose " + (String)yml + " pull");
        data.add("docker compose " + (String)yml + " up -d");
        try {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (updateall != null) {
            updateall.add("");
            updateall.add(cd);
            updateall.add("docker compose " + (String)yml + " pull");
            updateall.add("docker compose " + (String)yml + " up -d");
        }
        file = new File((path + "stop_" + name + extension).trim().replaceAll("\\\\", "/"));
        data = new Vector();
        data.add(firstline);
        data.add("");
        data.add(rem + "STOP Container");
        data.add("");
        data.add(cd);
        data.add("docker compose " + (String)yml + " down");
        try {
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file.setExecutable(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stopall != null) {
            stopall.add("");
            stopall.add(cd);
            stopall.add("docker compose " + (String)yml + " down");
        }
    }
}

