/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.basespringboot.service.BaseSystemInfoService;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.model.LettoSetupConfigFile;
import at.letto.setupservice.model.properties.LettoProperties;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.Windows;
import at.letto.tools.Cmd;
import at.letto.tools.Datum;
import at.letto.tools.ServerStatus;
import at.letto.tools.WebGet;
import at.letto.tools.threads.ThreadStatus;
import com.google.common.io.ByteSource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AnalyzeService
extends BaseSystemInfoService {
    @Autowired
    private TomcatConfiguration tomcatConfiguration;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    private SetupConfiguration setupConfiguration;
    private String setupUrl = "";
    private String httpPort;
    private String httpsPort;
    private String ajpPort;
    private String startupTime;
    private String uptime;
    private String appname;
    private String apphome;
    private String analyzeTime;
    private boolean local = false;
    private boolean debug = false;
    private String revision;
    private String rootPath;
    private String propertyFile;
    private String keystoreFile;
    private boolean localInstallationFound = false;
    private boolean localTomEEFound = false;
    private boolean localTomEEconfigured = false;
    private boolean localLTIfound = false;
    private boolean localLTIconfigured = false;
    private boolean setupConfigurationPresent = false;
    private boolean lettoRunning = false;
    private String tomeePID = "";
    private boolean nginxRunning = false;
    private boolean port80free = false;
    private boolean port443free = false;
    private String local_tomee_mysql_server = "";
    private String local_tomee_mysql_database = "";
    private String local_tomee_mysql_user = "";
    private String local_tomee_mysql_password = "";
    private String local_lti_mysql_server = "";
    private String local_lti_mysql_database = "";
    private String local_lti_mysql_user = "";
    private String local_lti_mysql_password = "";
    private String local_sicherung_user = "";
    private String local_sicherung_password = "";
    private String local_dns_name = "";
    private String local_admin_email = "";
    private String local_letto_memory = "";
    public boolean local_setup_autostart = false;
    public boolean local_letto_autostart = false;
    public boolean local_lti_autostart = false;
    public boolean local_setup_root = false;
    private boolean local_letto_path = false;
    private boolean local_tomee_path = false;
    private boolean local_lti_path = false;
    private boolean local_docker_path = false;
    private boolean local_tomee_startscript = false;
    private boolean local_tomee_stopscript = false;
    private boolean local_tomee_updatescript = false;
    private boolean local_tomee_statusscript = false;
    private boolean local_tomee_war = false;
    private boolean local_tomee_dir_images = false;
    private boolean local_tomee_dir_photos = false;
    private boolean local_tomee_dir_plugins = false;
    private boolean local_tomee_dir_projekte = false;
    private boolean local_tomee_dir_js = false;
    private boolean local_lti_startscript = false;
    private boolean local_lti_stopscript = false;
    private boolean local_lti_updatescript = false;
    private boolean local_lti_statusscript = false;
    private boolean local_lti_jar = false;
    private boolean local_apache_conf = false;
    private boolean linux_user_present = false;
    private boolean local_jdk_ok = false;
    private boolean local_maxima_ok = false;
    private boolean local_tex_ok = false;
    private boolean local_inkscape_ok = false;
    private String local_jdk_version = "";
    private String local_maxima_version = "";
    private String local_tex_version = "";
    private String local_inkscape_version = "";
    private boolean local_database_letto_root_connection = false;
    private boolean local_database_lti_root_connection = false;
    private boolean local_database_root_connection_without_password = false;
    private boolean local_database_letto_connection = false;
    private boolean local_database_lti_connection = false;
    private boolean local_database_letto_sicherung_connection = false;
    private boolean local_database_lti_sicherung_connection = false;
    private boolean local_mysql_sudoers = false;
    private String local_letto_war_revision = "";
    private String local_lti_revision = "";
    private boolean local_sicherung_ok = false;
    private String local_sicherung_letto_last_datum = "";
    private String local_sicherung_lti_last_datum = "";
    public boolean local_sicherung_cron = false;
    public String local_sicherung_crontab = "";
    public boolean local_update_cron = false;
    public String local_update_crontab = "";
    private String letto_beta_revision = "";
    private String letto_daily_revision = "";
    private String letto_stable_revision = "";
    private String lti_revision = "";
    private String lti_beta_revision = "";
    private String lti_daily_revision = "";
    private String lti_stable_revision = "";
    private String localUrlName = "";
    private String localUrlAddr = "";
    private String localUrl = "";
    private String localUrlPort = "";
    private String localUrlProtocol = "";
    private String localUrlHost = "";
    private String localUrlString = "";
    private boolean startupFinished = false;

    public void analyzeRequestUrl(HttpServletRequest request) {
        this.localUrlName = request.getLocalName();
        this.localUrlAddr = request.getLocalAddr();
        this.localUrl = request.getRequestURL().toString();
        URL requestURL = null;
        try {
            requestURL = new URL(this.localUrl);
            this.localUrlPort = requestURL.getPort() == -1 ? "" : ":" + requestURL.getPort();
            this.localUrlProtocol = requestURL.getProtocol();
            this.localUrlHost = requestURL.getHost();
            this.localUrlString = this.localUrlProtocol + "://" + this.localUrlHost + this.localUrlPort;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String getLocalSetupUrlWithPort() {
        if (this.microServiceConfiguration.isSetupDocker()) {
            return "https://" + this.localUrlHost + ":3096/config/session/welcome";
        }
        return "https://" + this.localUrlHost + ":9096/setup/session/welcome";
    }

    public String getSetupLocalUrl() {
        return "https://" + this.localUrlHost + "/setup/session/welcome";
    }

    public String getSetupLocalPortUrl() {
        return "https://" + this.localUrlHost + ":9096/setup/session/welcome";
    }

    public String getSetupDockerUrl() {
        return "https://" + this.localUrlHost + "/config/session/welcome";
    }

    public String getSetupDockerUrlPort() {
        return "https://" + this.localUrlHost + ":3096/config/session/welcome";
    }

    public String getLoginUri() {
        return "https://" + this.localUrlHost + "/login";
    }

    public String getLocalLettoUrl() {
        return "https://" + this.localUrlHost + "/letto";
    }

    public void analyze() {
        this.analyzebase();
        if (!this.microServiceConfiguration.isSetupDocker()) {
            this.analyzeinstallation();
        }
    }

    public void analyzebase() {
        this.analyzeTime = Datum.formatDateTime((Date)Datum.now());
        this.httpPort = "" + this.tomcatConfiguration.getHttpPort();
        this.httpsPort = "" + this.tomcatConfiguration.getHttpsPort();
        this.ajpPort = "" + this.tomcatConfiguration.getAjpPort();
        this.appname = this.applicationContext.getId();
        this.apphome = new ApplicationHome().toString();
        this.startupTime = Datum.formatDateTime((Date)new Date(this.applicationContext.getStartupDate()));
        this.uptime = (double)(System.currentTimeMillis() - this.applicationContext.getStartupDate()) / 1000.0 + " s";
        this.local = ServerStatus.isLocal;
        this.debug = ServerStatus.isDebug;
        this.revision = ServerStatus.getRevision();
        this.rootPath = LettoProperties.ROOT_PATH;
        this.propertyFile = LettoProperties.PROPERTIES_FILE;
        this.keystoreFile = LettoProperties.KESTORE_FILE;
        this.port80free = this.isPortAvailable(80);
        this.port443free = this.isPortAvailable(443);
        if (this.isWindows()) {
            String s = Cmd.systemcall((String)"cmd /c chcp");
            Matcher m = Pattern.compile("[^\\d]*(\\d+)[^\\d]*").matcher(s);
            if (m.find()) {
                this.cmdCharset = "Cp" + m.group(1);
            }
        }
    }

    public void analyzeinstallation() {
        this.port80free = this.isPortAvailable(80);
        this.port443free = this.isPortAvailable(443);
        this.searchLocalUser();
        this.searchLocalInstallation();
        this.searchLetto();
        this.searchNginxDocker();
        if (this.setupConfiguration.getConf().getDatabaseConfigured()) {
            this.checkDatabaseConnection();
            this.loadDataFromLocalDatabase();
        }
        this.checkLocalPrograms();
        this.checkmysqlsudoers();
        this.analyzeAutostart();
        this.analyzeRevisions();
        this.analyzeSicherung();
    }

    public void analyzeRevisions() {
        this.letto_beta_revision = this.getLettoBetaRevision();
        this.letto_daily_revision = this.getLettoDailyRevision();
        this.letto_stable_revision = this.getLettoStableRevision();
        this.lti_revision = this.getLettoLtiRevision();
        this.lti_beta_revision = this.letto_beta_revision;
        this.lti_daily_revision = this.letto_daily_revision;
        this.lti_stable_revision = this.letto_stable_revision;
    }

    public void analyzeSicherung() {
        this.local_sicherung_ok = false;
        this.local_sicherung_letto_last_datum = "";
        this.local_sicherung_lti_last_datum = "";
        this.local_sicherung_cron = false;
        this.local_sicherung_crontab = "";
        File sicherungsdir = new File("/sicherung");
        File sicherungsscript = new File("/sicherung/sicherung.sh");
        File sicherungletto = new File("/sicherung/letto.sql.gz");
        File sicherunglti = new File("/sicherung/lettolti.sql.gz");
        if (this.isLinux() && sicherungsdir.exists() && sicherungsdir.isDirectory() && sicherungsscript.exists() && sicherungsscript.isFile()) {
            this.local_sicherung_ok = true;
            if (sicherungletto.exists()) {
                this.local_sicherung_letto_last_datum = Datum.formatDateTime((Date)new Date(sicherungletto.lastModified()));
            }
            if (sicherunglti.exists()) {
                this.local_sicherung_lti_last_datum = Datum.formatDateTime((Date)new Date(sicherunglti.lastModified()));
            }
            Vector crontab = Cmd.readfile((String)"/etc/crontab");
            for (String s : crontab) {
                if (s.matches(".*/sicherung/sicherung\\.sh.*")) {
                    this.local_sicherung_cron = true;
                    this.local_sicherung_crontab = this.local_sicherung_crontab + s;
                }
                if (!s.matches(".*/opt/letto/update\\.sh.*")) continue;
                this.local_update_cron = true;
                this.local_update_crontab = this.local_update_crontab + s;
            }
        }
    }

    public String getLettoDailyRevision() {
        try {
            Vector data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/daily/revision.txt");
            if (data != null && data.size() > 0 && ((String)data.get(0)).trim().length() > 0) {
                return ((String)data.get(0)).trim();
            }
            data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/daily-revision.txt");
            if (data != null && data.size() > 0) {
                return ((String)data.get(0)).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getLettoStableRevision() {
        try {
            Vector data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/stable/revision.txt");
            if (data != null && data.size() > 0 && ((String)data.get(0)).trim().length() > 0) {
                return ((String)data.get(0)).trim();
            }
            data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/stable-revision.txt");
            if (data != null && data.size() > 0) {
                return ((String)data.get(0)).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getLettoBetaRevision() {
        try {
            Vector data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/beta/revision.txt");
            if (data != null && data.size() > 0) {
                return ((String)data.get(0)).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getLettoLtiRevision() {
        try {
            Vector data = WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/lti/revision.txt");
            if (data != null && data.size() > 0) {
                return ((String)data.get(0)).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void searchLocalUser() {
        try {
            if (this.isLinux()) {
                if (this.getSystemUsername().equals(this.setupConfiguration.getConf().getLinuxUser())) {
                    this.linux_user_present = true;
                } else {
                    String lu = this.setupConfiguration.getConf().getLinuxUser().trim();
                    if (lu != null && lu.length() > 1) {
                        for (String s : Cmd.readfile((String)"/etc/passwd")) {
                            if (!s.startsWith(lu + ":")) continue;
                            this.linux_user_present = true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String findRevision(File warfile) {
        try {
            ZipInputStream zipIn = new ZipInputStream(new FileInputStream(warfile));
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String name = entry.getName().replaceAll("\\\\", "/");
                if (!entry.isDirectory() && name.matches(".*revision\\.txt")) {
                    Charset charset;
                    InputStream stream;
                    BufferedReader bufferedReader;
                    String s;
                    byte[] bytesIn = new byte[500];
                    int read = 0;
                    StringBuilder sb = new StringBuilder();
                    read = zipIn.read(bytesIn);
                    if (read != -1 && (s = (bufferedReader = new BufferedReader(new InputStreamReader(stream = ByteSource.wrap((byte[])bytesIn).openStream(), charset = Charset.forName("UTF-8")))).readLine()) != null) {
                        zipIn.closeEntry();
                        zipIn.close();
                        return s.trim();
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            zipIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void searchLocalInstallation() {
        Matcher m;
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        File lettoPath = new File(conf.getLettopath());
        File tomeePath = new File(conf.getTomEEpath());
        File ltiPath = new File(conf.getLTIpath());
        File dockerPath = new File(conf.getDockerpath());
        this.local_letto_path = lettoPath.exists();
        if (this.local_letto_path) {
            File sicherung;
            File startScript = new File(conf.getPropertyString("letto_tomee_script_start"));
            File stopScript = new File(conf.getPropertyString("letto_tomee_script_start"));
            File updateScript = new File(conf.getPropertyString("letto_tomee_script_start"));
            File statusScript = new File(conf.getPropertyString("letto_tomee_script_start"));
            File images = new File(conf.getPropertyString("letto_tomee_dir_images"));
            File photos = new File(conf.getPropertyString("letto_tomee_dir_photos"));
            File plugins = new File(conf.getPropertyString("letto_tomee_dir_plugins"));
            File projekte = new File(conf.getPropertyString("letto_tomee_dir_projekte"));
            File js = new File(conf.getPropertyString("letto_tomee_dir_js"));
            this.local_tomee_startscript = startScript.exists();
            this.local_tomee_stopscript = stopScript.exists();
            this.local_tomee_updatescript = updateScript.exists();
            this.local_tomee_statusscript = statusScript.exists();
            this.local_tomee_dir_images = images.exists();
            this.local_tomee_dir_photos = photos.exists();
            this.local_tomee_dir_plugins = plugins.exists();
            this.local_tomee_dir_projekte = projekte.exists();
            this.local_tomee_dir_js = js.exists();
            if (this.local_tomee_startscript) {
                this.localInstallationFound = true;
            }
            if ((sicherung = new File("/sicherung/sicherung.sh")).exists()) {
                try {
                    for (Object s : Cmd.readfile((File)sicherung)) {
                        m = Pattern.compile("^\\s*mysqldump.*\\-\\-user=([^\\s]+)\\s.*").matcher((CharSequence)s);
                        if (m.find()) {
                            this.local_sicherung_user = m.group(1).trim();
                        }
                        if (!(m = Pattern.compile("^\\s*mysqldump.*\\-\\-password=([^\\s]+)\\s.*").matcher((CharSequence)s)).find()) continue;
                        this.local_sicherung_password = m.group(1).trim();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            File index = new File("/var/www/html/index.html");
            if (sicherung.exists()) {
                try {
                    for (String s : Cmd.readfile((File)index)) {
                        m = Pattern.compile(".*URL=https://([^/\\s]+)/letto.*").matcher(s);
                        if (!m.find()) continue;
                        this.local_dns_name = m.group(1).trim();
                    }
                }
                catch (Exception s) {
                    // empty catch block
                }
            }
            File apacheconf = new File("/etc/apache2/sites-available/letto.conf");
            if (sicherung.exists()) {
                try {
                    for (String s : Cmd.readfile((File)apacheconf)) {
                        m = Pattern.compile("^\\s*ServerName\\s+([^\\s]+)[\\r\\n\\s]+$").matcher(s);
                        if (m.find()) {
                            this.local_dns_name = m.group(1).trim();
                        }
                        if (!(m = Pattern.compile("^\\s*ServerAdmin\\s+([^\\s]+)[\\r\\n\\s]+$").matcher(s)).find()) continue;
                        this.local_admin_email = m.group(1).trim();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.localTomEEconfigured = false;
        this.localTomEEFound = false;
        this.local_tomee_path = tomeePath.exists();
        if (this.local_tomee_path) {
            File tomeeXml = new File(conf.getPropertyString("letto_tomee_tomeedir") + "/conf/tomee.xml");
            File lettoWar = new File(conf.getPropertyString("letto_tomee_letto_war"));
            if (tomeeXml.exists()) {
                for (Object s : Cmd.readfile((File)tomeeXml)) {
                    m = Pattern.compile("^\\s*JdbcUrl\\s+jdbc:mysql://([^/]+)/([^/\\?\\s\\n\\r$]+)[\\?\\s\\n\\r$](.*)").matcher((CharSequence)s);
                    if (m.find()) {
                        this.local_tomee_mysql_server = m.group(1).trim();
                        this.local_tomee_mysql_database = m.group(2).trim();
                    }
                    if ((m = Pattern.compile("^\\s+UserName\\s+([^\\s\\n\\r$]+)").matcher((CharSequence)s)).find()) {
                        this.local_tomee_mysql_user = m.group(1).trim();
                    }
                    if (!(m = Pattern.compile("^\\s+Password\\s+([^\\s\\n\\r$]+)").matcher((CharSequence)s)).find()) continue;
                    this.local_tomee_mysql_password = m.group(1).trim();
                }
                this.localTomEEFound = true;
                this.localTomEEconfigured = true;
            }
            this.local_tomee_war = lettoWar.exists();
            if (!this.local_tomee_war) {
                this.localInstallationFound = false;
            } else {
                this.local_letto_war_revision = AnalyzeService.findRevision((File)lettoWar);
            }
            File setenv = new File(conf.getPropertyString("letto_tomee_tomeedir") + "/bin/setenv.sh");
            if (setenv.exists()) {
                try {
                    for (String s : Cmd.readfile((File)setenv)) {
                        m = Pattern.compile("^\\s*export\\s+CATALINA_OPTS\\s*=.*\\-Xms([^\\s]+)\\s.*").matcher(s);
                        if (!m.find()) continue;
                        this.local_letto_memory = m.group(1).trim();
                    }
                }
                catch (Exception s) {
                    // empty catch block
                }
            }
        }
        this.localLTIfound = false;
        this.localLTIconfigured = false;
        this.local_lti_path = ltiPath.exists();
        if (this.local_lti_path) {
            File ltiAP = new File(conf.getPropertyString("letto_lti_home") + "/application.properties");
            File ltistartScript = new File(conf.getPropertyString("letto_lti_home") + "/ltistart.sh");
            File ltistopScript = new File(conf.getPropertyString("letto_lti_home") + "/ltistop.sh");
            File ltiupdateScript = new File(conf.getPropertyString("letto_lti_home") + "/ltiupdate.sh");
            File ltiJar = new File(conf.getPropertyString("letto_lti_home") + "/lettolti.jar");
            File ltistatusScript = new File(conf.getPropertyString("letto_lti_home") + "/ltistatus.sh");
            this.local_lti_startscript = ltistartScript.exists();
            this.local_lti_stopscript = ltistopScript.exists();
            this.local_lti_updatescript = ltiupdateScript.exists();
            this.local_lti_statusscript = ltistatusScript.exists();
            this.local_lti_jar = ltiJar.exists();
            if (this.local_lti_jar) {
                this.local_lti_revision = AnalyzeService.findRevision((File)ltiJar);
            }
            if (ltiAP.exists()) {
                for (String s : Cmd.readfile((File)ltiAP)) {
                    m = Pattern.compile("^\\s*spring.datasource.url\\s*=\\s*jdbc:mysql://([^/]+)/([^/\\?\\s\\n\\r$]+)[\\?\\s\\n\\r$](.*)").matcher(s);
                    if (m.find()) {
                        this.local_lti_mysql_server = m.group(1).trim();
                        this.local_lti_mysql_database = m.group(2).trim();
                    }
                    if ((m = Pattern.compile("^\\s*spring.datasource.username\\s*=\\s*([^\\s\\n\\r$]+)").matcher(s)).find()) {
                        this.local_lti_mysql_user = m.group(1).trim();
                    }
                    if (!(m = Pattern.compile("^\\s*spring.datasource.password\\s*=\\s*([^\\s\\n\\r$]+)").matcher(s)).find()) continue;
                    this.local_lti_mysql_password = m.group(1).trim();
                }
                this.localLTIfound = true;
                if (this.local_lti_startscript && this.local_lti_statusscript && this.local_lti_stopscript && this.local_lti_updatescript && this.local_lti_jar) {
                    this.localLTIconfigured = true;
                }
            }
        }
        if (this.local_docker_path = dockerPath.exists()) {
            File dockerComposePath = new File(conf.getPropertyString("docker_compose_home"));
            File dockerComposeEnv = new File(conf.getPropertyString("docker_compose_home") + "/.env");
            if (dockerComposePath.exists() && dockerComposeEnv.exists()) {
                this.setupConfigurationPresent = true;
            }
        }
        File apacheConfAv = new File("/etc/apache2/sites-available/letto.conf");
        File apacheConfEn = new File("/etc/apache2/sites-enabled/letto.conf");
        this.local_apache_conf = apacheConfEn.exists() && apacheConfAv.exists();
        this.analyzeApache();
    }

    public void analyzeApache() {
    }

    public void analyzeAutostart() {
        File rclocal;
        this.local_setup_autostart = false;
        this.local_letto_autostart = false;
        this.local_lti_autostart = false;
        this.local_setup_root = false;
        if (this.isLinux() && (rclocal = new File("/etc/rc.local")).exists()) {
            Vector data = Cmd.readfile((File)rclocal);
            for (String s : data) {
                if (s.matches(".*\\/opt\\/letto\\/lti\\/ltistart\\.sh.*")) {
                    this.local_lti_autostart = true;
                }
                if (s.matches(".*\\/opt\\/letto\\/start\\.sh.*")) {
                    this.local_letto_autostart = true;
                }
                if (s.matches("\\s*sudo\\s+-u\\s+letto\\s+\\/opt\\/letto\\/setup\\/startlettosetup\\.sh.*")) {
                    this.local_setup_autostart = true;
                }
                if (!s.matches("\\s*\\/opt\\/letto\\/setup\\/startlettosetup\\.sh.*")) continue;
                this.local_setup_autostart = true;
                this.local_setup_root = true;
            }
        }
    }

    public String getTomeePID() {
        if (this.isWindows()) {
            Pattern p = Pattern.compile("^java.exe\\s+(\\d+)\\s+.*");
            Object pid = "";
            for (String s : Cmd.systemcall((String)"tasklist").split("\\r?\\n\\r?")) {
                Matcher m = p.matcher(s);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        if (this.isLinux()) {
            String res = Cmd.systemcall((String)"ps -ax");
            Object pid = "";
            Pattern p = Pattern.compile("^\\s*(\\d+)[^\\d].*tomee.*");
            for (String line : res.split("\\r*\\n\\r*")) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        return "";
    }

    public String getLTIPID() {
        if (this.isWindows()) {
            Pattern p = Pattern.compile("^java.exe\\s+(\\d+)\\s+.*");
            Object pid = "";
            for (String s : Cmd.systemcall((String)"tasklist").split("\\r?\\n\\r?")) {
                Matcher m = p.matcher(s);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        if (this.isLinux()) {
            String res = Cmd.systemcall((String)"ps -ax");
            Object pid = "";
            Pattern p = Pattern.compile("^\\s*(\\d+)[^\\d].*lettolti.jar.*");
            for (String line : res.split("\\r*\\n\\r*")) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        return "";
    }

    public String getPID(String suchstring) {
        if (this.isWindows()) {
            Pattern p = Pattern.compile("^java.exe\\s+(\\d+)\\s+.*");
            Object pid = "";
            for (String s : Cmd.systemcall((String)"tasklist").split("\\r?\\n\\r?")) {
                Matcher m = p.matcher(s);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        if (this.isLinux()) {
            String res = Cmd.systemcall((String)"ps -ax");
            Object pid = "";
            Pattern p = Pattern.compile("^\\s*(\\d+)[^\\d].*" + suchstring + ".*");
            for (String line : res.split("\\r*\\n\\r*")) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                pid = (String)pid + (((String)pid).length() > 0 ? " " : "") + m.group(1);
            }
            return pid;
        }
        return "";
    }

    public boolean localTomEErunning() {
        return this.getTomeePID().length() > 0;
    }

    public boolean localLTIrunning() {
        return this.getLTIPID().length() > 0;
    }

    public boolean localApacheRunning() {
        return this.getPID("apache2").length() > 0;
    }

    public void searchLetto() {
        this.tomeePID = this.getTomeePID();
        if (this.tomeePID.length() > 0) {
            this.lettoRunning = true;
        }
        this.lettoRunning = false;
    }

    public void searchNginxDocker() {
        this.nginxRunning = false;
    }

    public void checkLocalPrograms() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String javac = "javac";
        String maxima = conf.getPropertyString("letto_local_maxima");
        String tex = conf.getPropertyString("letto_local_tex");
        String inkscape = conf.getPropertyString("letto_local_inkscape");
        this.local_jdk_ok = false;
        this.local_maxima_ok = false;
        this.local_tex_ok = false;
        this.local_inkscape_ok = false;
        if (javac != null && javac.length() > 0) {
            try {
                this.local_jdk_version = Cmd.systemcall((String)(javac + " -version")).trim().split("\\r*\\n\\r*")[0];
                if (this.local_jdk_version.matches("^.*[\\d].*")) {
                    this.local_jdk_ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (maxima != null && maxima.length() > 0) {
            try {
                this.local_maxima_version = Cmd.systemcall((String)(maxima + " --version")).trim();
                if (this.local_maxima_version.matches("^.*[\\d].*")) {
                    this.local_maxima_ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tex != null && tex.length() > 0) {
            try {
                this.local_tex_version = Cmd.systemcall((String)(tex + " -version")).trim().split("\\r*\\n\\r*")[0];
                if (this.local_tex_version.matches("^.*[\\d].*")) {
                    this.local_tex_ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inkscape != null && inkscape.length() > 0) {
            try {
                this.local_inkscape_version = Cmd.systemcall((String)(inkscape + " --version")).trim().split("\\r*\\n\\r*")[0];
                if (this.local_inkscape_version.matches("^.*[\\d].*")) {
                    this.local_inkscape_ok = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String searchMaximaPath() {
        String path = "";
        if (this.isWindows()) {
            try {
                path = Windows.findMaxima().getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (new File(path).exists()) {
                return path;
            }
        } else if (this.isLinux() && new File(path = Cmd.systemcall((String)"bash which maxima").trim()).exists()) {
            return path;
        }
        return "";
    }

    public String searchTexPath() {
        String path = "";
        if (this.isWindows()) {
            try {
                path = Windows.findPdfLatex().getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (new File(path).exists()) {
                return path;
            }
        } else if (this.isLinux() && new File(path = Cmd.systemcall((String)"bash which pdflatex").trim()).exists()) {
            return path;
        }
        return "";
    }

    public String searchInkscapePath() {
        String path = "";
        if (this.isWindows()) {
            try {
                path = Windows.findInkscape().getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (new File(path).exists()) {
                return path;
            }
        } else if (this.isLinux() && new File(path = Cmd.systemcall((String)"bash which inkscape").trim()).exists()) {
            return path;
        }
        return "";
    }

    public void loadDataFromLocalDatabase() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        try {
            Connection con = DriverManager.getConnection(conf.getLtiDatabaseUrl(), conf.getLtiDatabaseUser(), conf.getLtiDatabasePassword());
            Statement stmt = con.createStatement();
            String query = "show tables";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                System.out.printf("%s, %s, %s%n", rs.getString(1), rs.getString(2), rs.getString(3));
            }
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void checkmysqlsudoers() {
        this.local_mysql_sudoers = false;
        try {
            File sudoers = new File("/etc/sudoers");
            Vector data = null;
            if (sudoers.exists()) {
                data = Cmd.readfile((File)sudoers);
            }
            if (data == null) {
                data = new Vector();
            }
            boolean found = false;
            String s1 = "letto ALL=(ALL) NOPASSWD: /usr/sbin/service mysql *";
            for (int i = 0; i < data.size(); ++i) {
                String s = (String)data.get(i);
                if (!s.trim().equals(s1)) continue;
                this.local_mysql_sudoers = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkDatabaseConnection() {
        ResultSet rs;
        String query;
        Statement stmt;
        Connection con;
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        try {
            String cmd = "echo \"show databases;\" | mysql -u root -h localhost";
            CmdThread ct = this.cmdService.cmdScriptForeground(1000L, new String[]{cmd});
            this.cmdService.removeThread(ct);
            this.local_database_root_connection_without_password = false;
            if (ct.getThreadStatus() == ThreadStatus.FINISHED) {
                for (String s : (Vector)ct.getOut().get(0)) {
                    if (!s.equals("mysql")) continue;
                    this.local_database_root_connection_without_password = true;
                }
            }
        }
        catch (Exception cmd) {
            // empty catch block
        }
        try {
            con = DriverManager.getConnection(conf.getLettoDatabaseUrl() + "?serverTimezone=Europe/Vienna", "root", conf.getLettoDatabaseRootPassword());
            stmt = con.createStatement();
            query = "Show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_letto_root_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_letto_root_connection = false;
        }
        try {
            con = DriverManager.getConnection(conf.getLtiDatabaseUrl() + "?serverTimezone=Europe/Vienna", "root", conf.getLettoDatabaseRootPassword());
            stmt = con.createStatement();
            query = "Show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_lti_root_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_lti_root_connection = false;
        }
        try {
            con = DriverManager.getConnection(conf.getLettoDatabaseUrl() + "?serverTimezone=Europe/Vienna", conf.getSicherungDatabaseUser(), conf.getSicherungDatabasePassword());
            stmt = con.createStatement();
            query = "Show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_letto_sicherung_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_letto_sicherung_connection = false;
        }
        try {
            con = DriverManager.getConnection(conf.getLtiDatabaseUrl() + "?serverTimezone=Europe/Vienna", conf.getSicherungDatabaseUser(), conf.getSicherungDatabasePassword());
            stmt = con.createStatement();
            query = "Show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_lti_sicherung_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_lti_sicherung_connection = false;
        }
        try {
            con = DriverManager.getConnection(conf.getLettoDatabaseUrl() + "?serverTimezone=Europe/Vienna", conf.getLettoDatabaseUser(), conf.getLettoDatabasePassword());
            stmt = con.createStatement();
            query = "show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_letto_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_letto_connection = false;
        }
        try {
            con = DriverManager.getConnection(conf.getLtiDatabaseUrl() + "?serverTimezone=Europe/Vienna", conf.getLtiDatabaseUser(), conf.getLtiDatabasePassword());
            stmt = con.createStatement();
            query = "show tables";
            rs = stmt.executeQuery(query);
            con.close();
            this.local_database_lti_connection = true;
        }
        catch (SQLException throwables) {
            this.local_database_lti_connection = false;
        }
    }

    public boolean localLettoActive() {
        return this.local_letto_autostart || this.local_lti_autostart || this.localLTIrunning() || this.localTomEErunning() || this.localApacheRunning();
    }

    public void setOwnerLetto(String ... files) {
        if (this.isLinux()) {
            for (String file : files) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + file, "chmod 755 -R " + file});
                this.cmdService.removeThread(cmdThread);
            }
        }
    }

    public void setOwnerLetto(File ... files) {
        if (this.isLinux()) {
            for (File file : files) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + file.getAbsolutePath(), "chmod 755 -R " + String.valueOf(file)});
                this.cmdService.removeThread(cmdThread);
            }
        }
    }

    public String getLettoLocalStateHTML() {
        if (this.localInstallationFound) {
            if (this.lettoRunning) {
                return "<span style=\"color:green;\">running</span>";
            }
            return "<span style=\"color:red;\">stopped</span>";
        }
        return "<span style=\"color:orange;\">not installed</span>";
    }

    public String ok(boolean b) {
        if (b) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span>";
    }

    public String jdkok() {
        if (this.isLocal_jdk_ok()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installAll\">install all programs</button>";
    }

    public String maximaok() {
        if (this.isLocal_maxima_ok()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installAll\">install all programs</button>";
    }

    public String texok() {
        if (this.isLocal_tex_ok()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installAll\">install all programs</button>";
    }

    public String inkscapeok() {
        if (this.isLocal_inkscape_ok()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installAll\">install all programs</button>";
    }

    public String databaserootok() {
        if (this.isLocal_database_letto_root_connection()) {
            return "<span style=\"color:green;\">OK</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installDb\">configure Database connection</button>";
    }

    public String linuxuserok() {
        if (this.linux_user_present) {
            if (this.getSystemUsername().equals(this.setupConfiguration.getConf().getLinuxUser())) {
                return "<span style=\"color:green;\">OK</span>";
            }
            return "<span style=\"color:orange;\">OK but setupservice started as " + this.getSystemUsername() + "!</span>";
        }
        return "<span style=\"color:red;\">FAIL</span> <button  name=\"userAction\" value=\"installuser\">install</button>";
    }

    public String showTomeePID() {
        if (this.tomeePID.length() > 0) {
            return "<span style=\"color:green;\">running(" + this.tomeePID + ")</span>";
        }
        return "<span style=\"color:red;\">stopped</span>";
    }

    public String lettoPathOk() {
        boolean allok = true;
        boolean nothingok = true;
        if (this.local_letto_path) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_path) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_startscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_stopscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_updatescript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_statusscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_dir_images) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_dir_photos) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_dir_plugins) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_dir_projekte) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_dir_js) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (allok) {
            return "<span style=\"color:green;\">OK</span>";
        }
        if (nothingok) {
            return "<span style=\"color:red;\">FAIL</span>";
        }
        return "<span style=\"color:orange;\">teilweise OK</span>";
    }

    public String tomeeOk() {
        boolean allok = true;
        boolean nothingok = true;
        String running = "";
        if (this.local_tomee_path) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_startscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_stopscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_updatescript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_tomee_statusscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.localTomEErunning()) {
            running = " - running";
        } else if (allok) {
            running = " - stopped";
        }
        if (allok) {
            return "<span style=\"color:green;\">OK" + running + "</span>";
        }
        if (nothingok) {
            return "<span style=\"color:red;\">FAIL" + running + "</span>";
        }
        return "<span style=\"color:orange;\">teilweise OK" + running + "</span>";
    }

    public String ltiOk() {
        boolean allok = true;
        boolean nothingok = true;
        String running = "";
        if (this.local_lti_path) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_startscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_stopscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_updatescript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_statusscript) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.local_lti_jar) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.localLTIrunning()) {
            running = " - running";
        } else if (allok) {
            running = " - stopped";
        }
        if (allok) {
            return "<span style=\"color:green;\">OK" + running + "</span>";
        }
        if (nothingok) {
            return "<span style=\"color:red;\">FAIL" + running + "</span>";
        }
        return "<span style=\"color:orange;\">teilweise OK" + running + "</span>";
    }

    public String apacheOk() {
        boolean allok = true;
        boolean nothingok = true;
        String running = "";
        if (this.local_apache_conf) {
            nothingok = false;
        } else {
            allok = false;
        }
        if (this.localApacheRunning()) {
            running = " - running";
        } else if (allok) {
            running = " - stopped";
        }
        if (allok) {
            return "<span style=\"color:green;\">OK" + running + "</span>";
        }
        if (nothingok) {
            return "<span style=\"color:red;\">FAIL" + running + "</span>";
        }
        return "<span style=\"color:orange;\">teilweise OK" + running + "</span>";
    }

    public String autostartSetupOk() {
        if (this.local_setup_autostart && this.local_setup_root) {
            return "<span style=\"color:green;\">root</span>";
        }
        if (this.local_setup_autostart) {
            return "<span style=\"color:green;\">AUTO</span>";
        }
        return "<span style=\"color:red;\">OFF</span>";
    }

    public String autostartOk() {
        if (this.local_lti_autostart && this.local_letto_autostart) {
            return "<span style=\"color:green;\">OK</span>";
        }
        if (this.local_lti_autostart) {
            return "<span style=\"color:orange;\">LTI</span>";
        }
        if (this.local_letto_autostart) {
            return "<span style=\"color:orange;\">LeTTo</span>";
        }
        return "<span style=\"color:red;\">OFF</span>";
    }

    public String datensicherungOk() {
        if (this.local_sicherung_ok) {
            if (this.local_database_letto_sicherung_connection && this.local_database_lti_sicherung_connection) {
                if (this.local_sicherung_cron) {
                    return "<span style=\"color:green;\">OK-automatic</span>";
                }
                return "<span style=\"color:orange;\">MANUELL </span>";
            }
            return "<span style=\"color:red;\">FAIL - user/password</span>";
        }
        return "<span style=\"color:red;\">FAIL</span>";
    }

    public String cronjobsOk() {
        if (this.local_sicherung_cron && this.local_update_cron) {
            return "<span style=\"color:green;\">Sicherung und Update</span>";
        }
        if (this.local_sicherung_cron) {
            return "<span style=\"color:orange;\">Sicherung</span>";
        }
        if (this.local_update_cron) {
            return "<span style=\"color:orange;\">Update</span>";
        }
        return "<span style=\"color:red;\">OFF</span>";
    }

    public String runningTasks() {
        return this.cmdService.htmlStatusInfo();
    }

    public String getLettoPath() {
        if (this.setupConfiguration.getConf().getSetupLettoDocker()) {
            return "/opt/letto";
        }
        return this.setupConfiguration.getConf().getLettopath();
    }

    public double getCpuUsage() {
        double cpu_minute = -1.0;
        double cpu_5minute = -1.0;
        double cpu_15minute = -1.0;
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("cat", "/proc/loadavg");
            pb.redirectErrorStream(true);
            Process process = null;
            process = pb.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            Object pos = null;
            while ((line = reader.readLine()) != null) {
                if (Thread.interrupted()) {
                    process.destroyForcibly();
                }
                line = line.trim();
                String[] v = line.split("\\s+");
                try {
                    cpu_minute = Double.parseDouble(v[0]);
                    cpu_5minute = Double.parseDouble(v[1]);
                    cpu_15minute = Double.parseDouble(v[2]);
                }
                catch (Exception exception) {}
            }
            int exitCode = 0;
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            reader.close();
            inputStreamReader.close();
            inputStream.close();
            process.destroyForcibly();
            return cpu_minute;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    @Generated
    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public CmdService getCmdService() {
        return this.cmdService;
    }

    @Generated
    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    @Generated
    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    @Generated
    public SetupConfiguration getSetupConfiguration() {
        return this.setupConfiguration;
    }

    @Generated
    public String getSetupUrl() {
        return this.setupUrl;
    }

    @Generated
    public String getHttpPort() {
        return this.httpPort;
    }

    @Generated
    public String getHttpsPort() {
        return this.httpsPort;
    }

    @Generated
    public String getAjpPort() {
        return this.ajpPort;
    }

    @Generated
    public String getStartupTime() {
        return this.startupTime;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public String getAppname() {
        return this.appname;
    }

    @Generated
    public String getApphome() {
        return this.apphome;
    }

    @Generated
    public String getAnalyzeTime() {
        return this.analyzeTime;
    }

    @Generated
    public boolean isLocal() {
        return this.local;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public String getRevision() {
        return this.revision;
    }

    @Generated
    public String getRootPath() {
        return this.rootPath;
    }

    @Generated
    public String getPropertyFile() {
        return this.propertyFile;
    }

    @Generated
    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    @Generated
    public boolean isLocalInstallationFound() {
        return this.localInstallationFound;
    }

    @Generated
    public boolean isLocalTomEEFound() {
        return this.localTomEEFound;
    }

    @Generated
    public boolean isLocalTomEEconfigured() {
        return this.localTomEEconfigured;
    }

    @Generated
    public boolean isLocalLTIfound() {
        return this.localLTIfound;
    }

    @Generated
    public boolean isLocalLTIconfigured() {
        return this.localLTIconfigured;
    }

    @Generated
    public boolean isSetupConfigurationPresent() {
        return this.setupConfigurationPresent;
    }

    @Generated
    public boolean isLettoRunning() {
        return this.lettoRunning;
    }

    @Generated
    public boolean isNginxRunning() {
        return this.nginxRunning;
    }

    @Generated
    public boolean isPort80free() {
        return this.port80free;
    }

    @Generated
    public boolean isPort443free() {
        return this.port443free;
    }

    @Generated
    public String getLocal_tomee_mysql_server() {
        return this.local_tomee_mysql_server;
    }

    @Generated
    public String getLocal_tomee_mysql_database() {
        return this.local_tomee_mysql_database;
    }

    @Generated
    public String getLocal_tomee_mysql_user() {
        return this.local_tomee_mysql_user;
    }

    @Generated
    public String getLocal_tomee_mysql_password() {
        return this.local_tomee_mysql_password;
    }

    @Generated
    public String getLocal_lti_mysql_server() {
        return this.local_lti_mysql_server;
    }

    @Generated
    public String getLocal_lti_mysql_database() {
        return this.local_lti_mysql_database;
    }

    @Generated
    public String getLocal_lti_mysql_user() {
        return this.local_lti_mysql_user;
    }

    @Generated
    public String getLocal_lti_mysql_password() {
        return this.local_lti_mysql_password;
    }

    @Generated
    public String getLocal_sicherung_user() {
        return this.local_sicherung_user;
    }

    @Generated
    public String getLocal_sicherung_password() {
        return this.local_sicherung_password;
    }

    @Generated
    public String getLocal_dns_name() {
        return this.local_dns_name;
    }

    @Generated
    public String getLocal_admin_email() {
        return this.local_admin_email;
    }

    @Generated
    public String getLocal_letto_memory() {
        return this.local_letto_memory;
    }

    @Generated
    public boolean isLocal_setup_autostart() {
        return this.local_setup_autostart;
    }

    @Generated
    public boolean isLocal_letto_autostart() {
        return this.local_letto_autostart;
    }

    @Generated
    public boolean isLocal_lti_autostart() {
        return this.local_lti_autostart;
    }

    @Generated
    public boolean isLocal_setup_root() {
        return this.local_setup_root;
    }

    @Generated
    public boolean isLocal_letto_path() {
        return this.local_letto_path;
    }

    @Generated
    public boolean isLocal_tomee_path() {
        return this.local_tomee_path;
    }

    @Generated
    public boolean isLocal_lti_path() {
        return this.local_lti_path;
    }

    @Generated
    public boolean isLocal_docker_path() {
        return this.local_docker_path;
    }

    @Generated
    public boolean isLocal_tomee_startscript() {
        return this.local_tomee_startscript;
    }

    @Generated
    public boolean isLocal_tomee_stopscript() {
        return this.local_tomee_stopscript;
    }

    @Generated
    public boolean isLocal_tomee_updatescript() {
        return this.local_tomee_updatescript;
    }

    @Generated
    public boolean isLocal_tomee_statusscript() {
        return this.local_tomee_statusscript;
    }

    @Generated
    public boolean isLocal_tomee_war() {
        return this.local_tomee_war;
    }

    @Generated
    public boolean isLocal_tomee_dir_images() {
        return this.local_tomee_dir_images;
    }

    @Generated
    public boolean isLocal_tomee_dir_photos() {
        return this.local_tomee_dir_photos;
    }

    @Generated
    public boolean isLocal_tomee_dir_plugins() {
        return this.local_tomee_dir_plugins;
    }

    @Generated
    public boolean isLocal_tomee_dir_projekte() {
        return this.local_tomee_dir_projekte;
    }

    @Generated
    public boolean isLocal_tomee_dir_js() {
        return this.local_tomee_dir_js;
    }

    @Generated
    public boolean isLocal_lti_startscript() {
        return this.local_lti_startscript;
    }

    @Generated
    public boolean isLocal_lti_stopscript() {
        return this.local_lti_stopscript;
    }

    @Generated
    public boolean isLocal_lti_updatescript() {
        return this.local_lti_updatescript;
    }

    @Generated
    public boolean isLocal_lti_statusscript() {
        return this.local_lti_statusscript;
    }

    @Generated
    public boolean isLocal_lti_jar() {
        return this.local_lti_jar;
    }

    @Generated
    public boolean isLocal_apache_conf() {
        return this.local_apache_conf;
    }

    @Generated
    public boolean isLinux_user_present() {
        return this.linux_user_present;
    }

    @Generated
    public boolean isLocal_jdk_ok() {
        return this.local_jdk_ok;
    }

    @Generated
    public boolean isLocal_maxima_ok() {
        return this.local_maxima_ok;
    }

    @Generated
    public boolean isLocal_tex_ok() {
        return this.local_tex_ok;
    }

    @Generated
    public boolean isLocal_inkscape_ok() {
        return this.local_inkscape_ok;
    }

    @Generated
    public String getLocal_jdk_version() {
        return this.local_jdk_version;
    }

    @Generated
    public String getLocal_maxima_version() {
        return this.local_maxima_version;
    }

    @Generated
    public String getLocal_tex_version() {
        return this.local_tex_version;
    }

    @Generated
    public String getLocal_inkscape_version() {
        return this.local_inkscape_version;
    }

    @Generated
    public boolean isLocal_database_letto_root_connection() {
        return this.local_database_letto_root_connection;
    }

    @Generated
    public boolean isLocal_database_lti_root_connection() {
        return this.local_database_lti_root_connection;
    }

    @Generated
    public boolean isLocal_database_root_connection_without_password() {
        return this.local_database_root_connection_without_password;
    }

    @Generated
    public boolean isLocal_database_letto_connection() {
        return this.local_database_letto_connection;
    }

    @Generated
    public boolean isLocal_database_lti_connection() {
        return this.local_database_lti_connection;
    }

    @Generated
    public boolean isLocal_database_letto_sicherung_connection() {
        return this.local_database_letto_sicherung_connection;
    }

    @Generated
    public boolean isLocal_database_lti_sicherung_connection() {
        return this.local_database_lti_sicherung_connection;
    }

    @Generated
    public boolean isLocal_mysql_sudoers() {
        return this.local_mysql_sudoers;
    }

    @Generated
    public String getLocal_letto_war_revision() {
        return this.local_letto_war_revision;
    }

    @Generated
    public String getLocal_lti_revision() {
        return this.local_lti_revision;
    }

    @Generated
    public boolean isLocal_sicherung_ok() {
        return this.local_sicherung_ok;
    }

    @Generated
    public String getLocal_sicherung_letto_last_datum() {
        return this.local_sicherung_letto_last_datum;
    }

    @Generated
    public String getLocal_sicherung_lti_last_datum() {
        return this.local_sicherung_lti_last_datum;
    }

    @Generated
    public boolean isLocal_sicherung_cron() {
        return this.local_sicherung_cron;
    }

    @Generated
    public String getLocal_sicherung_crontab() {
        return this.local_sicherung_crontab;
    }

    @Generated
    public boolean isLocal_update_cron() {
        return this.local_update_cron;
    }

    @Generated
    public String getLocal_update_crontab() {
        return this.local_update_crontab;
    }

    @Generated
    public String getLetto_beta_revision() {
        return this.letto_beta_revision;
    }

    @Generated
    public String getLetto_daily_revision() {
        return this.letto_daily_revision;
    }

    @Generated
    public String getLetto_stable_revision() {
        return this.letto_stable_revision;
    }

    @Generated
    public String getLti_revision() {
        return this.lti_revision;
    }

    @Generated
    public String getLti_beta_revision() {
        return this.lti_beta_revision;
    }

    @Generated
    public String getLti_daily_revision() {
        return this.lti_daily_revision;
    }

    @Generated
    public String getLti_stable_revision() {
        return this.lti_stable_revision;
    }

    @Generated
    public String getLocalUrlName() {
        return this.localUrlName;
    }

    @Generated
    public String getLocalUrlAddr() {
        return this.localUrlAddr;
    }

    @Generated
    public String getLocalUrl() {
        return this.localUrl;
    }

    @Generated
    public String getLocalUrlPort() {
        return this.localUrlPort;
    }

    @Generated
    public String getLocalUrlProtocol() {
        return this.localUrlProtocol;
    }

    @Generated
    public String getLocalUrlHost() {
        return this.localUrlHost;
    }

    @Generated
    public String getLocalUrlString() {
        return this.localUrlString;
    }

    @Generated
    public boolean isStartupFinished() {
        return this.startupFinished;
    }

    @Generated
    public void setSetupConfiguration(SetupConfiguration setupConfiguration) {
        this.setupConfiguration = setupConfiguration;
    }

    @Generated
    public void setStartupFinished(boolean startupFinished) {
        this.startupFinished = startupFinished;
    }
}

