/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setup.dto.CmdResultDto;
import at.letto.setup.dto.CommandDto;
import at.letto.setup.restclient.LocalSetupService;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.SetupUpdateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImpLocalSetupService
implements LocalSetupService {
    @Autowired
    CmdService cmdService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    SetupUpdateService setupUpdateService;

    public boolean ping() {
        return true;
    }

    public String welcome() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome";
    }

    public CmdResultDto callCommand(CommandDto dto) {
        CmdThread t = dto.getTimeoutMillis() == 0L ? this.cmdService.cmdScriptBackground(this.welcome(), dto.getBasedir(), dto.getCommands()) : this.cmdService.cmdScriptForeground(dto.getTimeoutMillis(), true, dto.getCommands());
        CmdResultDto result = new CmdResultDto(t.getId(), t.isFinished(), t.getHtmlOutput());
        return result;
    }

    public String setupDockerStart() {
        CmdThread t = this.setupUpdateService.setupStart(this.welcome());
        return "setup docker container start as background Job!";
    }

    public String setupDockerRestart() {
        CmdThread t = this.setupUpdateService.setupRestart(this.welcome());
        return "setup docker container restart as background Job!";
    }

    public String setupDockerStop() {
        CmdThread t = this.setupUpdateService.setupStop(this.welcome());
        return "setup docker container stop as background Job!";
    }

    public String setupDockerUpdate() {
        CmdThread t = this.setupUpdateService.setupUpdate(this.welcome());
        return "setup docker container update as background Job!";
    }

    public String lettoDockerStart() {
        CmdThread t = this.setupUpdateService.dockerLettoStart(this.welcome());
        return "LeTTo docker container start as background Job!";
    }

    public String lettoDockerRestart() {
        CmdThread t = this.setupUpdateService.dockerLettoRestart(this.welcome());
        return "LeTTo docker container restart as background Job!";
    }

    public String lettoDockerStop() {
        CmdThread t = this.setupUpdateService.dockerLettoStop(this.welcome());
        return "LeTTo docker container stop as background Job!";
    }

    public String lettoDockerUpdate() {
        CmdThread t = this.setupUpdateService.dockerLettoUpdate(this.welcome());
        return "LeTTo docker container update as background Job!";
    }
}

