/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.config.EmailConfiguration;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    static final Logger LOGGER = LoggerFactory.getLogger(EmailService.class);
    @Autowired
    EmailConfiguration emailConfiguration;
    @Value(value="classpath:/mail-logo.png")
    private Resource resourceFile;

    public boolean sendSimpleMessage(String to, String subject, String text) {
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.emailConfiguration.getNoReplyAddress());
            message.setTo(to);
            message.setSubject(subject);
            message.setText(text);
            this.emailConfiguration.getJavaMailSender().send(message);
            return true;
        }
        catch (MailException exception) {
            LOGGER.error("cannot send email to " + to + " subject " + subject + " see stack-trace");
            exception.printStackTrace();
            return false;
        }
    }

    public boolean sendHtmlMessage(String to, String subject, String htmlBody) {
        try {
            JavaMailSender javaMailSender = this.emailConfiguration.getJavaMailSender();
            MimeMessage message = javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(this.emailConfiguration.getNoReplyAddress());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(htmlBody, true);
            javaMailSender.send(message);
            return true;
        }
        catch (MessagingException ex) {
            LOGGER.error("cannot send email to " + to + " subject " + subject + " see stack-trace");
            ex.printStackTrace();
            return false;
        }
    }
}

