/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.configFiles;

import at.letto.setupservice.configFiles.EnvFile;
import at.letto.tools.Cmd;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EnvFile {
    protected File file = null;
    protected HashMap<String, EnvVar> vars = null;
    protected Vector<EnvVar> varlist = null;

    public EnvFile(File file) {
        this.file = file;
        this.vars = new HashMap();
        this.varlist = new Vector();
        this.loadTemplate(this.template());
        this.readFile();
    }

    public abstract String[][] template();

    private void loadTemplate(String[][] template) {
        for (String[] var : template) {
            String name = "";
            String standard = "";
            String description = "";
            if (var.length == 2) {
                name = var[0];
                standard = var[1];
            }
            if (var.length > 2) {
                name = var[0];
                standard = var[1];
                description = var[2];
            }
            if (var.length == 1) {
                name = var[0];
            }
            if ((name = name.trim()).length() <= 0) continue;
            this.setVar(name, standard, standard, description);
        }
    }

    public int readFile(File file) {
        Pattern p = Pattern.compile("^([^=]+)=(.*)$");
        if (file.exists()) {
            try {
                for (String line : Cmd.readfile((File)file)) {
                    Matcher m = p.matcher(line = line.trim());
                    if (!m.find()) continue;
                    String name = m.group(1).trim();
                    String wert = m.group(2).replaceAll("\\r", "");
                    if (wert.trim().startsWith("'") && wert.trim().endsWith("'")) {
                        wert = wert.trim();
                        wert = wert.substring(1, wert.length() - 1);
                    }
                    if (name.length() <= 0) continue;
                    this.setVar(name, wert);
                }
                this.file = file;
                return 0;
            }
            catch (Exception ex) {
                System.out.println("File " + String.valueOf(file) + " cannot be read!");
                return 1;
            }
        }
        return 2;
    }

    public int readFile() {
        return this.readFile(this.file);
    }

    public int writeFile(File file) {
        try {
            Vector<CallSite> data = new Vector<CallSite>();
            for (EnvVar envVar : this.varlist) {
                Object w = envVar.wert.replaceAll("\\r", "").replaceAll("\\n", " ");
                if (((String)w).contains("$") || ((String)w).contains("`")) {
                    w = "'" + ((String)w).replaceAll("'", "\\\"").replaceAll("\\\\", "/") + "'";
                }
                data.add((CallSite)((Object)(envVar.name + "=" + (String)w)));
            }
            return Cmd.writelnfile(data, (File)file) ? 0 : 1;
        }
        catch (Exception ex) {
            System.out.println("File " + String.valueOf(file) + " cannot be read!");
            return 1;
        }
    }

    public int writeFile() {
        return this.writeFile(this.file);
    }

    public void setVar(String name, String wert) {
        if (name == null) {
            return;
        }
        if ((name = name.trim()).length() < 1) {
            return;
        }
        if (wert == null) {
            if (this.vars.containsKey(name)) {
                EnvVar oldEnvVar = (EnvVar)this.vars.get(name);
                this.vars.remove(oldEnvVar);
                for (int i = 0; i < this.varlist.size(); ++i) {
                    if (this.varlist.get(i) != oldEnvVar) continue;
                    this.varlist.remove(i);
                    return;
                }
            }
        } else if (this.vars.containsKey(name)) {
            ((EnvVar)this.vars.get(name)).set(wert);
        } else {
            EnvVar envVar = new EnvVar(this, name, wert);
            this.vars.put(name, envVar);
            this.varlist.add(envVar);
        }
    }

    public void setVar(String name, Integer wert) {
        if (wert == null) {
            this.setVar(name, (String)null);
        } else {
            this.setVar(name, "" + wert);
        }
    }

    public void setVar(String name, Long wert) {
        if (wert == null) {
            this.setVar(name, (String)null);
        } else {
            this.setVar(name, "" + wert);
        }
    }

    public void setVar(String name, Boolean wert) {
        if (wert == null) {
            this.setVar(name, (String)null);
        } else {
            this.setVar(name, "" + wert);
        }
    }

    public void setVar(String name, String wert, String standard, String description) {
        if (standard == null) {
            standard = "";
        }
        if (description == null) {
            description = "";
        }
        if ((name = name.trim()).length() > 0) {
            EnvVar envVar = new EnvVar(this, name, wert, standard, description);
            this.vars.put(name, envVar);
            if (this.vars.containsKey(name)) {
                EnvVar oldEnvVar = (EnvVar)this.vars.get(name);
                for (int i = 0; i < this.varlist.size(); ++i) {
                    if (this.varlist.get(i) != oldEnvVar) continue;
                    this.varlist.set(i, envVar);
                    return;
                }
                this.varlist.add(envVar);
            } else {
                this.varlist.add(envVar);
            }
        }
    }

    public String getVar(String name) {
        if (this.vars.containsKey(name = name.trim())) {
            return ((EnvVar)this.vars.get((Object)name)).wert.trim();
        }
        return null;
    }

    public Boolean getVarBoolean(String name) {
        if (this.vars.containsKey(name = name.trim())) {
            String s = ((EnvVar)this.vars.get((Object)name)).wert.trim();
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("on")) {
                return true;
            }
            if (s.equalsIgnoreCase("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("ein")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
            if (s.equalsIgnoreCase("off")) {
                return false;
            }
            if (s.equalsIgnoreCase("0")) {
                return false;
            }
            if (s.equalsIgnoreCase("aus")) {
                return false;
            }
        }
        return null;
    }

    public Integer getVarInteger(String name) {
        if (this.vars.containsKey(name = name.trim())) {
            String s = ((EnvVar)this.vars.get((Object)name)).wert.trim();
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Long getVarLong(String name) {
        if (this.vars.containsKey(name = name.trim())) {
            String s = ((EnvVar)this.vars.get((Object)name)).wert.trim();
            try {
                return Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean containsKey(String name) {
        return this.vars.containsKey(name);
    }
}

