/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.model.LettoSetupConfigFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.UpdateService;
import at.letto.tools.Cmd;
import at.letto.tools.threads.ThreadStatus;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InstallService {
    @Autowired
    SetupConfiguration setupConfiguration;
    @Autowired
    DockerConfiguration dockerConfiguration;
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    AnalyzeService analyzeService;
    @Autowired
    CmdService cmdService;
    @Autowired
    UpdateService updateService;
    private String TOMEEVERSION = "8.0.6";
    private String MYSQLCONNECTOR = "mysql-connector-java-8.0.20";
    private String DOWNLOADPASSWORD = "h[1EJj_+epQ34Pz";
    public static String APT_JDK = "openjdk-8-jre openjdk-8-jdk openjdk-8-demo openjdk-8-doc openjdk-8-jre-headless openjdk-8-source";
    public static String APT_MAXIMA = "maxima";
    public static String APT_INKSCAPE = "inkscape scour";
    public static String APT_TOOLS = "net-tools arj zip unzip software-properties-common tmux";
    public static String APT_TEX = "texinfo texlive-base texlive-latex-recommended texlive texlive-latex-extra texlive-full fig2ps ttm texlive-lang-german";
    public static String APT_APACHE = "apache2 php python3-certbot-apache";
    public static String APT_MYSQL = "mysql-server mysql-client";

    public CmdThread installAllUbuntu(String backlink) {
        String[] commands = new String[]{"apt-get -y update", "apt-get -y upgrade", "apt-get -y dist-upgrade", "apt-get -y autoremove", "apt-get install -y " + APT_JDK, "apt-get install -y " + APT_MAXIMA, "apt-get install -y " + APT_INKSCAPE, "apt-get install -y " + APT_TOOLS, "apt-get install -y " + APT_TEX, "apt-get install -y " + APT_APACHE, "apt-get install -y " + APT_MYSQL};
        return this.cmdService.cmdScriptBackground(backlink, this.analyzeService.getUserDir(), commands);
    }

    public CmdThread installUser(String backlink) {
        String user = this.setupConfiguration.getConf().getLinuxUser();
        String[] commands = new String[]{"adduser  --disabled-password --gecos " + user + ",0,0,0 " + user, "if getent group letto >/dev/null; then echo group letto exists; else addgroup letto; fi", "if getent group " + user + " | grep -q \"\\bletto\\b\"; then echo " + user + " is in group letto; else adduser " + user + " letto; fi", "echo Please set Password for user " + this.setupConfiguration.getConf().getLinuxUser() + " in the unix-shell to enable login!"};
        return this.cmdService.cmdScriptBackground(backlink, this.analyzeService.getUserDir(), commands);
    }

    private String mysqlcmd(String user, String password, String host, String database, String cmd) {
        Object ret = "mysql";
        if (user != null && user.length() > 0) {
            ret = (String)ret + " -u" + user;
        }
        if (password != null && password.length() > 0) {
            ret = (String)ret + " -p" + password;
        }
        ret = (String)ret + " -h" + host;
        if (database != null && database.length() > 0) {
            ret = (String)ret + " " + database;
        }
        ret = (String)ret + " -e\"" + cmd + "\"";
        return ret;
    }

    private String mysqlcmd(String credsfile, String database, String cmd) {
        Object ret = "mysql";
        if (credsfile != null && credsfile.length() > 0) {
            ret = (String)ret + " --defaults-extra-file=" + credsfile;
        }
        if (database != null && database.length() > 0) {
            ret = (String)ret + " " + database;
        }
        ret = (String)ret + " -e\"" + cmd + "\"";
        return ret;
    }

    private boolean mysql(String user, String password, String host, String database, String ... cmd) {
        try {
            File credsfile = new File(this.analyzeService.getUserDir() + "/mycred.cnf");
            try {
                Vector<CallSite> data = new Vector<CallSite>();
                data.add((CallSite)((Object)("[client]\nuser=" + user)));
                if (password != null && password.length() > 0) {
                    data.add((CallSite)((Object)("password=" + password)));
                }
                if (host != null && host.length() > 0) {
                    data.add((CallSite)((Object)("host=" + host)));
                }
                data.add((CallSite)((Object)("[mysqldump]\nuser=" + user)));
                if (password != null && password.length() > 0) {
                    data.add((CallSite)((Object)("password=" + password)));
                }
                if (host != null && host.length() > 0) {
                    data.add((CallSite)((Object)("host=" + host)));
                }
                Cmd.writelnfile(data, (File)credsfile);
            }
            catch (Exception ex) {
                credsfile = null;
            }
            String[] mc = new String[cmd.length];
            for (int i = 0; i < cmd.length; ++i) {
                mc[i] = credsfile == null ? this.mysqlcmd(user, password, host, database, cmd[i]) : this.mysqlcmd(credsfile.getAbsolutePath(), database, cmd[i]);
            }
            CmdThread ct = this.cmdService.cmdForeground(5000L, mc);
            try {
                if (credsfile != null) {
                    credsfile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ct.getThreadStatus() == ThreadStatus.FINISHED) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean setDbRootPassword(String password) {
        this.setupConfiguration.getConf().setProperty("letto_tomee_mysql_root_password", password);
        this.setupConfiguration.getConf().save();
        this.mysql("root", "", "localhost", "mysql", new String[]{"ALTER USER 'root'@'localhost' IDENTIFIED WITH caching_sha2_password BY '" + password + "'; flush privileges;", "ALTER USER 'root'@'%' IDENTIFIED WITH caching_sha2_password BY '" + password + "'; flush privileges;"});
        this.dbConfig();
        return true;
    }

    public void dbConfig() {
        String password = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_root_password");
        String lettodatabaseserver = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_server");
        String lettouser = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_user");
        String lettodatabase = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_database");
        String lettopassword = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_password");
        String ltidatabaseserver = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_server");
        String ltiuser = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_user");
        String ltidatabase = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_database");
        String ltipassword = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_password");
        String sicherunguser = this.setupConfiguration.getConf().getPropertyString("letto_mysql_sicherungsuser");
        String sicherungpassword = this.setupConfiguration.getConf().getPropertyString("letto_mysql_sicherungspasswort");
        this.mysql("root", password, lettodatabaseserver, "mysql", new String[]{"GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' WITH GRANT OPTION; flush privileges;", "UPDATE user SET host='%' where user='root'; flush privileges;", "CREATE USER '" + lettouser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + lettopassword + "'; flush privileges;", "ALTER USER '" + lettouser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + lettopassword + "'; flush privileges;", "GRANT USAGE ON *.* TO '" + lettouser + "'@'%'; flush privileges;", "ALTER USER '" + lettouser + "'@'%' REQUIRE NONE WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0;", "CREATE DATABASE IF NOT EXISTS " + lettodatabase + ";", "GRANT ALL PRIVILEGES ON " + lettodatabase + ".* TO '" + lettouser + "'@'%'; flush privileges;", "GRANT ALL PRIVILEGES ON `" + lettouser + "_%`.* TO '" + lettouser + "'@'%';flush privileges;", "CREATE USER '" + sicherunguser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + sicherungpassword + "'; flush privileges;", "ALTER USER '" + sicherunguser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + sicherungpassword + "'; flush privileges;", "GRANT USAGE,SELECT,FILE,LOCK TABLES, PROCESS ON *.* TO '" + sicherunguser + "'@'%'; flush privileges;"});
        if (!ltidatabaseserver.trim().equals(lettodatabaseserver.trim())) {
            this.mysql("root", password, ltidatabaseserver, "mysql", new String[]{"GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' WITH GRANT OPTION; flush privileges;", "UPDATE user SET host='%' where user='root'; flush privileges;", "CREATE USER '" + ltiuser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + ltipassword + "'; flush privileges;", "ALTER USER '" + ltiuser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + ltipassword + "'; flush privileges;", "GRANT USAGE ON *.* TO '" + ltiuser + "'@'%'; flush privileges;", "ALTER USER '" + ltiuser + "'@'%' REQUIRE NONE WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0;", "CREATE DATABASE IF NOT EXISTS " + ltidatabase + ";", "GRANT ALL PRIVILEGES ON " + ltidatabase + ".* TO '" + ltiuser + "'@'%'; flush privileges;", "GRANT ALL PRIVILEGES ON `" + ltiuser + "_%`.* TO '" + ltiuser + "'@'%';flush privileges;", "CREATE USER '" + sicherunguser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + sicherungpassword + "'; flush privileges;", "ALTER USER '" + sicherunguser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + sicherungpassword + "'; flush privileges;", "GRANT USAGE,SELECT,FILE,LOCK TABLES, PROCESS ON *.* TO '" + sicherunguser + "'@'%'; flush privileges;"});
        } else {
            this.mysql("root", password, ltidatabaseserver, "mysql", new String[]{"CREATE USER '" + ltiuser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + ltipassword + "'; flush privileges;", "ALTER USER '" + ltiuser + "'@'%' IDENTIFIED WITH caching_sha2_password BY '" + ltipassword + "'; flush privileges;", "GRANT USAGE ON *.* TO '" + ltiuser + "'@'%'; flush privileges;", "ALTER USER '" + ltiuser + "'@'%' REQUIRE NONE WITH MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0;", "CREATE DATABASE IF NOT EXISTS " + ltidatabase + ";", "GRANT ALL PRIVILEGES ON " + ltidatabase + ".* TO '" + ltiuser + "'@'%'; flush privileges;", "GRANT ALL PRIVILEGES ON `" + ltiuser + "_%`.* TO '" + ltiuser + "'@'%';flush privileges;"});
        }
        try {
            if (this.analyzeService.isLinux()) {
                String s;
                int i;
                File mycnf = new File("/etc/mysql/mysql.conf.d/mysqld.cnf");
                if (mycnf.exists()) {
                    Vector data = Cmd.readfile((File)mycnf);
                    boolean f1 = false;
                    boolean f2 = false;
                    String s1 = "sql_mode=\"STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION\"";
                    String s2 = "default-time-zone='SYSTEM'";
                    for (i = 0; i < data.size(); ++i) {
                        s = (String)data.get(i);
                        if (s.startsWith("\\s*sql_mode\\s*=")) {
                            f1 = true;
                            s = s1;
                            continue;
                        }
                        if (!s.startsWith("\\s*default-time-zone\\s*=")) continue;
                        f2 = true;
                        s = s2;
                    }
                    if (!f1) {
                        data.add(s1);
                    }
                    if (!f2) {
                        data.add(s2);
                    }
                    Cmd.writelnfile((Vector)data, (File)mycnf);
                }
                CmdThread ct = this.cmdService.cmdScriptForeground(50000L, new String[]{"service mysql restart"});
                File sudoers = new File("/etc/sudoers");
                Vector<String> data = null;
                if (sudoers.exists()) {
                    data = Cmd.readfile((File)sudoers);
                }
                if (data == null) {
                    data = new Vector<String>();
                }
                boolean found = false;
                String s1 = "letto ALL=(ALL) NOPASSWD: /usr/sbin/service mysql *";
                for (i = 0; i < data.size(); ++i) {
                    s = (String)data.get(i);
                    if (!s.trim().equals(s1)) continue;
                    found = true;
                }
                if (!found) {
                    data.add(s1);
                }
                Cmd.writelnfile(data, (File)sudoers);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void localResetDatabase() {
        String lettodatabaseserver = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_server");
        String lettouser = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_user");
        String lettodatabase = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_database");
        String lettopassword = this.setupConfiguration.getConf().getPropertyString("letto_tomee_mysql_password");
        this.mysql(lettouser, lettopassword, lettodatabaseserver, "", new String[]{"drop database " + lettodatabase + ";", "create database " + lettodatabase + ";"});
    }

    public void localResetLtiDatabase() {
        String ltidatabaseserver = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_server");
        String ltiuser = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_user");
        String ltidatabase = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_database");
        String ltipassword = this.setupConfiguration.getConf().getPropertyString("letto_lti_mysql_password");
        this.mysql(ltiuser, ltipassword, ltidatabaseserver, "", new String[]{"drop database " + ltidatabase + ";", "create database " + ltidatabase + ";"});
    }

    public String startLettoLocal() {
        if (this.analyzeService.isLinux()) {
            String cmd = this.setupConfiguration.getConf().getPropertyString("letto_tomee_home/start.sh");
            String ret = Cmd.systemcall((String)cmd);
            return ret;
        }
        return "Start von TomEE ist zur Zeit nur f\u00fcr Linux realisiert!!";
    }

    public String stopLettoLocal() {
        if (this.analyzeService.isLinux()) {
            String cmd = this.setupConfiguration.getConf().getPropertyString("letto_tomee_home/stop.sh");
            String ret = Cmd.systemcall((String)cmd);
            return ret;
        }
        return "Stoppen von TomEE ist zur Zeit nur f\u00fcr Linux realisiert!!";
    }

    public String restartLettoLocal() {
        if (this.analyzeService.isLinux()) {
            String cmd = this.setupConfiguration.getConf().getPropertyString("letto_tomee_home/restart.sh");
            String ret = Cmd.systemcall((String)cmd);
            return ret;
        }
        return "Restart von TomEE ist zur Zeit nur f\u00fcr Linux realisiert!!";
    }

    public String statusLettoLocal() {
        if (this.analyzeService.isLinux()) {
            String cmd = this.setupConfiguration.getConf().getPropertyString("letto_tomee_home/status.sh");
            String ret = Cmd.systemcall((String)cmd);
            return ret;
        }
        return "";
    }

    public String updateLettoLocal() {
        if (this.analyzeService.isLinux()) {
            String cmd = this.setupConfiguration.getConf().getPropertyString("letto_tomee_home/update.sh");
            String ret = Cmd.systemcall((String)cmd);
            return ret;
        }
        return "";
    }

    public void createDir(String dir) {
        try {
            File f = new File(dir);
            if (!f.exists()) {
                f.mkdirs();
            }
            f.setExecutable(true);
            if (this.analyzeService.isLinux()) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + dir, "chmod 755 -R " + dir});
                this.cmdService.removeThread(cmdThread);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void configLocalDirs() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        this.createDir(conf.getPropertyString("letto_tomee_home"));
        this.createDir(conf.getPropertyString("letto_tomee_home") + "/pdf");
        this.createDir(conf.getPropertyString("letto_tomee_home") + "/tex");
        this.createDir(conf.getPropertyString("letto_tomee_home") + "/war");
        this.createDir(conf.getPropertyString("letto_lti_home"));
        this.createDir(conf.getPropertyString("docker_home"));
        this.createDir(conf.getPropertyString("letto_tomee_script_start"));
        this.createDir(conf.getPropertyString("letto_tomee_script_start"));
        this.createDir(conf.getPropertyString("letto_tomee_script_start"));
        this.createDir(conf.getPropertyString("letto_tomee_script_start"));
        this.createDir(conf.getPropertyString("letto_tomee_dir_images"));
        this.createDir(conf.getPropertyString("letto_tomee_dir_photos"));
        this.createDir(conf.getPropertyString("letto_tomee_dir_plugins"));
        this.createDir(conf.getPropertyString("letto_tomee_dir_projekte"));
        this.createDir(conf.getPropertyString("letto_tomee_dir_js"));
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto /opt", "chmod 755 /opt", "chgrp letto /opt"});
            this.cmdService.removeThread(cmdThread);
        }
    }

    public String deleteLocalTomEE() {
        try {
            LettoSetupConfigFile conf = this.setupConfiguration.getConf();
            File dir = new File(conf.getTomEEpath());
            if (dir.exists()) {
                dir.delete();
            }
            return "";
        }
        catch (Exception exception) {
            return "lokaler TomEE-Server kann nicht gel\u00f6scht werden";
        }
    }

    public void installLocalTomEE() {
        this.deleteLocalTomEE();
        String tomeeversion = this.TOMEEVERSION;
        String tomeepackage = "apache-tomee-" + tomeeversion + "-plume.tar.gz";
        String tomeedir = "apache-tomee-plume-" + tomeeversion;
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        File dir = new File(conf.getTomEEpath());
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(600000L, new String[]{"cd /opt", "rm " + tomeepackage + " -f", "wget https://mirror.klaus-uwe.me/apache/tomee/tomee-" + tomeeversion + "/" + tomeepackage, "tar -xzf " + tomeepackage, "ln -s /opt/" + tomeedir + " " + conf.getTomEEpath(), "rm " + this.MYSQLCONNECTOR + ".zip -f", "wget https://dev.mysql.com/get/Downloads/Connector-J/" + this.MYSQLCONNECTOR + ".zip", "unzip -o " + this.MYSQLCONNECTOR + ".zip", "cp " + this.MYSQLCONNECTOR + "/" + this.MYSQLCONNECTOR + ".jar " + conf.getTomEEpath() + "/lib/", "chown letto -R " + tomeedir, "chgrp letto -R " + tomeedir});
        }
        this.configLocalTomEE();
    }

    public void configLocalTomEE() {
        int i;
        String s2;
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String tomeedir = conf.getTomEEpath();
        File f_tomee_xml = new File(tomeedir + "/conf/tomee.xml");
        File f_cat_prop = new File(tomeedir + "/conf/catalina.properties");
        File f_context_xml = new File(tomeedir + "/conf/context.xml");
        File f_server_xml = new File(tomeedir + "/conf/server.xml");
        File f_cat_sh = new File(tomeedir + "/bin/catalina.sh");
        File f_setenv_sh = new File(tomeedir + "/bin/setenv.sh");
        File f_cat_policy = new File(tomeedir + "/conf/catalina.policy");
        Vector data = new Vector();
        data.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        data.add("<tomee>");
        data.add("  <Resource id=\"jdbc/letto\" type=\"DataSource\">");
        data.add("    JdbcDriver  com.mysql.cj.jdbc.Driver");
        data.add("    JdbcUrl     " + conf.getLettoDatabaseUrl() + "?serverTimezone=Europe/Vienna&amp;useSSL=false");
        data.add("    UserName    " + conf.getLettoDatabaseUser());
        data.add("    Password    " + conf.getLettoDatabasePassword());
        data.add("    jtaManaged = true");
        data.add("    testOnReturn = true");
        data.add("    testWhileIdle = true");
        data.add("    timeBetweenEvictionRunsMillis = 60");
        data.add("    initialSize = 2");
        data.add("    failOverReadOnly = false");
        data.add("    autoReconnect = true");
        data.add("    minIdle = 2");
        data.add("    validationQuery = select 1");
        data.add("  </Resource>");
        data.add("</tomee>");
        Cmd.writelnfile(data, (File)f_tomee_xml);
        data = Cmd.readfile((File)f_cat_prop);
        boolean found = false;
        for (String s2 : data) {
            if (!s2.matches("\\s*org.apache.el.parser.SKIP_IDENTIFIER_CHECK=tru[\\s\\n\\r]*")) continue;
            found = true;
        }
        if (!found) {
            data.add("org.apache.el.parser.SKIP_IDENTIFIER_CHECK=true");
            Cmd.writelnfile(data, (File)f_cat_prop);
        }
        data = new Vector();
        data.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        data.add("<Context>");
        data.add("  <WatchedResource>WEB-INF/web.xml</WatchedResource>");
        data.add("  <WatchedResource>WEB-INF/tomcat-web.xml</WatchedResource>");
        data.add("  <WatchedResource>${catalina.base}/conf/web.xml</WatchedResource>");
        data.add("  <Manager pathname=\"\" />");
        data.add("</Context>");
        Cmd.writelnfile(data, (File)f_context_xml);
        data = Cmd.readfile((File)f_server_xml);
        for (i = 0; i < data.size(); ++i) {
            s2 = (String)data.get(i);
            if ((s2 = s2.replaceAll("8009", "8089")).matches("\\s*<!--[^\\-]*AJP[^\\-]*-->[\\s\\n\\r]*")) {
                s2 = "<Connector port=\"8089\" secretRequired=\"false\" protocol=\"AJP/1.3\" redirectPort=\"8443\" />";
            }
            data.set(i, s2);
        }
        Cmd.writelnfile((Vector)data, (File)f_server_xml);
        data = Cmd.readfile((File)f_cat_sh);
        for (i = 0; i < data.size(); ++i) {
            s2 = (String)data.get(i);
            if ((s2 = s2.replaceAll("UMASK=\"0027\"", "UMASK=\"0002\"")).matches("\\s*Djava.io.tmpdir=\"\\\"$CATALINA_TMPDIR\\\"\"[\\s\\n\\r]*")) {
                s2 = "Djava.io.tmpdir=\"\\\"$CATALINA_TMPDIR\\\"\" -Djava.awt.headless=true";
            }
            if (s2.matches("\\s*Djava.io.tmpdir=\"$CATALINA_TMPDIR\"[\\s\\n\\r]*")) {
                s2 = "Djava.io.tmpdir=\"\\\"$CATALINA_TMPDIR\\\"\" -Djava.awt.headless=true";
            }
            data.set(i, s2);
        }
        Cmd.writelnfile((Vector)data, (File)f_cat_sh);
        data = new Vector();
        data.add("#!/bin/sh -e");
        data.add("export CATALINA_OPTS=\"-Xms" + conf.getTomEEMemory() + " -Xmx" + conf.getTomEEMemory() + "\"");
        Cmd.writelnfile(data, (File)f_setenv_sh);
        data = Cmd.readfile((File)f_cat_policy);
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + tomeedir, "chmod 755 -R " + tomeedir});
            this.cmdService.removeThread(cmdThread);
        }
        if (this.analyzeService.getTomeePID().length() > 0) {
            this.stopLocalTomEE();
        }
        this.startLocalTomEE();
        this.downloadAndInstallLettoWar(conf.getUpdateVersion());
        this.downloadStartStopScripts();
    }

    public String startLocalTomEE() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String tomeedir = conf.getTomEEpath();
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.analyzeService.getSystemUsername().equals("root") ? this.cmdService.cmdScriptForeground(180000L, new String[]{"sudo -u letto " + tomeedir + "/bin/startup.sh"}) : this.cmdService.cmdScriptForeground(180000L, new String[]{tomeedir + "/bin/startup.sh"});
            this.cmdService.removeThread(cmdThread);
        } else if (this.analyzeService.isWindows()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{tomeedir + "/bin/startup.bat"});
            this.cmdService.removeThread(cmdThread);
        } else {
            return "TomEE ist nur mit Linux und Windows start- und stoppbar!";
        }
        return "";
    }

    public String stopLocalTomEE() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String tomeedir = conf.getTomEEpath();
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{tomeedir + "/bin/shutdown.sh"});
            String pid = this.analyzeService.getTomeePID();
            if (pid.length() > 0) {
                cmdThread = this.cmdService.cmdScriptForeground(60000L, new String[]{"kill " + pid});
            } else {
                this.cmdService.removeThread(cmdThread);
            }
        } else if (this.analyzeService.isWindows()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{tomeedir + "/bin/shutdown.bat"});
            String pid = this.analyzeService.getTomeePID();
            if (pid.length() > 0) {
                cmdThread = this.cmdService.cmdScriptForeground(60000L, new String[]{"taskkill " + pid});
            } else {
                this.cmdService.removeThread(cmdThread);
            }
        } else {
            return "TomEE ist nur mit Linux und Windows start- und stoppbar!";
        }
        return "";
    }

    public String deleteLocalTomEElogfile() {
        File f = this.getLocalTomEElogfile();
        if (f != null) {
            try {
                f.delete();
            }
            catch (Exception ex) {
                return "Logfile kann nicht gel\u00f6scht werden!";
            }
        } else {
            return "L\u00f6schen vom Logfile nicht m\u00f6glich, da der Pfad nicht stimmt!";
        }
        return "";
    }

    public File getLocalTomEElogfile() {
        try {
            return new File(this.setupConfiguration.getConf().getTomEEpath() + "/logs/catalina.out");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalTomEEtomeexml() {
        try {
            return new File(this.setupConfiguration.getConf().getTomEEpath() + "/conf/tomee.xml");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalTomEEserverxml() {
        try {
            return new File(this.setupConfiguration.getConf().getTomEEpath() + "/conf/server.xml");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalTomEEcatalinash() {
        try {
            return new File(this.setupConfiguration.getConf().getTomEEpath() + "/bin/catalina.sh");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalTomEEsetenvsh() {
        try {
            return new File(this.setupConfiguration.getConf().getTomEEpath() + "/bin/setenv.sh");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalLTIlogfile() {
        try {
            return new File(this.setupConfiguration.getConf().getLTIpath() + "/ltistart.log");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalLTIconfigfile() {
        try {
            return new File(this.setupConfiguration.getConf().getLTIpath() + "/application.properties");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String toVersionUrl(String version) {
        if ((version = version.toLowerCase()).equals("daily")) {
            return "https://www.letto.at/download/letto/daily";
        }
        if (version.equals("stable")) {
            return "https://www.letto.at/download/letto/stable";
        }
        if (version.equals("beta")) {
            return "https://www.letto.at/download/letto/beta";
        }
        Matcher m = Pattern.compile("^rev(\\d+)$").matcher(version);
        if (m.find()) {
            return "https://www.letto.at/download/letto/archiv/rev" + m.group(1);
        }
        m = Pattern.compile("^(\\d+)$").matcher(version);
        if (m.find()) {
            return "https://www.letto.at/download/letto/archiv/rev" + m.group(1);
        }
        return "";
    }

    public void downloadAndInstallLettoWar(String version) {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String tomeedir = conf.getTomEEpath();
        String ziel = tomeedir + "/webapps/letto.war";
        String url = this.toVersionUrl(version);
        if (url.length() > 0) {
            String msg = this.updateService.downloadCheckMd5(url + "/letto.war", url + "/letto.md5", ziel);
            if (msg.length() > 0) {
                System.out.println("Fehler: " + msg);
            }
            if (this.analyzeService.isLinux()) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + ziel, "chmod 755 -R " + ziel});
                this.cmdService.removeThread(cmdThread);
            }
        }
    }

    public void downloadStartStopScripts() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String lettodir = conf.getLettopath();
        String url = "https://www.letto.at/download/letto";
        if (this.analyzeService.isLinux()) {
            this.updateService.download(url + "/update.sh", lettodir + "/update.sh");
            this.updateService.download(url + "/start.sh", lettodir + "/start.sh");
            this.updateService.download(url + "/stop.sh", lettodir + "/stop.sh");
            this.updateService.download(url + "/updatescripts.sh", lettodir + "/updatescripts.sh");
            this.updateService.download(url + "/restart.sh", lettodir + "/restart.sh");
            this.updateService.download(url + "/restartdatabase.sh", lettodir + "/restartdatabase.sh");
            this.updateService.download(url + "/status.sh", lettodir + "/status.sh");
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + lettodir + "/*.sh", "chmod 755 -R " + lettodir + "/*.sh"});
            this.cmdService.removeThread(cmdThread);
        }
    }

    public void downloadAndInstallLTI() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        String ziel = ltidir + "/";
        String url = "https://www.letto.at/download/letto/lti";
        if (url.length() > 0) {
            Object msg = this.updateService.downloadBinary(url + "/lettolti.jar", ziel + "lettolti.jar");
            msg = (String)msg + this.updateService.download(url + "/ltistart.sh", ziel + "ltistart.sh");
            msg = (String)msg + this.updateService.download(url + "/ltistop.sh", ziel + "ltistop.sh");
            msg = (String)msg + this.updateService.download(url + "/ltistatus.sh", ziel + "ltistatus.sh");
            if (((String)(msg = (String)msg + this.updateService.download(url + "/ltiupdate.sh", ziel + "ltiupdate.sh"))).length() > 0) {
                System.out.println("Fehler: " + (String)msg);
            }
            if (this.analyzeService.isLinux()) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + ziel + "*", "chmod 755 -R " + ziel + "*"});
                this.cmdService.removeThread(cmdThread);
            }
            Vector<Object> applicationProperties = new Vector<Object>();
            applicationProperties.add("spring.jpa.properties.hibernate.dialect=org.hibernate.dialect.MySQL8Dialect");
            applicationProperties.add("spring.datasource.url=" + conf.getLtiDatabaseUrl() + "?serverTimezone=Europe/Vienna&autoReconnect=true&allowPublicKeyRetrieval=true&useSSL=false&useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false");
            applicationProperties.add("pring.datasource.username=" + conf.getLtiDatabaseUser());
            applicationProperties.add("spring.datasource.password=" + conf.getLtiDatabasePassword());
            Cmd.writelnfile(applicationProperties, (File)new File(ziel + "application.properties"));
            this.startLocalLTI();
        }
    }

    public void startLocalLTI() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.analyzeService.getSystemUsername().equals("root") ? this.cmdService.cmdScriptForeground(180000L, new String[]{"sudo -u letto " + ltidir + "/ltistart.sh"}) : this.cmdService.cmdScriptForeground(180000L, new String[]{ltidir + "/ltistart.sh"});
            this.cmdService.removeThread(cmdThread);
        } else {
            System.out.println("LTI ist nur mit Linux start- und stoppbar!");
        }
    }

    public void stopLocalLTI() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        if (this.analyzeService.isLinux()) {
            CmdThread cmdThread = this.analyzeService.getSystemUsername().equals("root") ? this.cmdService.cmdScriptForeground(180000L, new String[]{"sudo -u letto " + ltidir + "/ltistop.sh"}) : this.cmdService.cmdScriptForeground(180000L, new String[]{ltidir + "/ltistop.sh"});
            this.cmdService.removeThread(cmdThread);
        } else {
            System.out.println("LTI ist nur mit Linux start- und stoppbar!");
        }
    }

    public void symbolicLink(String base, String target) {
        File targetfile = new File(target);
        try {
            if (targetfile.exists()) {
                targetfile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!targetfile.exists()) {
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(10000L, new String[]{"ln -s " + base + " " + target});
            this.cmdService.removeThread(cmdThread);
        }
    }

    public String installLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        String email = conf.getLettoAdminEmail();
        String dnsname = conf.getLettoDnsName();
        if (this.analyzeService.isLinux()) {
            Vector<Object> data = new Vector<Object>();
            data.add("<VirtualHost *:80>");
            data.add("  ServerAdmin " + email);
            data.add("  ServerName  " + dnsname);
            data.add("  DocumentRoot /var/www/html");
            data.add("  ErrorLog ${APACHE_LOG_DIR}/error.log");
            data.add("  CustomLog ${APACHE_LOG_DIR}/access.log combined");
            data.add("  RewriteEngine on");
            data.add("  RewriteCond %{SERVER_NAME} $dnsname");
            data.add("  RewriteRule ^ https://%{SERVER_NAME}%{REQUEST_URI} [END,NE,R=permanent]");
            data.add("</VirtualHost>");
            data.add("");
            data.add("<IfModule mod_ssl.c>");
            data.add("  <VirtualHost *:443>");
            data.add("    ServerAdmin " + email);
            data.add("    ServerName  " + dnsname);
            data.add("    DocumentRoot /var/www/html");
            data.add("    ErrorLog ${APACHE_LOG_DIR}/error.log");
            data.add("    CustomLog ${APACHE_LOG_DIR}/access.log combined");
            data.add("    SSLEngine on");
            data.add("    SSLProxyEngine  On");
            data.add("    ProxyRequests   Off");
            data.add("    ProxyPreserveHost On");
            data.add("    <Location /letto>");
            data.add("      ProxyPass ajp://localhost:8089/letto");
            data.add("    </Location>");
            data.add("    <Location /lti3>");
            data.add("      ProxyPass ajp://localhost:9099/lti3");
            data.add("    </Location>");
            data.add("    <Location /oidc>");
            data.add("      ProxyPass ajp://localhost:9099/oidc");
            data.add("    </Location>");
            data.add("    <Location /setup>");
            data.add("      ProxyPass ajp://localhost:7096/setup");
            data.add("    </Location>");
            data.add("");
            data.add("    # SSH Zertifikate mittels letsencrypt und certbot verwenden");
            data.add("    #Include               /etc/letsencrypt/options-ssl-apache.conf");
            data.add("    #SSLCertificateFile    /etc/letsencrypt/live/$dnsname/fullchain.pem");
            data.add("    #SSLCertificateKeyFile /etc/letsencrypt/live/$dnsname/privkey.pem");
            data.add("");
            data.add("    # SSH Zertifikate selbstzertifiziert");
            data.add("    SSLCertificateFile      /etc/ssl/certs/ssl-cert-snakeoil.pem");
            data.add("    SSLCertificateKeyFile /etc/ssl/private/ssl-cert-snakeoil.key");
            data.add("  </VirtualHost>");
            data.add("</IfModule>");
            Cmd.writelnfile(data, (File)new File("/etc/apache2/sites-available/letto.conf"));
            data = new Vector();
            data.add("<html>");
            data.add("<head>");
            data.add("        <meta http-equiv=\"refresh\" content=\"0; URL=https://" + dnsname + "/letto\">");
            data.add("</head>");
            data.add("</html>");
            Cmd.writelnfile(data, (File)new File("/var/www/html/index.html"));
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"apt-get -y install apache2 php python3-certbot-apache", "a2enmod ssl", "a2enmod proxy", "a2enmod proxy_ajp", "a2enmod rewrite", "rm /etc/apache2/sites-enabled/* -f", "ln -s /etc/apache2/sites-available/letto.conf /etc/apache2/sites-enabled/letto.conf", "service apache2 stop", "service apache2 start"});
                this.symbolicLink("/opt/letto/images", "/var/www/html/images");
                this.symbolicLink("/opt/letto/js", "/var/www/html/js");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/index.html");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/photos/index.html");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/plugins/index.html");
            }
        } else {
            return "Apache2 ist nur mit Linux start- und stoppbar!";
        }
        this.analyzeService.setOwnerLetto(new String[]{"/etc/apache2/sites-available/letto.conf", "/var/www/html/index.html"});
        return "";
    }

    public String insertSetupInLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        String email = conf.getLettoAdminEmail();
        String dnsname = conf.getLettoDnsName();
        if (this.analyzeService.isLinux()) {
            Vector<Object> data = new Vector<Object>();
            data.add("<VirtualHost *:80>");
            data.add("  ServerAdmin " + email);
            data.add("  ServerName  " + dnsname);
            data.add("  DocumentRoot /var/www/html");
            data.add("  ErrorLog ${APACHE_LOG_DIR}/error.log");
            data.add("  CustomLog ${APACHE_LOG_DIR}/access.log combined");
            data.add("  RewriteEngine on");
            data.add("  RewriteCond %{SERVER_NAME} $dnsname");
            data.add("  RewriteRule ^ https://%{SERVER_NAME}%{REQUEST_URI} [END,NE,R=permanent]");
            data.add("</VirtualHost>");
            data.add("");
            data.add("<IfModule mod_ssl.c>");
            data.add("  <VirtualHost *:443>");
            data.add("    ServerAdmin " + email);
            data.add("    ServerName  " + dnsname);
            data.add("    DocumentRoot /var/www/html");
            data.add("    ErrorLog ${APACHE_LOG_DIR}/error.log");
            data.add("    CustomLog ${APACHE_LOG_DIR}/access.log combined");
            data.add("    SSLEngine on");
            data.add("    SSLProxyEngine  On");
            data.add("    ProxyRequests   Off");
            data.add("    ProxyPreserveHost On");
            data.add("    <Location /letto>");
            data.add("      ProxyPass ajp://localhost:8089/letto");
            data.add("    </Location>");
            data.add("    <Location /lti3>");
            data.add("      ProxyPass ajp://localhost:9099/lti3");
            data.add("    </Location>");
            data.add("    <Location /oidc>");
            data.add("      ProxyPass ajp://localhost:9099/oidc");
            data.add("    </Location>");
            data.add("    <Location /setup>");
            data.add("      ProxyPass ajp://localhost:7096/setup");
            data.add("    </Location>");
            data.add("");
            data.add("    # SSH Zertifikate mittels letsencrypt und certbot verwenden");
            data.add("    #Include               /etc/letsencrypt/options-ssl-apache.conf");
            data.add("    #SSLCertificateFile    /etc/letsencrypt/live/$dnsname/fullchain.pem");
            data.add("    #SSLCertificateKeyFile /etc/letsencrypt/live/$dnsname/privkey.pem");
            data.add("");
            data.add("    # SSH Zertifikate selbstzertifiziert");
            data.add("    SSLCertificateFile      /etc/ssl/certs/ssl-cert-snakeoil.pem");
            data.add("    SSLCertificateKeyFile /etc/ssl/private/ssl-cert-snakeoil.key");
            data.add("  </VirtualHost>");
            data.add("</IfModule>");
            Cmd.writelnfile(data, (File)new File("/etc/apache2/sites-available/letto.conf"));
            data = new Vector();
            data.add("<html>");
            data.add("<head>");
            data.add("        <meta http-equiv=\"refresh\" content=\"0; URL=https://" + dnsname + "/letto\">");
            data.add("</head>");
            data.add("</html>");
            Cmd.writelnfile(data, (File)new File("/var/www/html/index.html"));
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"apt-get -y install apache2 php python3-certbot-apache", "a2enmod ssl", "a2enmod proxy", "a2enmod proxy_ajp", "a2enmod rewrite", "rm /etc/apache2/sites-enabled/* -f", "ln -s /etc/apache2/sites-available/letto.conf /etc/apache2/sites-enabled/letto.conf", "service apache2 stop", "service apache2 start"});
                this.symbolicLink("/opt/letto/images", "/var/www/html/images");
                this.symbolicLink("/opt/letto/js", "/var/www/html/js");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/index.html");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/photos/index.html");
                this.symbolicLink("/var/www/html/index.html", "/opt/letto/images/plugins/index.html");
            }
        } else {
            return "Apache2 ist nur mit Linux start- und stoppbar!";
        }
        this.analyzeService.setOwnerLetto(new String[]{"/etc/apache2/sites-available/letto.conf", "/var/www/html/index.html"});
        return "";
    }

    public String startLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        if (this.analyzeService.isLinux()) {
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"service apache2 start"});
            }
        } else {
            return "Apache2 ist nur mit Linux start- und stoppbar!";
        }
        return "";
    }

    public String stopLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        if (this.analyzeService.isLinux()) {
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"service apache2 stop"});
            }
        } else {
            return "Apache2 ist nur mit Linux start- und stoppbar!";
        }
        return "";
    }

    public String restartLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        if (this.analyzeService.isLinux()) {
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"service apache2 restart"});
            }
        } else {
            return "Apache2 ist nur mit Linux start- und stoppbar!";
        }
        return "";
    }

    public void deleteLocalApache() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String ltidir = conf.getLTIpath();
        String email = conf.getLettoAdminEmail();
        String dnsname = conf.getLettoDnsName();
        if (this.analyzeService.isLinux()) {
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(180000L, new String[]{"apt-get purge apache2", "rm /etc/apache2/sites-enabled/* -f", "rm /etc/apache2/sites-available/* -f"});
            }
        } else {
            System.out.println("Apache2 ist nur mit Linux start- und stoppbar!");
        }
    }

    public File getLocalApacheLogfile() {
        try {
            this.createDir("/opt/letto/logs");
            if (this.analyzeService.getSystemUsername().equals("root")) {
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(6000L, new String[]{"echo systemctl status apache2: >/opt/letto/logs/apache2.log", "systemctl status apache2.service --dry-run --no-pager -l >>/opt/letto/logs/apache2.log", "echo >>/opt/letto/logs/apache2.log", "echo >>/opt/letto/logs/apache2.log", "echo journalctl -xe >>/opt/letto/logs/apache2.log", "journalctl -xe --dry-run --no-pager >>/opt/letto/logs/apache2.log"});
            }
            return new File("/opt/letto/logs/apache2.log");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getLocalApacheConfigfile() {
        try {
            return new File("/etc/apache2/sites-available/letto.conf");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setLettoLocalAutostart(boolean set) {
        this.analyzeService.analyzeAutostart();
        this.analyzeService.local_letto_autostart = set;
        this.setLocalAutostart();
    }

    public void setLTILocalAutostart(boolean set) {
        this.analyzeService.analyzeAutostart();
        this.analyzeService.local_lti_autostart = set;
        this.setLocalAutostart();
    }

    public void setSetupLocalAutostart(boolean set, boolean root) {
        this.analyzeService.analyzeAutostart();
        this.analyzeService.local_setup_autostart = set;
        this.analyzeService.local_setup_root = root;
        this.setLocalAutostart();
    }

    public void setLocalAutostart() {
        if (this.analyzeService.isLinux()) {
            Vector<String> data;
            int lastline = 0;
            File rclocal = new File("/etc/rc.local");
            if (rclocal.exists()) {
                data = Cmd.readfile((File)rclocal);
                lastline = data.size();
                for (int i = 0; i < data.size(); ++i) {
                    String s = (String)data.get(i);
                    if (s.matches(".*\\/opt\\/letto\\/lti\\/ltistart\\.sh.*")) {
                        data.remove(i--);
                    }
                    if (s.matches(".*\\/opt\\/letto\\/start\\.sh.*")) {
                        data.remove(i--);
                    }
                    if (s.matches("\\s*sudo\\s+-u\\s+letto\\s+\\/opt\\/letto\\/setup\\/startlettosetup\\.sh.*")) {
                        data.remove(i--);
                    }
                    if (s.matches("\\s*\\/opt\\/letto\\/setup\\/startlettosetup\\.sh.*")) {
                        data.remove(i--);
                    }
                    if (!s.matches("\\s*exit\\s+0.*")) continue;
                    data.remove(i--);
                }
            } else {
                data = new Vector<String>();
                data.add("#!/bin/sh -e");
            }
            if (this.analyzeService.local_setup_autostart) {
                if (this.analyzeService.local_setup_root) {
                    data.add("/opt/letto/setup/startlettosetup.sh");
                } else {
                    data.add("sudo -u letto /opt/letto/setup/startlettosetup.sh");
                }
            }
            if (this.analyzeService.local_letto_autostart) {
                data.add("sudo -u letto /opt/letto/start.sh");
            }
            if (this.analyzeService.local_lti_autostart) {
                data.add("sudo -u letto /opt/letto/lti/ltistart.sh");
            }
            data.add("exit 0");
            Cmd.writelnfile(data, (File)rclocal);
            CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chmod 755 -R /etc/rc.local"});
            this.cmdService.removeThread(cmdThread);
        }
    }

    public String updateLettoLocal(String revision) {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        boolean running = true;
        if (revision == null) {
            revision = "";
        }
        revision = revision.trim();
        if (!this.analyzeService.localTomEErunning()) {
            this.startLocalTomEE();
            running = false;
        }
        String ziel = conf.getPropertyString("letto_tomee_letto_war");
        Object quelle = revision.length() == 0 ? "https://www.letto.at/download/letto/daily" : (revision.equals("beta") ? "https://www.letto.at/download/letto/beta" : (revision.equals("daily") ? "https://www.letto.at/download/letto/daily" : (revision.equals("stable") ? "https://www.letto.at/download/letto/stable" : "https://www.letto.at/download/letto/archiv/rev" + revision)));
        String msg = this.updateService.downloadCheckMd5((String)quelle + "/letto.war", (String)quelle + "/letto.md5", ziel);
        if (msg.length() > 0) {
            if (revision.matches("\\d+.*")) {
                quelle = "https://www.letto.at/download/letto/archiv/letto" + revision + ".war";
                msg = this.updateService.download((String)quelle, ziel);
            } else if (revision.equals("daily")) {
                quelle = "https://www.letto.at/download/letto/letto-daily";
                msg = this.updateService.downloadCheckMd5((String)quelle + ".war", (String)quelle + ".md5", ziel);
            } else if (revision.equals("stable")) {
                quelle = "https://www.letto.at/download/letto/letto-stable";
                msg = this.updateService.downloadCheckMd5((String)quelle + ".war", (String)quelle + ".md5", ziel);
            }
        }
        if (msg.length() > 0) {
            return msg;
        }
        return "";
    }

    public String updateLtiLocal(String revision) {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        boolean running = false;
        if (this.analyzeService.localLTIrunning()) {
            this.stopLocalLTI();
            running = true;
        }
        String ziel = conf.getPropertyString("letto_lti_home") + "/lettolti.jar";
        Object quelle = revision == null || revision.length() == 0 ? "https://www.letto.at/download/letto/lti" : (revision.equals("beta") ? "https://www.letto.at/download/letto/beta" : (revision.equals("daily") ? "https://www.letto.at/download/letto/daily" : (revision.equals("stable") ? "https://www.letto.at/download/letto/stable" : "https://www.letto.at/download/letto/archiv/rev" + revision)));
        String msg = this.updateService.downloadCheckMd5((String)quelle + "/lettolti.jar", (String)quelle + "/lettolti.md5", ziel);
        if (running) {
            this.startLocalLTI();
        }
        if (msg.length() > 0) {
            return msg;
        }
        return "";
    }

    public String localSicherungEinrichten() {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String lettouser = conf.getPropertyString("letto_tomee_mysql_user");
        String lettoserver = conf.getPropertyString("letto_tomee_mysql_server");
        String lettodatabase = conf.getPropertyString("letto_tomee_mysql_database");
        String lettopassword = conf.getPropertyString("letto_tomee_mysql_password");
        String ltiuser = conf.getPropertyString("letto_lti_mysql_user");
        String ltiserver = conf.getPropertyString("letto_lti_mysql_server");
        String ltidatabase = conf.getPropertyString("letto_lti_mysql_database");
        String ltipassword = conf.getPropertyString("letto_lti_mysql_password");
        String password = conf.getPropertyString("letto_mysql_sicherungspasswort");
        String user = conf.getPropertyString("letto_mysql_sicherungsuser");
        File sicherungsdir = new File("/sicherung");
        try {
            if (!sicherungsdir.exists()) {
                sicherungsdir.mkdir();
            }
            this.analyzeService.setOwnerLetto(new File[]{sicherungsdir});
        }
        catch (Exception ex) {
            return "/sicherung kann nicht angelegt werden!";
        }
        File sicherung = new File("/sicherung/sicherung.sh");
        Vector<Object> data = new Vector<Object>();
        data.add("#!/bin/bash");
        data.add("datum=$(date)");
        data.add("IFS=' '");
        data.add("datearray=($datum)");
        data.add("wochentag=${datearray[0]}");
        data.add("monat=${datearray[1]}");
        data.add("tag=${datearray[2]}");
        data.add("jahr=${datearray[5]}");
        data.add("echo Sicherung am $tag.$monat.$jahr $wochentag");
        data.add("touch    /sicherung/sqlsicherungaktiv");
        data.add("sudo -u letto /opt/letto/stop.sh");
        data.add("mysqldump --user=" + user + " --password=" + password + " -h " + lettoserver + " " + lettodatabase + " | gzip -9 >/sicherung/letto.sql.gz");
        data.add("mysqldump --user=" + user + " --password=" + password + " -h " + ltiserver + " " + ltidatabase + " | gzip -9 >/sicherung/lettolti.sql.gz");
        data.add("mysqldump --user=" + user + " --password=" + password + " -h " + lettoserver + " " + lettodatabase + " | gzip -9 >/sicherung/mysql.sql.gz");
        data.add("tar -czhf /sicherung/opt-letto.tgz /opt/letto");
        data.add("tar -czf /sicherung/opt-tomee.tgz /opt/tomee/*");
        data.add("tar -czf /sicherung/etc.tgz /etc");
        data.add("tar -czf /sicherung/varwww.tgz /var/www");
        data.add("sudo -u letto /opt/letto/start.sh");
        data.add("rm  -rf  /sicherung/sqlsicherungaktiv");
        data.add("if ! [ -e /sicherung/weekdays/ ] ; then mkdir /sicherung/weekdays; fi");
        data.add("if ! [ -e /sicherung/month/ ] ; then mkdir /sicherung/month; fi");
        data.add("# t\u00e4gliche Sicherung");
        data.add("if ! [ -e /sicherung/weekdays/$wochentag ]; then mkdir -p /sicherung/weekdays/$wochentag; fi");
        data.add("cp /sicherung/letto.sql.gz /sicherung/weekdays/$wochentag/");
        data.add("cp /sicherung/lettolti.sql.gz /sicherung/weekdays/$wochentag/");
        data.add("# monatliche Sicherung");
        data.add("if [ $tag == 1 ] ; then");
        data.add("  sv=\"/sicherung/month/$jahr-$monat\"");
        data.add("  if ! [ -e $sv ]; then mkdir -p $sv; fi");
        data.add("  cp /sicherung/*gz $sv/");
        data.add("fi");
        Cmd.writelnfile(data, (File)sicherung);
        this.analyzeService.setOwnerLetto(new File[]{sicherung});
        this.localSicherungCronStart();
        return "";
    }

    public String localSicherungCronStart() {
        Vector data;
        File crontab = new File("/etc/crontab");
        if (crontab.exists()) {
            data = Cmd.readfile((File)crontab);
            for (int i = 0; i < data.size(); ++i) {
                String s = (String)data.get(i);
                if (!s.matches(".*\\/sicherung\\/sicherung\\.sh.*")) continue;
                data.remove(i--);
            }
        } else {
            return "/etc/crontab not exists. Crontab cannot be configured !!";
        }
        this.analyzeService.local_sicherung_cron = true;
        this.analyzeService.local_sicherung_crontab = "00 01    * * *   root    /sicherung/sicherung.sh";
        data.add(this.analyzeService.local_sicherung_crontab);
        Cmd.writelnfile((Vector)data, (File)crontab);
        return "";
    }

    public String localSicherungCronStop() {
        Vector data;
        File crontab = new File("/etc/crontab");
        if (crontab.exists()) {
            data = Cmd.readfile((File)crontab);
            for (int i = 0; i < data.size(); ++i) {
                String s = (String)data.get(i);
                if (!s.matches(".*\\/sicherung\\/sicherung\\.sh.*")) continue;
                data.remove(i--);
            }
        } else {
            return "/etc/crontab not exists. Crontab cannot be configured !!";
        }
        this.analyzeService.local_sicherung_cron = false;
        this.analyzeService.local_sicherung_crontab = "";
        Cmd.writelnfile((Vector)data, (File)crontab);
        return "";
    }

    public CmdThread sicherungLocal(String backlink) {
        String[] commands = new String[]{"/sicherung/sicherung.sh"};
        return this.cmdService.cmdScriptBackground(backlink, this.analyzeService.getUserDir(), commands);
    }

    public CmdThread sicherungLocalLettoImportLast(String backlink) {
        return this.sicherungLocalLettoImport("/sicherung/letto.sql.gz", backlink);
    }

    public CmdThread sicherungLocalLettoImport(String filename, String backlink) {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String lettouser = conf.getPropertyString("letto_tomee_mysql_user");
        String lettoserver = conf.getPropertyString("letto_tomee_mysql_server");
        String lettodatabase = conf.getPropertyString("letto_tomee_mysql_database");
        String lettopassword = conf.getPropertyString("letto_tomee_mysql_password");
        String ltiuser = conf.getPropertyString("letto_lti_mysql_user");
        String ltiserver = conf.getPropertyString("letto_lti_mysql_server");
        String ltidatabase = conf.getPropertyString("letto_lti_mysql_database");
        String ltipassword = conf.getPropertyString("letto_lti_mysql_password");
        String password = conf.getPropertyString("letto_mysql_sicherungspasswort");
        String user = conf.getPropertyString("letto_mysql_sicherungsuser");
        File sicherung = new File(filename);
        if (sicherung.exists() && sicherung.isFile()) {
            Object cmd = "";
            cmd = filename.endsWith(".gz") ? "zcat " + sicherung.getAbsolutePath() + " | mysql --user=" + lettouser + " --password=" + lettopassword + " -h " + lettoserver + " " + lettodatabase : "mysql --user=" + lettouser + " --password=" + lettopassword + " -h " + lettoserver + " " + lettodatabase + " <" + sicherung.getAbsolutePath();
            String[] commands = new String[]{"/opt/letto/stop.sh", "mysql --user=" + lettouser + " --password=" + lettopassword + " -h " + lettoserver + " -e\"drop database if exists " + lettodatabase + ";create database " + lettodatabase + ";\"", cmd, "/opt/letto/start.sh"};
            return this.cmdService.cmdScriptBackground(backlink, this.analyzeService.getUserDir(), commands);
        }
        return null;
    }

    public CmdThread sicherungLocalLtiImportLast(String backlink) {
        return this.sicherungLocalLtiImport("/sicherung/lettolti.sql.gz", backlink);
    }

    public CmdThread sicherungLocalLtiImport(String filename, String backlink) {
        LettoSetupConfigFile conf = this.setupConfiguration.getConf();
        String lettouser = conf.getPropertyString("letto_tomee_mysql_user");
        String lettoserver = conf.getPropertyString("letto_tomee_mysql_server");
        String lettodatabase = conf.getPropertyString("letto_tomee_mysql_database");
        String lettopassword = conf.getPropertyString("letto_tomee_mysql_password");
        String ltiuser = conf.getPropertyString("letto_lti_mysql_user");
        String ltiserver = conf.getPropertyString("letto_lti_mysql_server");
        String ltidatabase = conf.getPropertyString("letto_lti_mysql_database");
        String ltipassword = conf.getPropertyString("letto_lti_mysql_password");
        String password = conf.getPropertyString("letto_mysql_sicherungspasswort");
        String user = conf.getPropertyString("letto_mysql_sicherungsuser");
        File sicherung = new File(filename);
        if (sicherung.exists() && sicherung.isFile()) {
            Object cmd = "";
            cmd = filename.endsWith(".gz") ? "zcat " + sicherung.getAbsolutePath() + " | mysql --user=" + ltiuser + " --password=" + ltipassword + " -h " + ltiserver + " " + ltidatabase : "mysql --user=" + ltiuser + " --password=" + ltipassword + " -h " + ltiserver + " " + ltidatabase + " <" + sicherung.getAbsolutePath();
            String[] commands = new String[]{"/opt/letto/lti/ltistop.sh", "mysql --user=" + ltiuser + " --password=" + ltipassword + " -h " + ltiserver + " -e\"drop database if exists " + ltidatabase + ";create database " + ltidatabase + ";\"", cmd, "/opt/letto/ltistart.sh"};
            return this.cmdService.cmdScriptBackground(backlink, this.analyzeService.getUserDir(), commands);
        }
        return null;
    }

    public String localUpdateCronStart() {
        Vector data;
        File crontab = new File("/etc/crontab");
        if (crontab.exists()) {
            data = Cmd.readfile((File)crontab);
            for (int i = 0; i < data.size(); ++i) {
                String s = (String)data.get(i);
                if (!s.matches(".*\\/opt\\/letto\\/update\\.sh.*")) continue;
                data.remove(i--);
            }
        } else {
            return "/etc/crontab not exists. Crontab cannot be configured !!";
        }
        this.analyzeService.local_update_cron = true;
        this.analyzeService.local_update_crontab = "00 05    * * 6   letto    /opt/letto/update.sh";
        data.add(this.analyzeService.local_update_crontab);
        Cmd.writelnfile((Vector)data, (File)crontab);
        return "";
    }

    public String localUpdateCronStop() {
        Vector data;
        File crontab = new File("/etc/crontab");
        if (crontab.exists()) {
            data = Cmd.readfile((File)crontab);
            for (int i = 0; i < data.size(); ++i) {
                String s = (String)data.get(i);
                if (!s.matches(".*\\/opt\\/letto\\/update\\.sh.*")) continue;
                data.remove(i--);
            }
        } else {
            return "/etc/crontab not exists. Crontab cannot be configured !!";
        }
        this.analyzeService.local_update_cron = false;
        this.analyzeService.local_update_crontab = "";
        Cmd.writelnfile((Vector)data, (File)crontab);
        return "";
    }
}

