-- MySQL dump 10.13  Distrib 8.0.30, for Linux (x86_64)
--
-- Host: localhost    Database: letto_base
-- ------------------------------------------------------
-- Server version	8.0.30

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `Cpu`
--

DROP TABLE IF EXISTS `Cpu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Cpu` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `APPLICATION` varchar(255) DEFAULT NULL,
  `CPULOAD` double DEFAULT NULL,
  `TIME` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3195 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Cpu`
--

LOCK TABLES `Cpu` WRITE;
/*!40000 ALTER TABLE `Cpu` DISABLE KEYS */;
INSERT INTO `Cpu` VALUES (2262,'lettohtlstp',0.0041168290609309485,'2022-10-01 09:37:46'),(2263,'lettohtlstp',0.004471576548818417,'2022-10-01 09:38:46'),(2265,'lettohtlstp',0.008733292723496402,'2022-10-01 09:39:46'),(2267,'lettohtlstp',0.00907744361544426,'2022-10-01 09:40:46'),(2269,'lettohtlstp',0.0043046162653363855,'2022-10-01 09:41:46'),(2272,'lettohtlstp',0.0028264863399526706,'2022-10-01 09:42:46'),(3192,'lettohtlstp',0.01567430848585636,'2022-10-01 09:43:46'),(3193,'lettohtlstp',0.004390567926521033,'2022-10-01 09:44:46'),(3194,'lettohtlstp',0.0024886673622546915,'2022-10-01 09:45:46');
/*!40000 ALTER TABLE `Cpu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `FilesForTestDetails`
--

DROP TABLE IF EXISTS `FilesForTestDetails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `FilesForTestDetails` (
  `TestDetail_ID` int DEFAULT NULL,
  `FILES` longtext,
  KEY `FK_FilesForTestDetails_TestDetail_ID` (`TestDetail_ID`),
  CONSTRAINT `FK_FilesForTestDetails_TestDetail_ID` FOREIGN KEY (`TestDetail_ID`) REFERENCES `testDetails` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `FilesForTestDetails`
--

LOCK TABLES `FilesForTestDetails` WRITE;
/*!40000 ALTER TABLE `FilesForTestDetails` DISABLE KEYS */;
/*!40000 ALTER TABLE `FilesForTestDetails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Info`
--

DROP TABLE IF EXISTS `Info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `Info` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(40) NOT NULL,
  `WERT` varchar(100) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Info`
--

LOCK TABLES `Info` WRITE;
/*!40000 ALTER TABLE `Info` DISABLE KEYS */;
INSERT INTO `Info` VALUES (1,'version','193.170.118.80,Mon May 04 19:13:14 CEST 2015'),(4,'db_change','6500'),(10,'init','');
/*!40000 ALTER TABLE `Info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LogMsg`
--

DROP TABLE IF EXISTS `LogMsg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `LogMsg` (
  `id` int NOT NULL AUTO_INCREMENT,
  `CPULOAD` double DEFAULT NULL,
  `IDPREV` int DEFAULT NULL,
  `METHODNAME` varchar(255) DEFAULT NULL,
  `MSG` longtext,
  `TIME` datetime DEFAULT NULL,
  `TIMEINMILLIS` bigint DEFAULT NULL,
  `TYP` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_LogMsg_idUser` (`idUser`),
  CONSTRAINT `FK_LogMsg_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LogMsg`
--

LOCK TABLES `LogMsg` WRITE;
/*!40000 ALTER TABLE `LogMsg` DISABLE KEYS */;
/*!40000 ALTER TABLE `LogMsg` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MoodleFile`
--

DROP TABLE IF EXISTS `MoodleFile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `MoodleFile` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BREITE` int DEFAULT NULL,
  `FILENAME` varchar(100) DEFAULT NULL,
  `TAGALT` varchar(100) DEFAULT NULL,
  `TAGHEIGHT` int DEFAULT NULL,
  `TAGSTYLE` varchar(100) DEFAULT NULL,
  `TAGTITLE` varchar(100) DEFAULT NULL,
  `TAGWIDTH` int DEFAULT NULL,
  `idImage` varchar(100) DEFAULT NULL,
  `idText` bigint DEFAULT NULL,
  `files_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_MoodleFile_idImage` (`idImage`),
  KEY `FK_MoodleFile_idText` (`idText`),
  CONSTRAINT `FK_MoodleFile_idImage` FOREIGN KEY (`idImage`) REFERENCES `images` (`MD5`),
  CONSTRAINT `FK_MoodleFile_idText` FOREIGN KEY (`idText`) REFERENCES `moodleText` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3055 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MoodleFile`
--

LOCK TABLES `MoodleFile` WRITE;
/*!40000 ALTER TABLE `MoodleFile` DISABLE KEYS */;
INSERT INTO `MoodleFile` VALUES (2280,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2279,0),(2281,0,'Clipboard.png','',0,'','',15,'7276d3109302f65936a55fae1fb9aa0',2279,1),(2297,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2296,0),(2298,0,'LeTTo_Logo_animated_100.gif','',0,'','',2,'525c15c31e66eab77f1be8e845931b',2296,1),(2314,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2313,0),(2315,0,'Clipboard.png','',0,'','',5,'1769dd3d6ad813cfa2458d2afb473ba9',2313,1),(2333,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2332,0),(2334,0,'Clipboard.png','',0,'','',5,'1769dd3d6ad813cfa2458d2afb473ba9',2332,1),(2350,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2349,0),(2368,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2367,0),(2384,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2383,0),(2402,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2401,0),(2403,0,'Clipboard.png','',0,'','',5,'1769dd3d6ad813cfa2458d2afb473ba9',2401,1),(2404,0,'LeTTo_Logo_animated_100.gif','',0,'','',2,'525c15c31e66eab77f1be8e845931b',2401,2),(2436,0,'Clipboard.png','',0,'','',5,'6dd7774d667fd069333acfc79646',2435,0),(2613,0,'Clipboard.png','',0,'','',50,'5774cec878624c2dea29aff334bc787',2612,0),(2815,0,'Clipboard.png','',0,'','',50,'bfcbd89c9af61e1a9bc87c3daff2b1d',2814,0),(2826,0,'Clipboard.png','',0,'','',50,'5774cec878624c2dea29aff334bc787',2825,0),(3054,0,'1ZT9_P4aMWc[1]','',0,'','',50,'2de2caa0c1df48586e76bb5a53ee87b9',3053,0);
/*!40000 ALTER TABLE `MoodleFile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SEQUENCE`
--

DROP TABLE IF EXISTS `SEQUENCE`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SEQUENCE` (
  `SEQ_NAME` varchar(50) NOT NULL,
  `SEQ_COUNT` decimal(38,0) DEFAULT NULL,
  PRIMARY KEY (`SEQ_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SEQUENCE`
--

LOCK TABLES `SEQUENCE` WRITE;
/*!40000 ALTER TABLE `SEQUENCE` DISABLE KEYS */;
INSERT INTO `SEQUENCE` VALUES ('SEQ_GEN',3200);
/*!40000 ALTER TABLE `SEQUENCE` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SPRING_SESSION`
--

DROP TABLE IF EXISTS `SPRING_SESSION`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SPRING_SESSION` (
  `PRIMARY_ID` char(36) NOT NULL,
  `SESSION_ID` char(36) NOT NULL,
  `CREATION_TIME` bigint NOT NULL,
  `LAST_ACCESS_TIME` bigint NOT NULL,
  `MAX_INACTIVE_INTERVAL` int NOT NULL,
  `EXPIRY_TIME` bigint NOT NULL,
  `PRINCIPAL_NAME` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`PRIMARY_ID`),
  UNIQUE KEY `SPRING_SESSION_IX1` (`SESSION_ID`),
  KEY `SPRING_SESSION_IX2` (`EXPIRY_TIME`),
  KEY `SPRING_SESSION_IX3` (`PRINCIPAL_NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SPRING_SESSION`
--

LOCK TABLES `SPRING_SESSION` WRITE;
/*!40000 ALTER TABLE `SPRING_SESSION` DISABLE KEYS */;
/*!40000 ALTER TABLE `SPRING_SESSION` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SPRING_SESSION_ATTRIBUTES`
--

DROP TABLE IF EXISTS `SPRING_SESSION_ATTRIBUTES`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `SPRING_SESSION_ATTRIBUTES` (
  `SESSION_PRIMARY_ID` char(36) NOT NULL,
  `ATTRIBUTE_NAME` varchar(200) NOT NULL,
  `ATTRIBUTE_BYTES` blob NOT NULL,
  PRIMARY KEY (`SESSION_PRIMARY_ID`,`ATTRIBUTE_NAME`),
  CONSTRAINT `SPRING_SESSION_ATTRIBUTES_FK` FOREIGN KEY (`SESSION_PRIMARY_ID`) REFERENCES `SPRING_SESSION` (`PRIMARY_ID`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SPRING_SESSION_ATTRIBUTES`
--

LOCK TABLES `SPRING_SESSION_ATTRIBUTES` WRITE;
/*!40000 ALTER TABLE `SPRING_SESSION_ATTRIBUTES` DISABLE KEYS */;
/*!40000 ALTER TABLE `SPRING_SESSION_ATTRIBUTES` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `abteilung`
--

DROP TABLE IF EXISTS `abteilung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `abteilung` (
  `id` int NOT NULL AUTO_INCREMENT,
  `AV` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `INFO` varchar(100) DEFAULT NULL,
  `KURZBEZEICHNUNG` varchar(20) NOT NULL,
  `NAME` varchar(100) NOT NULL,
  `OULEHRER` varchar(40) DEFAULT NULL,
  `OUSCHUELER` varchar(40) DEFAULT NULL,
  `TELEFON` varchar(100) DEFAULT NULL,
  `WEB` varchar(100) DEFAULT NULL,
  `idSchule` int NOT NULL,
  `abteilungs_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_abteilung_idSchule` (`idSchule`),
  CONSTRAINT `FK_abteilung_idSchule` FOREIGN KEY (`idSchule`) REFERENCES `schule` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `abteilung`
--

LOCK TABLES `abteilung` WRITE;
/*!40000 ALTER TABLE `abteilung` DISABLE KEYS */;
INSERT INTO `abteilung` VALUES (1,NULL,NULL,NULL,'ABT','ABT',NULL,NULL,NULL,NULL,1,NULL);
/*!40000 ALTER TABLE `abteilung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity`
--

DROP TABLE IF EXISTS `activity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity` (
  `id` int NOT NULL AUTO_INCREMENT,
  `IDLK` int DEFAULT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `PATH` longtext,
  `VISIBLE` tinyint(1) DEFAULT '0',
  `idActivityType` int DEFAULT NULL,
  `idDokument` int DEFAULT NULL,
  `idLehrerKlasse` int DEFAULT NULL,
  `idParentActivity` int DEFAULT NULL,
  `idQuestion` bigint DEFAULT NULL,
  `ERSTELLER_ID` int DEFAULT NULL,
  `idLink` int DEFAULT NULL,
  `idProject` int DEFAULT NULL,
  `idTest` int DEFAULT NULL,
  `activities_ORDER` int DEFAULT '0',
  `folder_ORDER` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_activity_idLehrerKlasse` (`idLehrerKlasse`),
  KEY `FK_activity_idLink` (`idLink`),
  KEY `FK_activity_ERSTELLER_ID` (`ERSTELLER_ID`),
  KEY `FK_activity_idDokument` (`idDokument`),
  KEY `FK_activity_idQuestion` (`idQuestion`),
  KEY `FK_activity_idActivityType` (`idActivityType`),
  KEY `FK_activity_idParentActivity` (`idParentActivity`),
  KEY `FK_activity_idProject` (`idProject`),
  KEY `FK_activity_idTest` (`idTest`),
  CONSTRAINT `FK_activity_ERSTELLER_ID` FOREIGN KEY (`ERSTELLER_ID`) REFERENCES `user` (`id`),
  CONSTRAINT `FK_activity_idActivityType` FOREIGN KEY (`idActivityType`) REFERENCES `activitytype` (`id`),
  CONSTRAINT `FK_activity_idDokument` FOREIGN KEY (`idDokument`) REFERENCES `dokumente` (`id`),
  CONSTRAINT `FK_activity_idLehrerKlasse` FOREIGN KEY (`idLehrerKlasse`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_activity_idLink` FOREIGN KEY (`idLink`) REFERENCES `inetlinks` (`id`),
  CONSTRAINT `FK_activity_idParentActivity` FOREIGN KEY (`idParentActivity`) REFERENCES `activity` (`id`),
  CONSTRAINT `FK_activity_idProject` FOREIGN KEY (`idProject`) REFERENCES `projekte` (`id`),
  CONSTRAINT `FK_activity_idQuestion` FOREIGN KEY (`idQuestion`) REFERENCES `question` (`id`),
  CONSTRAINT `FK_activity_idTest` FOREIGN KEY (`idTest`) REFERENCES `tests` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity`
--

LOCK TABLES `activity` WRITE;
/*!40000 ALTER TABLE `activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activitytype`
--

DROP TABLE IF EXISTS `activitytype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activitytype` (
  `id` int NOT NULL AUTO_INCREMENT,
  `DESCRIPTION` varchar(100) DEFAULT NULL,
  `IMAGENAME` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100404 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activitytype`
--

LOCK TABLES `activitytype` WRITE;
/*!40000 ALTER TABLE `activitytype` DISABLE KEYS */;
INSERT INTO `activitytype` VALUES (1,'Projekt','projekt.svg'),(77,'HtmlQuestion','htmlquestion.png'),(2658,'Test','test.jpg'),(87551,'Folder','folder.png'),(100401,'Dokument','pdf-24.png'),(100402,'Abgabe','abgabe.png'),(100403,'InetLink','link.svg');
/*!40000 ALTER TABLE `activitytype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `answer`
--

DROP TABLE IF EXISTS `answer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `answer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ANSWER` longtext,
  `CORRECTANSWERFORMAT` int DEFAULT NULL,
  `CORRECTANSWERLENGTH` int DEFAULT NULL,
  `EINHEIT` varchar(255) DEFAULT NULL,
  `FEEDBACK` longtext,
  `FORMAT` varchar(20) DEFAULT NULL,
  `FRACTION` double DEFAULT NULL,
  `MAXIMA` longtext,
  `TEXT` longtext,
  `TOLERANCE` varchar(20) DEFAULT NULL,
  `idAnswer` bigint DEFAULT NULL,
  `answers_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_answer_idAnswer` (`idAnswer`),
  CONSTRAINT `FK_answer_idAnswer` FOREIGN KEY (`idAnswer`) REFERENCES `subquestion` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `answer`
--

LOCK TABLES `answer` WRITE;
/*!40000 ALTER TABLE `answer` DISABLE KEYS */;
INSERT INTO `answer` VALUES (2288,'1',2,5,'','','html',100,'1','Seite gelesen','1.0%',2287,0),(2305,'4.3',2,5,'','','html',100,'x','x','1.0%',2304,0),(2322,'a',2,5,'','','html',100,'','A','1.0%',2321,0),(2323,'b',2,5,'','','html',0,'','B','1.0%',2321,1),(2324,'c',2,5,'','','html',0,'','C','1.0%',2321,2),(2341,'5arg0.9273',2,5,'','','html',100,'z','z','1.0%',2340,0),(2357,'300mV',2,5,'','','html',100,'U','U','1.0%',2356,0),(2359,'2.2kOhm',2,5,'','','html',100,'R','R','0',2358,0),(2375,'0.991',2,5,'','','html',100,'u','u','a0.001',2374,0),(2391,'U/I',2,5,'symbolfull;constvarsnone','','html',100,'erg','U/I','1.0%',2390,0),(2393,'sin(x)/x',2,5,'symbolfull;constvarsnone','','html',100,'erg2','sin(x)/x','1.0%',2392,0),(2411,'4.3',2,5,'','','html',100,'x','x','1.0%',2410,0),(2413,'5arg0.9273',2,5,'','','html',100,'z','z','1.0%',2412,0),(2415,'300mV',2,5,'','','html',100,'U','U','1.0%',2414,0),(2417,'2.2kOhm',2,5,'','','html',100,'R','R','0',2416,0),(2419,'0.991',2,5,'','','html',100,'u','u','a0.001',2418,0),(2421,'U/I',2,5,'symbolfull;constvarsnone','','html',100,'erg','U/I','1.0%',2420,0),(2423,'sin(x)/x',2,5,'symbolfull;constvarsnone','','html',100,'erg2','sin(x)/x','1.0%',2422,0),(2425,'a',2,5,'','','html',100,'','A','1.0%',2424,0),(2426,'b',2,5,'','','html',0,'','B','1.0%',2424,1),(2427,'c',2,5,'','','html',0,'','C','1.0%',2424,2),(2443,'4.3',2,5,'','','html',100,'x','x','1.0%',2442,0),(2445,'5arg0.9273',2,5,'','','html',100,'z','z','1.0%',2444,0),(2447,'300mV',2,5,'','','html',100,'U','U','1.0%',2446,0),(2449,'2.2kOhm',2,5,'','','html',100,'R','R','0',2448,0),(2451,'0.991',2,5,'','','html',100,'u','u','a0.001',2450,0),(2453,'U/I',2,5,'symbolfull;constvarsnone','','html',100,'erg','U/I','1.0%',2452,0),(2455,'sin(x)/x',2,5,'symbolfull;constvarsnone','','html',100,'erg2','sin(x)/x','1.0%',2454,0),(2469,'[5.53553390593,3.53553390593]',2,5,'','','html',100,'erg','[5/sqrt(2)+2,5/sqrt(2)]','1%',2468,0),(2482,'[0.002898,4.774]',2,5,'','','html',100,'[T,a]','[T,a]','5%',2481,0),(2493,'[2,9]',2,5,'','','html',100,'P','[P_1,P_2]','4%',2492,0),(2506,'matrix([2,9],[-5,-2],[10,-4])',2,5,'','','html',100,'[P,P1,P2]','[[P_1,P_2],[P1_1,P1_2],[P2_1,P2_2]]','4%',2505,0),(2518,'matrix([2,9],[8,-8])',2,5,'','','html',100,'[P1,P2]','[[P1_1,P1_2],[P2_1,P2_2]]','4%',2517,0),(2531,'matrix([4,0],[4,-1],[-2,-4])',2,5,'','','html',100,'D','[[A_1,A_2],[B_1,B_2],[C_1,C_2]]','a0.1',2530,0),(2544,'matrix([-5,-3],[-5,-1],[-2,-1],[-2,-3])',2,5,'','','html',100,'D','[[A_1,A_2],[A_1,h+A_2],[b+A_1,h+A_2],[b+A_1,A_2]]','a0.3',2543,0),(2554,'y=-3+2*x',2,5,'','','html',100,'G','y = 2*x-3','0.1',2553,0),(2564,'y=-3+2*x',2,5,'','','html',100,'G','y = 2*x-3','0.1',2563,0),(2574,'y=-4+x^2',2,5,'','','html',100,'G','y = x^2-4','4%',2573,0),(2584,'-4+x^2',2,5,'','','html',100,'G','x^2-4','a0.5',2583,0),(2596,'28.54V',2,5,'','','html',100,'Us','Us','1%',2595,0),(2608,'5.102ms',2,5,'','','html',100,'1/f','1/f','1%',2607,0),(2620,'\"\"',2,5,'','','html',0,'','','1.0%',2619,0),(2622,'',2,5,'','','html',100,'p1','lor(land([58,435] = vget(Q0,1),[1204,435] = vget(Q0,3)),land([1204,435] = vget(Q0,1),[58,435] = vget(Q0,3)))','a10',2621,0),(2624,'',2,5,'','','html',100,'p2','wenn(vget(Q0,1,0) < vget(Q0,3,0),land(2 = pvlinek(Q0,0),-2 = pvlinek(Q0,1)),land(2 = pvlinek(Q0,1),-2 = pvlinek(Q0,0)))','30%',2623,0),(2637,'matrix([-1,0],[3,0],[5,0])',2,5,'','','html',0,'L','[[x1,0],[x1+dx2,0],[x1+dx3+dx2,0]]','1%',2636,0),(2639,'1. Nullstelle',2,5,'','','html',100,'q1','land(pvhaspoint(Q0,[x1,0]),pvpoints(Q0) = 3)','a0.05',2638,0),(2640,'',2,5,'','','html',60,'q1a','pvhaspoint(Q0,[x1,0])','1%',2638,1),(2642,'2. Nullstelle',2,5,'','','html',100,'q2','land(pvhaspoint(Q0,[x1+dx2,0]),pvpoints(Q0) = 3)','a0.05',2641,0),(2643,'',2,5,'','','html',60,'q2a','pvhaspoint(Q0,[x1+dx2,0])','1%',2641,1),(2645,'3. Nullstelle',2,5,'','','html',100,'q3','land(pvhaspoint(Q0,[x1+dx3+dx2,0]),pvpoints(Q0) = 3)','a0.05',2644,0),(2646,'',2,5,'','','html',60,'q3a','pvhaspoint(Q0,[x1+dx3+dx2,0])','1%',2644,1),(2648,'Anzahl der Nullstellen',2,5,'','','html',100,'q4','pvpoints(Q0) = 3','1%',2647,0),(2659,'matrix([3,2])',2,5,'','','html',100,'matrix(erg)','matrix([3,k])','1%',2658,0),(2661,'Steigung',2,5,'','','html',100,'q1','k=vget(Q0,0,1)/(-2+vget(Q0,0,0))','2%',2660,0),(2675,'matrix([0,0],[0.05,0.050042],[0.1,0.10033],[0.15,0.15114],[0.2,0.20271],[0.25,0.25534],[0.3,0.30934],[0.35,0.36503],[0.4,0.42279],[0.45,0.48306],[0.5,0.5463],[0.55,0.61311],[0.6,0.68414],[0.65,0.7602],[0.7,0.84229],[0.75,0.9316],[0.8,1.0296],[0.85,1.1383],[0.9,1.2602],[0.95,1.3984],[1,1.5574],[1.05,1.7433],[1.1,1.9648],[1.15,2.2345],[1.2,2.5722],[1.25,3.0096],[1.3,3.6021],[1.35,4.4552],[1.4,5.7979],[1.45,8.2381],[1.5,14.101],[1.55,48.078],[1.6,-34.233],[1.65,-12.599],[1.7,-7.6966],[1.75,-5.5204],[1.8,-4.2863],[1.85,-3.4881],[1.9,-2.9271],[1.95,-2.5095],[2,-2.185],[2.05,-1.9246],[2.1,-1.7098],[2.15,-1.529],[2.2,-1.3738],[2.25,-1.2386],[2.3,-1.1192],[2.35,-1.0125],[2.4,-0.91601],[2.45,-0.82802],[2.5,-0.74702],[2.55,-0.67186],[2.6,-0.6016],[2.65,-0.53544],[2.7,-0.47273],[2.75,-0.41292],[2.8,-0.35553],[2.85,-0.30015],[2.9,-0.24641],[2.95,-0.19397],[3,-0.14255],[3.05,-0.09185],[3.1,-0.041617],[3.15,0.0084075],[3.2,0.058474],[3.25,0.10883],[3.3,0.15975],[3.35,0.21148],[3.4,0.26432],[3.45,0.31857],[3.5,0.37459],[3.55,0.43274],[3.6,0.49347],[3.65,0.55727],[3.7,0.62473],[3.75,0.69655],[3.8,0.77356],[3.85,0.85676],[3.9,0.94742],[3.95,1.0471],[4,1.1578],[4.05,1.2821],[4.1,1.4235],[4.15,1.5866],[4.2,1.7778],[4.25,2.0063],[4.3,2.2858],[4.35,2.6376],[4.4,3.0963],[4.45,3.7233],[4.5,4.6373],[4.55,6.1038],[4.6,8.8602],[4.65,16.008],[4.7,80.713],[4.75,-26.575],[4.8,-11.385],[4.85,-7.2209],[4.9,-5.2675],[4.95,-4.1291],[5,-3.3805],[5.05,-2.8486],[5.1,-2.4494],[5.15,-2.1374],[5.2,-1.8856],[5.25,-1.6773],[5.3,-1.5013],[5.35,-1.3498],[5.4,-1.2175],[5.45,-1.1005],[5.5,-0.99558],[5.55,-0.90067],[5.6,-0.81394],[5.65,-0.734],[5.7,-0.65973],[5.75,-0.5902],[5.8,-0.52467],[5.85,-0.46248],[5.9,-0.40311],[5.95,-0.34609],[6,-0.29101],[6.05,-0.23751],[6.1,-0.18526],[6.15,-0.13398],[6.2,-0.083378],[6.25,-0.033197],[6.3,0.016816],[6.35,0.066914],[6.4,0.11735],[6.45,0.16838],[6.5,0.22028],[6.55,0.27333],[6.6,0.32786],[6.65,0.3842],[6.7,0.44276],[6.75,0.50397],[6.8,0.56834],[6.85,0.63648],[6.9,0.70911],[6.95,0.78708],[7,0.87145],[7.05,0.96351],[7.1,1.0649],[7.15,1.1777],[7.2,1.3046],[7.25,1.4493],[7.3,1.6166],[7.35,1.8133],[7.4,2.0493],[7.45,2.3392],[7.5,2.706],[7.55,3.1877],[7.6,3.8523],[7.65,4.8342],[7.7,6.4429],[7.75,9.5824],[7.8,18.507],[7.85,251.15],[7.9,-21.715],[7.95,-10.383],[8,-6.7997],[8.05,-5.0361],[8.1,-3.9824],[8.15,-3.2789],[8.2,-2.7737],[8.25,-2.3917],[8.3,-2.0914],[8.35,-1.8479],[8.4,-1.6457],[8.45,-1.4743],[8.5,-1.3264],[8.55,-1.1969],[8.6,-1.082],[8.65,-0.97898],[8.7,-0.88556],[8.75,-0.80006],[8.8,-0.72115],[8.85,-0.64773],[8.9,-0.57892],[8.95,-0.51399],[9,-0.45232],[9.05,-0.39337],[9.1,-0.3367],[9.15,-0.28191],[9.2,-0.22864],[9.25,-0.17658],[9.3,-0.12543],[9.35,-0.074918],[9.4,-0.024783],[9.45,0.025227],[9.5,0.075364],[9.55,0.12588],[9.6,0.17704],[9.65,0.22911],[9.7,0.28239],[9.75,0.3372],[9.8,0.39388],[9.85,0.45285],[9.9,0.51455],[9.95,0.57952])',2,5,'','','html',100,'M','pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200)','1%',2674,0),(2677,'Funktion sehr genau',2,5,'','','html',100,'q1','pvcompare(pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200),Q0,minx,maxx,miny,maxy)','1%',2676,0),(2678,'Funktion genau',2,5,'','','html',80,'q1','pvcompare(pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200),Q0,minx,maxx,miny,maxy)','2%',2676,1),(2679,'Funktion ok',2,5,'','','html',60,'q1','pvcompare(pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200),Q0,minx,maxx,miny,maxy)','4%',2676,2),(2680,'ungenau',2,5,'','','html',40,'q1','pvcompare(pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200),Q0,minx,maxx,miny,maxy)','8%',2676,3),(2690,'matrix([0,1],[0.1,0.995],[0.2,0.98007],[0.3,0.95534],[0.4,0.92106],[0.5,0.87758],[0.6,0.82534],[0.7,0.76484],[0.8,0.69671],[0.9,0.62161],[1,0.5403],[1.1,0.4536],[1.2,0.36236],[1.3,0.2675],[1.4,0.16997],[1.5,0.070737],[1.6,-0.0292],[1.7,-0.12884],[1.8,-0.2272],[1.9,-0.32329],[2,-0.41615],[2.1,-0.50485],[2.2,-0.5885],[2.3,-0.66628],[2.4,-0.73739],[2.5,-0.80114],[2.6,-0.85689],[2.7,-0.90407],[2.8,-0.94222],[2.9,-0.97096],[3,-0.98999],[3.1,-0.99914],[3.2,-0.99829],[3.3,-0.98748],[3.4,-0.9668],[3.5,-0.93646],[3.6,-0.89676],[3.7,-0.8481],[3.8,-0.79097],[3.9,-0.72593],[4,-0.65364],[4.1,-0.57482],[4.2,-0.49026],[4.3,-0.4008],[4.4,-0.30733],[4.5,-0.2108],[4.6,-0.11215],[4.7,-0.012389],[4.8,0.087499],[4.9,0.18651],[5,0.28366],[5.1,0.37798],[5.2,0.46852],[5.3,0.55437],[5.4,0.63469],[5.5,0.70867],[5.6,0.77557],[5.7,0.83471],[5.8,0.88552],[5.9,0.92748],[6,0.96017],[6.1,0.98327],[6.2,0.99654],[6.3,0.99986],[6.4,0.99318],[6.5,0.97659],[6.6,0.95023],[6.7,0.91438],[6.8,0.8694],[6.9,0.81573],[7,0.7539],[7.1,0.68455],[7.2,0.60835],[7.3,0.52608],[7.4,0.43855],[7.5,0.34664],[7.6,0.25126],[7.7,0.15337],[7.8,0.053955],[7.9,-0.046002],[8,-0.1455],[8.1,-0.24354],[8.2,-0.33915],[8.3,-0.43138],[8.4,-0.51929],[8.5,-0.60201],[8.6,-0.67872],[8.7,-0.74865],[8.8,-0.81109],[8.9,-0.86544],[9,-0.91113],[9.1,-0.94772],[9.2,-0.97484],[9.3,-0.99223],[9.4,-0.99969],[9.5,-0.99717],[9.6,-0.98469],[9.7,-0.96236],[9.8,-0.93043],[9.9,-0.88919],[10,-0.83907])',2,5,'','','html',100,'','pvfunc(cos(x),x,0,10,0.1)','1%',2689,0),(2692,'Funktion sehr genau',2,5,'','','html',100,'q1','pvcompare(pvfunc(cos(x),x,0,10,0.1),Q0,0,10,-2,2)','1%',2691,0),(2693,'Funktion genau',2,5,'','','html',80,'q1','pvcompare(pvfunc(cos(x),x,0,10,0.1),Q0,0,10,-2,2)','2%',2691,1),(2694,'Funktion ok',2,5,'','','html',60,'q1','pvcompare(pvfunc(cos(x),x,0,10,0.1),Q0,0,10,-2,2)','4%',2691,2),(2695,'ungenau',2,5,'','','html',40,'q1','pvcompare(pvfunc(cos(x),x,0,10,0.1),Q0,0,10,-2,2)','8%',2691,3),(2705,'[-1,-1]',2,5,'','','html',100,'[-1,-1]','[-1,-1]','3%',2704,0),(2707,'3.Quadrant',2,5,'','','html',100,'q1','land(vget(Q0,0) < 0,vget(Q0,1) < 0)','1%',2706,0),(2716,'[3,4]',2,5,'','','html',100,'P','[3,4]','3%',2715,0),(2718,'OK',2,5,'','','html',100,'Q0=P','Q0 = [3,4]','4%',2717,0),(2720,'\"\"',2,5,'','','html',100,'','','3%',2719,0),(2722,'OK',2,5,'','','html',100,'Q2=P','Q2 = [3,4]','4%',2721,0),(2731,'matrix([-2,-5],[6,1],[1,9])',2,5,'','','html',100,'P','[[-2,-5],[6,1],[1,9]]','3%',2730,0),(2733,'OK',2,5,'','','html',100,'q1','land(land(pvhaspoint(Q0,[-2,-5]),pvhaspoint(Q0,[6,1])),pvhaspoint(Q0,[1,9]))','4%',2732,0),(2735,'\"\"',2,5,'','','html',100,'','','3%',2734,0),(2737,'OK',2,5,'','','html',100,'q3','land(land(pvhaspoint(Q2,[-2,-5]),pvhaspoint(Q2,[6,1])),pvhaspoint(Q2,[1,9]))','4%',2736,0),(2746,'matrix([3,4],[6,-2])',2,5,'','','html',100,'M','[[3,4],[6,-2]]','3%',2745,0),(2748,'OK',2,5,'','','html',100,'pvsortx(Q0)=pvsortx(M)','pvsortx(Q0) = pvsortx([[3,4],[6,-2]])','4%',2747,0),(2750,'\"\"',2,5,'','','html',100,'','','3%',2749,0),(2752,'OK',2,5,'','','html',100,'pvsortx(Q2)=pvsortx(M)','pvsortx(Q2) = pvsortx([[3,4],[6,-2]])','4%',2751,0),(2763,'y=-3+2*x',2,5,'','','html',100,'G','y = k*x+d','5%',2762,0),(2765,'matrix([0,-3],[2,1])',2,5,'','','html',100,'M','[[0,d],[2,2*k+d]]','5%',2764,0),(2767,'OK',2,5,'','','html',100,'q3','land(pvlinek(Q2,0) = k,pvlined(Q2,0) = d)','5%',2766,0),(2778,'matrix([0,-3],[2,1],[0,-1],[2,3])',2,5,'','','html',100,'M','[[0,d],[2,2*k+d],[0,d+2],[2,2*k+d+2]]','5%',2777,0),(2780,'parallel',2,5,'','','html',100,'q1','pvlinek(Q0,0) = pvlinek(Q0,1)','5%',2779,0),(2789,'3',2,5,'','','html',100,'erg','3','3%',2788,0),(2791,'OK',2,5,'','','html',100,'Q0=3','Q0 = 3','4%',2790,0),(2793,'\"\"',2,5,'','','html',100,'','','3%',2792,0),(2795,'OK',2,5,'','','html',100,'Q2=4','Q2 = 4','4%',2794,0),(2804,'3',2,5,'','','html',100,'erg','3','3%',2803,0),(2806,'OK',2,5,'','','html',100,'Q0=3','Q0 = 3','4%',2805,0),(2808,'\"\"',2,5,'','','html',100,'','','3%',2807,0),(2810,'OK',2,5,'','','html',100,'Q2=4','Q2 = 4','4%',2809,0),(2822,'',2,5,'','','html',100,'','[0]','1%',2821,0),(2833,'[0,2]',2,5,'=','','html',100,'','[0,2]','1.0%',2832,0),(2852,'[0]',2,5,'','','html',100,'','[0]','1%',2851,0),(2870,'2.8284',2,5,'','','html',100,'A','2^(3/2)','1.0%',2869,0),(2882,'[1.37,0.01843]',2,5,'calc','','html',100,'[T1,T2]','[T1,T2]','5%',2881,0),(2883,'[0.01843,1.37]',2,5,'calc','','html',100,'[T2,T1]','[T2,T1]','5%',2881,1),(2899,'46.86°',2,5,'°','','html',100,'cabs(w)','sqrt(realpart(vin([x2-x1,y2-y1],[x3-x1,y3-y1]))^2+imagpart(vin([x2-x1,y2-y1],[x3-x1,y3-y1]))^2)/(sqrt(realpart(vabs([x2-x1,y2-y1]))^2+imagpart(vabs([x2-x1,y2-y1]))^2)*sqrt(realpart(vabs([x3-x1,y3-y1]))^2+imagpart(vabs([x3-x1,y3-y1]))^2))','1.0%',2898,0),(2901,'7.4302',2,5,'','','html',100,'vabs(B-C)','vabs([x2-x3,y2-y3])','1%',2900,0),(2919,'[15,19,21]',2,5,',frac','','html',100,'B','defracmix(frac([g2,z2,n2])+frac([g1,z1,n1]))','1.0%',2918,0),(2929,'x*(4*x+3*y*x^2+y^2)',2,5,'term','','html',100,'f','x*y^2+3*x^3*y+4*x^2','1%',2928,0),(2939,'\"\"',2,5,'','','html',100,'','','1.0%',2938,0),(3027,'4Ohm',2,5,'','','html',100,'R','4Ohm','1%',3026,0),(3029,'250mS',2,5,'S','','html',100,'G','0.25S','1%',3028,0),(3061,'28.44',2,5,'','','html',100,'n','(-cround(sqrt(b^2+a^2),4)^2)+b^2+a^2','1%',3060,0),(3063,'28.44',2,5,'','','html',100,'n','(-cround(sqrt(b^2+a^2),4)^2)+b^2+a^2','a0.001',3062,0),(3065,'28.44',2,5,'','','html',100,'n','(-cround(sqrt(b^2+a^2),4)^2)+b^2+a^2','1%',3064,0),(3067,'',2,5,'','','html',100,'Q2/c=0','Q2/cround(sqrt(b^2+a^2),4) = 0','a0.001',3066,0),(3085,'5',2,5,';calc','','html',100,'erg','5','1%',3084,0),(3087,'c^2=a^2+b^2',2,5,'symbolfull','','html',100,'c^2=a^2+b^2','c^2 = b^2+a^2','1%',3086,0),(3097,'',2,5,'','','html',100,'','Auto','1.0%',3096,0),(3099,'',2,5,'','','html',100,'','Räder','1.0%',3098,0),(3101,'',2,5,'','','html',100,'','Fahrrad','1.0%',3100,0),(3102,'',2,5,'','','html',50,'','fahrrad','1.0%',3100,1),(3103,'',2,5,'','','html',30,'','farrad','1.0%',3100,2),(3104,'',2,5,'','','html',0,'','Haus','1.0%',3100,3),(3114,'',2,5,'','','html',100,'','Auto','1.0%',3113,0),(3116,'',2,5,'','','html',100,'','Räder','1.0%',3115,0),(3118,'',2,5,'','','html',100,'','Fahrrad','1.0%',3117,0),(3119,'',2,5,'','','html',50,'','fahrrad','1.0%',3117,1),(3120,'',2,5,'','','html',30,'','farrad','1.0%',3117,2),(3121,'',2,5,'','','html',0,'','Haus','1.0%',3117,3);
/*!40000 ALTER TABLE `answer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurtGruppe`
--

DROP TABLE IF EXISTS `beurtGruppe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurtGruppe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GEWICHTUNG` double DEFAULT NULL,
  `BEURTGRUPPENDEF_ID` int DEFAULT NULL,
  `BEURTEILUNGSCONFIG_ID` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_beurtGruppe_BEURTGRUPPENDEF_ID` (`BEURTGRUPPENDEF_ID`),
  KEY `FK_beurtGruppe_BEURTEILUNGSCONFIG_ID` (`BEURTEILUNGSCONFIG_ID`),
  CONSTRAINT `FK_beurtGruppe_BEURTEILUNGSCONFIG_ID` FOREIGN KEY (`BEURTEILUNGSCONFIG_ID`) REFERENCES `beurteilungsconfig` (`id`),
  CONSTRAINT `FK_beurtGruppe_BEURTGRUPPENDEF_ID` FOREIGN KEY (`BEURTGRUPPENDEF_ID`) REFERENCES `beurtGruppenDef` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7768345 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurtGruppe`
--

LOCK TABLES `beurtGruppe` WRITE;
/*!40000 ALTER TABLE `beurtGruppe` DISABLE KEYS */;
INSERT INTO `beurtGruppe` VALUES (7768342,2,7768329,6167759),(7768343,5,7768330,6167759),(7768344,1,7768331,6167759);
/*!40000 ALTER TABLE `beurtGruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurtGruppeLK`
--

DROP TABLE IF EXISTS `beurtGruppeLK`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurtGruppeLK` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GEWICHTUNG` double DEFAULT NULL,
  `BEURTGRUPPENDEF_ID` int DEFAULT NULL,
  `LEHRERKLASSE_ID` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_beurtGruppeLK_LEHRERKLASSE_ID` (`LEHRERKLASSE_ID`),
  KEY `FK_beurtGruppeLK_BEURTGRUPPENDEF_ID` (`BEURTGRUPPENDEF_ID`),
  CONSTRAINT `FK_beurtGruppeLK_BEURTGRUPPENDEF_ID` FOREIGN KEY (`BEURTGRUPPENDEF_ID`) REFERENCES `beurtGruppenDef` (`id`),
  CONSTRAINT `FK_beurtGruppeLK_LEHRERKLASSE_ID` FOREIGN KEY (`LEHRERKLASSE_ID`) REFERENCES `lehrerKlasse` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurtGruppeLK`
--

LOCK TABLES `beurtGruppeLK` WRITE;
/*!40000 ALTER TABLE `beurtGruppeLK` DISABLE KEYS */;
/*!40000 ALTER TABLE `beurtGruppeLK` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurtGruppenDef`
--

DROP TABLE IF EXISTS `beurtGruppenDef`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurtGruppenDef` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GRUPPE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7768332 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurtGruppenDef`
--

LOCK TABLES `beurtGruppenDef` WRITE;
/*!40000 ALTER TABLE `beurtGruppenDef` DISABLE KEYS */;
INSERT INTO `beurtGruppenDef` VALUES (7768329,'Mitarbeitsgruppe'),(7768330,'Prüfungsgruppe'),(7768331,'Hausübungsgruppe');
/*!40000 ALTER TABLE `beurtGruppenDef` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurteilung`
--

DROP TABLE IF EXISTS `beurteilung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurteilung` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BEZEICHNERBEURTEILUNGSART` varchar(255) DEFAULT NULL,
  `DATUM` datetime DEFAULT NULL,
  `FRAGETEXT` longtext,
  `GEWICHT` double DEFAULT NULL,
  `INPUT` varchar(255) DEFAULT NULL,
  `NOTE` varchar(255) DEFAULT NULL,
  `PROZENT` double DEFAULT NULL,
  `TESTALLOWED` tinyint(1) DEFAULT '0',
  `idBeurteilungart` int DEFAULT NULL,
  `idFremdLehrer` int DEFAULT NULL,
  `idKlassenBeurteilung` int DEFAULT NULL,
  `idLehrerKlasse` int DEFAULT NULL,
  `idSubBeurteilung` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  `idActivity` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_beurteilung_idBeurteilungart` (`idBeurteilungart`),
  KEY `FK_beurteilung_idSubBeurteilung` (`idSubBeurteilung`),
  KEY `FK_beurteilung_idLehrerKlasse` (`idLehrerKlasse`),
  KEY `FK_beurteilung_idUser` (`idUser`),
  KEY `FK_beurteilung_idKlassenBeurteilung` (`idKlassenBeurteilung`),
  KEY `FK_beurteilung_idFremdLehrer` (`idFremdLehrer`),
  KEY `FK_beurteilung_idActivity` (`idActivity`),
  CONSTRAINT `FK_beurteilung_idActivity` FOREIGN KEY (`idActivity`) REFERENCES `activity` (`id`),
  CONSTRAINT `FK_beurteilung_idBeurteilungart` FOREIGN KEY (`idBeurteilungart`) REFERENCES `beurteilungsartGlobal` (`id`),
  CONSTRAINT `FK_beurteilung_idFremdLehrer` FOREIGN KEY (`idFremdLehrer`) REFERENCES `user` (`id`),
  CONSTRAINT `FK_beurteilung_idKlassenBeurteilung` FOREIGN KEY (`idKlassenBeurteilung`) REFERENCES `klassenbeurteilung` (`id`),
  CONSTRAINT `FK_beurteilung_idLehrerKlasse` FOREIGN KEY (`idLehrerKlasse`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_beurteilung_idSubBeurteilung` FOREIGN KEY (`idSubBeurteilung`) REFERENCES `beurteilung` (`id`),
  CONSTRAINT `FK_beurteilung_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurteilung`
--

LOCK TABLES `beurteilung` WRITE;
/*!40000 ALTER TABLE `beurteilung` DISABLE KEYS */;
/*!40000 ALTER TABLE `beurteilung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurteilungsart`
--

DROP TABLE IF EXISTS `beurteilungsart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurteilungsart` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BEZEICHNUNG` varchar(255) DEFAULT NULL,
  `GEWICHTUNG` double DEFAULT NULL,
  `PROZANZEIGE` tinyint(1) DEFAULT '0',
  `PROZVISIBLE` tinyint(1) DEFAULT '0',
  `SHOWFRAGENTEXT` tinyint(1) DEFAULT '0',
  `SUBBEURTEILUNGEN` varchar(255) DEFAULT NULL,
  `ZWISCHENNOTEN` tinyint(1) DEFAULT '0',
  `BEURTGRUPPE_ID` int DEFAULT NULL,
  `idConfig` int DEFAULT NULL,
  `idBeurteilungsart` int DEFAULT NULL,
  `beurteilungsarten_ORDER` int DEFAULT NULL,
  `USEMINPROZ` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_beurteilungsart_BEURTGRUPPE_ID` (`BEURTGRUPPE_ID`),
  KEY `FK_beurteilungsart_idBeurteilungsart` (`idBeurteilungsart`),
  KEY `FK_beurteilungsart_idConfig` (`idConfig`),
  CONSTRAINT `FK_beurteilungsart_BEURTGRUPPE_ID` FOREIGN KEY (`BEURTGRUPPE_ID`) REFERENCES `beurtGruppe` (`id`),
  CONSTRAINT `FK_beurteilungsart_idBeurteilungsart` FOREIGN KEY (`idBeurteilungsart`) REFERENCES `beurteilungsartGlobal` (`id`),
  CONSTRAINT `FK_beurteilungsart_idConfig` FOREIGN KEY (`idConfig`) REFERENCES `beurteilungsconfig` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8237115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurteilungsart`
--

LOCK TABLES `beurteilungsart` WRITE;
/*!40000 ALTER TABLE `beurteilungsart` DISABLE KEYS */;
INSERT INTO `beurteilungsart` VALUES (6167760,'',5,0,1,0,'',1,7768343,6167759,6167751,1,NULL),(6167766,'',1,0,1,0,'',0,7768342,6167759,6167752,2,NULL),(6167780,'',1,0,0,0,'',0,7768344,6167759,74,3,NULL),(6167785,'',2,0,1,0,'Prüfung,Mitarbeit,!Protokoll',1,7768343,6167759,12376432,4,NULL),(6167792,'',0,0,0,0,'',1,NULL,6167759,6167757,5,NULL),(6167799,'',3,0,1,0,'Mitarbeit, !Protokoll',1,7768342,6167759,6167758,6,NULL),(6671147,'',1,0,1,0,'',1,7768343,6167759,21134563,0,NULL),(8237106,'',2,0,1,0,'',0,7768342,6167759,73,7,NULL),(8237114,'',5,0,1,0,'',1,7768343,6167759,71,8,NULL);
/*!40000 ALTER TABLE `beurteilungsart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurteilungsartGlobal`
--

DROP TABLE IF EXISTS `beurteilungsartGlobal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurteilungsartGlobal` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ABK` varchar(255) DEFAULT NULL,
  `ANONYM` tinyint(1) DEFAULT '0',
  `CHECKPOSSIBLE` tinyint(1) DEFAULT '0',
  `ERLAUBTEVERSUCHE` int DEFAULT NULL,
  `GESUNDHEITSCHECK` tinyint(1) DEFAULT '0',
  `NAME` varchar(255) DEFAULT NULL,
  `ONLINE` tinyint(1) DEFAULT '0',
  `TESTVERSUCHANLEGEN` tinyint(1) DEFAULT '0',
  `VISIBLE` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21134564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurteilungsartGlobal`
--

LOCK TABLES `beurteilungsartGlobal` WRITE;
/*!40000 ALTER TABLE `beurteilungsartGlobal` DISABLE KEYS */;
INSERT INTO `beurteilungsartGlobal` VALUES (71,'T',0,0,1,0,'Test',1,0,0),(72,'SA',0,0,1,0,'Schularbeit',1,0,0),(73,'SMÜ',0,0,1,0,'SMÜ',1,0,0),(74,'HÜ',0,1,0,0,'Hausübung',1,0,1),(75,'RÜ',0,1,0,0,'Rechenübung',1,0,1),(76,'Summe',0,0,1,0,'Summe',0,0,0),(6167751,NULL,0,0,NULL,0,'Prüfung',0,0,0),(6167752,NULL,0,0,NULL,0,'Mitarbeit',0,0,0),(6167757,NULL,0,0,NULL,0,'Allgemeines',0,0,0),(6167758,NULL,0,0,NULL,0,'Projekt',0,0,0),(12376432,NULL,0,0,NULL,0,'Labor',0,0,0),(21134563,NULL,0,0,NULL,0,'Werkstätte',0,0,0);
/*!40000 ALTER TABLE `beurteilungsartGlobal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `beurteilungsconfig`
--

DROP TABLE IF EXISTS `beurteilungsconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `beurteilungsconfig` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ANZEIGEKATALOG` int DEFAULT NULL,
  `BESCHREIBUNG` varchar(255) DEFAULT NULL,
  `CALCNOTE` tinyint(1) DEFAULT '0',
  `DEFAULTSCHEMA` tinyint(1) DEFAULT '0',
  `GEGENSTAENDE` varchar(255) DEFAULT NULL,
  `GRUPPIERUNG` tinyint(1) DEFAULT '0',
  `MINPROZENT` double DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `SCHOWNOTENSCHUELER` tinyint(1) DEFAULT '0',
  `SCHULSTUFEN` varchar(255) DEFAULT NULL,
  `SUMMELEHRER` tinyint(1) DEFAULT '0',
  `USEDMODES` varchar(255) DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_beurteilungsconfig_idUser` (`idUser`),
  CONSTRAINT `FK_beurteilungsconfig_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6167760 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `beurteilungsconfig`
--

LOCK TABLES `beurteilungsconfig` WRITE;
/*!40000 ALTER TABLE `beurteilungsconfig` DISABLE KEYS */;
INSERT INTO `beurteilungsconfig` VALUES (6167759,0,'',1,1,NULL,0,37.5,'default',0,NULL,0,NULL,NULL);
/*!40000 ALTER TABLE `beurteilungsconfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bewertungen`
--

DROP TABLE IF EXISTS `bewertungen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bewertungen` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MINPROZENT` double DEFAULT NULL,
  `PROZENT` double DEFAULT NULL,
  `SYMBOL` varchar(100) NOT NULL,
  `TEXT` varchar(255) DEFAULT NULL,
  `idBeurteilungsart` int DEFAULT NULL,
  `bewertungen_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_bewertungen_idBeurteilungsart` (`idBeurteilungsart`),
  CONSTRAINT `FK_bewertungen_idBeurteilungsart` FOREIGN KEY (`idBeurteilungsart`) REFERENCES `beurteilungsart` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8237120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bewertungen`
--

LOCK TABLES `bewertungen` WRITE;
/*!40000 ALTER TABLE `bewertungen` DISABLE KEYS */;
INSERT INTO `bewertungen` VALUES (6167761,89,93.75,'1','Sehr Gut',6167760,0),(6167762,76,81.25,'2','Gut',6167760,1),(6167763,61,68.75,'3','Befriedigend',6167760,2),(6167764,50.1,56.25,'4','Genügend',6167760,3),(6167765,0,43.75,'5','Nicht Genügend',6167760,4),(6167767,87.5,93.75,'+','+',6167766,0),(6167768,75,80,'+~','+~',6167766,1),(6167769,62.5,67,'~','~',6167766,2),(6167781,80,93.75,'+','+',6167780,0),(6167782,50,75,'~','~',6167780,1),(6167783,0,38,'-','-',6167780,2),(6167784,0,0,'Â¥','HÜ fehlt',6167780,3),(6167786,87.5,93.75,'1','1',6167785,0),(6167787,75,81.25,'2','2',6167785,1),(6167788,62.5,68.75,'3','3',6167785,2),(6167789,50,56.25,'4','4',6167785,3),(6167790,0,43.75,'5','5',6167785,4),(6167791,0,-1,'Â¥','Â¥',6167785,5),(6167793,0,-1,'E','Elterngespräch',6167792,0),(6167794,0,-1,'T','Telefonat',6167792,1),(6167795,0,-1,'K','Längere Krankheit',6167792,2),(6167796,0,-1,'D','Disziplin',6167792,3),(6167797,0,-1,'F','Frühwarnungsgespräch',6167792,4),(6167798,0,-1,'X','Sonstiges',6167792,5),(6167800,90,93.75,'1','Sehr Gut',6167799,0),(6167801,80,85,'2','Gut',6167799,1),(6167802,66,75,'3','Befriedigend',6167799,2),(6167803,50,55,'4','Genügend',6167799,3),(6167804,0,38,'5','Nicht genügend',6167799,4),(6195713,50,55,'~-','~-',6167766,3),(6195714,0,38,'-','-',6167766,4),(6196504,0,0,'Â¥',NULL,6167799,5),(6671290,87.5,93.75,'1','Sehr Gut',6671147,0),(6671291,75,81.25,'2','Gut',6671147,1),(6671292,62.5,68.75,'3','Befriedigend',6671147,2),(6671293,50.1,56.25,'4','Genügend',6671147,3),(6671294,0,43.75,'5','Nicht Genügend',6671147,4),(6671295,0,-1,'Â¥',NULL,6671147,5),(8237107,87.5,93.75,'+','+',8237106,0),(8237108,75,80,'+~','+~',8237106,1),(8237109,62.5,67,'~','~',8237106,2),(8237110,50,55,'~-','~-',8237106,3),(8237111,0,38,'-','-',8237106,4),(8237115,89,93.75,'1','Sehr Gut',8237114,0),(8237116,76,81.25,'2','Gut',8237114,1),(8237117,61,68.75,'3','Befriedigend',8237114,2),(8237118,50.1,56.25,'4','Genügend',8237114,3),(8237119,0,43.75,'5','Nicht Genügend',8237114,4);
/*!40000 ALTER TABLE `bewertungen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category`
--

DROP TABLE IF EXISTS `category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `EINHEITENKORR` tinyint(1) DEFAULT '0',
  `EINHEITENKORRTEXT` longtext,
  `GLOBALCATEGORY` tinyint(1) DEFAULT '0',
  `IDSCHOOL` int DEFAULT NULL,
  `LEVEL` int DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `PRIVATECATEGORY` tinyint(1) DEFAULT '0',
  `USEINTERNALCALC` tinyint(1) DEFAULT '0',
  `KOMP_ID` int DEFAULT NULL,
  `idParent` int DEFAULT NULL,
  `categories_ORDER` int DEFAULT NULL,
  `CATEGORYLINK` longtext,
  PRIMARY KEY (`id`),
  KEY `FK_category_idParent` (`idParent`),
  KEY `FK_category_KOMP_ID` (`KOMP_ID`),
  CONSTRAINT `FK_category_idParent` FOREIGN KEY (`idParent`) REFERENCES `category` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category`
--

LOCK TABLES `category` WRITE;
/*!40000 ALTER TABLE `category` DISABLE KEYS */;
INSERT INTO `category` VALUES (2268,0,'',0,0,0,'LeTTo',0,0,NULL,2651,10,NULL),(2270,0,'',1,0,0,'Demobeispiele-LeTTo',0,0,NULL,2268,0,NULL),(2273,0,'',0,0,0,'LeTTo-Onramp',0,0,NULL,2270,0,NULL),(2274,0,'',0,0,0,'LeTTo-Onramp Parts',0,0,NULL,2273,0,NULL),(2456,0,'',0,0,0,'Plugins',0,0,NULL,2270,1,NULL),(2457,0,'',0,0,0,'Plot',0,0,NULL,2456,0,NULL),(2458,0,'',0,0,0,'interaktive_Eingabe',0,0,NULL,2457,0,NULL),(2459,0,'',0,0,0,'direkte-Auswertung',0,0,NULL,2458,0,NULL),(2609,0,'',0,0,0,'berechnete Auswertung ',0,0,NULL,2458,1,NULL),(2651,NULL,NULL,0,0,NULL,'',0,0,NULL,NULL,NULL,NULL),(2652,NULL,NULL,0,0,NULL,'_temp',0,0,NULL,2651,1,NULL),(2653,NULL,NULL,0,0,NULL,'Antriebstechnik',0,0,NULL,2651,2,NULL),(2654,NULL,NULL,0,0,NULL,'Automatisierungstechnik',0,0,NULL,2651,3,NULL),(2655,NULL,NULL,0,0,NULL,'Elektronik',0,0,NULL,2651,4,NULL),(2656,NULL,NULL,0,0,NULL,'Energiesysteme',0,0,NULL,2651,5,NULL),(2657,NULL,NULL,0,0,NULL,'Informatik',0,0,NULL,2651,6,NULL),(2658,NULL,NULL,0,0,NULL,'Mechatronik',0,0,NULL,2651,7,NULL),(2659,NULL,NULL,0,0,NULL,'Physik',0,0,NULL,2651,8,NULL),(2660,NULL,NULL,0,0,NULL,'CPE',0,0,NULL,2651,9,NULL),(2661,NULL,NULL,0,0,NULL,'Labor',0,0,NULL,2651,10,NULL),(2811,0,'',0,0,0,'stumme_Karte',0,0,NULL,2457,1,NULL),(2902,0,'',0,0,0,'Parser',0,0,NULL,2270,2,NULL),(2903,0,'',0,0,0,'Zahlen-Darstellung',0,0,NULL,2902,0,NULL),(2969,0,'',0,0,0,'pv-Funktionen für Punktemengen',0,0,NULL,2902,1,NULL),(2998,0,'',0,0,0,'Mengen',0,0,NULL,2902,2,NULL),(3015,0,'',0,0,0,'VorBerechnung',0,0,NULL,2902,3,NULL),(3030,0,'',0,0,0,'Polynome',0,0,NULL,2902,4,NULL),(3048,0,'',0,0,0,'Fragetypen',0,0,NULL,2270,3,NULL),(3131,0,'',0,0,0,'Datensätze',0,0,NULL,2270,4,NULL);
/*!40000 ALTER TABLE `category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_gegenstand`
--

DROP TABLE IF EXISTS `category_gegenstand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_gegenstand` (
  `categories_ID` int NOT NULL,
  `gegenstaende_ID` int NOT NULL,
  `gegenstaende_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`categories_ID`,`gegenstaende_ID`),
  KEY `FK_category_gegenstand_gegenstaende_ID` (`gegenstaende_ID`),
  CONSTRAINT `FK_category_gegenstand_categories_ID` FOREIGN KEY (`categories_ID`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_category_gegenstand_gegenstaende_ID` FOREIGN KEY (`gegenstaende_ID`) REFERENCES `gegenstand` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_gegenstand`
--

LOCK TABLES `category_gegenstand` WRITE;
/*!40000 ALTER TABLE `category_gegenstand` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_gegenstand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_kompetenz`
--

DROP TABLE IF EXISTS `category_kompetenz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_kompetenz` (
  `kompetenzCategories_ID` int NOT NULL,
  `kompetenzen_ID` int NOT NULL,
  `kompetenzen_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`kompetenzCategories_ID`,`kompetenzen_ID`),
  KEY `FK_category_kompetenz_kompetenzen_ID` (`kompetenzen_ID`),
  CONSTRAINT `FK_category_kompetenz_kompetenzCategories_ID` FOREIGN KEY (`kompetenzCategories_ID`) REFERENCES `category` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_kompetenz`
--

LOCK TABLES `category_kompetenz` WRITE;
/*!40000 ALTER TABLE `category_kompetenz` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_kompetenz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_question`
--

DROP TABLE IF EXISTS `category_question`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_question` (
  `categories_ID` int NOT NULL,
  `questions_ID` bigint NOT NULL,
  `questions_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`categories_ID`,`questions_ID`),
  KEY `FK_category_question_questions_ID` (`questions_ID`),
  CONSTRAINT `FK_category_question_questions_ID` FOREIGN KEY (`questions_ID`) REFERENCES `question` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_question`
--

LOCK TABLES `category_question` WRITE;
/*!40000 ALTER TABLE `category_question` DISABLE KEYS */;
/*!40000 ALTER TABLE `category_question` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configuser`
--

DROP TABLE IF EXISTS `configuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `configuser` (
  `id` int NOT NULL AUTO_INCREMENT,
  `NAME` varchar(255) DEFAULT NULL,
  `TEXT` longtext,
  `TYP` int DEFAULT NULL,
  `USER_ID` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_configuser_USER_ID` (`USER_ID`),
  CONSTRAINT `FK_configuser_USER_ID` FOREIGN KEY (`USER_ID`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuser`
--

LOCK TABLES `configuser` WRITE;
/*!40000 ALTER TABLE `configuser` DISABLE KEYS */;
INSERT INTO `configuser` VALUES (2266,'lastSelectedCategory','3048',3,2);
/*!40000 ALTER TABLE `configuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `datasetDefinition`
--

DROP TABLE IF EXISTS `datasetDefinition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `datasetDefinition` (
  `id` int NOT NULL AUTO_INCREMENT,
  `DECIMALS` varchar(20) DEFAULT NULL,
  `DISTRIBUTION` varchar(20) DEFAULT NULL,
  `EINHEIT` varchar(255) DEFAULT NULL,
  `ITEMCOUNT` int DEFAULT NULL,
  `ITEMS` longtext,
  `MAXIMUM` varchar(20) DEFAULT NULL,
  `MINIMUM` varchar(20) DEFAULT NULL,
  `NAME` varchar(40) DEFAULT NULL,
  `STATUS` varchar(40) DEFAULT NULL,
  `TYPE` varchar(30) DEFAULT NULL,
  `ZAHLENBEREICH` text,
  `ZIFFERN` int DEFAULT NULL,
  `idParent` bigint DEFAULT NULL,
  `datasetDefinitions_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_datasetDefinition_idParent` (`idParent`),
  CONSTRAINT `FK_datasetDefinition_idParent` FOREIGN KEY (`idParent`) REFERENCES `question` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3186 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `datasetDefinition`
--

LOCK TABLES `datasetDefinition` WRITE;
/*!40000 ALTER TABLE `datasetDefinition` DISABLE KEYS */;
INSERT INTO `datasetDefinition` VALUES (2277,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2275,0),(2278,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2275,1),(2291,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2289,0),(2292,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2289,1),(2293,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2289,2),(2294,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2289,3),(2295,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2289,4),(2308,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2306,0),(2309,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2306,1),(2310,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2306,2),(2311,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2306,3),(2312,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2306,4),(2327,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2325,0),(2328,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2325,1),(2329,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2325,2),(2330,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2325,3),(2331,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2325,4),(2344,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2342,0),(2345,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2342,1),(2346,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2342,2),(2347,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2342,3),(2348,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2342,4),(2362,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2360,0),(2363,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2360,1),(2364,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2360,2),(2365,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2360,3),(2366,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2360,4),(2378,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2376,0),(2379,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2376,1),(2380,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2376,2),(2381,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2376,3),(2382,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2376,4),(2396,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2394,0),(2397,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2394,1),(2398,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2394,2),(2399,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2394,3),(2400,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2394,4),(2430,'0','uniform','',40,'4.3;2.8;2;7.7;5;4.2;4;4.2;2;4.2;3.5;2.6;3.6;7.8;5.8;7.7;4.2;2.8;2.6;5.4;5.2;7.7;6.2;2.1;5.2;2.1;5.1;6.3;5.2;4.2;2.6;5.2;2.1;4.1;4.6;5.4;6.2;7.5;4.3;4.3','7.8','2','x','shared','calculated','F2:2-8',2,2428,0),(2431,'0','uniform','=karti',40,'(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i);(3+4*%i)','5','5','z','shared','calculated','C:3i4 ',13,2428,1),(2432,'0','uniform','=V',40,'0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3;0.3','0.3','0.3','U','shared','calculated','300m',13,2428,2),(2433,'3','uniform','=Ohm',40,'2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200;2200','2200','2200','R','shared','calculated','2200',13,2428,3),(2434,'0','uniform','',40,'0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991;0.991','0.991','0.991','u','shared','calculated','F3:0.991',3,2428,4),(2472,'3','uniform','',40,'4.774;2.724;2.568;4.07;2.42;4.261;4.87;4.18;4.87;4.18;3.586;4.774;4.703;4.213;4.18;4.703;2.469;3.329;4.07;2.789;4.147;2.42;3.232;2.805;2.42;4.064;4.064;4.703;3.159;4.83;2.285;4.07;2.42;3.634;3.031;2.645;4.029;3.329;2.204;3.634','4.87','2.204','a','shared','calculated','2-5',13,2470,0),(2473,'3','uniform','',40,'2.721;2.395;2.721;2.74;-2.945;1.45;2.148;2.589;1.911;2.655;1.214;-1.786;-1.58;1.731;2.589;-2.372;1.911;-2.777;-1.933;-1.513;1.134;2.514;-1.786;2.589;-2.372;-1.547;-2.73;1.58;-2.846;1.829;1.594;1.214;-1.001;-1.999;2.742;-2.277;2.221;1.566;2.742;-2.767','2.945','1.001','b','shared','calculated','1-3,-3--1',13,2470,1),(2474,'3','uniform','',40,'0.002898;0.04248;0.02853;0.08643;0.06964;0.007954;0.08628;0.01192;0.02672;0.06907;0.08573;0.01925;0.06964;0.09864;0.0758;0.04528;0.0175;0.06412;0.09549;0.04528;0.02672;0.05512;0.02672;0.06964;0.0231;0.008585;0.002974;0.03581;0.003375;0.06627;0.05675;0.04248;0.06148;0.05139;0.06917;0.02672;0.04248;0.06964;0.04156;0.01192','0.09864','0.002898','T','shared','calculated','0.001-0.1',13,2470,2),(2485,'0','uniform','',40,'[2,9];[5,-4];[-2,-6];[-2,0];[2,5];[0,9];[3,10];[0,-4];[5,2];[-3,0];[-4,-10];[-6,-10];[-7,-4];[8,6];[-10,-6];[0,-10];[6,-7];[-6,-10];[-6,-9];[4,-6];[-5,-4];[-7,-4];[-4,-8];[-10,8];[5,-3];[-2,6];[5,2];[2,0];[5,2];[4,9];[-4,1];[-10,-6];[4,4];[-7,-7];[0,-4];[4,7];[0,-10];[-3,-7];[7,6];[7,0]','10','0','P','shared','calculated','V2:I-10-10',13,2483,0),(2496,'0','uniform','',40,'[2,9];[5,-4];[-2,-6];[-2,0];[2,5];[0,9];[3,10];[0,-4];[5,2];[-3,0];[-4,-10];[-6,-10];[-7,-4];[8,6];[-10,-6];[0,-10];[6,-7];[-6,-10];[-6,-9];[4,-6];[-5,-4];[-7,-4];[-4,-8];[-10,8];[5,-3];[-2,6];[5,2];[2,0];[5,2];[4,9];[-4,1];[-10,-6];[4,4];[-7,-7];[0,-4];[4,7];[0,-10];[-3,-7];[7,6];[7,0]','10','0','P','shared','calculated','V2:I-10-10',13,2494,0),(2497,'0','uniform','',40,'[-5,-2];[8,-9];[-2,-3];[3,1];[3,-9];[2,0];[-3,-6];[0,2];[8,-1];[2,-1];[-6,-4];[1,-6];[-6,-6];[-6,10];[2,-4];[8,-7];[-3,7];[4,6];[-9,-8];[8,-8];[5,10];[8,-6];[-3,-9];[7,5];[-2,1];[1,7];[10,-8];[3,10];[-6,-7];[8,-1];[2,-9];[-1,4];[-1,8];[6,4];[2,-1];[10,0];[-5,-1];[-3,2];[3,10];[-3,-8]','10','0','P1','shared','calculated','V2:I-10-10',13,2494,1),(2498,'0','uniform','',40,'[10,-4];[-10,-7];[6,-1];[2,-5];[2,2];[-1,5];[-3,-10];[-1,-7];[-5,-6];[6,-3];[-7,-10];[9,6];[-5,4];[-7,5];[10,-7];[5,1];[5,-2];[3,5];[3,0];[-1,1];[3,7];[0,-1];[-9,-10];[9,-4];[5,6];[4,-1];[-4,5];[-10,6];[-7,-3];[3,-2];[-3,4];[9,-3];[0,-1];[-1,-7];[0,2];[2,-2];[7,2];[-1,-3];[3,-1];[2,3]','10','0','P2','shared','calculated','V2:I-10-10',13,2494,2),(2509,'0','uniform','',40,'[2,9];[5,-4];[-2,-6];[-2,0];[2,5];[0,9];[3,10];[0,-4];[5,2];[-3,0];[-4,-10];[-6,-10];[-7,-4];[8,6];[-10,-6];[0,-10];[6,-7];[-6,-10];[-6,-9];[4,-6];[-5,-4];[-7,-4];[-4,-8];[-10,8];[5,-3];[-2,6];[5,2];[2,0];[5,2];[4,9];[-4,1];[-10,-6];[4,4];[-7,-7];[0,-4];[4,7];[0,-10];[-3,-7];[7,6];[7,0]','10','0','P1','shared','calculated','V2:I-10-10',13,2507,0),(2510,'0','uniform','',40,'[8,-8];[-8,4];[-4,4];[0,8];[-3,4];[-5,-7];[-8,-6];[-8,2];[-4,0];[-7,4];[0,7];[8,-10];[1,-1];[7,9];[8,-3];[8,9];[4,-9];[-9,-8];[5,-7];[-3,6];[-10,9];[-6,3];[4,-10];[-8,2];[-10,-4];[-9,6];[-4,-10];[5,-1];[-3,-2];[-6,4];[10,1];[9,-8];[1,0];[0,7];[10,-1];[8,-7];[4,5];[9,-10];[2,-5];[8,9]','10','0','P2','shared','calculated','V2:I-10-10',13,2507,1),(2521,'0','uniform','',40,'[4,0];[5,9];[5,-1];[0,2];[4,4];[-5,-1];[4,-5];[0,0];[-2,4];[9,-5];[-10,4];[-4,-2];[6,-4];[5,0];[5,1];[-8,-9];[0,0];[-9,1];[6,9];[0,4];[-4,-1];[-4,5];[9,6];[-4,9];[4,5];[4,5];[-7,0];[5,-4];[-5,5];[5,1];[-5,-3];[-10,7];[9,-7];[0,0];[-6,0];[-9,1];[9,0];[6,0];[1,10];[-8,0]','10','0','A','shared','calculated','V2:I-10-10',13,2519,0),(2522,'0','uniform','',40,'[4,-1];[-5,0];[10,8];[8,-8];[-8,0];[8,-2];[7,10];[-10,-2];[-6,8];[0,-5];[-8,-4];[2,-10];[-5,-7];[-8,0];[-1,7];[10,9];[-5,10];[-5,8];[-6,-5];[-8,-4];[-3,-8];[0,7];[0,-6];[5,5];[-10,2];[-6,6];[-5,-7];[-2,2];[-5,-2];[10,1];[5,8];[0,0];[8,-9];[2,0];[0,-6];[7,-5];[6,5];[-6,-7];[-5,-5];[-10,2]','10','0','B','shared','calculated','V2:I-10-10',13,2519,1),(2523,'0','uniform','',40,'[-2,-4];[3,6];[6,-7];[-6,4];[0,-7];[-3,-7];[5,0];[3,-4];[0,-6];[5,-4];[-1,7];[0,-6];[0,-2];[6,4];[-8,7];[-7,9];[-4,3];[-6,-3];[-5,-4];[0,2];[0,-4];[8,-7];[-6,-5];[0,2];[3,-4];[8,-4];[10,0];[-10,-4];[8,-3];[9,-2];[9,-2];[-8,0];[-7,-1];[4,10];[7,5];[-6,-2];[6,3];[-2,0];[-9,8];[0,-7]','10','0','C','shared','calculated','V2:I-10-10',13,2519,2),(2534,'0','uniform','',40,'[-5,-3];[-7,-5];[-10,-4];[-1,-10];[-1,-3];[0,-8];[-8,0];[-2,1];[-7,-9];[-2,1];[-7,-7];[-4,-9];[-9,0];[-9,0];[0,-3];[0,0];[-6,-8];[-1,-2];[-7,-7];[-6,-9];[-1,-4];[-1,-6];[-5,-9];[-6,-4];[-5,0];[-1,-9];[-7,-6];[-5,0];[-1,-5];[0,-7];[-10,-2];[-7,-6];[-4,0];[1,1];[-3,-7];[-1,-1];[-3,2];[1,0];[-3,-7];[-10,-7]','10','0','A','shared','calculated','V2:I-10-2',13,2532,0),(2535,'0','uniform','',40,'3;4;5;4;3;4;3;4;4;4;5;5;4;4;3;5;5;3;4;3;2;4;3;5;2;2;4;5;2;2;4;3;4;4;5;2;5;4;4;4','5','2','b','shared','calculated','I2-5',13,2532,1),(2536,'0','uniform','',40,'2;5;5;5;4;5;4;2;2;5;5;5;2;5;3;2;3;5;5;5;4;3;2;5;2;2;5;5;4;5;5;5;2;2;3;5;5;4;3;2','5','2','h','shared','calculated','I2-5',13,2532,2),(2587,'3','uniform','V',40,'28.54;11.46;2.945;2.544;6.421;21.86;140.7;36.12;11.46;6.421;53.14;17.87;118.8;4.096;89.15;36.12;6.214;11.46;2.847;118.8;53.14;42.09;13.82;9.847;62.76;54.73;189.7;89.15;41.91;157.4;2.847;36.12;106.1;106.1;157.4;148.6;118.8;142.5;89.15;6.421','189.7','2.544','Us','shared','calculated','2-230',13,2585,0),(2588,'3','uniform','Hz',40,'196;195;27.39;105.3;81.08;136.5;135.4;110;136.5;195;103.8;156.5;110.8;101.9;15.28;48.32;111;120.2;47.81;110.5;120.2;120;169.3;47.81;47.81;27.39;195;135.4;195;101.9;156.5;186.5;36.62;36.62;178.4;188.5;88.03;96.63;15.28;168.7','196','15.28','f','shared','calculated','10-200',13,2585,1),(2599,'3','uniform','V',40,'28.54;11.46;2.945;2.544;6.421;21.86;140.7;36.12;11.46;6.421;53.14;17.87;118.8;4.096;89.15;36.12;6.214;11.46;2.847;118.8;53.14;42.09;13.82;9.847;62.76;54.73;189.7;89.15;41.91;157.4;2.847;36.12;106.1;106.1;157.4;148.6;118.8;142.5;89.15;6.421','189.7','2.544','Us','shared','calculated','2-230',13,2597,0),(2600,'3','uniform','Hz',40,'196;195;27.39;105.3;81.08;136.5;135.4;110;136.5;195;103.8;156.5;110.8;101.9;15.28;48.32;111;120.2;47.81;110.5;120.2;120;169.3;47.81;47.81;27.39;195;135.4;195;101.9;156.5;186.5;36.62;36.62;178.4;188.5;88.03;96.63;15.28;168.7','196','15.28','f','shared','calculated','10-200',13,2597,1),(2627,'0','uniform','',40,'-1;-3;-1;-1;-3;-3;-2;-4;-1;-2;-3;-1;-3;-1;-1;-3;-1;-1;-1;-3;-2;-2;-2;-4;-1;-1;-4;-3;-1;-1;-1;-2;-1;-4;-3;-1;-4;-4;-4;-4','4','1','x1','shared','calculated','I-4--1',12,2625,0),(2628,'0','uniform','',40,'4;3;3;3;2;1;4;1;1;3;1;1;4;3;2;3;4;1;4;4;3;1;1;4;4;3;4;1;1;1;2;3;1;3;4;4;1;2;1;4','4','1','dx2','shared','calculated','I1-4',12,2625,1),(2629,'0','uniform','',40,'2;3;4;3;3;1;2;4;3;2;3;1;1;3;4;3;3;1;4;1;4;1;1;2;3;3;2;4;1;3;3;3;3;2;3;1;3;1;1;1','4','1','dx3','shared','calculated','I1-4',12,2625,2),(2651,'3','uniform','',40,'2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2','2','2','k','shared','calculated','F2:2',2,2649,0),(2664,'3','uniform','',40,'0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0','0','0','minx','shared','calculated','0',12,2662,0),(2665,'3','uniform','',40,'10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10;10','10','10','maxx','shared','calculated','10',12,2662,1),(2666,'3','uniform','',40,'-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5;-5','5','5','miny','shared','calculated','-5',12,2662,2),(2667,'3','uniform','',40,'5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5;5','5','5','maxy','shared','calculated','5',12,2662,3),(2754,'3','uniform','',40,'2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2','2','2','k','shared','calculated','2',12,2753,0),(2755,'3','uniform','',40,'-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3','3','3','d','shared','calculated','-3',12,2753,1),(2769,'3','uniform','',40,'2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2','2','2','k','shared','calculated','2',12,2768,0),(2770,'3','uniform','',40,'-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3;-3','3','3','d','shared','calculated','-3',12,2768,1),(2836,'3','uniform','',40,'1.9;1.6;1.5;1.6;1.1;1.8;1.5;1.1;1.6;1.2;1.6;2;1.5;1.8;1.2;1.5;1.7;1.2;1.5;1.2;1.2;1.5;1.4;1.3;1.9;1.6;1.6;1.2;1.3;1.5;1.3;1.9;1.6;1.2;1.5;2;1.5;1.4;1.4;1.7','2','1.1','a','shared','calculated','F2:1-2',2,2834,0),(2837,'3','uniform','',40,'-1.9;-1.2;-1.8;-1.7;-2;-1.6;-2;-1.8;-1.9;-1.6;-1;-1.6;-2;-1.8;-2;-1.9;-2;-1.2;-1.1;-1.3;-1.8;-1.7;-1;-2;-1.9;-1.5;-1.3;-1.1;-1.6;-1.8;-1.2;-1.9;-1.8;-1.9;-1.4;-2;-1.9;-1;-1.7;-1.6','2','1','b','shared','calculated','F2:-2--1',2,2834,1),(2838,'3','uniform','',40,'0.26;0.53;-0.14;0.26;-0.16;0.89;2.3;-0.14;-1.8;-1.5;-2;0.91;0.89;-2;0.25;0.23;-0.16;-2;-0.68;-0.82;0.23;-0.14;0.89;-2;-2.9;-0.82;1.2;-1.5;2.6;-2;2.3;1.6;-1.5;1.3;1.2;-0.05;-1.5;0.25;-0.68;2.8','2.9','0.05','c','shared','calculated','F2:-3-3',2,2834,2),(2839,'3','uniform','',40,'2.154;1.182;-1.575;-2.448;0.6081;1.796;2.827;2.16;-1.376;2.634;-1.574;-2.838;-1.311;2.827;0.5461;0.6987;2.204;-2.162;-2.428;2.283;1.505;-2.935;-0.6206;1.349;1.796;-1.376;2.732;-0.6981;1.504;1.377;-1.698;1.274;-0.6905;2.827;-1.311;-1.376;-1.311;-1.276;-0.8012;0.563','2.935','0.5461','s1','shared','calculated','-3--0.5,0.5-3',13,2834,3),(2840,'3','uniform','',40,'-2.997;-2.684;-1.511;-1.285;1.813;0.6726;1.523;-0.9292;-1.746;-0.9292;-0.5518;1.888;1.669;-0.9193;-2.801;1.588;2.512;-1.66;1.562;-2.325;2.901;0.7349;0.8524;-2.071;-2.749;-1.531;0.8456;2.811;0.7349;-1.692;-2.997;-2.997;1.318;-0.9292;-1.446;2.718;-2.594;2.762;1.943;-0.9193','2.997','0.5518','s2','shared','calculated','-3--0.5,0.5-3',13,2834,4),(2841,'3','uniform','',40,'-1.791;-0.9454;-1.791;-1.23;0.6523;1.104;0.7692;-1.803;0.5469;1.303;1.57;-0.5835;-2.615;-2.613;1.997;0.6523;-1.493;-1.241;1.988;-0.5835;2.888;-0.8719;0.5469;-1.124;1.999;-1.425;2.223;0.9225;-0.6813;0.5469;-2.615;-2.859;1.731;-2.661;2.22;1.334;-1.796;0.6523;-1.942;-1.803','2.888','0.5469','s3','shared','calculated','-3--0.5,0.5-3',13,2834,5),(2842,'3','uniform','',40,'2.981;1.239;-0.9656;2.097;1.594;1.04;1.495;0.6319;0.7474;1.207;-0.8196;-1.716;0.7195;1.648;-1.646;0.6319;-0.9891;0.6319;1.141;-0.9656;-0.9656;-1.071;-0.9656;-1.469;1.281;0.6319;-2.38;-1.071;0.8187;1.141;2.904;-2.56;0.6481;1.027;1.594;-2.619;-2.108;-2.629;-1.02;0.6479','2.981','0.6319','s4','shared','calculated','-3--0.5,0.5-3',13,2834,6),(2843,'3','uniform','',40,'0.6539;2.014;-1.401;1.67;-0.9513;-1.176;-2.384;-1.48;0.6629;-2.678;-1.795;0.714;-1.313;1.076;0.714;1.087;-2.371;-1.397;-1.795;-1.977;2.164;0.6629;1.67;-1.401;-0.9342;-0.6002;0.94;2.642;-0.8913;-1.401;-2.412;0.998;-1.176;0.94;-0.591;0.5381;-0.8913;-1.726;1.991;1.21','2.678','0.5381','s5','shared','calculated','-3--0.5,0.5-3',13,2834,7),(2844,'3','uniform','',40,'0.9686;-2.975;-2.154;2.425;2.362;-2.894;0.7842;1.63;-2.113;1.354;0.96;2.448;1.968;-2.941;-2.324;-1.459;-2.324;-1.45;2.267;1.968;-2.894;-2.479;0.9686;0.9848;0.5539;2.003;2.24;2.928;-1.564;-2.894;-0.9923;-2.59;2.677;1.3;2.144;0.7291;-2.567;-0.5393;-2.026;-2.026','2.975','0.5393','s6','shared','calculated','-3--0.5,0.5-3',13,2834,8),(2873,'3','uniform','s',40,'2.615;0.7348;0.9045;2.892;2.839;2.573;2.553;2.584;0.6308;1.296;2.839;1.919;1.772;0.9038;1.22;2.415;2.935;2.244;2.026;1.737;1.737;2.415;1.919;1.495;1.776;0.8896;2.252;2.615;2.839;1.495;2.553;1.919;2.892;0.6308;1.803;2.998;1.105;1.803;1.205;2.681','2.998','0.6308','T1','shared','calculated','0.5-3',12,2871,0),(2874,'3','uniform','s',40,'0.01944;0.04847;0.0154;0.07587;0.06942;0.09127;0.004824;0.07416;0.02694;0.07222;0.09533;0.09577;0.09255;0.07213;0.03847;0.09255;0.09299;0.07222;0.07213;0.09127;0.004824;0.07209;0.09255;0.06255;0.05293;0.02404;0.08405;0.05293;0.04847;0.09255;0.07416;0.015;0.09299;0.0464;0.01944;0.05363;0.08805;0.09577;0.05363;0.03787','0.09577','0.004824','T2','shared','calculated','0.001-0.1',12,2871,1),(2886,'3','uniform','',40,'-3.242;-3.626;-2.572;-2.629;-2.619;-2.629;-2.053;-1.547;-3.695;-3.009;-3.702;-1.61;-3.695;-2.207;-3.242;-3.242;-1.358;-1.049;-3.081;-1.358;-3.054;-2.744;-1.432;-2.674;-3.726;-1.129;-1.514;-3.726;-2.053;-1.61;-3.695;-3.081;-1.432;-3.702;-3.009;-2.774;-2.053;-1.371;-1.514;-1.886','3.726','1.049','x1','shared','calculated','-4--1',12,2884,0),(2887,'3','uniform','',40,'5.189;2.477;2.204;0.5865;0.4808;2.297;2.905;0.8929;4.561;4.441;6.965;5.189;3.841;1.523;1.419;3.606;6.546;6.158;2.297;6.428;2.297;3.606;2.204;3.841;6.005;0.7578;0.5865;0.4808;5.189;0.5865;0.7628;6.07;6.005;2.44;0.7628;3.606;1.523;4.738;6.413;1.523','6.965','0.4808','x2','shared','calculated','0-7',12,2884,1),(2888,'3','uniform','',40,'-1.036;-0.8372;2.568;1.58;-1.036;-2.165;1.643;-1.65;-1.203;-1.036;2.378;0.1454;-2.329;1.465;-1.826;1.513;1.442;1.643;-0.8372;2.804;1.615;1.615;-1.844;-1.705;2.688;1.43;1.43;0.5378;1.482;1.386;-1.036;2.568;2.378;-1.9;-1.284;-1.266;-2.309;2.435;2.435;-1.844','2.804','0.1454','y1','shared','calculated','-3-3',12,2884,2),(2889,'3','uniform','',40,'4.128;7.178;4.755;1.255;4.128;5.408;7.705;5.675;3.257;7.767;1.769;7.164;7.164;5.408;1.769;4.186;4.128;3.776;2.28;6.365;1.2;4.949;5.974;3.528;1.759;5.974;3.906;7.178;3.257;5.697;2.241;3.528;3.257;1.759;4.299;5.697;7.705;4.755;4.186;4.612','7.767','1.2','y2','shared','calculated','1-8',12,2884,3),(2890,'3','uniform','',40,'-1.246;-6.034;-5.082;-6.175;-7.68;-2.104;-6.17;-4.027;-6.689;-6.689;-3.317;-3.405;-2.13;-5.603;-6.17;-6.175;-1.238;-2.104;-6.92;-1.246;-1.246;-1.29;-6.17;-7.797;-6.175;-1.29;-3.317;-1.246;-5.841;-7.368;-2.13;-4.74;-4.051;-6.034;-5.603;-1.416;-2.104;-6.175;-5.534;-6.689','7.797','1.238','y3','shared','calculated','-8--1',12,2884,4),(2891,'3','uniform','',40,'0.05787;3.826;5.411;5.729;0.4603;5.493;5.411;3.8;5.411;1.468;6.818;0.7262;6.984;4.675;3.551;1.703;5.493;5.729;0.05787;1.105;1.703;3.551;5.256;3.8;5.493;3.435;6.506;0.84;1.468;1.694;0.7262;3.826;3.435;3.551;1.694;1.724;6.818;0.5386;6.115;6.115','6.984','0.05787','x3','shared','calculated','0-7',12,2884,5),(2906,'0','uniform','',40,'4;2;9;9;2;2;9;9;8;10;2;6;1;2;9;9;2;5;5;6;5;9;1;2;2;2;5;3;8;9;6;5;4;9;2;2;8;1;7;7','10','1','z2','shared','calculated','I1-10\n ',14,2904,0),(2907,'0','uniform','',40,'3;1;3;6;4;6;2;9;3;8;9;3;9;6;3;6;7;4;6;9;10;7;10;3;3;7;8;5;3;4;3;5;5;9;8;2;10;10;10;6','10','1','z1','shared','calculated','I1-10\n ',14,2904,1),(2908,'0','uniform','',40,'8;1;7;6;9;7;9;9;10;4;1;8;2;7;1;1;1;6;1;5;5;4;1;5;2;10;2;1;7;5;8;9;7;6;2;10;10;8;9;8','10','1','g1','shared','calculated','I1-10\n ',14,2904,2),(2909,'0','uniform','',40,'7;6;3;8;8;7;10;2;7;7;9;5;4;4;9;5;9;8;4;7;1;9;7;9;4;4;8;4;4;6;1;9;7;7;10;2;3;7;1;4','10','1','g2','shared','calculated','I1-10\n ',14,2904,3),(2910,'0','uniform','',40,'9;10;5;7;9;9;8;3;6;8;7;7;2;2;3;2;9;6;8;10;10;9;3;10;9;9;2;10;2;8;7;9;3;4;4;8;4;2;2;7','10','2','n1','shared','calculated','I2-10 ',14,2904,4),(2911,'0','uniform','',40,'7;6;8;10;9;6;4;8;3;10;2;8;9;5;4;10;8;8;8;3;9;7;6;7;3;4;3;9;6;2;10;4;8;8;2;7;7;7;6;6','10','2','n2','shared','calculated','I2-10 ',14,2904,5),(2950,'3','uniform','',40,'2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°;2arg45°','2','2','a','shared','calculated','C:2arg45°',12,2948,0),(2951,'3','uniform','',40,'4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4','4','4','b','shared','calculated','C:4arg0',12,2948,1),(2952,'3','uniform','',40,'3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i;3*%i','3','3','c','shared','calculated','C:0j3',12,2948,2),(2953,'3','uniform','A',40,'(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i);(2+3*%i)','3.60555127546','3.60555127546','d','shared','calculated','C:2j3',12,2948,3),(2954,'3','uniform','V',40,'(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i);(-4-3*%i)','5','5','e','shared','calculated','C:-4j-3',12,2948,4),(3018,'0','uniform','V',40,'16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16;16','16','16','U','shared','calculated','16',12,3016,0),(3019,'0','uniform','A',40,'4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4;4','4','4','I','shared','calculated','4',12,3016,1),(3039,'3','uniform','',40,'5.658;5.909;4.939;3.037;3.628;4.939;3.962;3.28;5.373;2.48;5.019;4.388;2.839;3.164;5.373;5.658;3.559;5.909;2.738;2.192;2.273;4.388;2.738;2.738;5.878;3.643;5.658;3.319;3.962;2.273;2.192;5.881;5.365;3.551;3.916;3.916;2.839;3.643;5.365;4.064','5.909','2.192','a','shared','calculated','2-6',12,3038,0),(3040,'3','uniform','',40,'2.539;3.881;5.542;3.827;3.267;2.987;2.394;4.934;3.503;3.915;3.267;3.915;2.118;3.009;4.454;3.827;3.992;2.646;4.086;2.34;5.108;5.108;4.527;5.514;4.454;3.915;5.457;3.779;5.542;3.64;5.108;5.36;5.355;4.422;3.64;3.779;5.696;2.741;4.086;3.64','5.696','2.118','b','shared','calculated','2-6',12,3038,1),(3041,'3','uniform','',40,'2.726;5.551;3.863;5.259;2.776;4.183;2.499;2.499;2.623;3.541;5.429;4.556;4.959;2.11;3.773;4.357;3.773;4.027;5.497;5.285;4.942;5.8;3.541;3.85;5.325;4.183;4.183;2.726;2.499;4.531;4.556;5.677;4.531;3.612;3.627;5.754;5.429;4.942;4.357;2.623','5.8','2.11','c','shared','calculated','2-6',12,3038,2),(3051,'0','uniform','',40,'4E5;4','4E5','4','a','shared','calculated','sF:400000,4',13,3049,0),(3052,'0','uniform','',40,'1.23456E5;1.23456','1.23456E5','1.23456','b','shared','calculated','sF:123456,1.23456',13,3049,1),(3124,'3','uniform','',40,'2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2','2','2','x','shared','calculated','2',12,3122,0),(3134,'0','uniform','',40,'abc;x  zf;man;b,s;golf','x  zf','abc','s','shared','calculated','sS:abc,x  zf,man,b\\,s,golf',12,3132,0),(3135,'0','uniform','',40,'abc;x  zf;x  zf;b,s;abc;x  zf;abc;x  zf;b,s;b,s;x  zf;golf;man;x  zf;x  zf;x  zf;golf;x  zf;abc;man;man;abc;golf;golf;abc;x  zf;man;golf;x  zf;golf;abc;abc;x  zf;abc;b,s;golf;abc;b,s;golf;man','x  zf','abc','a','shared','calculated','S:abc,x  zf,man,b\\,s,golf',12,3132,1),(3136,'3','uniform','',40,'dcddde;62cbb;b1;89e3;c5;766fbe;ea;aa;08b;1adbad;d1;15b0a9a47;4766;4aedc502e;a5;a73dc;014;e8d0;6;e;1;5;caa;4e0;de;3;f4;3;c5;28eb2c;cc;a;02;cc5;e1;09;01c4b9;c0efb;572e1;c2','f4','014','r1','shared','calculated','R:[a-f0-9]+',12,3132,2),(3137,'3','uniform','',40,'Uuqo;Vkip;Arhl;Naot;Brcp;Nsta;Hmam;Ubax;Zlpu;Mkat;Jaxa;Jmxt;Yliv;Uouv;Mnqj;Ehrd;Vmkp;Cxug;Hbwj;Sutv;Rfhg;Yalv;Tcdv;Slsj;Yblo;Xfcs;Mfif;Jvkb;Dsql;Rpbd;Bzcr;Rypr;Iesb;Pqch;Kane;Bcdv;Pyko;Xxei;Ekiy;Yzdh','Zlpu','Arhl','r2','shared','calculated','R4:[A-Z][a-z]+',12,3132,3),(3146,'0','uniform','',40,'4;6;6;4;2;8;8;8;8;8;6;6;2;4;6;6;8;2;2;2;2;2;6;8;2;8;4;4;4;6;4;4;2;4;6;8;2;4;2;2','8','2','a','shared','calculated','4,6,2,8',12,3144,0),(3147,'3','uniform','',40,'7.429;9.67;18.51;15.44;8.123;15.44;19.66;8.683;6.343;18.7;19.25;19.25;8.123;3.255;13.09;19.66;16.97;8.683;7.429;11.08;19.66;19.45;19.45;6.343;8.27;9.053;5.338;10.98;15.34;3.636;6.343;18.45;9.67;9.268;8.15;8.15;7.429;3.452;6.66;15.34','19.66','3.255','b','shared','calculated','2-20',12,3144,1),(3148,'3','uniform','',40,'2.4;2.4;2.6;2.5;4.3;4.4;5;4.6;2;2;4.6;4.8;4;4.5;2.4;3.6;3;3.6;3.5;4.1;2;4.5;5;3.3;4.8;2.3;3.3;4.3;3.6;3.5;4.1;2.9;4.3;3.2;4.2;3;3.6;2;2.4;2.6','5','2','c','shared','calculated','2:0.1:5',12,3144,2),(3149,'3','uniform','',40,'5.463;6.451;5.665;5.459;6.269;5.384;5.665;5.041;6.423;6.411;5.384;2;6.181;6.076;6.327;5.463;5.459;6.315;12;2;5.967;6.327;6.258;5.505;5.471;5.701;5.041;5.041;5.041;6.181;5.701;6.786;6.181;5.384;6.823;6.315;6.823;5.701;5.806;12','12','2','d','shared','calculated','2,3,5-7,12',12,3144,3),(3150,'3','uniform','',40,'-16.85;-5.597;-6.578;-16.84;-8.077;-15.64;-8.077;-16.84;-15.64;-6.057;-12.4;-19.5;-6.976;-11.5;-16.84;-6.578;-5.575;-16.07;-6.578;-18.78;-15.64;-2.792;-7.596;-18.78;-10.26;-5.597;-11.5;-12.13;-8.883;-11.36;-8.883;-17.23;-15.64;-15.64;-5.082;-10.26;-8.077;-12.4;-6.578;-6.199','19.5','2.792','e','shared','calculated','-20--2',12,3144,4),(3151,'3','uniform','',40,'24;24;3;24;96;24;24;96;24;12;6;96;48;12;6;12;24;3;3;3;12;3;48;48;48;48;6;12;96;3;6;3;6;6;48;24;3;12;12;3','96','3','f','shared','calculated','3*2:100',12,3144,5),(3152,'3','uniform','',40,'68;12;39;10;22;33;10;10;39;18;22;22;27;12;27;27;56;33;12;12;12;22;15;27;33;39;15;27;18;15;22;27;15;33;27;56;22;27;27;15','68','10','g','shared','calculated','E12:10-80',12,3144,6),(3153,'3','uniform','',40,'4E-6;0.002;4E-6;3000;6E6;0.002;6E6;6E6;6E6;6E6;3000;4E-6;0.002;3000;4E-6;4E-6;6E6;4E-6;6E6;4E-6;6E6;6E6;6E6;6E6;0.002;0.002;4E-6;3000;4E-6;6E6;6E6;4E-6;4E-6;3000;3000;0.002;0.002;0.002;3000;4E-6','6E6','4E-6','h','shared','calculated','2m,3k,4u,6M',12,3144,7),(3162,'0','uniform','',40,'[5,6,8,5];[3,5,8,4];[2,7,5,2];[4,5,3,2];[8,2,3,6];[7,7,8,8];[7,6,6,6];[7,2,3,6];[8,3,7,7];[7,2,2,5];[5,8,2,7];[6,6,7,3];[3,2,3,2];[5,3,5,8];[3,5,7,3];[7,4,3,7];[6,3,8,6];[4,7,6,3];[6,8,8,8];[6,8,8,6];[2,5,2,6];[3,8,4,5];[4,8,2,5];[5,6,8,6];[2,5,5,5];[3,7,8,2];[2,8,5,8];[6,7,3,6];[2,5,2,6];[2,2,7,5];[2,8,4,2];[3,8,8,2];[5,5,6,8];[4,6,2,6];[7,7,3,3];[7,3,7,6];[3,8,4,3];[7,3,7,3];[6,8,5,6];[5,6,7,3]','8','2','a','shared','calculated','V4:I2-8',12,3160,0),(3163,'0','uniform','',40,'[2,3,6,6];[4,4,5,4];[7,5,4,3];[7,7,2,8];[4,8,5,6];[4,4,4,6];[8,6,4,5];[6,6,4,6];[4,7,6,8];[3,7,7,5];[6,5,3,3];[4,6,7,7];[6,8,4,8];[8,7,2,5];[6,4,7,2];[8,3,5,7];[7,5,6,5];[6,6,5,3];[6,7,8,4];[5,3,2,4];[7,3,4,8];[6,4,6,6];[6,3,7,4];[6,3,7,6];[8,6,3,2];[7,3,6,6];[4,7,4,4];[3,5,7,2];[2,6,6,2];[6,2,6,7];[6,6,8,2];[6,6,5,5];[5,6,2,4];[4,5,6,6];[6,5,5,4];[6,7,3,4];[7,5,3,3];[5,3,7,2];[4,3,8,7];[4,3,7,6]','8','2','b','shared','calculated','V4:I2-8',12,3160,1),(3164,'3','uniform','',40,'matrix([6.454,3.494,2.946,4.346],[2.432,7.478,5.022,3.845],[2.266,2.577,5.656,4.71]);matrix([7.398,3.102,6.463,5.656],[7.478,6.454,6.704,2.351],[4.549,4.71,3.845,6.335]);matrix([3.142,6.454,6.722,6.115],[6.63,7.478,5.898,2.946],[5.238,2.351,6.704,4.516]);matrix([7.772,5.656,4.667,2.266],[2.577,6.115,6.463,2.741],[4.326,6.704,4.549,3.142]);matrix([2.351,7.772,4.516,6.722],[3.494,3.845,4.71,4.549],[6.704,3.142,2.946,5.656]);matrix([4.667,3.142,7.772,5.898],[2.741,2.266,6.737,4.516],[4.822,7.386,5.022,4.391]);matrix([7.386,6.722,6.341,2.946],[3.494,3.102,6.673,4.549],[6.229,4.667,2.577,6.704]);matrix([7.772,2.946,6.229,3.142],[5.238,4.516,4.71,6.673],[2.577,4.667,2.432,5.022]);matrix([6.341,3.142,5.898,6.673],[3.845,6.454,4.326,2.741],[6.63,4.346,5.823,6.704]);matrix([6.115,7.398,6.335,2.741],[2.577,4.391,4.667,2.266],[4.516,4.822,5.898,6.341]);matrix([4.516,6.673,7.398,2.432],[7.772,2.946,4.325,6.454],[6.63,3.102,6.722,5.656]);matrix([3.102,7.386,3.494,5.238],[4.516,4.325,4.326,3.845],[7.772,5.656,4.549,2.741]);matrix([2.266,5.898,4.549,5.238],[4.822,4.631,3.102,2.351],[4.71,6.341,6.229,4.346]);matrix([5.656,6.115,6.704,3.102],[7.386,6.722,4.325,4.631],[6.63,2.351,5.823,6.335]);matrix([4.391,6.229,4.326,5.022],[2.577,7.398,6.463,2.946],[5.823,6.722,4.667,3.494]);matrix([4.71,2.741,4.631,3.102],[2.577,5.898,5.823,2.266],[6.722,6.115,4.391,6.673]);matrix([5.823,4.326,7.386,2.741],[3.845,4.667,6.454,6.341],[4.516,6.704,5.898,2.946]);matrix([6.463,2.432,4.325,6.737],[6.229,4.71,5.656,2.351],[4.516,6.704,3.845,2.577]);matrix([4.822,6.335,2.351,4.325],[3.142,4.667,6.463,6.115],[7.386,6.341,4.346,5.238]);matrix([5.823,3.102,2.741,6.115],[4.631,4.71,2.351,4.667],[2.577,4.822,6.63,3.142]);matrix([6.673,2.741,4.325,3.142],[2.432,5.656,3.845,6.229],[6.722,4.326,3.102,5.238]);matrix([6.463,6.229,4.71,6.335],[5.238,4.516,4.346,6.454],[5.823,2.946,4.667,2.741]);matrix([4.631,6.463,6.229,6.673],[4.516,4.326,7.386,2.266],[6.454,3.845,6.335,6.722]);matrix([4.631,4.391,6.115,4.667],[5.823,6.673,4.549,4.71],[6.341,6.722,5.022,3.102]);matrix([3.142,4.346,6.673,6.335],[2.432,5.238,6.341,6.454],[4.391,7.398,4.667,5.656]);matrix([6.335,3.142,6.454,4.346],[4.325,6.673,5.022,5.898],[6.463,5.238,4.631,6.229]);matrix([4.549,2.432,5.022,6.454],[2.741,7.772,3.494,3.142],[5.238,3.102,6.115,7.398]);matrix([4.346,5.022,6.115,6.737],[4.631,6.463,2.266,6.704],[6.454,3.845,6.341,4.391]);matrix([4.822,7.772,4.391,6.704],[2.577,6.229,4.667,6.463],[5.238,5.823,5.656,6.673]);matrix([4.667,5.022,4.325,4.326],[7.398,3.494,3.845,7.772],[6.341,6.673,6.115,5.823]);matrix([6.673,2.577,3.142,4.631],[5.823,4.346,6.335,5.898],[3.102,2.266,4.326,5.238]);matrix([5.656,5.022,6.63,6.722],[3.142,6.229,2.946,5.238],[4.516,3.494,2.432,4.346]);matrix([4.667,4.391,6.115,6.673],[2.432,3.845,6.63,4.71],[2.946,4.516,5.656,6.463]);matrix([4.326,2.946,4.325,5.656],[6.454,6.722,2.432,2.577],[2.266,6.341,4.516,6.115]);matrix([7.398,6.63,4.71,5.656],[6.115,7.478,7.772,4.631],[5.238,5.022,3.845,3.142]);matrix([2.741,3.845,5.022,6.115],[6.722,3.102,6.463,4.71],[2.946,2.351,4.391,6.737]);matrix([4.346,6.63,6.454,7.772],[7.398,4.667,4.631,5.656],[3.845,4.549,4.516,3.142]);matrix([6.454,3.845,4.667,6.229],[6.341,4.822,3.102,6.737],[4.346,4.631,6.463,5.823]);matrix([4.391,7.478,6.229,6.454],[6.673,5.022,3.494,4.71],[6.115,4.549,3.845,4.667]);matrix([3.845,3.142,2.266,6.115],[6.463,4.667,4.326,4.516],[4.822,7.386,5.022,5.656])','7.772','2.266','c','shared','calculated','M3x4:2-8',12,3160,2),(3165,'0','uniform','',40,'matrix([4,3],[3,8],[3,2]);matrix([6,4],[3,4],[6,4]);matrix([3,5],[7,3],[3,7]);matrix([3,5],[7,6],[6,2]);matrix([8,2],[4,2],[7,6]);matrix([7,4],[2,8],[3,3]);matrix([5,6],[3,7],[3,2]);matrix([7,7],[7,8],[4,7]);matrix([5,3],[6,6],[2,4]);matrix([3,2],[7,2],[5,8]);matrix([3,6],[2,3],[3,3]);matrix([6,7],[5,4],[8,7]);matrix([4,4],[3,4],[8,4]);matrix([6,4],[5,2],[8,2]);matrix([3,6],[4,4],[8,6]);matrix([7,7],[4,3],[4,8]);matrix([4,7],[4,4],[5,3]);matrix([7,6],[7,2],[6,7]);matrix([8,6],[8,8],[8,4]);matrix([7,2],[3,2],[7,4]);matrix([3,3],[8,8],[4,7]);matrix([3,6],[3,4],[3,6]);matrix([6,2],[3,7],[6,2]);matrix([4,8],[7,2],[2,8]);matrix([4,8],[6,3],[4,7]);matrix([3,6],[7,8],[5,2]);matrix([2,4],[3,2],[3,2]);matrix([2,7],[6,3],[2,4]);matrix([2,3],[6,4],[2,8]);matrix([3,3],[6,4],[2,2]);matrix([8,4],[2,2],[5,2]);matrix([2,8],[3,2],[2,4]);matrix([2,8],[5,3],[5,2]);matrix([2,8],[2,4],[8,3]);matrix([4,6],[5,5],[5,2]);matrix([4,5],[8,6],[3,7]);matrix([5,8],[7,6],[7,7]);matrix([6,3],[3,6],[2,7]);matrix([5,6],[2,2],[7,7]);matrix([3,2],[2,2],[3,2])','8','2','d','shared','calculated','M3x2:I2-8',12,3160,3),(3166,'3','uniform','',40,'matrix([7.983,6.425,6.961],[5.341,2.349,4.834],[6.961,7.983,7.983]);matrix([6.561,7.602,7.983],[4.94,7.724,7.602],[5.586,6.961,2.231]);matrix([6.478,7.602,2.206],[5.914,7.602,7.983],[6.425,6.425,7.513]);matrix([6.561,2.544,6.601],[7.513,2.544,3.108],[4.391,6.808,4.391]);matrix([4.391,5.341,7.983],[4.391,7.513,2.231],[3.158,5.141,2.231]);matrix([4.391,4.834,5.558],[5.558,3.108,4.834],[6.808,7.724,7.792]);matrix([5.916,3.158,5.341],[4.871,5.914,3.015],[5.558,7.724,2.867]);matrix([4.834,6.561,4.94],[7.602,4.871,4.94],[6.425,6.478,2.867]);matrix([6.478,2.349,5.688],[5.023,7.513,5.688],[2.206,7.602,5.586]);matrix([2.867,2.867,5.77],[7.758,6.808,3.158],[7.776,3.158,5.77]);matrix([4.391,6.961,4.993],[5.586,5.341,7.776],[5.141,4.993,5.023]);matrix([7.776,4.871,2.231],[3.158,7.602,4.858],[4.94,4.391,4.391]);matrix([6.601,7.776,5.385],[7.724,4.871,6.601],[4.391,7.71,6.561]);matrix([5.341,7.724,6.478],[7.71,2.206,2.544],[6.561,2.349,4.993]);matrix([3.108,3.015,5.558],[4.858,3.569,2.544],[4.391,5.586,5.341]);matrix([4.94,4.871,7.776],[4.94,6.478,7.758],[6.425,6.425,6.561]);matrix([7.776,4.871,3.158],[3.569,6.808,6.961],[4.834,2.206,3.108]);matrix([6.561,2.349,2.867],[4.94,4.871,5.688],[5.586,5.558,7.452]);matrix([5.688,5.688,6.961],[7.724,5.558,5.77],[4.94,6.961,3.108]);matrix([2.231,6.961,6.808],[5.023,4.858,5.341],[6.961,7.724,7.776]);matrix([5.558,4.391,3.108],[7.792,5.558,4.94],[2.349,3.015,7.452]);matrix([5.77,4.834,5.341],[6.601,6.478,5.688],[7.513,5.385,7.776]);matrix([5.558,6.961,5.586],[3.108,6.961,7.792],[2.206,5.023,5.77]);matrix([6.601,2.206,5.586],[2.867,4.834,4.834],[6.425,5.586,5.916]);matrix([5.023,7.513,4.94],[7.452,5.558,5.558],[4.391,5.688,4.834]);matrix([5.385,5.914,6.478],[7.452,5.688,7.724],[3.015,6.808,2.206]);matrix([5.341,4.871,5.141],[5.586,7.602,7.513],[4.993,5.77,5.385]);matrix([6.808,7.776,2.206],[3.569,5.688,4.391],[5.688,7.513,7.513]);matrix([3.158,3.569,5.586],[5.341,2.349,7.776],[5.141,6.425,3.158]);matrix([3.569,5.023,7.452],[4.871,2.231,3.569],[6.425,5.341,7.724]);matrix([7.452,5.77,7.758],[4.993,6.478,7.602],[6.601,4.858,4.993]);matrix([2.231,6.601,5.688],[3.569,5.916,4.993],[5.558,5.341,4.94]);matrix([5.385,4.858,7.792],[7.513,7.513,4.94],[5.688,5.916,3.158]);matrix([4.834,7.758,7.452],[2.206,5.77,6.478],[2.544,5.914,5.341]);matrix([4.871,2.867,5.916],[4.391,4.834,7.792],[4.834,4.834,4.993]);matrix([4.993,6.601,7.513],[3.569,5.916,5.916],[7.983,6.961,4.858]);matrix([7.792,5.77,5.023],[5.688,4.834,7.792],[4.391,7.452,5.023]);matrix([3.108,7.724,5.77],[6.601,7.513,5.023],[7.792,5.141,3.158]);matrix([2.867,7.724,5.688],[5.558,5.385,7.602],[5.914,3.108,3.158]);matrix([4.94,6.808,7.758],[4.94,2.231,6.808],[5.914,7.724,4.391])','7.983','2.349','e','shared','calculated','M3:2-8',12,3160,4),(3167,'0','uniform','',40,'matrix([3,4,3],[7,3,4],[6,3,6]);matrix([7,7,3],[3,6,6],[5,6,5]);matrix([5,6,4],[8,4,8],[7,3,3]);matrix([4,4,6],[7,6,7],[5,5,5]);matrix([6,8,4],[3,6,5],[5,5,5]);matrix([5,6,7],[6,6,3],[8,6,5]);matrix([7,6,4],[6,3,4],[7,6,3]);matrix([6,8,4],[5,3,3],[7,3,3]);matrix([8,8,5],[6,7,6],[7,6,3]);matrix([4,8,3],[4,6,6],[8,5,3]);matrix([4,3,5],[4,5,5],[6,5,3]);matrix([6,3,4],[7,5,6],[5,5,5]);matrix([5,3,6],[6,3,6],[6,6,8]);matrix([4,3,6],[7,6,4],[7,7,3]);matrix([4,6,6],[6,8,8],[3,7,3]);matrix([8,6,4],[3,3,7],[8,4,6]);matrix([8,6,5],[3,8,5],[3,4,4]);matrix([3,7,7],[5,3,3],[6,3,7]);matrix([4,3,6],[5,4,3],[4,6,6]);matrix([4,8,6],[6,7,5],[7,3,5]);matrix([5,7,8],[5,3,6],[3,5,4]);matrix([8,4,3],[8,7,6],[5,8,6]);matrix([5,3,6],[3,3,4],[6,3,3]);matrix([8,7,3],[4,3,3],[4,8,6]);matrix([3,3,5],[3,7,3],[7,8,6]);matrix([5,6,3],[3,6,3],[6,4,4]);matrix([8,7,6],[4,5,3],[7,8,4]);matrix([4,4,7],[7,5,5],[6,3,5]);matrix([3,7,7],[6,7,5],[4,6,4]);matrix([4,7,6],[7,4,7],[7,5,5]);matrix([6,5,5],[8,5,3],[6,6,5]);matrix([4,6,4],[3,5,5],[4,3,6]);matrix([5,7,4],[7,4,5],[3,3,8]);matrix([6,4,7],[3,7,4],[8,4,3]);matrix([3,3,7],[3,7,4],[8,3,8]);matrix([7,5,6],[6,7,4],[3,4,4]);matrix([8,3,5],[6,8,3],[4,4,6]);matrix([3,6,6],[3,3,5],[3,4,8]);matrix([4,6,4],[4,6,5],[5,5,4]);matrix([3,4,6],[5,4,4],[6,6,6])','8','3','f','shared','calculated','M3:I3-8',12,3160,5),(3176,'0','uniform','',40,'2;5;6;6;4;10;6;3;6;3;5;7;2;6;5;7;9;3;10;9;3;9;9;9;5;4;9;10;5;7;6;6;4;6;6;9;6;9;10;3','10','2','a','shared','calculated','I:2-10',12,3174,0),(3177,'3','uniform','',40,'3;6;2;8;-3;5','8','-3','b','shared','calculated','sI:3,6,2,8,-3,5',12,3174,1),(3178,'3','uniform','',40,'3.587;4.931;4.109;3.438;3.227;3.746;4.026;3.836;4.168;3.683;4.617;3.645;3.962;4.041;4.041;3.971;3.956;3.683;4.527;4.639;3.28;3.587;3.28;3.667;4.813;3.438;4.026;3.28;3.971;4.574;3.836;4.357;3.772;3.645;4.646;7;3.961;4.164;3.28;4.168','7','3.227','c','shared','calculated','F:2,3-5,7',12,3174,2),(3179,'3','uniform','',40,'15.8;11.7;19.6;14.9;7.24;13.8;13.2;19.6;7.24;9.43;13.2;9.68;9.68;6.77;5.58;5.15;16.8;18.4;19.6;8.66;9.68;6.77;5.58;6.35;10.6;15.1;10.6;8.16;14.3;13.8;18;13.8;16.8;16.8;18.4;5.15;16.4;13.6;3.73;3.73','19.6','3.73','d','shared','calculated','F3:3-20',3,3174,3),(3180,'3','uniform','',40,'2.6;2.6;3.2;4.4;3.8;2;5;2;3.2;3.2;4.4;3.8;4.4;3.2;5;3.8;3.8;3.8;2.6;2.6;4.4;2;4.4;4.4;2.6;2.6;5;4.4;4.4;2.6;2.6;2;2;4.4;4.4;3.8;4.4;5;2.6;4.4','5','2','e','shared','calculated','6:2-5',12,3174,4),(3181,'3','uniform','',40,'1.2;-5;2.3;8;0.03;12','12','-5','f','shared','calculated','sF:1.2,-5,2.3,8,0.03,12',12,3174,5),(3182,'3','uniform','',40,'3.1;4.9;2.8;5;3.2;3.7;2.1;2;3.6;4.2;2.7;3.5;3.6;3;3.4;2.1;2.2;2.1;2;3;2.2;4.5;2.7;4.9;4.2;2.7;4.6;3.2;4.9;3.1;3.5;4.5;3.3;2;2.7;3.4;2.6;2.4;4.9;4','5','2','g','shared','calculated','2:0.1:5',12,3174,6),(3183,'0','uniform','',40,'2.9arg-32°;2.8arg150°;2.7arg-164°;-3.4;2.8arg-40°;3.2arg146°;2.9arg-32°;4arg-30°;2.8arg150°;3.5arg142°;2.8arg-162°;2.9arg-32°;3.9arg-150°;3.5arg54°;3;2.1arg174°;3arg-32°;3.5arg54°;2.5arg-170°;3.3arg-70°;3.3arg174°;3arg-46°;2.7arg75°;3arg140°;3.6arg-108°;3.5arg54°;2.3arg18°;2.3arg-170°;3.2arg146°;2.3arg-170°;2.8arg-162°;2.6arg128°;3.1arg-42°;2.5arg-170°;2.8arg-40°;3.2arg144°;2.3arg140°;2.5arg-170°;2.3arg-170°;3.5arg142°','4','2.1','h','shared','calculated','C2:2-4',2,3174,7),(3184,'0','uniform','',40,'3arg39°;2.1arg68°;3.2arg80°;2.5arg41°;2.5arg39°;3.4arg43°;2.2arg80°;2arg86°;3.9arg47°;2.6arg28°;3.1arg39°;2.2arg80°;2.8arg69°;3.6arg28°;2.5arg39°;3.4arg41°;3.6arg68°;2.7arg47°;3.1arg55°;3.3arg68°;3.7arg56°;3.1arg39°;3.7arg56°;2.2arg73°;2.5arg86°;3.9arg27°;2.5arg41°;3.6arg28°;2.9arg68°;3.1arg77°;3.6arg28°;3.6arg68°;3.2arg56°;3arg86°;3.1arg55°;3.2arg80°;2.6arg28°;2.9arg61°;2.2arg80°;3.4arg43°','3.9','2','i','shared','calculated','C2:2-4arg10-90',2,3174,8),(3185,'3','uniform','=karti',40,'(2.7+4*%i);(2.8+1.5*%i);(2.8+1.5*%i);(2.9+5.7*%i);(3-0.8*%i);(3.4-0.71*%i);(3.5+3.1*%i);(3.1+5.7*%i);(4+1.3*%i);(3.5+3.1*%i);(2.2+5.8*%i);(3.7+2.1*%i);(3.4-0.7*%i);(2.9-%i);(2.8+5.8*%i);(3-0.8*%i);(3.1+3.6*%i);(3.4-0.7*%i);(3.4-0.71*%i);(3.9+1.9*%i);(3.9+3.3*%i);(3.2-%i);(2.9-%i);(2.7+4*%i);(2.9-%i);(2.1+2.7*%i);(3.3+3.8*%i);(3.9+1.9*%i);(2.8+5*%i);(3.1+3.6*%i);(3.9+3.3*%i);(3.9+3.3*%i);(3.9+2.6*%i);(3.1+0.69*%i);(2.8+1.5*%i);(4+1.3*%i);(3.4+5.2*%i);(2.8+1.5*%i);(2.7+4*%i);(3.1+3.6*%i)','6.488451279','3.06757233004','j','shared','calculated','C2:2-4j-2-6',2,3174,9);
/*!40000 ALTER TABLE `datasetDefinition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deskriptor`
--

DROP TABLE IF EXISTS `deskriptor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `deskriptor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `DESKRIPTOR` longtext,
  `JAHRGANG` int DEFAULT NULL,
  `KOMPETENZBEREICH` varchar(200) DEFAULT NULL,
  `KURZBEZEICHNUNG` varchar(200) DEFAULT NULL,
  `LEVEL` int DEFAULT NULL,
  `SEMESTER` int DEFAULT NULL,
  `idGegenstand` int DEFAULT NULL,
  `idLehrplan` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_deskriptor_idGegenstand` (`idGegenstand`),
  KEY `FK_deskriptor_idLehrplan` (`idLehrplan`),
  CONSTRAINT `FK_deskriptor_idGegenstand` FOREIGN KEY (`idGegenstand`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `FK_deskriptor_idLehrplan` FOREIGN KEY (`idLehrplan`) REFERENCES `lehrplan` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deskriptor`
--

LOCK TABLES `deskriptor` WRITE;
/*!40000 ALTER TABLE `deskriptor` DISABLE KEYS */;
/*!40000 ALTER TABLE `deskriptor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dokumente`
--

DROP TABLE IF EXISTS `dokumente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dokumente` (
  `id` int NOT NULL AUTO_INCREMENT,
  `CONTENT` longblob,
  `FILESIZE` bigint DEFAULT NULL,
  `FILENAME` varchar(255) DEFAULT NULL,
  `MD5` varchar(255) DEFAULT NULL,
  `TYP` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `MD5` (`MD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dokumente`
--

LOCK TABLES `dokumente` WRITE;
/*!40000 ALTER TABLE `dokumente` DISABLE KEYS */;
/*!40000 ALTER TABLE `dokumente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `errorquestion`
--

DROP TABLE IF EXISTS `errorquestion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `errorquestion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `CATPATH` varchar(255) DEFAULT NULL,
  `DATUM` datetime DEFAULT NULL,
  `ERLEDIGT` tinyint(1) DEFAULT '0',
  `MSGTEXT` longtext,
  `TYPE` int DEFAULT NULL,
  `USER` varchar(255) DEFAULT NULL,
  `idQuestion` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_errorquestion_idQuestion` (`idQuestion`),
  CONSTRAINT `FK_errorquestion_idQuestion` FOREIGN KEY (`idQuestion`) REFERENCES `question` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `errorquestion`
--

LOCK TABLES `errorquestion` WRITE;
/*!40000 ALTER TABLE `errorquestion` DISABLE KEYS */;
/*!40000 ALTER TABLE `errorquestion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fragengruppe`
--

DROP TABLE IF EXISTS `fragengruppe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fragengruppe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ANZAHL` int DEFAULT NULL,
  `NR` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fragengruppe`
--

LOCK TABLES `fragengruppe` WRITE;
/*!40000 ALTER TABLE `fragengruppe` DISABLE KEYS */;
/*!40000 ALTER TABLE `fragengruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gegenstand`
--

DROP TABLE IF EXISTS `gegenstand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gegenstand` (
  `id` int NOT NULL AUTO_INCREMENT,
  `CATEGORYNAME` varchar(255) DEFAULT NULL,
  `KUERZEL` varchar(20) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gegenstand`
--

LOCK TABLES `gegenstand` WRITE;
/*!40000 ALTER TABLE `gegenstand` DISABLE KEYS */;
/*!40000 ALTER TABLE `gegenstand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gegenstand_gegenstand`
--

DROP TABLE IF EXISTS `gegenstand_gegenstand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gegenstand_gegenstand` (
  `gegenstaendeForLehrplan_ID` int NOT NULL,
  `alternativGegenstaende_ID` int NOT NULL,
  PRIMARY KEY (`gegenstaendeForLehrplan_ID`,`alternativGegenstaende_ID`),
  KEY `FK_gegenstand_gegenstand_alternativGegenstaende_ID` (`alternativGegenstaende_ID`),
  CONSTRAINT `FK_gegenstand_gegenstand_alternativGegenstaende_ID` FOREIGN KEY (`alternativGegenstaende_ID`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `gegenstand_gegenstand_gegenstaendeForLehrplan_ID` FOREIGN KEY (`gegenstaendeForLehrplan_ID`) REFERENCES `gegenstand` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gegenstand_gegenstand`
--

LOCK TABLES `gegenstand_gegenstand` WRITE;
/*!40000 ALTER TABLE `gegenstand_gegenstand` DISABLE KEYS */;
/*!40000 ALTER TABLE `gegenstand_gegenstand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `globalconfig`
--

DROP TABLE IF EXISTS `globalconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalconfig` (
  `id` int NOT NULL AUTO_INCREMENT,
  `DISABLESCHOOLEDIT` tinyint(1) DEFAULT '0',
  `EDITABLE` tinyint(1) DEFAULT '0',
  `HELP` longtext,
  `NAME` varchar(255) DEFAULT NULL,
  `TEXT` longtext,
  `TYP` int DEFAULT NULL,
  `VISIBLE` tinyint(1) DEFAULT '0',
  `idSchule` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_globalconfig_idSchule` (`idSchule`),
  CONSTRAINT `FK_globalconfig_idSchule` FOREIGN KEY (`idSchule`) REFERENCES `schule` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `globalconfig`
--

LOCK TABLES `globalconfig` WRITE;
/*!40000 ALTER TABLE `globalconfig` DISABLE KEYS */;
INSERT INTO `globalconfig` VALUES (1,0,0,'Lizenz-Code','lizenz','nycoSVPbRN1tsjg+m08sfguO/Kig1448g0a9MaL0pqp6QWQYUHPBEtzcJQU18FahFSoj0GKXUfGmQ2yYGtEEVm9fCFZyDBHSXEelvJ46oTEF5YET/+DrI+sdlgmli1zYEwMcqHFECAWCUCpXWyyOiueOavsekEAwGnrrz98paw8csvCd+Uid/lnItZiLtWE7f10PgCwFekg=',0,0,1),(2,0,0,'Package-Daten, die für Maxima geladen werden sollen','moodle.mac','/* ======================================================================= */\n/* moodle.mac                                                       V 1.04 */\n/* ======================================================================= */\n/* Electrical Engineering functions                                        */\n/* ======================================================================= */\n\n/* -----------------------------------------------------------------------                  */\n/* parallel_resistance - Parallel connection of resistances                */\n/* -----------------------------------------------------------------------                  */\nparallel_resistance([z]):=xthru(1/apply(\"+\",1/z))$\n\"||\"([z]):=apply(parallel_resistance,z)$\nnary(\"||\",115)$\n\n/* ======================================================================= */\n/* Erweiterungen speziell fuer Moodle  --> DAMB                             */\n/* ======================================================================= */\n\ndisplay2d:false$\nset_display(ascii)$\nassume_pos:false$\nfpprintprec:10$\npow(x,y):=x^y$\npar(x,y):=x*y/(x+y)$\nZ(betr, phase):= betr*exp(%i*phase*%pi/180)$\n|(x,y):=x*y/(x+y)$\nnary(|)$\npi():=%pi$\nlog10(x):=log(x)/log(10)$\nrad2deg(x):=x*180/%pi$\ndeg2rad(x):=x/180*%pi$\n\n/* ======================================================================= */\n/* Various Functions                                                       */\n/* ======================================================================= */\n\n/* ----------------------------------------------------------------------- */\n/* selective_kill_all - Kill all functions below this definition           */\n/* ----------------------------------------------------------------------- */\nselective_kill_all():=\napply(kill,delete(\'\'selective_kill,listify(setdifference((\n   setify(map(op,functions))),\'\'\'\'(setify(map(op,functions)))))))$\nnofix(selective_kill_all)$\n\n/* ----------------------------------------------------------------------- */\n/* coefficient_list(p,s) - calculates a list of the coefficients of        */\n/*                         the polynomial p(s) in ascending order          */\n/* ----------------------------------------------------------------------- */\ncoefficient_list(p,s) := lambda([v],map(lambda([u],coeff(v,s,u)),\n   makelist(i,i,0,hipow(v,s))))(expand(p))$\n   \n/* ----------------------------------------------------------------------- */\n/* standard_form - One of the 4 standard forms of a transfer function      */\n/*    (making one of the leading or absolute coefficients to 1)            */\n/* ----------------------------------------------------------------------- */\nstandard_form(f,[n]) :=\nblock([n1,numli,denli,numli1,denli1,k,ratprint:false],\nf:xthru(f),\nn1:if length(n)=0 then 4 else n[1],\n[numli,denli]:[coefficient_list(num(f),s),coefficient_list(denom(f),s)],\n[numli1,denli1]:[delete(0,numli),delete(0,denli)],\nk:[last(numli1),first(numli1),last(denli1),first(denli1)][n1],\nnumli:numli/k, denli:denli/k,\napply(\"+\",fullmap(lambda([u],if u=1.0 then 1 else u),\n        float(numli)*makelist(s**i,i,0,length(numli)-1)))/\napply(\"+\",fullmap(lambda([u],if u=1.0 then 1 else u),\n        float(denli)*makelist(s**i,i,0,length(denli)-1)))\n)$  \nroot(x,y):=x^(1/y)$',0,0,NULL),(3,0,0,'Pfad, unter dem Projekt-Abgaben von Schülern gespeichert werden','pathProjektAbgaben','/opt/letto/projekt/',0,0,NULL),(4,0,0,'Pfad, unter dem Fotos von Schülern unter ihrer Sokrates-ID gespeichert sind','pathUserPhotos','/opt/letto/images/photos/',0,0,NULL),(5,0,0,'Pfad, unter dem die Dateien der Testfragen gespeichert sind','pathImages','/opt/letto/images/',0,0,NULL),(6,0,0,'Webpfad, unter dem die Dateien aufrufbr sind','webPathImages','/images/',0,0,NULL),(7,0,0,'Pfad, unter dem Datenbank-Backups gespeichert werden','pathDatabaseBackup','/opt/letto/backup/',0,0,NULL),(8,0,0,'Import von Schüler-Bildern nach Sokrates-ID oder Voname.Nachname','schuelerPhoto','SokratesID',0,0,NULL),(9,1,0,'Konfigurationsdatei für globale Einstellungen','configFile','/opt/letto/config.json',0,0,NULL),(10,1,0,'Anwendungspfad von Maxima','maximaPath','maxima',0,0,NULL),(11,1,0,'Web-Pfad, unter dem die lokale Javascript-Library verfügbar ist','javascriptWebPath','/js/',0,0,NULL),(12,1,0,'Pfad zu lokalem Javascript-Verzeichnis','javascriptFilesystemPath','/opt/letto/js/',0,0,NULL),(14,0,0,'Mögliche Gruppierungen von Beurteilungen','BewertungsGruppen','Prüfung;Hausübung;Mitarbeit;Referat',0,0,NULL),(15,1,0,'Pfad für Plugins am Server','pluginpath','/opt/letto/plugins',0,0,NULL),(17,0,0,'Lehrer beim Import mit l- am Beginn ergänzen','addLehrerKuerzel','0',4,0,NULL),(18,0,0,'Definition der möglichen Testbereiche wie Reading, Listening, ...','testBereiche','*Reading-30-0, Listening-30-0, Writing-40-0*Typ1 Aufgaben-60-0, Typ2 Aufgaben-40-0',0,0,NULL),(19,0,0,'Angezeigtes Bild am Hauptschirm, Typ muss auf Image gesetzt werden','image','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',0,0,NULL),(20,0,0,'Schulbezeichnung, die links oben im Hauptfenster angezeigt wird','schulname','LeTTo',0,0,NULL),(21,0,0,'Schulstufe, die in der ersten Klasse vorliegt. (HTL: 9, AHS, NMS: 5, Volksschule: 1)','startSchulstufe','9',3,0,NULL),(22,0,1,'Abzüge bei Einheitenfehler ','EH_Fehler','0.1',2,1,NULL),(23,0,1,'Default-Wert für Toleranz','Toleranz','1%',0,1,NULL),(24,0,1,'Prozentwert bei hinzugefügter Teilantwort ','SQ_Prozent','50%',0,1,NULL),(25,0,1,'Definiert, ob Fragen unvollständig gespeichert werden dürfen (0:nein/1:ja) ','AllowEmptyQuest','1',3,1,NULL),(26,0,1,'Definiert, ob bei unvollständigen Fragen eine Warnung angezeigt wird (0:nein/1:ja) ','ShowWarningEmptyQuest','0',3,1,NULL),(27,0,1,'Definiert das Ende eines Tex-Documents','DocEnd','\n\\end{document}\n',0,1,NULL),(28,0,1,'Definiert die Startseite eines TEX-Dokuments','DocInit','\\documentclass[11pt,german,a4paper]{report}\n\\def\\name{Prof. Max Mustermann\n}',0,1,NULL),(29,0,1,'Beginn des Dokuments mit Definition der Dokumentklasse','DocInitQuestion','\\documentclass[11pt,german,a4paper]{article}\n\\def\\name{Prof. Max Mustermann}\n',0,1,NULL),(30,0,1,'Testdefinition mit Definition der Dokumentklasse','DocInitTest','\\documentclass[11pt,german,a4paper]{article}',0,1,NULL),(31,0,1,'TEX-Definitonen bis incl. \\begindocument','DocStart','\\PageNormal\n\\begin{document}',0,1,NULL),(32,0,1,'TEX-Definitonen für eine Question bis inkl. \\begindocument','DocStartQuestion','\\PageQuestion\n\\begin{document}',0,1,NULL),(33,0,1,'TEX-Definitonen für einen Test bis inkl. \\begindocument','DocStartTest','\\PageTest\n\\begin{document}',0,1,NULL),(34,0,0,'TEX-Paramter für LATEX','TEX_Parameter','-interaction=nonstopmode -max-print-line=120 -output-directory=%d %f',0,0,NULL),(35,1,0,'Commandline-Aufruf der TEX-Compilers','TEX_Compiler','pdflatex',0,0,NULL),(36,1,0,'Pfad für die Tex Dateien','TexDocs','/opt/letto/tex',0,0,NULL),(37,1,0,'Pfad für die PDF-Dateien','PDFPfad','/opt/letto/pdf',0,0,NULL),(38,1,0,'Pfad für die XML-Export-Dateien','DefaultPfad','/opt/letto/xml',0,0,NULL),(39,1,0,'Pfad für die Export-Dateien','ExportPfad','/opt/letto/export',0,0,NULL),(40,1,0,'Pfad für die Bild-Dateien beim Erzeugen von Tex-Dokumenten','ImagePfad','/opt/letto/img',0,0,NULL),(41,1,0,'Pfad für temporäre Dateien','TempPath','/opt/letto/tmp',0,0,NULL),(42,1,0,'Pfad für alle Scripts zum Update/Starten/Stoppen/... des Servers','script_path','/opt/letto',0,0,NULL),(43,1,0,'Datei für den Watchdog vom Betriebssystem','WatchdogFile','/opt/letto/lettowatchdog',0,0,NULL),(46,1,0,'Identification für Lizenz-Server','restKey','XjRMRC/QgHQ+RKlnD2SKM7qll3cvPrmifOWmDyYfTnh/PvlOEP9NVg==',0,0,NULL),(47,0,0,'Anzeige der Testergebisse mit Lösungen freischalten','showTestResults','1',4,1,NULL),(48,1,0,'Parameter zur Konfiguration des Mail-Servers, Konfiguration bitte über Globale Mail-Einstellungen','mailParams','mail.smtp.host=smtp.gmail.com;mail.smtp.socketFactory.port=465;mail.smtp.socketFactory.class=javax.net.ssl.SSLSocketFactory;mail.smtp.auth=true;mail.smtp.port=465',0,0,NULL),(49,0,0,'Daten-Austausch-Server','exchange','0',4,0,NULL),(51,1,0,'Domain-Bezeichnung (zB.: htl-stp.local','domain','meineDomain.local',0,0,NULL),(52,0,1,'1: Maxima wird vor dem Speichern der Frage aufgerufen; 0: Kein Maxima-Aufruf','maximaForSave','1',4,1,NULL),(53,0,1,'Angabe, ob Fragen auch in bereits gespeicherten Tests verändert werden dürfen: 0:Ja, 1:Rückfrage, 2:Nein','questChangeTestSolved','0',3,0,NULL),(54,0,1,'Angabe, welche Beurteilungsarten im Katalog angezeigt werden sollen. Einstellbar über den Katalog und den Setup-Button','angezeigteBeurteilungen','[SMÜ, Test, Hausübung, Schularbeit, Rechenübung, Mahnung, Noten]',0,0,NULL),(57,0,1,'Angaben, welche Werte und Einheiten Datensätze zugewiesen bekommen','datasetDefault','default;;0;I1-10\nR;Ohm;0;E12:1k-100k\nL;H;0;1m-100m\nC;F;0;E12:1n-100n\n',0,0,NULL),(58,0,1,'Größe des Fragen-Vorschau-Dialoges im Format Breite;Höhe','dialogSize','1000;600',0,1,NULL),(59,0,0,'Fokus-Lost-Event bei Tests auch durch Größenänderung','focusLostBySizeChange','0',4,0,NULL),(60,0,1,'Anzeige der Anzahl an Fragen bei jeder Kategorie ','showQuestionCount','0',4,1,NULL),(61,0,0,'Anzeige aller Gegenstände bei Lehrer-Klassenzuteilung ','alleGegenstaende','0',4,0,NULL),(62,0,0,'Benutzer können Kategorien für andere Benutzer unsichtbar machen (private Kategorien) ','privateKategorien','0',4,0,NULL),(63,0,1,'Codierung von exportierten Dateien: UTF8 oder ISO','exportFormat','ISO',0,1,NULL),(64,0,1,'CSV-Trennzeichen','csvTrennzeichen',';',0,1,NULL),(66,1,0,'Fehlermeldung bei Lösungsberechnung','errTimerCalcErg','Fehler beim Berechnen der Lösung für die Frage',0,0,NULL),(67,1,0,'Fehlermeldung bei AngabeMitZahlen','errTimerAngabe','Fehler beim Rendern des Angabetextes',0,0,NULL),(68,1,0,'Fehlermeldung beim Rendern von Antworten','errTimerAntwort','Fehler beim Rendern von Antworten',0,0,NULL),(69,0,0,'Style-Information für Reifeprüfungsangabe (mündlich)','rdpfragen.sty','% =============================================================================\n% Maturafragen                                      DI Werner Damböck, 7.6.2016\n% =============================================================================\n%\\documentclass[11pt]{article}\n\n\\usepackage{amssymb}\n\\usepackage[T1]{fontenc}\n\\usepackage[utf8]{inputenc}\n\\usepackage[american,naustrian]{babel}\n\\usepackage{makeidx}\n\\usepackage{color}\n\\usepackage{xcolor}\n\\usepackage{listings}\n\\usepackage{float}\n\\usepackage{latexsym}\n\\usepackage{array}\n\\usepackage{longtable}\n\\usepackage{tabularx}\n\\usepackage{textcomp}\n\\usepackage{verbatim}\n\\usepackage{ifthen}\n\\usepackage{hyperref}\n\\usepackage{multirow}\n\\usepackage{pdfpages}\n\\usepackage{marvosym}\n\\usepackage{twoopt}\n\\usepackage{picinpar}\n\\usepackage{graphicx}\n\\usepackage{ulem}\n\\usepackage[a4paper,width=186mm,height=276mm,hmargin=6.5mm,vmargin=10mm]{geometry}\n\\usepackage{tikz}\n\\usetikzlibrary{calc}\n\\usepackage{amsmath}\n\n% Variable Textbausteine:\n% -----------------------\n\\def\\schule{~}\n\\def\\Schule#1{\\def\\schule{#1}}\n\\def\\pruefungsgebiet{~}\n\\def\\Pruefungsgebiet#1{\\def\\pruefungsgebiet{#1}}\n\\def\\pruefer{~}\n\\def\\Pruefer#1{\\def\\pruefer{#1}}\n\\def\\beisitzer{~}\n\\def\\Beisitzer#1{\\def\\beisitzer{#1}}\n\\def\\jahrgang{~}\n\\def\\Jahrgang#1{\\def\\jahrgang{#1}}\n\\def\\datum{~}\n\\def\\Datum#1{\\def\\datum{#1}}\n\\def\\themenbereich{~}\n\\def\\Themenbereich#1{\\def\\themenbereich{#1}}\n\\def\\kandidat{~}\n\\def\\Kandidat#1{\\def\\kandidat{#1}}\n\\def\\kategorie{~}\n\\def\\Kategorie#1{\\def\\kategorie{#1}}\n\\def\\katD{D}\n\\def\\katE{E}\n\\def\\katSF{SF}\n\\def\\katWF{WF}\n\\def\\katKP{KP}\n\\def\\katLFS{LFS}\n\\def\\termin{~}\n\\def\\Termin#1{\\def\\termin{#1}}\n\n% Farben:\n% -------\n\\definecolor{colx}{RGB}{38,80,164}\n\\definecolor{grau}{rgb}{0.8,0.8,0.8}\n\n% Schriftarten:\n% -------------\n\\newfont{\\fontbigbold}{phvb8t scaled 1200}\n\\newfont{\\fontbold}{phvb8t scaled 1000}\n\\newfont{\\fontnormal}{phvr8t scaled 1000}\n\\newfont{\\fontsmall}{phvr8t scaled 900}\n\\newfont{\\fontverysmall}{phvr8t scaled 750}\n\\newfont{\\fonttiny}{phvr8t scaled 600}\n\n% Linienbreiten:\n% --------------\n\\tikzset{w1/.style={line width=0.2mm}}\n\\tikzset{w2/.style={line width=0.45mm}}\n\\tikzset{w3/.style={line width=0.9mm}}\n\n% ------------------------------------------------------------------------\n\\long\\def\\Aufgabenstellung#1{\\newpage\n% ------------------------------------------------------------------------\n\\begin{tikzpicture}[x=1mm,y=1mm]\n\\def\\breite{185}\n\\def\\hoehe{275}\n\n% Koordinaten:\n% ------------\n\\coordinate (lu) at (0,0);\n\\coordinate (ru) at (\\breite,0);\n\\coordinate (lo) at (0,\\hoehe);\n\\coordinate (ro) at (\\breite,\\hoehe);\n\\coordinate (l1) at (0,6);\n\\coordinate (l2) at (0,18);\n\\coordinate (l3) at (0,57);\n\\coordinate (l4) at ($(l3)+(0,12.5)$);\n\\coordinate (l5) at ($(l3)+(0,20)$);\n\\coordinate (l6) at ($(l5)+(0,12.5)$);\n\\coordinate (l7) at ($(l5)+(0,20)$);\n\\coordinate (l8) at ($(l7)+(0,7.5)$);\n\\coordinate (l9) at ($(l8)+(0,7.5)$);\n\\coordinate (a7) at ($(l7)+0.167*(\\breite,0)$);\n\\coordinate (b7) at ($(l7)+0.333*(\\breite,0)$);\n\\coordinate (c7) at ($(l7)+0.5*(\\breite,0)$);\n\\coordinate (d7) at ($(l7)+0.667*(\\breite,0)$);\n\\coordinate (e7) at ($(l7)+0.833*(\\breite,0)$);\n\\coordinate (a3) at ($(l3)+(54,0)$);\n\\coordinate (l15) at ($(lo)-(0,15)$);\n\\coordinate (l14) at ($(l15)-(0,6)$);\n\\coordinate (l13) at ($(l14)-(0,7.5)$);\n\\coordinate (l12) at ($(l13)-(0,7.5)$);\n\\coordinate (l11) at ($(l12)-(0,7.5)$);\n\\coordinate (l10) at ($(l11)-(0,12)$);\n\\coordinate (a15) at ($(l15)+(36,0)$);\n\\coordinate (d15) at ($(l15)+(\\breite,0)-(30,0)$);\n\\coordinate (e15) at ($(l15)+(\\breite,0)-(15,0)$);\n\\coordinate (b15) at ($(l15)!0.333!(e15)$);\n\\coordinate (c15) at ($(l15)!0.667!(e15)$);\n\\coordinate (b11) at (l11-|b15);\n\\coordinate (c11) at (l11-|c15);\n\\coordinate (e11) at (l11-|e15);\n\\coordinate (l111) at ($(l11)!0.167!(b11)$);\n\\coordinate (l112) at ($(l11)!0.333!(b11)$);\n\\coordinate (l113) at ($(l11)!0.5!(b11)$);\n\\coordinate (l114) at ($(l11)!0.667!(b11)$);\n\\coordinate (l115) at ($(l11)!0.833!(b11)$);\n\n% Linien:\n% -------\n\\fill [grau] (l14) rectangle (e15) (l12-|b11) rectangle (l13-|c11)\n             (l8) rectangle (ru|-l9) (l6) rectangle (ru|-l7);\n\\draw [w3] (lu) rectangle (ro);\n\\draw [w2] (l15)--+(\\breite,0) (l11)--+(\\breite,0) (a15)--(a15|-lo)\n           (d15)--(d15|-lo) (b11)--(b15) (c11)--(c15);\n\\draw [w1] (e11)--(e15) (l14)--(l14-|e15) (l13-|b15)--(l13-|e15)\n           (l12)--(l12-|e15) (l10)--+(\\breite,0) (l111)--(l111|-l12)\n           (l112)--(l112|-l12) (l113)--(l113|-l12) (l114)--(l114|-l12)\n           (l115)--(l115|-l12);\n\\draw [w2] (l2)--+(\\breite,0) (l7)--+(\\breite,0) (l9)--+(\\breite,0)\n           (e7)--(e7|-l2) (l3)--(l3-|e7) (l5)--(l5-|e7);\n\\draw [w1] (l8)--+(\\breite,0) (l6)--+(\\breite,0) (l4)--+(\\breite,0)\n           (l3-|e7)--(l3-|ru) (a3)--(a3|-l4) (a7)--(a7|-l8) (b7)--(b7|-l8)\n           (c7)--(c7|-l8) (d7)--(d7|-l8) (e7)--(e7|-l8) (l1)--+(\\breite,0);\n\n% HTL-Logo:\n% ---------\n\\begin{scope}[yshift=-10.5mm,xshift=-13mm,y=0.12pt,x=0.12pt]\n\\path[fill=black,nonzero rule] (430.6450,6465.1800) -- (430.6450,6465.1800) -- (429.8400,6461.1600) -- (429.0310,6457.1400)\n-- (428.2270,6453.9300) -- (425.8090,6451.5200) -- (424.1990,6449.1000) -- (420.9770,6447.5000) -- (418.5630,6446.6900)\n-- (411.3130,6446.6900) -- (406.4800,6449.1000) -- (406.4800,6446.6900) -- (396.0080,6446.6900) -- (396.0080,6495.7200)\n-- (406.4800,6495.7200) -- (406.4800,6478.8400) -- (412.1170,6482.0500) -- (414.5350,6482.8600) -- (417.7580,6483.6600)\n-- (420.1720,6482.8600) -- (423.3950,6482.0500) -- (425.0080,6480.4500) -- (427.4220,6478.8400) -- (428.2270,6475.6300)\n-- (429.8400,6472.4100) -- (430.6450,6465.1800) -- cycle(419.3670,6465.1800) -- (419.3670,6465.1800) -- (418.5630,6469.2000)\n-- (417.7580,6472.4100) -- (415.3400,6474.0200) -- (412.9260,6474.8200) -- (409.7030,6474.0200) -- (406.4800,6473.2100)\n-- (406.4800,6454.7300) -- (414.5350,6454.7300) -- (416.9490,6457.1400) -- (418.5630,6460.3600) -- (419.3670,6465.1800);\n\\path[fill=black,nonzero rule] (450.7810,6487.6800) -- (439.5040,6487.6800) -- (439.5040,6495.7200) -- (450.7810,6495.7200)\n-- (450.7810,6487.6800) -- cycle(450.7810,6446.6900) -- (439.5040,6446.6900) -- (439.5040,6482.0500) -- (450.7810,6482.0500);\n\\path[fill=black,nonzero rule] (462.0550,6446.6900) -- (473.3323,6446.6900) -- (473.3323,6495.7173) -- (462.0550,6495.7173)\n-- (462.0550,6446.6900) -- cycle;\n\\path[fill=black,nonzero rule] (516.8280,6446.6900) -- (505.5510,6446.6900) -- (505.5510,6450.7100) -- (503.1330,6449.1000)\n-- (500.7190,6447.5000) -- (498.3050,6445.8900) -- (492.6640,6445.8900) -- (489.4450,6447.5000) -- (487.8320,6449.1000)\n-- (485.4140,6450.7100) -- (483.8050,6453.9300) -- (483.0000,6457.1400) -- (482.1950,6460.3600) -- (482.1950,6468.3900)\n-- (483.0000,6472.4100) -- (484.6090,6475.6300) -- (486.2190,6478.0400) -- (488.6370,6480.4500) -- (491.0550,6482.0500)\n-- (494.2730,6482.8600) -- (496.6910,6483.6600) -- (501.5230,6482.8600) -- (505.5510,6481.2500) -- (505.5510,6495.7200)\n-- (516.8280,6495.7200) -- (516.8280,6446.6900) -- cycle(505.5510,6456.3400) -- (505.5510,6474.0200) -- (503.9410,6474.8200)\n-- (497.4960,6474.8200) -- (495.0820,6472.4100) -- (493.4690,6469.2000) -- (493.4690,6459.5500) -- (495.0820,6457.1400)\n-- (496.6910,6454.7300) -- (503.1330,6454.7300) -- (505.5510,6456.3400);\n\\path[fill=black,nonzero rule] (561.1290,6446.6900) -- (549.8520,6446.6900) -- (549.8520,6450.7100) -- (545.0200,6447.5000)\n-- (542.6020,6445.8900) -- (539.3790,6445.8900) -- (534.5470,6446.6900) -- (532.9380,6447.5000) -- (531.3280,6449.1000)\n-- (529.7150,6450.7100) -- (528.9100,6453.1200) -- (528.1050,6459.5500) -- (528.1050,6482.0500) -- (539.3790,6482.0500)\n-- (539.3790,6460.3600) -- (540.1880,6457.1400) -- (541.7970,6455.5300) -- (544.2150,6454.7300) -- (547.4340,6455.5300)\n-- (549.8520,6457.1400) -- (549.8520,6482.0500) -- (561.1290,6482.0500);\n\\path[fill=black,nonzero rule] (606.2340,6446.6900) -- (594.9570,6446.6900) -- (594.9570,6469.2000) -- (594.1520,6471.6100)\n-- (592.5430,6474.0200) -- (586.9020,6474.0200) -- (583.6800,6472.4100) -- (583.6800,6446.6900) -- (572.4060,6446.6900)\n-- (572.4060,6482.0500) -- (583.6800,6482.0500) -- (583.6800,6478.8400) -- (589.3160,6482.0500) -- (591.7340,6482.8600)\n-- (594.9570,6483.6600) -- (599.7890,6482.8600) -- (601.4020,6481.2500) -- (603.0120,6479.6400) -- (604.6210,6478.0400)\n-- (605.4300,6475.6300) -- (606.2340,6470.0000);\n\\path[fill=black,nonzero rule] (648.9220,6450.7100) -- (648.9220,6446.6900) -- (648.1170,6442.6700) -- (646.5040,6439.4600)\n-- (644.0900,6437.0500) -- (641.6720,6435.4400) -- (638.4530,6434.6400) -- (630.3980,6433.8300) -- (623.9570,6433.8300)\n-- (618.3160,6435.4400) -- (618.3160,6444.2800) -- (619.9260,6444.2800) -- (621.5390,6443.4800) -- (623.9570,6442.6700)\n-- (626.3670,6441.8700) -- (628.7850,6441.8700) -- (633.6170,6442.6700) -- (636.8440,6444.2800) -- (637.6450,6446.6900)\n-- (638.4530,6450.7100) -- (638.4530,6451.5200) -- (633.6170,6448.3000) -- (631.2030,6447.5000) -- (625.5660,6447.5000)\n-- (623.1480,6448.3000) -- (620.7300,6449.9100) -- (618.3160,6452.3200) -- (616.7070,6454.7300) -- (615.8980,6457.9500)\n-- (615.0940,6461.1600) -- (614.2890,6465.9800) -- (615.0940,6469.2000) -- (615.8980,6473.2100) -- (616.7070,6476.4300)\n-- (619.1210,6478.8400) -- (620.7300,6480.4500) -- (623.9570,6482.0500) -- (626.3670,6482.8600) -- (629.5940,6483.6600)\n-- (634.4260,6482.8600) -- (638.4530,6480.4500) -- (638.4530,6482.0500) -- (648.9220,6482.0500) -- (648.9220,6450.7100)\n-- cycle(638.4530,6457.9500) -- (638.4530,6474.0200) -- (636.0350,6474.8200) -- (630.3980,6474.8200) -- (627.9800,6472.4100)\n-- (626.3670,6469.2000) -- (625.5660,6465.1800) -- (626.3670,6461.1600) -- (627.1760,6458.7500) -- (629.5940,6456.3400)\n-- (635.2300,6456.3400) -- (638.4530,6457.9500);\n\\path[fill=black,nonzero rule] (725.4450,6446.6900) -- (725.4450,6469.2000) -- (724.6450,6472.4100) -- (723.0350,6474.0200)\n-- (718.1840,6474.0200) -- (714.9690,6472.4100) -- (714.9690,6446.6900) -- (703.6910,6446.6900) -- (703.6910,6472.4100)\n-- (702.0820,6474.0200) -- (698.8630,6474.0200) -- (696.4450,6473.2100) -- (694.0310,6472.4100) -- (694.0310,6446.6900)\n-- (682.7540,6446.6900) -- (682.7540,6482.0500) -- (694.0310,6482.0500) -- (694.0310,6478.8400) -- (698.8630,6482.0500)\n-- (701.2770,6482.8600) -- (704.5000,6483.6600) -- (707.7190,6482.8600) -- (710.1370,6482.0500) -- (712.5550,6479.6400)\n-- (714.1680,6477.2300) -- (719.7890,6482.0500) -- (723.0350,6482.8600) -- (725.4450,6483.6600) -- (730.2660,6482.8600)\n-- (731.8750,6481.2500) -- (733.4800,6480.4500) -- (735.9220,6476.4300) -- (735.9220,6446.6900);\n\\path[fill=black,nonzero rule] (759.2850,6487.6800) -- (747.2030,6487.6800) -- (747.2030,6495.7200) -- (759.2850,6495.7200)\n-- (759.2850,6487.6800) -- cycle(758.4490,6446.6900) -- (747.2030,6446.6900) -- (747.2030,6482.0500) -- (758.4490,6482.0500);\n\\path[fill=black,nonzero rule] (783.4220,6446.6900) -- (777.7970,6446.6900) -- (775.3870,6447.5000) -- (773.7810,6449.1000)\n-- (772.1720,6450.7100) -- (771.3400,6452.3200) -- (770.5350,6457.9500) -- (770.5350,6474.8200) -- (766.5160,6474.8200)\n-- (766.5160,6482.0500) -- (770.5350,6482.0500) -- (770.5350,6492.5000) -- (781.8160,6492.5000) -- (781.8160,6482.0500)\n-- (792.2930,6482.0500) -- (792.2930,6474.8200) -- (781.8160,6474.8200) -- (781.8160,6458.7500) -- (782.6170,6456.3400)\n-- (784.2270,6454.7300) -- (787.4690,6453.9300) -- (789.0780,6453.9300) -- (791.4880,6454.7300) -- (792.2930,6454.7300)\n-- (792.2930,6447.5000) -- (788.2730,6446.6900) -- (783.4220,6446.6900);\n\\path[fill=black,nonzero rule] (850.3010,6446.6900) -- (819.6720,6446.6900) -- (819.6720,6453.9300) -- (836.6090,6474.0200)\n-- (820.4770,6474.0200) -- (820.4770,6482.0500) -- (850.3010,6482.0500) -- (850.3010,6474.8200) -- (832.5590,6455.5300)\n-- (850.3010,6455.5300);\n\\path[fill=black,nonzero rule] (892.1760,6446.6900) -- (880.8910,6446.6900) -- (880.8910,6450.7100) -- (875.2660,6447.5000)\n-- (872.8240,6445.8900) -- (869.6090,6445.8900) -- (864.7930,6446.6900) -- (863.1840,6447.5000) -- (861.5740,6449.1000)\n-- (860.7420,6450.7100) -- (859.1330,6453.1200) -- (858.3320,6459.5500) -- (858.3320,6482.0500) -- (869.6090,6482.0500)\n-- (869.6090,6460.3600) -- (870.4180,6457.1400) -- (872.0230,6455.5300) -- (875.2660,6454.7300) -- (877.6760,6455.5300)\n-- (880.8910,6457.1400) -- (880.8910,6482.0500) -- (892.1760,6482.0500);\n\\path[fill=black,nonzero rule] (938.8980,6446.6900) -- (925.2070,6446.6900) -- (916.3400,6461.9600) -- (914.7340,6460.3600)\n-- (914.7340,6446.6900) -- (903.4490,6446.6900) -- (903.4490,6495.7200) -- (914.7340,6495.7200) -- (914.7340,6468.3900)\n-- (925.2070,6482.0500) -- (938.0980,6482.0500) -- (925.2070,6466.7900);\n\\path[fill=black,nonzero rule] (978.3670,6446.6900) -- (967.0820,6446.6900) -- (967.0820,6450.7100) -- (962.2340,6447.5000)\n-- (959.0160,6445.8900) -- (956.6090,6445.8900) -- (951.7810,6446.6900) -- (949.3400,6447.5000) -- (947.7340,6449.1000)\n-- (946.9340,6450.7100) -- (946.1330,6453.1200) -- (945.3240,6459.5500) -- (945.3240,6482.0500) -- (955.8010,6482.0500)\n-- (955.8010,6464.3800) -- (956.6090,6460.3600) -- (956.6090,6457.1400) -- (958.2150,6455.5300) -- (961.4260,6454.7300)\n-- (963.8670,6455.5300) -- (967.0820,6457.1400) -- (967.0820,6482.0500) -- (978.3670,6482.0500);\n\\path[fill=black,nonzero rule] (1022.6500,6446.6900) -- (1012.1800,6446.6900) -- (1012.1800,6464.3800) -- (1011.3700,6469.2000)\n-- (1011.3700,6471.6100) -- (1009.7600,6474.0200) -- (1004.1300,6474.0200) -- (1000.9300,6472.4100) -- (1000.9300,6446.6900)\n-- (989.6410,6446.6900) -- (989.6410,6482.0500) -- (1000.9300,6482.0500) -- (1000.9300,6478.8400) -- (1005.7400,6482.0500)\n-- (1008.9600,6482.8600) -- (1012.1800,6483.6600) -- (1016.2100,6482.8600) -- (1018.6300,6481.2500) -- (1020.2400,6479.6400)\n-- (1021.0400,6478.0400) -- (1021.8400,6475.6300) -- (1022.6500,6470.0000);\n\\path[fill=black,nonzero rule] (1056.4900,6487.6800) -- (1054.0700,6487.6800) -- (1051.6700,6488.4800) -- (1048.4300,6487.6800)\n-- (1046.8200,6486.8800) -- (1046.0100,6485.2700) -- (1046.0100,6482.0500) -- (1054.0700,6482.0500) -- (1054.0700,6474.8200)\n-- (1046.0100,6474.8200) -- (1046.0100,6446.6900) -- (1034.7300,6446.6900) -- (1034.7300,6474.8200) -- (1030.7100,6474.8200)\n-- (1030.7100,6482.0500) -- (1034.7300,6482.0500) -- (1034.7300,6482.8600) -- (1035.5300,6489.2900) -- (1037.1400,6490.8900)\n-- (1038.7800,6493.3100) -- (1040.3800,6494.1100) -- (1042.8000,6495.7200) -- (1048.4300,6496.5200) -- (1053.2700,6495.7200)\n-- (1056.4900,6495.7200);\n\\path[fill=black,nonzero rule] (1075.8000,6446.6900) -- (1069.3800,6446.6900) -- (1067.7700,6447.5000) -- (1065.3600,6449.1000)\n-- (1064.5500,6450.7100) -- (1063.7100,6452.3200) -- (1062.9200,6457.9500) -- (1062.9200,6474.8200) -- (1058.0900,6474.8200)\n-- (1058.0900,6482.0500) -- (1062.9200,6482.0500) -- (1062.9200,6492.5000) -- (1073.3900,6492.5000) -- (1073.3900,6482.0500)\n-- (1083.8700,6482.0500) -- (1083.8700,6474.8200) -- (1073.3900,6474.8200) -- (1073.3900,6458.7500) -- (1074.1900,6456.3400)\n-- (1075.8000,6454.7300) -- (1079.0500,6453.9300) -- (1081.4600,6453.9300) -- (1083.0700,6454.7300) -- (1083.8700,6454.7300)\n-- (1083.8700,6447.5000) -- (1080.6600,6446.6900) -- (1075.8000,6446.6900);\n\\path[fill=colx,nonzero rule] (781.0120,6562.0200) -- (1073.3900,6562.0200) .. controls (1082.0700,6562.0200) and (1089.1100,6555.0100)\n.. (1089.1100,6546.3500) .. controls (1089.1100,6537.7000) and (1082.0700,6530.6800) .. (1073.3900,6530.6800) -- (781.0120,6530.6800)\n.. controls (772.3320,6530.6800) and (765.2970,6537.7000) .. (765.2970,6546.3500) .. controls (765.2970,6555.0100) and (772.3320,6562.0200)\n.. (781.0120,6562.0200);\n\\path[fill=colx,nonzero rule] (816.4570,6603.4100) -- (1065.3600,6603.4100) .. controls (1072.4600,6603.4100) and (1078.2400,6597.6600)\n.. (1078.2400,6590.5500) .. controls (1078.2400,6583.4500) and (1072.4600,6577.7000) .. (1065.3600,6577.7000) -- (816.4570,6577.7000)\n.. controls (809.3550,6577.7000) and (803.5700,6583.4500) .. (803.5700,6590.5500) .. controls (803.5700,6597.6600) and (809.3550,6603.4100)\n.. (816.4570,6603.4100);\n\\path[fill=colx,nonzero rule] (853.5080,6639.5800) -- (1067.7700,6639.5800) .. controls (1073.5500,6639.5800) and (1078.2400,6634.9000)\n.. (1078.2400,6629.1300) .. controls (1078.2400,6623.3600) and (1073.5500,6618.6800) .. (1067.7700,6618.6800) -- (853.5080,6618.6800)\n.. controls (847.7230,6618.6800) and (843.0310,6623.3600) .. (843.0310,6629.1300) .. controls (843.0310,6634.9000) and (847.7230,6639.5800)\n.. (853.5080,6639.5800);\n\\path[fill=colx,nonzero rule] (896.1910,6668.5200) -- (1079.8500,6668.5200) .. controls (1083.8300,6668.5200) and (1087.0800,6665.2800)\n.. (1087.0800,6661.2900) .. controls (1087.0800,6657.2900) and (1083.8300,6654.0500) .. (1079.8500,6654.0500) -- (896.1910,6654.0500)\n.. controls (892.2070,6654.0500) and (888.9570,6657.2900) .. (888.9570,6661.2900) .. controls (888.9570,6665.2800) and (892.2070,6668.5200)\n.. (896.1910,6668.5200);\n\\path[fill=colx,nonzero rule] (934.0510,6693.8300) -- (1093.5400,6693.8300) .. controls (1096.8800,6693.8300) and (1099.5800,6691.1300)\n.. (1099.5800,6687.8000) .. controls (1099.5800,6684.4800) and (1096.8800,6681.7800) .. (1093.5400,6681.7800) -- (934.0510,6681.7800)\n.. controls (930.7070,6681.7800) and (928.0080,6684.4800) .. (928.0080,6687.8000) .. controls (928.0080,6691.1300) and (930.7070,6693.8300)\n.. (934.0510,6693.8300);\n\\path[fill=black,nonzero rule] (393.5940,6527.8700) -- (393.5940,6736.8300) -- (452.3910,6736.8300) -- (452.3910,6670.1300)\n-- (459.6410,6674.1400) -- (467.6910,6678.1600) -- (474.9410,6679.7700) -- (483.8050,6680.5700) -- (493.4690,6679.7700)\n-- (503.1330,6677.3600) -- (507.9690,6675.7500) -- (511.9920,6673.3400) -- (516.8280,6670.1300) -- (520.0510,6666.9100)\n-- (524.0780,6662.8900) -- (527.2970,6658.0700) -- (530.5200,6653.2400) -- (532.9380,6647.6200) -- (534.5470,6641.1900)\n-- (536.1560,6633.9600) -- (536.9650,6625.9200) -- (536.9650,6527.8700) -- (477.3590,6527.8700) -- (477.3590,6608.2300)\n-- (476.5550,6616.2700) -- (475.7500,6619.4900) -- (474.1410,6622.7000) -- (472.5270,6624.3100) -- (470.9180,6625.9200)\n-- (467.6910,6626.7200) -- (465.2810,6627.5300) -- (462.0550,6626.7200) -- (459.6410,6625.9200) -- (458.0310,6624.3100)\n-- (455.6130,6622.7000) -- (454.8050,6619.4900) -- (454.0040,6616.2700) -- (453.1950,6608.2300) -- (453.1950,6527.8700);\n\\path[fill=black,nonzero rule] (641.6720,6625.9200) -- (609.4570,6625.9200) -- (609.4570,6592.9700) -- (610.2620,6588.9500)\n-- (611.8710,6584.9300) -- (613.4800,6581.7100) -- (616.7070,6580.1100) -- (619.9260,6578.5000) -- (623.9570,6577.7000)\n-- (641.6720,6577.7000) -- (641.6720,6527.8700) -- (605.4300,6527.8700) -- (593.3440,6529.4800) -- (587.7070,6530.2800)\n-- (582.8750,6531.8800) -- (578.0430,6533.4900) -- (573.2110,6535.9000) -- (569.1800,6539.1200) -- (565.1560,6542.3300)\n-- (561.9340,6546.3500) -- (558.7110,6551.1800) -- (556.2930,6556.0000) -- (553.8790,6561.6300) -- (552.2700,6567.2500)\n-- (550.6560,6574.4800) -- (549.8520,6581.7100) -- (549.8520,6736.8300) -- (609.4570,6736.8300) -- (609.4570,6677.3600)\n-- (641.6720,6677.3600);\n\\path[fill=black,nonzero rule] (661.8090,6527.8700) -- (721.4145,6527.8700) -- (721.4145,6736.8350) -- (661.8090,6736.8350)\n-- (661.8090,6527.8700) -- cycle;\n\\end{scope}\n\n% Beschriftung:\n% -------------\n\\node [yshift=2.0mm] at ($(a15)!0.5!(d15|-lo)$) {\\fontbigbold\\vphantom{(}\\schule};\n\\node [yshift=-3.0mm] at ($(a15)!0.5!(d15|-lo)$) {\\fontbigbold\\vphantom{(}Reife- und Diplompr\\\"ufung};\n\\node at ($(l14)!0.5!(b15)$) {\\fontsmall\\vphantom{(}Pr\\\"ufungsgebiet};\n\\node at ($(b11|-l12)!0.5!(c11|-l13)$) {\\fontsmall\\vphantom{(}Beisitzer/in bzw.~2.~Pr\\\"ufer/in};\n\\node at ($(b15)!0.5!(c15|-l14)$) {\\fontsmall\\vphantom{(}Pr\\\"ufer/in};\n\\node at ($(c15)!0.5!(e15|-l14)$) {\\fontsmall\\vphantom{(}Kandidat/Kandidatin};\n\\node [right] at ($(l13-|c11)!0.5!(l12-|c11)$) {\\fontsmall\\vphantom{(}Jahrgang};\n\\node [right] at ($(l12-|c11)!0.5!(l11-|c11)$) {\\fontsmall\\vphantom{(}Datum};\n\\node [below right] at (d15|-lo) {\\fontsmall\\vphantom{(}Pr\\\"ufung Nr.};\n\\node at ($(l12)!0.5!(l111)$) {\\fontsmall\\vphantom{(}D$^{\\hbox{\\fonttiny 1)}}$};\n\\node at ($(l111)!0.5!(l112|-l12)$) {\\fontsmall\\vphantom{(}E$^{\\hbox{\\fonttiny 1)}}$};\n\\node at ($(l112)!0.5!(l113|-l12)$) {\\fontsmall\\vphantom{(}SF$^{\\hbox{\\fonttiny 1)}}$};\n\\node at ($(l113)!0.5!(l114|-l12)$) {\\fontsmall\\vphantom{(}WF$^{\\hbox{\\fonttiny 1)}}$};\n\\node at ($(l114)!0.5!(l115|-l12)$) {\\fontsmall\\vphantom{(}KP$^{\\hbox{\\fonttiny 1)}}$};\n\\node at ($(l115)!0.5!(b11|-l12)$) {\\fontsmall\\vphantom{(}LFS$^{\\hbox{\\fonttiny 1)}}$};\n\\node [below] at ($(e15)!0.5!(e15-|ro)$) {\\fontsmall\\vphantom{(}Termin$^{\\hbox{\\fonttiny 2)}}$};\n\\node [below,yshift=-6mm] at ($(e15)!0.5!(e15-|ro)$) {\\fontsmall 1~(H)};\n\\node [below,yshift=-11mm] at ($(e15)!0.5!(e15-|ro)$) {\\fontsmall 2~(W)};\n\\node [below,yshift=-16mm] at ($(e15)!0.5!(e15-|ro)$) {\\fontsmall 3~(W)};\n\\node [below,yshift=-21mm] at ($(e15)!0.5!(e15-|ro)$) {\\fontsmall 4~(W)};\n\\node [below right] at (l11) {\\fontnormal Themenbereich};\n\\node [below right] at (l10) {\\fontnormal Aufgabenstellung};\n\\node at ($(l8)!0.5!(l9-|ru)$) {\\fontnormal\\vphantom{(}Vorbereitungs- und Pr\\\"ufungszeiten};\n\\node at ($(l7)!0.5!(l8-|a7)$) {\\fontverysmall\\vphantom{(}Beginn der Vorbereitung};\n\\node at ($(l7-|b7)!0.5!(l8-|c7)$) {\\fontverysmall\\vphantom{(}Beginn der Pr\\\"ufung};\n\\node at ($(l7-|d7)!0.5!(l8-|e7)$) {\\fontverysmall\\vphantom{(}Ende der Pr\\\"ufung};\n\\node at ($(l6-|ru)!0.5!(e7)$) {\\fontsmall\\vphantom{(}Unterschriften};\n\\node at ($(l6)!0.5!(e7)$) {\\fontbold\\vphantom{(}Beurteilung};\n\\node [right,yshift=3mm] at ($(l1)!0.5!(l2)$) {\\fonttiny\\vphantom{(}1)\n      Zutreffendes ankreuzen! D -- Deutsch, E -- Englisch,\n      SF -- Schwerpunktfach, WF -- Wahlfach, KP -- Kompensationspr\\\"ufung,\n      LFS -- Fachpr\\\"ufung in lebender Fremdsprache abgelegt};\n\\node [right] at ($(l1)!0.5!(l2)$) {\\fonttiny\\vphantom{(}2) Angabe des Termins\n      bezogen auf die Kandidatin/den Kandidaten: 1~(H)\\dots\\ Haupttermin,\n      2~(W), 3~(W), 4~(W) \\dots\\ Wiederholungstermine --- Zutreffendes ankreuzen!};\n\\node [right,yshift=-3mm] at ($(l1)!0.5!(l2)$) {\\fonttiny\\vphantom{(}F\\\"ur eine\n      Beurteilung mit \\glqq Nicht gen\\\"ugend\\grqq\\ ist die Begr\\\"undung auch\n      im Pr\\\"ufungskatalog einzutragen!};\n\\node [right] at ($(lu)!0.5!(l1)$) {\\fontsmall\\vphantom{(}Dokumentversion: Letto (\\LaTeX)};\n\\node [below right] at (l3) {\\fontsmall Anmerkungen/Begr\\\"undungen};\n\\node [below right] at (l6-|e7) {\\fontsmall Pr\\\"ufer/Pr\\\"uferin};\n\\node [below right] at (l3-|e7) {\\fontsmall Vorsitzende/r};\n\\node [below right] at (l4) {\\fontsmall M\\\"undliche Pr\\\"ufung};\n\\node [below right] at (l4-|a3) {\\fontsmall Gesamtbeurteilung der Klausurpr\\\"ufung};\n\\node [below right] at (l4-|e7) {\\fontsmall Beisitzende/r};\n\\node [below right] at (l6) {\\fontsmall Beurteilungsantrag (in Worten)};\n\\node at ($(l4)!0.5!(l5-|e7)$) {\\fontsmall\\vphantom{(} Beurteilungsantrag -- Kompensationspr\\\"ufung};\n\n% Ausfuellen:\n% -----------\n\\node at ($(l14)!0.5!(l12-|b15)$) {\\fontbold\\vphantom{(}\\pruefungsgebiet};\n\\node at ($(l14-|b15)!0.5!(l13-|c15)$) {\\fontbold\\vphantom{(}\\pruefer};\n\\node at ($(l12-|b15)!0.5!(l11-|c15)$) {\\fontbold\\vphantom{(}\\beisitzer};\n% \\node at ($(l14-|c15)!0.5!(l13-|e15)$) {\\fontbold\\vphantom{(}\\kandidat};\n\\node at ($(l13-|c15)!0.5!(l12-|e15)$) {\\fontbold\\vphantom{(}\\jahrgang};\n\\node at ($(l12-|c15)!0.5!(l11-|e15)$) {\\fontbold\\vphantom{(}\\datum};\n\\node at ($(l10)!0.5!(l11-|ro)$) {\\fontbold\\vphantom{(}\\themenbereich};\n\\ifx\\kategorie\\katD\\draw [w1] ($(l12)!0.5!(l111)$)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifx\\kategorie\\katE\\draw [w1] ($(l111)!0.5!(l112|-l12)$)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifx\\kategorie\\katSF\\draw [w1] ($(l112)!0.5!(l113|-l12)$)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifx\\kategorie\\katWF\\draw [w1] ($(l113)!0.5!(l114|-l12)$)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifx\\kategorie\\katKP\\draw [w1] ($(l114)!0.5!(l115|-l12)$)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifx\\kategorie\\katLFS\\draw [w1] ($(l115)!0.5!(b11|-l12)$) ++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifnum\\termin=1\\draw [w1] ($(e15)!0.5!(e15-|ro)$)++(0,-8.5)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifnum\\termin=2\\draw [w1] ($(e15)!0.5!(e15-|ro)$)++(0,-13.5)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifnum\\termin=3\\draw [w1] ($(e15)!0.5!(e15-|ro)$)++(0,-18.5)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\ifnum\\termin=4\\draw [w1] ($(e15)!0.5!(e15-|ro)$)++(0,-23.5)++(-3,-2)--++(6,4)++(0,-4)--++(-6,4);\\fi\n\\node [below right] at ($(l10)+(5mm,-8mm)$) {\\parbox{170mm}{#1}};\n\\end{tikzpicture}}\n% ------------------------------------------------------------------------\n\n\n%--------------------------------------------------------------------------------------------------------------------------------------------------\n% ------------------------------- HAA.sty\n%--------------------------------------------------------------------------------------------------------------------------------------------------\n\n% ---------------------------------------------------------------------------\n% Tabulatoraehnliche Umgebung (aus KOMA)                             1.7.1996\n% ---------------------------------------------------------------------------\n\\newenvironment{tabulator}[2][]\n               {\\def\\sc@septext{#1}\n                \\list{}{\\settowidth{\\labelwidth}{#2#1}\n                        \\leftmargin\\labelwidth \\advance\\leftmargin by \\labelsep\n                        \\let\\makelabel\\tabulatorlabel}}\n               {\\endlist}\n\\newenvironment{Zerotabulator}[2][]\n               {\\def\\sc@septext{#1}\n                \\list{}{\\topsep0pt\\itemsep0pt\\parsep0pt\\settowidth{\\labelwidth}{#2#1}\n                        \\leftmargin\\labelwidth \\advance\\leftmargin by \\labelsep\n                        \\let\\makelabel\\tabulatorlabel}}\n               {\\endlist}\n\\newcommand\\tabulatorlabel[1]{#1\\hfil\\sc@septext}\n\n% ---------------------------------------------------------------------------\n% Zentriert hervorheben                                             30.6.1996\n% ---------------------------------------------------------------------------\n\\def\\Emph#1{\\par\\medskip\\centerline{\\large\\bfseries#1}}\n\n% ---------------------------------------------------------------------------\n% Description Umgebung ohne Leerraum zwischen den Items              3.3.1996\n% ---------------------------------------------------------------------------\n\\makeatletter\n\\newenvironment{zerodescription}\n   {\\list{}{\\topsep0pt\\itemsep0pt\\topsep0pt\\parsep0pt\\labelwidth\\z@%\n   \\itemindent-\\leftmargin\\let\\makelabel\\descriptionlabel}}{\\endlist}\n\\newenvironment{Zerodescription}\n   {\\list{}{\\topsep0pt\\itemsep0pt\\parsep0pt\\labelwidth\\z@%\n   \\itemindent-\\leftmargin\\let\\makelabel\\descriptionlabel}}{\\endlist}\n\\makeatother\n\n% ---------------------------------------------------------------------------\n% Enumerate Umgebung ohne Leerraum zwischen den Items                3.3.1996\n% ---------------------------------------------------------------------------\n\\makeatletter\n\\newenvironment{zeroenumerate}\n   {\\begin{list}{\\arabic{enumi}.}{\\usecounter{enumi}\\parsep0pt\\topsep0pt\\itemsep0pt}}\n   {\\end{list}}\n\\newenvironment{Zeroenumerate}\n   {\\begin{list}{\\arabic{enumi}.}{\\usecounter{enumi}\\parsep0pt\\itemsep0pt}}\n   {\\end{list}}\n\\makeatother\n\n% ---------------------------------------------------------------------------\n% Itemize Umgebung ohne Leerraum zwischen den Items                 27.6.1996\n% ---------------------------------------------------------------------------\n\\makeatletter\n\\newenvironment{zeroitemize}\n   {\\begin{list}{$\\bullet$}{\\parsep0pt\\topsep0pt\\itemsep0pt}}\n   {\\end{list}}\n\\newenvironment{Zeroitemize}\n   {\\begin{list}{$\\bullet$}{\\parsep0pt\\itemsep0pt}}\n   {\\end{list}}\n\\makeatother\n\n% ---------------------------------------------------------------------------\n% Markierung mit kleinen Boxen                                     30.12.1995\n% ---------------------------------------------------------------------------\n\\def\\xbbox{{\\setbox0\\hbox{x}\\rule{\\ht0}{\\ht0}}}\n\\def\\Xbbox{{\\setbox0\\hbox{X}\\rule{\\ht0}{\\ht0}}}\n\\def\\xwbox{{\\fboxsep0pt\\setbox0\\hbox{x}\\dimen0\\ht0\\advance\n    \\dimen0by2\\fboxrule\\framebox[\\dimen0]{\\phantom x}}}\n\\def\\Xwbox{{\\fboxsep0pt\\setbox0\\hbox{X}\\dimen0\\ht0\\advance\n    \\dimen0by2\\fboxrule\\framebox[\\dimen0]{\\phantom X}}}\n\\def\\xgbox{{\\fboxsep0pt\\setbox1\\hbox{x}\\dimen1\\ht1\\advance\\dimen1by2\\fboxrule\n    \\leavevmode\\psboxit{box 0.6 setgray fill}{\\framebox[\\dimen1]{\\phantom x}}}}\n\\def\\Xgbox{{\\fboxsep0pt\\setbox1\\hbox{X}\\dimen1\\ht1\\advance\\dimen1by2\\fboxrule\n    \\leavevmode\\psboxit{box 0.6 setgray fill}{\\framebox[\\dimen1]{\\phantom X}}}}\n\n% ---------------------------------------------------------------------------\n% Ueberschrift (dreiteilig: links,Mitte,rechts; mit zwei Querbalken) 7.11.94\n% ---------------------------------------------------------------------------\n\\long\\def\\header#1#2#3{\\par\\hrule\\smallskip{\\large\\bf\n         \\hbox to\\textwidth{\\rlap{#1}\\hfill{#2}\\hfill\\llap{#3}}}\n         \\smallskip\\hrule\\par\\bigskip}\n\n% ---------------------------------------------------------------------------\n% Einbinden von PCX-Bildern:\n% ---------------------------------------------------------------------------\n\\def\\pcxget#1#2#3#4#5{\\hbox to #2{\\hskip#3%   zum Einbinden von PCX-Files\n\\vbox to #4{\\vskip#5\\special{em:graph #1}\\vss}\\hss}}\n\\def\\pcx#1#2#3#4#5%  Einlesen von PCX-Files, HAA,15.10.1993\n{\\parbox{#2}{\\vspace*{#5}\\hskip#3\\special{em:graph #1}%\n\\vspace{-#5}\\vspace{#4}}}\n\\def\\pcxt#1#2#3#4#5%  Einlesen von PCX-Files, HAA,15.10.1993\n{\\parbox[t]{#2}{\\vspace*{#5}\\hskip#3\\special{em:graph #1}%\n\\vspace{-#5}\\vspace{#4}}}\n\\def\\pcxb#1#2#3#4#5%  Einlesen von PCX-Files, HAA,15.10.1993\n{\\parbox[b]{#2}{\\vspace*{#5}\\hskip#3\\special{em:graph #1}%\n\\vspace{-#5}\\vspace{#4}}}\n\n% ---------------------------------------------------------------------------\n% Positionierung von Texten:\n% ---------------------------------------------------------------------------\n\n\\newbox\\insertbox\n\\long\\def\\position#1#2#3{{\\global\\setbox\\insertbox\\hbox{#3}\\unskip%\n\\hskip#2\\makebox[0pt][l]{%\n\\vtop to0pt{\\vskip#1\\vskip-\\ht\\insertbox\\copy\\insertbox\\vss}}%\n\\unskip\\hskip-#2}}%\n\\long\\def\\positionc#1#2#3{{\\global\\setbox\\insertbox\\hbox{#3}\\unskip%\n\\hskip#2\\makebox[0pt][c]{%\n\\vtop to0pt{\\vskip#1\\vskip-\\ht\\insertbox\\copy\\insertbox\\vss}}%\n\\unskip\\hskip-#2}}%\n\\def\\xposition#1#2{\\makebox[0mm][l]{\\hskip#1#2}}\n\n% ---------------------------------------------------------------------------\n% Beschriften von 70x73mm Etiketten\n% ---------------------------------------------------------------------------\n\n\\newdimen\\ypos\\newdimen\\xpos\n\\long\\def\\Label#1#2#3{%\n   \\ypos37.125mm\\multiply\\ypos by#1\\advance\\ypos by -37.125mm\n   \\xpos70.000mm\\multiply\\xpos by#2\\advance\\xpos by -70.000mm\n   \\advance\\ypos by21.00mm\\advance\\xpos by 5mm\n   \\position{\\ypos}{\\xpos}{$\\vcenter{\n   \\begin{minipage}{60mm}#3\\end{minipage}}$}}\n\n% ---------------------------------------------------------------------------\n% Diverse Definitionen:\n% ---------------------------------------------------------------------------\n\n% Schleife als \\long\\def:\n\\long\\def\\LOOP#1\\repeat{\\long\\def\\iterate{#1\\relax\\expandafter\\iterate\\fi}%\n\\iterate\\let\\iterate\\relax}\n\n\\def\\topfraction{1}\n\\def\\bottomfraction{1}\n\\def\\textfraction{0}\n\n\\def\\circled#1{\\bigcirc\\mkern-9mu\\hbox to 0pt{\\footnotesize\\hss#1\\hss}\\mkern9mu}\n\\def\\1{} % macht gar nichts,dient nur zum Einfuegen vom \\index-Befehl\n\\def\\2{} % macht gar nichts,dient nur zum Einfuegen vom \\index-Befehl\n\n\\def\\eq{&\\!\\!\\!\\!=\\!\\!\\!\\!&}\n\\def\\nn{\\nonumber}\n\\def\\MM{\\mbox{}}\n\\def\\LL{{\\cal L}}\n\\def\\unit#1{\\>{\\rm #1}}\n\\def\\formelbox#1{\\fbox{$\\DD{\\VV\\quad#1\\quad}$}}\n\\def\\promille{\\,\\, ^{\\rm o}\\mkern-1\\thinmuskip/_{\\mkern-1\\thinmuskip\\rm oo}}\n\\def\\entspricht{=^{\\mkern-4.8\\thinmuskip^\\wedge}}\n\\def\\eff{_{\\rm eff}}\n\\def\\d{{\\rm d}}\n\\def\\dd{\\,{\\rm d}}\n\\def\\VERT{\\mathclose{\\,\\V{\\int}\\vrule\\,}}\n\n\\def\\bmatrix#1{\\left[\\matrix{#1}\\right]}\n\\def\\UB#1#2{\\mathinner{\\underbrace{#1}_{#2}}}\n\\def\\OB#1#2{\\mathinner{\\overbrace{#1}_{#2}}}\n\n\\def\\UU#1{\\underline{#1}}\n\\def\\UUU#1{\\underline{\\underline{#1}}}\n\\def\\TT#1{{\\textstyle{#1}}}\n\\def\\DD#1{{\\displaystyle{#1}}}\n\\def\\SS#1{{\\scriptstyle{#1}}}\n\\def\\SSS#1{{\\scriptscriptstyle{#1}}}\n\\def\\VV{\\vphantom{{(\\over(}}}\n\\def\\H#1{{\\hphantom{#1}}}\n\\def\\V#1{{\\vphantom{#1}}}\n\n\\def\\N{\\noalign{\\smallskip}}\n\\def\\NN{\\noalign{\\medskip}}\n\\def\\NNN{\\noalign{\\bigskip}}\n\n\\def\\Re{\\mathop{\\rm Re}\\nolimits}\n\\def\\Im{\\mathop{\\rm Im}\\nolimits}\n\\def\\e#1{\\mathinner{\\mathop{\\rm e}^{#1}\\nolimits}}\n\\def\\arg{\\mathop{\\rm arg}\\nolimits}\n\n\\let\\theta=\\vartheta\n\\let\\epsilon=\\varepsilon\n\\let\\phi=\\varphi\n\n\\def\\symboltable{%\n\\begin{tabular}{|c||c|c|c|c|c|c|c|c|c|c|}\n\\hline &$0$&$1$&$2$&$3$&$4$&$5$&$6$&$7$&$8$&$9$ \\\\\\hline\\hline\n$000$&\\symbol{000} &\\symbol{001} &\\symbol{002} &\\symbol{003} &\\symbol{004} &\\symbol{005} &\\symbol{006} &\\symbol{007} &\\symbol{008} &\\symbol{009} \\\\ \\hline\n$010$&\\symbol{010} &\\symbol{011} &\\symbol{012} &\\symbol{013} &\\symbol{014} &\\symbol{015} &\\symbol{016} &\\symbol{017} &\\symbol{018} &\\symbol{019} \\\\ \\hline\n$020$&\\symbol{020} &\\symbol{021} &\\symbol{022} &\\symbol{023} &\\symbol{024} &\\symbol{025} &\\symbol{026} &\\symbol{027} &\\symbol{028} &\\symbol{029} \\\\ \\hline\n$030$&\\symbol{030} &\\symbol{031} &\\symbol{032} &\\symbol{033} &\\symbol{034} &\\symbol{035} &\\symbol{036} &\\symbol{037} &\\symbol{038} &\\symbol{039} \\\\ \\hline\n$040$&\\symbol{040} &\\symbol{041} &\\symbol{042} &\\symbol{043} &\\symbol{044} &\\symbol{045} &\\symbol{046} &\\symbol{047} &\\symbol{048} &\\symbol{049} \\\\ \\hline\n$050$&\\symbol{050} &\\symbol{051} &\\symbol{052} &\\symbol{053} &\\symbol{054} &\\symbol{055} &\\symbol{056} &\\symbol{057} &\\symbol{058} &\\symbol{059} \\\\ \\hline\n$060$&\\symbol{060} &\\symbol{061} &\\symbol{062} &\\symbol{063} &\\symbol{064} &\\symbol{065} &\\symbol{066} &\\symbol{067} &\\symbol{068} &\\symbol{069} \\\\ \\hline\n$070$&\\symbol{070} &\\symbol{071} &\\symbol{072} &\\symbol{073} &\\symbol{074} &\\symbol{075} &\\symbol{076} &\\symbol{077} &\\symbol{078} &\\symbol{079} \\\\ \\hline\n$080$&\\symbol{080} &\\symbol{081} &\\symbol{082} &\\symbol{083} &\\symbol{084} &\\symbol{085} &\\symbol{086} &\\symbol{087} &\\symbol{088} &\\symbol{089} \\\\ \\hline\n$090$&\\symbol{090} &\\symbol{091} &\\symbol{092} &\\symbol{093} &\\symbol{094} &\\symbol{095} &\\symbol{096} &\\symbol{097} &\\symbol{098} &\\symbol{099} \\\\ \\hline\n$100$&\\symbol{100} &\\symbol{101} &\\symbol{102} &\\symbol{103} &\\symbol{104} &\\symbol{105} &\\symbol{106} &\\symbol{107} &\\symbol{108} &\\symbol{109} \\\\ \\hline\n$110$&\\symbol{110} &\\symbol{111} &\\symbol{112} &\\symbol{113} &\\symbol{114} &\\symbol{115} &\\symbol{116} &\\symbol{117} &\\symbol{118} &\\symbol{119} \\\\ \\hline\n$120$&\\symbol{120} &\\symbol{121} &\\symbol{122} &\\symbol{123} &\\symbol{124} &\\symbol{125} &\\symbol{126} &\\symbol{127} &\\symbol{128} &\\symbol{129} \\\\ \\hline\n$130$&\\symbol{130} &\\symbol{131} &\\symbol{132} &\\symbol{133} &\\symbol{134} &\\symbol{135} &\\symbol{136} &\\symbol{137} &\\symbol{138} &\\symbol{139} \\\\ \\hline\n$140$&\\symbol{140} &\\symbol{141} &\\symbol{142} &\\symbol{143} &\\symbol{144} &\\symbol{145} &\\symbol{146} &\\symbol{147} &\\symbol{148} &\\symbol{149} \\\\ \\hline\n$150$&\\symbol{150} &\\symbol{151} &\\symbol{152} &\\symbol{153} &\\symbol{154} &\\symbol{155} &\\symbol{156} &\\symbol{157} &\\symbol{158} &\\symbol{159} \\\\ \\hline\n$160$&\\symbol{160} &\\symbol{161} &\\symbol{162} &\\symbol{163} &\\symbol{164} &\\symbol{165} &\\symbol{166} &\\symbol{167} &\\symbol{168} &\\symbol{169} \\\\ \\hline\n$170$&\\symbol{170} &\\symbol{171} &\\symbol{172} &\\symbol{173} &\\symbol{174} &\\symbol{175} &\\symbol{176} &\\symbol{177} &\\symbol{178} &\\symbol{179} \\\\ \\hline\n$180$&\\symbol{180} &\\symbol{181} &\\symbol{182} &\\symbol{183} &\\symbol{184} &\\symbol{185} &\\symbol{186} &\\symbol{187} &\\symbol{188} &\\symbol{189} \\\\ \\hline\n$190$&\\symbol{190} &\\symbol{191} &\\symbol{192} &\\symbol{193} &\\symbol{194} &\\symbol{195} &\\symbol{196} &\\symbol{197} &\\symbol{198} &\\symbol{199} \\\\ \\hline\n$200$&\\symbol{200} &\\symbol{201} &\\symbol{202} &\\symbol{203} &\\symbol{204} &\\symbol{205} &\\symbol{206} &\\symbol{207} &\\symbol{208} &\\symbol{209} \\\\ \\hline\n$210$&\\symbol{210} &\\symbol{211} &\\symbol{212} &\\symbol{213} &\\symbol{214} &\\symbol{215} &\\symbol{216} &\\symbol{217} &\\symbol{218} &\\symbol{219} \\\\ \\hline\n$220$&\\symbol{220} &\\symbol{221} &\\symbol{222} &\\symbol{223} &\\symbol{224} &\\symbol{225} &\\symbol{226} &\\symbol{227} &\\symbol{228} &\\symbol{229} \\\\ \\hline\n$230$&\\symbol{230} &\\symbol{231} &\\symbol{232} &\\symbol{233} &\\symbol{234} &\\symbol{235} &\\symbol{236} &\\symbol{237} &\\symbol{238} &\\symbol{239} \\\\ \\hline\n$240$&\\symbol{240} &\\symbol{241} &\\symbol{242} &\\symbol{243} &\\symbol{244} &\\symbol{245} &\\symbol{246} &\\symbol{247} &\\symbol{248} &\\symbol{249} \\\\ \\hline\n$250$&\\symbol{250} &\\symbol{251} &\\symbol{252} &\\symbol{253} &\\symbol{254} &\\symbol{255} &             &             &             &             \\\\ \\hline\n\\end{tabular}\n}\n\n% Cloze-Fragen-Platzhalter\n\\def\\clozequestion{\n	\\colorbox{lightyellow}{\\fbox{\\raisebox{25pt}{\\hbox to 30mm{}}}}  % mit Rahmen\n	%\\colorbox{lightyellow}{\\raisebox{25pt}{\\hbox to 30mm{}}}	     % ohne Rahmen\n}\n%\\def\\clozequestion{\\rule{30mm}{1pt}}\n\n%--------------------------------Einstellungen\n\\definecolor{lightyellow}{rgb}{1,1,0.8}\n\\definecolor{Brown}{cmyk}{0,0.81,1,0.60}\n\\definecolor{OliveGreen}{cmyk}{0.64,0,0.95,0.40}\n\\definecolor{CadetBlue}{cmyk}{0.62,0.57,0.23,0}\n\\definecolor{Orange}{cmyk}{0.5,0.7,0.9,0}\n\\pagestyle{empty}\n\n%------------------------------------------------------------------------------------\n\\newcounter{bspnummer}\n\\def\\v1{\\smallskip\\par}\n\\def\\jpgn#1#2{\\begin{minipage}{#2}    \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}}\n\\def\\jpgd#1{\\begin{minipage}{30mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}  }\n\\def\\jpgkl#1{\\begin{minipage}{50mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage} }\n\\def\\jpgm#1{\\begin{minipage}{80mm} \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}  }\n\\def\\jpggr#1{\\begin{minipage}{\\textwidth}\\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg} \\end{minipage} }\n\\def\\pdfn#1#2{\\begin{minipage}{#2}    \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}}\n\\def\\pdfd#1{\\begin{minipage}{30mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}  }\n\\def\\pdfkl#1{\\begin{minipage}{50mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage} }\n\\def\\pdfm#1{\\begin{minipage}{80mm} \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}  }\n\\def\\pdfgr#1{\\begin{minipage}{\\textwidth}\\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf} \\end{minipage} }\n\n    %  Punkte Angabe\n%-----------------------------------------------------------------------------------\n% Gruppe als Parameter\n\\def\\testkopf#1{\\begin{tabular}{|p{12mm}|p{14mm}|p{54mm}|p{5mm}|p{25mm}|p{10mm}|p{13mm}|p{25mm}|}\n\\hline\nGeg.&Klasse&\\Arbeit&Gr.&Name&KatNr&Prozent&Note\\\\\n\\hline\n\\Gegenstand&\\Klasse&\\Testnummer&#1&&&&\\medskip\\\\\n\\hline\n\\end{tabular}\\setcounter{bspnummer}{0}\\\\\n%\\begin{tabular}{|p{10mm}|p{10mm}|p{138mm}|p{18mm}|}\n%\\hline Nr.&Soll&Angabe&Ist\\\\ \\hline \\end{tabular}\\\\\n}\n%---------------------------------\n%Beispielkopf\n\\def\\testbsp#1{\\stepcounter{bspnummer}\\begin{tabular}{|p{25mm}|p{25mm}|p{130mm}}\n\\hline Bsp. \\the\\value{bspnummer}&Soll: #1& Ist: \\\\\\end{tabular} \\\\\n}\n%---------------------------------\n% -------------------------------- Source - Code - Formatierung----------------\n\\newcount\\Sourcenummer\\Sourcenummer=0\n\\definecolor{Brown}{cmyk}{0,0.81,1,0.60}\n\\definecolor{OliveGreen}{cmyk}{0.64,0,0.95,0.40}\n\\definecolor{CadetBlue}{cmyk}{0.62,0.57,0.23,0}\n\\definecolor{Orange}{cmyk}{0.5,0.7,0.9,0}\n\\lstset{frame=ltrb,framesep=5pt,basicstyle=\\small,breaklines=true,\n  keywordstyle=\\ttfamily\\color{OliveGreen},numbers=left,\n  identifierstyle=\\ttfamily\\color{CadetBlue}\\bfseries,commentstyle=\\color{Brown},\n  stringstyle=\\ttfamily\\color{Orange}}\n\\lstset{literate=\n    {Ö}{{\\\"O}}1\n    {Ä}{{\\\"A}}1\n    {Ü}{{\\\"U}}1\n    {ß}{{\\ss}}1\n    {ü}{{\\\"u}}1\n    {ä}{{\\\"a}}1\n    {ö}{{\\\"o}}1\n    {~}{{\\textasciitilde}}1\n} \n\n% ------------------------- Sonderzeichen ------------------------------------\n\\def\\bs{$\\backslash$}             \n\\def\\lgk{$\\lbrace$}               % Geschwungenen Klammer links\n\\def\\rgk{$\\rbrace$}      \n\\def\\tild{$\\sim$}                 % Tilde\n\\def\\hk{\\textquotesingle}         % einfaches Hochkomma\n\\def\\hkb{\\textasciigrave}	        % einfaches schräges Hochkomma\n\\def\\prozent{\\textdiscount}       % Prozentzeichen\n\\def\\dach{$^\\wedge$}  	\n\\def\\dollar{\\$}\n\\def\\raute{$\\sharp$}\n%größer  $>$\n%kleiner $<$\n%senktrechter Strich $\\mid$\n%---------------------------------- Pfeile\n\\def\\pfeillr{$\\longleftrightarrow$}\n\\def\\pfeil{$\\Rightarrow$}\n\n% ------------------------ Textformatierungen --------------------------------\n%---------------------------------- Blickfangpunkte\n\\def\\bitem{\\begin{itemize} \\item}\n\\def\\eitem{\\end{itemize}}\n\\long\\def\\sitem#1{\\begin{tabular}{p{2mm}p{0.85\\textwidth}} -& #1 \\end{tabular}\\\\}\n%---------------------------------- Einrücken\n\\long\\def\\tab#1{\\makebox[#1\\textwidth][1]{~}}  \n\\def\\tabe{\\tab{0.1}}\n\\def\\tabm{\\tab{0.3}}\n\\def\\cent#1{\\begin{center} #1 \\end{center}}\n%----------------------------------------------------\n\\long\\def\\mp#1{\\begin{minipage}{0.85\\textwidth} #1 \\end{minipage}}\n\\long\\def\\itab#1{\\begin{tabular}{p{2mm}p{0.85\\textwidth}}& #1\\\\ \\end{tabular}\\\\}\n\n\\begin{document}\n',0,0,NULL),(70,0,0,'Tex-Packages, die für die Erzeugung von PDF-Dokumneten geladen werden','moodle.sty','\\usepackage{amssymb}\n\\usepackage[utf8]{inputenc}\n\\usepackage[american,naustrian]{babel}\n\\usepackage{makeidx}\n\\usepackage{color}\n\\usepackage{xcolor}\n\\usepackage{listings}\n\\usepackage{float}\n\\usepackage{latexsym}\n\\usepackage{array}\n\\usepackage{longtable}\n\\usepackage{tabularx}\n\\usepackage{textcomp}\n\\usepackage{verbatim}\n\\usepackage{ifthen}\n\\usepackage{hyperref}\n\\usepackage{multirow}\n\\usepackage{pdfpages}\n\\usepackage{marvosym}\n\\usepackage{twoopt}\n\\usepackage{picinpar}\n\\usepackage{graphicx}\n\\usepackage{ulem}\n\\usepackage{amsmath}\n\\usepackage[left]{eurosym}\n\\DeclareUnicodeCharacter{20AC}{\\text{\\euro}}\n\n%-------------------------------- Seitenformatierungen\n\\def\\PageTest{\n	\\voffset -10.5mm             \\advance\\voffset        by -20mm\n	\\hoffset -0.5mm\n	\\oddsidemargin5.0mm          \\advance\\oddsidemargin  by -20mm\n	\\evensidemargin5.0mm         \\advance\\evensidemargin by -20mm\n	\\textwidth150mm              \\advance\\textwidth      by  40mm\n	\\textheight640pt             \\advance\\textheight     by  40mm\n	\\parskip3pt plus2pt\n	\\parindent0pt\n	\\pagestyle{empty}\n}\n\\def\\PageQuestion{\n	\\voffset -10.5mm              \\advance\\voffset        by -10mm\n	\\hoffset -0.5mm\n	\\oddsidemargin5.0mm          \\advance\\oddsidemargin  by -10mm\n	\\evensidemargin5.0mm         \\advance\\evensidemargin by -10mm\n	\\textwidth150mm              \\advance\\textwidth      by  20mm\n	\\textheight640pt             \\advance\\textheight     by  35mm\n	\\parskip3pt plus2pt\n	\\parindent0pt\n	%\\pagestyle{empty}\n	\\setcounter{page}{1}\n	\\pagenumbering{arabic}\n	\\pagestyle{plain}\n}\n\\def\\PageNormal{\n	\\voffset -10.5mm              \\advance\\voffset        by -10mm\n	\\hoffset -0.5mm\n	\\oddsidemargin5.0mm          \\advance\\oddsidemargin  by -10mm\n	\\evensidemargin5.0mm         \\advance\\evensidemargin by -10mm\n	\\textwidth150mm              \\advance\\textwidth      by  20mm\n	\\textheight640pt             \\advance\\textheight     by  35mm\n	\\parskip3pt plus2pt\n	\\parindent0pt\n	\\setcounter{page}{1}\n	\\pagenumbering{arabic}\n	\\pagestyle{plain}\n}\n\n% ------------------------ allgemeine Definitionen ----------------------------\n\\def\\titel#1{\n  \\pagenumbering{roman}	\n  \\title{#1} \n  \\author{\\name}\n  \\maketitle\n  \\setcounter{page}{1} \n  \\tableofcontents\n  \\clearpage\n  \\pagenumbering{arabic}\n}\n\n% Cloze-Fragen-Platzhalter\n\\def\\clozequestion{\n	\\colorbox{lightyellow}{\\fbox{\\raisebox{25pt}{\\hbox to 30mm{}}}}  % mit Rahmen\n	%\\colorbox{lightyellow}{\\raisebox{25pt}{\\hbox to 30mm{}}}	     % ohne Rahmen\n}\n%\\def\\clozequestion{\\rule{30mm}{1pt}}\n\n%--------------------------------Einstellungen\n\\definecolor{lightyellow}{rgb}{1,1,0.8}\n\\definecolor{Brown}{cmyk}{0,0.81,1,0.60}\n\\definecolor{OliveGreen}{cmyk}{0.64,0,0.95,0.40}\n\\definecolor{CadetBlue}{cmyk}{0.62,0.57,0.23,0}\n\\definecolor{Orange}{cmyk}{0.5,0.7,0.9,0}\n\\addtolength{\\topmargin}{-20pt}\n\\addtolength{\\textheight}{10pt}	 \n\\pagestyle{empty}\n%------------------------------------------------------------------------------------\n\\def\\Klasse{}\n\\def\\Gegenstand{}\n\\def\\Arbeit{Bezeichnung}\n\\def\\Testnummer{1.}\n\\def\\Datum{}\n%------------------------------------------------------------------------------------\n\\newcounter{bspnummer}\n\\def\\v1{\\smallskip\\par}\n\\def\\jpgn#1#2{\\begin{minipage}{#2}    \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}}\n\\def\\jpgd#1{\\begin{minipage}{30mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}  }\n\\def\\jpgkl#1{\\begin{minipage}{50mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage} }\n\\def\\jpgm#1{\\begin{minipage}{80mm} \\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg}     \\end{minipage}  }\n\\def\\jpggr#1{\\begin{minipage}{\\textwidth}\\includegraphics[width=\\textwidth]{\\imagepath/#1.jpg} \\end{minipage} }\n\\def\\pdfn#1#2{\\begin{minipage}{#2}    \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}}\n\\def\\pdfd#1{\\begin{minipage}{30mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}  }\n\\def\\pdfkl#1{\\begin{minipage}{50mm}  \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage} }\n\\def\\pdfm#1{\\begin{minipage}{80mm} \\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf}     \\end{minipage}  }\n\\def\\pdfgr#1{\\begin{minipage}{\\textwidth}\\includegraphics[width=\\textwidth]{\\imagepath/#1.pdf} \\end{minipage} }\n\n    %  Punkte Angabe\n%-----------------------------------------------------------------------------------\n% Gruppe als Parameter\n\\def\\testkopf#1{\\begin{tabular}{|p{12mm}|p{14mm}|p{54mm}|p{5mm}|p{25mm}|p{10mm}|p{13mm}|p{25mm}|}\n\\hline\nGeg.&Klasse&\\Arbeit&Gr.&Name&KatNr&Prozent&Note\\\\\n\\hline\n\\Gegenstand&\\Klasse&\\Testnummer&#1&&&&\\medskip\\\\\n\\hline\n\\end{tabular}\\setcounter{bspnummer}{0}\\\\\n%\\begin{tabular}{|p{10mm}|p{10mm}|p{138mm}|p{18mm}|}\n%\\hline Nr.&Soll&Angabe&Ist\\\\ \\hline \\end{tabular}\\\\\n}\n%---------------------------------\n%Beispielkopf\n\\def\\testbsp#1{\\stepcounter{bspnummer}\\begin{tabular}{|p{25mm}|p{25mm}|p{130mm}}\n\\hline Bsp. \\the\\value{bspnummer}&Soll: #1& Ist: \\\\\\end{tabular} \\\\\n}\n%---------------------------------\n% -------------------------------- Source - Code - Formatierung----------------\n\\newcount\\Sourcenummer\\Sourcenummer=0\n\\definecolor{Brown}{cmyk}{0,0.81,1,0.60}\n\\definecolor{OliveGreen}{cmyk}{0.64,0,0.95,0.40}\n\\definecolor{CadetBlue}{cmyk}{0.62,0.57,0.23,0}\n\\definecolor{Orange}{cmyk}{0.5,0.7,0.9,0}\n\\lstset{frame=ltrb,framesep=5pt,basicstyle=\\small,breaklines=true,\n  keywordstyle=\\ttfamily\\color{OliveGreen},numbers=left,\n  identifierstyle=\\ttfamily\\color{CadetBlue}\\bfseries,commentstyle=\\color{Brown},\n  stringstyle=\\ttfamily\\color{Orange}}\n\\lstset{literate=\n    {Ö}{{\\\"O}}1\n    {Ä}{{\\\"A}}1\n    {Ü}{{\\\"U}}1\n    {ß}{{\\ss}}1\n    {ü}{{\\\"u}}1\n    {ä}{{\\\"a}}1\n    {ö}{{\\\"o}}1\n    {~}{{\\textasciitilde}}1\n} \n\n% ------------------------- Sonderzeichen ------------------------------------\n\\def\\bs{$\\backslash$}             \n\\def\\lgk{$\\lbrace$}               % Geschwungenen Klammer links\n\\def\\rgk{$\\rbrace$}      \n\\def\\tild{$\\sim$}                 % Tilde\n\\def\\hk{\\textquotesingle}         % einfaches Hochkomma\n\\def\\hkb{\\textasciigrave}	        % einfaches schräges Hochkomma\n\\def\\prozent{\\textdiscount}       % Prozentzeichen\n\\def\\dach{$^\\wedge$}  	\n\\def\\dollar{\\$}\n\\def\\raute{$\\sharp$}\n%größer  $>$\n%kleiner $<$\n%senktrechter Strich $\\mid$\n%---------------------------------- Pfeile\n\\def\\pfeillr{$\\longleftrightarrow$}\n\\def\\pfeil{$\\Rightarrow$}\n\n% ------------------------ Textformatierungen --------------------------------\n%---------------------------------- Blickfangpunkte\n\\def\\bitem{\\begin{itemize} \\item}\n\\def\\eitem{\\end{itemize}}\n\\long\\def\\sitem#1{\\begin{tabular}{p{2mm}p{0.85\\textwidth}} -& #1 \\end{tabular}\\\\}\n%---------------------------------- Einrücken\n\\long\\def\\tab#1{\\makebox[#1\\textwidth][1]{~}}  \n\\def\\tabe{\\tab{0.1}}\n\\def\\tabm{\\tab{0.3}}\n\\def\\cent#1{\\begin{center} #1 \\end{center}}\n%----------------------------------------------------\n\\long\\def\\mp#1{\\begin{minipage}{0.85\\textwidth} #1 \\end{minipage}}\n\\long\\def\\itab#1{\\begin{tabular}{p{2mm}p{0.85\\textwidth}}& #1\\\\ \\end{tabular}\\\\}\n\n%------------------- Literaturverzeichniseintrag\n\\def\\Autor#1{{#1:}}\n\\def\\Titel#1{{\\sl #1.}}\n\\def\\Verlag#1{#1.}\n\\def\\literatur#1#2#3#4{\\bibitem{#1}{#2:}{\\sl #3.}#4.}\n\\makeindex  \n\n',0,0,NULL),(78,1,0,'Automatisches Lizenzupdate für ganzen Server','lizenzAutomatic','1',4,0,NULL),(135,0,0,'Angezeigtes Bild am Hauptschirm, Typ muss auf Image gesetzt werden','image','',0,0,1),(136,0,0,'Schulbezeichnung, die links oben im Hauptfenster angezeigt wird','schulname','Schule',0,0,1),(138,0,0,'Schulbezeichnung, die links oben im Hauptfenster angezeigt wird','schulname','Schule',0,0,1),(2251,0,0,'Pfad, unter dem Tex-Daten gespeichert werden','pathTex','/opt/letto/tex/',0,0,NULL),(2252,1,0,'Web-Pfad zu allen notwendigen JS-Libraries, es erfolgt keine Kontrolle der Verfügbarkeit, wenn dieser Wert gesetzt ist!','forceJavascriptPath','',0,0,NULL),(2253,0,0,'Selbstregistrierung über mail-Adresse erlauben','registrierung','0',4,0,NULL),(2254,0,0,'Selbstregistrierung nur mit gültigem Kurs-Key','registrierungKurs','0',4,0,NULL),(2255,0,1,'Beurteilungen für User, wird für jeden User überschrieben','userBewertungen','',0,0,NULL),(2256,1,0,'Bezeichnung des LDAP-Servers','LDAPServer','',0,0,NULL),(2257,1,0,'Parameter der LDAP Verbindung (Strichpunkt-getrennt: par1=wert1;par2=wert2','LDAPparams','',0,0,NULL),(2258,1,0,'Name des Active-Directory-Servers','ADServer','',0,0,NULL),(2259,0,1,'Zuletzt vom Benutzer ausgewählte Kategorie','lastSelectedCategory','',0,0,NULL),(2260,0,1,'Benutzerdefinierte Testeinstellungen','defaultTestConfig','',0,0,NULL),(2261,0,1,'CSV-Zahlenformat, Leer: Systemeinstellungen','csvKomma','',0,1,NULL);
/*!40000 ALTER TABLE `globalconfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gruppe`
--

DROP TABLE IF EXISTS `gruppe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gruppe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `INFO` varchar(100) DEFAULT NULL,
  `NAME` varchar(40) NOT NULL,
  `idKlasse` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_gruppe_idKlasse` (`idKlasse`),
  CONSTRAINT `FK_gruppe_idKlasse` FOREIGN KEY (`idKlasse`) REFERENCES `klasse` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gruppe`
--

LOCK TABLES `gruppe` WRITE;
/*!40000 ALTER TABLE `gruppe` DISABLE KEYS */;
/*!40000 ALTER TABLE `gruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gruppeuser`
--

DROP TABLE IF EXISTS `gruppeuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gruppeuser` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ROLLE` int DEFAULT NULL,
  `idGruppe` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_gruppeuser_idUser` (`idUser`),
  KEY `FK_gruppeuser_idGruppe` (`idGruppe`),
  CONSTRAINT `FK_gruppeuser_idGruppe` FOREIGN KEY (`idGruppe`) REFERENCES `gruppe` (`id`),
  CONSTRAINT `FK_gruppeuser_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gruppeuser`
--

LOCK TABLES `gruppeuser` WRITE;
/*!40000 ALTER TABLE `gruppeuser` DISABLE KEYS */;
/*!40000 ALTER TABLE `gruppeuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gruppierung`
--

DROP TABLE IF EXISTS `gruppierung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gruppierung` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GRUPPENMODUS` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gruppierung`
--

LOCK TABLES `gruppierung` WRITE;
/*!40000 ALTER TABLE `gruppierung` DISABLE KEYS */;
/*!40000 ALTER TABLE `gruppierung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `MD5` varchar(100) NOT NULL,
  `EXTENSION` varchar(10) DEFAULT NULL,
  `IDUSER` bigint DEFAULT NULL,
  `INHALT` longtext,
  `JAVASCRIPT` longtext,
  PRIMARY KEY (`MD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` VALUES ('1769dd3d6ad813cfa2458d2afb473ba9','png',0,'',''),('2de2caa0c1df48586e76bb5a53ee87b9','none',0,'',''),('525c15c31e66eab77f1be8e845931b','gif',0,'',''),('5774cec878624c2dea29aff334bc787','png',0,'',''),('6dd7774d667fd069333acfc79646','png',0,'',''),('7276d3109302f65936a55fae1fb9aa0','png',0,'',''),('bfcbd89c9af61e1a9bc87c3daff2b1d','png',0,'','');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inetlinks`
--

DROP TABLE IF EXISTS `inetlinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inetlinks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `LINKADRESS` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inetlinks`
--

LOCK TABLES `inetlinks` WRITE;
/*!40000 ALTER TABLE `inetlinks` DISABLE KEYS */;
/*!40000 ALTER TABLE `inetlinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `katalog_fremdlehrer`
--

DROP TABLE IF EXISTS `katalog_fremdlehrer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `katalog_fremdlehrer` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ZUSTIMMUNG` tinyint(1) DEFAULT '0',
  `lkID` int DEFAULT NULL,
  `userID` int DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `FK_katalog_fremdlehrer_userID` (`userID`),
  KEY `FK_katalog_fremdlehrer_lkID` (`lkID`),
  CONSTRAINT `FK_katalog_fremdlehrer_lkID` FOREIGN KEY (`lkID`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_katalog_fremdlehrer_userID` FOREIGN KEY (`userID`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `katalog_fremdlehrer`
--

LOCK TABLES `katalog_fremdlehrer` WRITE;
/*!40000 ALTER TABLE `katalog_fremdlehrer` DISABLE KEYS */;
/*!40000 ALTER TABLE `katalog_fremdlehrer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `klasse`
--

DROP TABLE IF EXISTS `klasse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `klasse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ALIAS` varchar(255) DEFAULT NULL,
  `IDKV` int DEFAULT NULL,
  `IDKURSLTI` bigint DEFAULT NULL,
  `JAHRGANG` int DEFAULT NULL,
  `NAME` varchar(255) NOT NULL,
  `SCHULSTUFE` int DEFAULT NULL,
  `SEMESTER` int DEFAULT NULL,
  `idAbteilung` int DEFAULT NULL,
  `idLehrplan` int DEFAULT NULL,
  `idSchuljahr` int DEFAULT NULL,
  `idSchule` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_klasse_idSchuljahr` (`idSchuljahr`),
  KEY `FK_klasse_idAbteilung` (`idAbteilung`),
  KEY `FK_klasse_idLehrplan` (`idLehrplan`),
  KEY `FK_klasse_idSchule` (`idSchule`),
  CONSTRAINT `FK_klasse_idAbteilung` FOREIGN KEY (`idAbteilung`) REFERENCES `abteilung` (`id`),
  CONSTRAINT `FK_klasse_idLehrplan` FOREIGN KEY (`idLehrplan`) REFERENCES `lehrplan` (`id`),
  CONSTRAINT `FK_klasse_idSchule` FOREIGN KEY (`idSchule`) REFERENCES `schultyp` (`id`),
  CONSTRAINT `FK_klasse_idSchuljahr` FOREIGN KEY (`idSchuljahr`) REFERENCES `schuljahr` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `klasse`
--

LOCK TABLES `klasse` WRITE;
/*!40000 ALTER TABLE `klasse` DISABLE KEYS */;
/*!40000 ALTER TABLE `klasse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `klassenbeurteilung`
--

DROP TABLE IF EXISTS `klassenbeurteilung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `klassenbeurteilung` (
  `id` int NOT NULL AUTO_INCREMENT,
  `AUFGABENSTELLUNG` longtext,
  `BEZEICHNERBEURTEILUNGSART` varchar(255) DEFAULT NULL,
  `DATUM` datetime DEFAULT NULL,
  `GEWICHT` double DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `SELECTEDLEVEL` int DEFAULT NULL,
  `SHOWDATEBEURTEILUNG` tinyint(1) DEFAULT '0',
  `TESTALLOWED` tinyint(1) DEFAULT '0',
  `idBeurteilungsartGlobal` int DEFAULT NULL,
  `idFremdLehrer` int DEFAULT NULL,
  `idLehrerKlasse` int DEFAULT NULL,
  `idParent` int DEFAULT NULL,
  `SELKOMPETENZ_ID` int DEFAULT NULL,
  `idActivity` int DEFAULT NULL,
  `klassenBeurteilungen_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_klassenbeurteilung_idLehrerKlasse` (`idLehrerKlasse`),
  KEY `FK_klassenbeurteilung_idParent` (`idParent`),
  KEY `FK_klassenbeurteilung_idFremdLehrer` (`idFremdLehrer`),
  KEY `FK_klassenbeurteilung_SELKOMPETENZ_ID` (`SELKOMPETENZ_ID`),
  KEY `FK_klassenbeurteilung_idBeurteilungsartGlobal` (`idBeurteilungsartGlobal`),
  KEY `FK_klassenbeurteilung_idActivity` (`idActivity`),
  CONSTRAINT `FK_klassenbeurteilung_idActivity` FOREIGN KEY (`idActivity`) REFERENCES `activity` (`id`),
  CONSTRAINT `FK_klassenbeurteilung_idBeurteilungsartGlobal` FOREIGN KEY (`idBeurteilungsartGlobal`) REFERENCES `beurteilungsartGlobal` (`id`),
  CONSTRAINT `FK_klassenbeurteilung_idFremdLehrer` FOREIGN KEY (`idFremdLehrer`) REFERENCES `user` (`id`),
  CONSTRAINT `FK_klassenbeurteilung_idLehrerKlasse` FOREIGN KEY (`idLehrerKlasse`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_klassenbeurteilung_idParent` FOREIGN KEY (`idParent`) REFERENCES `klassenbeurteilung` (`id`),
  CONSTRAINT `FK_klassenbeurteilung_SELKOMPETENZ_ID` FOREIGN KEY (`SELKOMPETENZ_ID`) REFERENCES `kompetenz` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `klassenbeurteilung`
--

LOCK TABLES `klassenbeurteilung` WRITE;
/*!40000 ALTER TABLE `klassenbeurteilung` DISABLE KEYS */;
/*!40000 ALTER TABLE `klassenbeurteilung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kompetenz`
--

DROP TABLE IF EXISTS `kompetenz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kompetenz` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BASISWISSEN` longtext,
  `ERWEITERUNGSWISSEN` longtext,
  `KOMPETENZ` varchar(200) DEFAULT NULL,
  `idAbteilung` int NOT NULL,
  `idSchultyp` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_kompetenz_0` (`KOMPETENZ`,`idAbteilung`,`idSchultyp`),
  KEY `FK_kompetenz_idSchultyp` (`idSchultyp`),
  KEY `FK_kompetenz_idAbteilung` (`idAbteilung`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kompetenz`
--

LOCK TABLES `kompetenz` WRITE;
/*!40000 ALTER TABLE `kompetenz` DISABLE KEYS */;
/*!40000 ALTER TABLE `kompetenz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kompetenz_beurteilung`
--

DROP TABLE IF EXISTS `kompetenz_beurteilung`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kompetenz_beurteilung` (
  `id` int NOT NULL AUTO_INCREMENT,
  `level` int DEFAULT NULL,
  `beurteilungID` int DEFAULT NULL,
  `kompetenzID` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_kompetenz_beurteilung_beurteilungID` (`beurteilungID`),
  KEY `FK_kompetenz_beurteilung_kompetenzID` (`kompetenzID`),
  CONSTRAINT `FK_kompetenz_beurteilung_beurteilungID` FOREIGN KEY (`beurteilungID`) REFERENCES `beurteilung` (`id`),
  CONSTRAINT `FK_kompetenz_beurteilung_kompetenzID` FOREIGN KEY (`kompetenzID`) REFERENCES `kompetenz` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kompetenz_beurteilung`
--

LOCK TABLES `kompetenz_beurteilung` WRITE;
/*!40000 ALTER TABLE `kompetenz_beurteilung` DISABLE KEYS */;
/*!40000 ALTER TABLE `kompetenz_beurteilung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kompetenz_lehrplan`
--

DROP TABLE IF EXISTS `kompetenz_lehrplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kompetenz_lehrplan` (
  `Kompetenz_ID` int NOT NULL,
  `notUsedInLehrplan_ID` int NOT NULL,
  PRIMARY KEY (`Kompetenz_ID`,`notUsedInLehrplan_ID`),
  KEY `FK_kompetenz_lehrplan_notUsedInLehrplan_ID` (`notUsedInLehrplan_ID`),
  CONSTRAINT `FK_kompetenz_lehrplan_Kompetenz_ID` FOREIGN KEY (`Kompetenz_ID`) REFERENCES `kompetenz` (`id`),
  CONSTRAINT `FK_kompetenz_lehrplan_notUsedInLehrplan_ID` FOREIGN KEY (`notUsedInLehrplan_ID`) REFERENCES `lehrplan` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kompetenz_lehrplan`
--

LOCK TABLES `kompetenz_lehrplan` WRITE;
/*!40000 ALTER TABLE `kompetenz_lehrplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `kompetenz_lehrplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kompetenz_subquestion`
--

DROP TABLE IF EXISTS `kompetenz_subquestion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kompetenz_subquestion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `level` int DEFAULT NULL,
  `kompetenzID` int DEFAULT NULL,
  `subQuestionsID` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_kompetenz_subquestion_kompetenzID` (`kompetenzID`),
  KEY `FK_kompetenz_subquestion_subQuestionsID` (`subQuestionsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kompetenz_subquestion`
--

LOCK TABLES `kompetenz_subquestion` WRITE;
/*!40000 ALTER TABLE `kompetenz_subquestion` DISABLE KEYS */;
/*!40000 ALTER TABLE `kompetenz_subquestion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lehrerKlasse`
--

DROP TABLE IF EXISTS `lehrerKlasse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lehrerKlasse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BEZEICHNUNG` varchar(255) DEFAULT NULL,
  `CONFIG` varchar(255) DEFAULT NULL,
  `DISABLEKATALOG` tinyint(1) DEFAULT '0',
  `FREMDZUGRIFF` tinyint(1) DEFAULT '0',
  `GEWICHTUNG` double DEFAULT NULL,
  `KOSTEN` varchar(255) DEFAULT NULL,
  `USERADDED` tinyint(1) DEFAULT '0',
  `idConfigBeurteilung` int DEFAULT NULL,
  `idGegenstand` int DEFAULT NULL,
  `idKlasse` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  `KURSKENNUNG` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_lehrerKlasse_idUser` (`idUser`),
  KEY `FK_lehrerKlasse_idKlasse` (`idKlasse`),
  KEY `FK_lehrerKlasse_idConfigBeurteilung` (`idConfigBeurteilung`),
  KEY `FK_lehrerKlasse_idGegenstand` (`idGegenstand`),
  CONSTRAINT `FK_lehrerKlasse_idConfigBeurteilung` FOREIGN KEY (`idConfigBeurteilung`) REFERENCES `beurteilungsconfig` (`id`),
  CONSTRAINT `FK_lehrerKlasse_idGegenstand` FOREIGN KEY (`idGegenstand`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `FK_lehrerKlasse_idKlasse` FOREIGN KEY (`idKlasse`) REFERENCES `klasse` (`id`),
  CONSTRAINT `FK_lehrerKlasse_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lehrerKlasse`
--

LOCK TABLES `lehrerKlasse` WRITE;
/*!40000 ALTER TABLE `lehrerKlasse` DISABLE KEYS */;
/*!40000 ALTER TABLE `lehrerKlasse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lehrinhalt`
--

DROP TABLE IF EXISTS `lehrinhalt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lehrinhalt` (
  `id` int NOT NULL AUTO_INCREMENT,
  `JAHRGANG` int DEFAULT NULL,
  `KOMPETENZBEREICH` varchar(200) DEFAULT NULL,
  `KURZBEZEICHNUNG` varchar(200) DEFAULT NULL,
  `LEHRINHALT` longtext,
  `LEVEL` int DEFAULT NULL,
  `SEMESTER` int DEFAULT NULL,
  `idGegenstand` int DEFAULT NULL,
  `idLehrplan` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_lehrinhalt_idLehrplan` (`idLehrplan`),
  KEY `FK_lehrinhalt_idGegenstand` (`idGegenstand`),
  CONSTRAINT `FK_lehrinhalt_idGegenstand` FOREIGN KEY (`idGegenstand`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `FK_lehrinhalt_idLehrplan` FOREIGN KEY (`idLehrplan`) REFERENCES `lehrplan` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lehrinhalt`
--

LOCK TABLES `lehrinhalt` WRITE;
/*!40000 ALTER TABLE `lehrinhalt` DISABLE KEYS */;
/*!40000 ALTER TABLE `lehrinhalt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lehrinhalt_deskriptor`
--

DROP TABLE IF EXISTS `lehrinhalt_deskriptor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lehrinhalt_deskriptor` (
  `deskriptoren_ID` int NOT NULL,
  `lehrinhalte_ID` int NOT NULL,
  PRIMARY KEY (`deskriptoren_ID`,`lehrinhalte_ID`),
  KEY `FK_lehrinhalt_deskriptor_lehrinhalte_ID` (`lehrinhalte_ID`),
  CONSTRAINT `FK_lehrinhalt_deskriptor_deskriptoren_ID` FOREIGN KEY (`deskriptoren_ID`) REFERENCES `deskriptor` (`id`),
  CONSTRAINT `FK_lehrinhalt_deskriptor_lehrinhalte_ID` FOREIGN KEY (`lehrinhalte_ID`) REFERENCES `lehrinhalt` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lehrinhalt_deskriptor`
--

LOCK TABLES `lehrinhalt_deskriptor` WRITE;
/*!40000 ALTER TABLE `lehrinhalt_deskriptor` DISABLE KEYS */;
/*!40000 ALTER TABLE `lehrinhalt_deskriptor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lehrinhalt_kompetenz`
--

DROP TABLE IF EXISTS `lehrinhalt_kompetenz`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lehrinhalt_kompetenz` (
  `kompetenzen_ID` int NOT NULL,
  `lehrinhalte_ID` int NOT NULL,
  `kompetenzen_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`kompetenzen_ID`,`lehrinhalte_ID`),
  KEY `FK_lehrinhalt_kompetenz_lehrinhalte_ID` (`lehrinhalte_ID`),
  CONSTRAINT `FK_lehrinhalt_kompetenz_kompetenzen_ID` FOREIGN KEY (`kompetenzen_ID`) REFERENCES `kompetenz` (`id`),
  CONSTRAINT `FK_lehrinhalt_kompetenz_lehrinhalte_ID` FOREIGN KEY (`lehrinhalte_ID`) REFERENCES `lehrinhalt` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lehrinhalt_kompetenz`
--

LOCK TABLES `lehrinhalt_kompetenz` WRITE;
/*!40000 ALTER TABLE `lehrinhalt_kompetenz` DISABLE KEYS */;
/*!40000 ALTER TABLE `lehrinhalt_kompetenz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lehrplan`
--

DROP TABLE IF EXISTS `lehrplan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `lehrplan` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BESCHREIBUNG` longtext,
  `BEZEICHNUNG` longtext,
  `GEGENSTANDSZUORDNUNG` longtext,
  `INKRAFTSEIT` date DEFAULT NULL,
  `SEMESTRABSCHULSTUFE` int DEFAULT NULL,
  `SEMESTRIERT` tinyint(1) DEFAULT '0',
  `STARTJAHRGANG` int DEFAULT NULL,
  `idAbteilung` int DEFAULT NULL,
  `idSchultyp` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_lehrplan_idAbteilung` (`idAbteilung`),
  KEY `FK_lehrplan_idSchultyp` (`idSchultyp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lehrplan`
--

LOCK TABLES `lehrplan` WRITE;
/*!40000 ALTER TABLE `lehrplan` DISABLE KEYS */;
/*!40000 ALTER TABLE `lehrplan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `loadedplugins`
--

DROP TABLE IF EXISTS `loadedplugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `loadedplugins` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CLASSPATH` varchar(255) DEFAULT NULL,
  `FULLPATH` varchar(255) DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `STATUS` int DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `loadedplugins`
--

LOCK TABLES `loadedplugins` WRITE;
/*!40000 ALTER TABLE `loadedplugins` DISABLE KEYS */;
/*!40000 ALTER TABLE `loadedplugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `moodleRechte`
--

DROP TABLE IF EXISTS `moodleRechte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `moodleRechte` (
  `id` int NOT NULL AUTO_INCREMENT,
  `q_change` tinyint DEFAULT NULL,
  `q_delete` tinyint DEFAULT NULL,
  `q_insert` tinyint DEFAULT NULL,
  `idKateg` int DEFAULT NULL,
  `idUser` int NOT NULL,
  `rechte_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_moodleRechte_idKateg` (`idKateg`),
  KEY `FK_moodleRechte_idUser` (`idUser`),
  CONSTRAINT `FK_moodleRechte_idKateg` FOREIGN KEY (`idKateg`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_moodleRechte_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2272 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `moodleRechte`
--

LOCK TABLES `moodleRechte` WRITE;
/*!40000 ALTER TABLE `moodleRechte` DISABLE KEYS */;
INSERT INTO `moodleRechte` VALUES (2271,1,1,1,2270,2,0);
/*!40000 ALTER TABLE `moodleRechte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `moodleText`
--

DROP TABLE IF EXISTS `moodleText`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `moodleText` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `FORMAT` varchar(40) DEFAULT NULL,
  `TEXT` longtext,
  `idQuestion` bigint DEFAULT NULL,
  `moodleTexte_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_moodleText_idQuestion` (`idQuestion`),
  CONSTRAINT `FK_moodleText_idQuestion` FOREIGN KEY (`idQuestion`) REFERENCES `question` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `moodleText`
--

LOCK TABLES `moodleText` WRITE;
/*!40000 ALTER TABLE `moodleText` DISABLE KEYS */;
INSERT INTO `moodleText` VALUES (2279,'html','<h1><strong>LeTTo-Onramp</strong></h1>\n\n<h2><strong>Herzlich Willkommen!</strong></h2>\n\n<p>In diesem interaktiven Tutorial werden</p>\n\n<ul>\n	<li>\n	<p>die Details zur Ergebniseingabe am LeTTo-Server veranschaulicht.</p>\n	</li>\n	<li>\n	<p>M&ouml;glichkeiten geboten Ergebniseingaben online zu testen.</p>\n	</li>\n</ul>\n\n<h2><br/>\nDas <strong>LeTTo-Team w&uuml;nscht viel Erfolg</strong> bei bevorstehenden Pr&uuml;fungen.</h2>\n\n<p>&nbsp;</p>\n\n<h2>Fragenauswahl</h2>\n\n<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; [IMG1]</p>\n\n<ul>\n	<li>Im linken Bereich ihres Browserfensters (Fragenauswahl) sehen Sie eine Auflistung der Pr&uuml;fungsfragen - siehe Musterabbildung oberhalb.<br/>\n	&nbsp;</li>\n	<li>Sie k&ouml;nnen durch Mausklick direkt jene Frage w&auml;hlen, welche Sie beantworten m&ouml;chten. Alternativ werden sie mit der Option <strong>N&auml;chste Frage </strong>zur n&auml;chsten gelisteten Frage weitergeleitet.<br/>\n	&nbsp;</li>\n	<li>Ist f&uuml;r die Pr&uuml;fung eine maximale <strong>Pr&uuml;fungszeit </strong>definiert worden, dann sehen Sie die noch verbleibend Zeit eingeblendet. Ist die Pr&uuml;fungszeit abgelaufen wird der Test automatisch abgegeben.<br/>\n	&nbsp;</li>\n	<li>M&ouml;chten Sie die Pr&uuml;fung abgeben, dann w&auml;hlen Sie <strong>Test abgeben</strong>.</li>\n</ul>\n\n<p><br/>\n&nbsp;</p>\n\n<p>[Q1]&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2275,0),(2282,'html','',2275,1),(2283,'html','',2275,2),(2284,'html','',2275,3),(2285,'html','',2275,4),(2286,'html','',2275,5),(2296,'html','<h2>Dezimaltrennzeichen</h2>\n\n<p>Immer einen <strong>Punkt </strong>als Dezimaltrennzeichen verwenden!</p>\n\n<ul>\n	<li>Geben Sie die Zahl $x = {x}$ in das Ergebnisfeld ein.<br/>\n	<br/>\n	$x=$ [Q0]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>Hilfestellung bei der Eingabe</h2>\n\n<h3>Vorschaufenster</h3>\n\n<p>Ein <strong>Doppelklick </strong>ins Eingabefeld aktiviert ein Vorschaufenster, das die Eingabe besonders &uuml;bersichtlich darstellt.</p>\n\n<ul>\n	<li>Testen Sie diese Hilfestellung durch Doppelklick auf das obige Eingabefeld.<br/>\n	&nbsp;</li>\n</ul>\n\n<h3>Bilder-Zoom</h3>\n\n<p>Ein <strong>Doppelklick </strong>auf Graphiken innerhalb der Fragestellungen &ouml;ffnet eine vergr&ouml;&szlig;erte Ansicht der Graphik.</p>\n\n<ul>\n	<li>Testen Sie diese Hilfestellung durch Doppelklick auf das [IMG1]-Logo.</li>\n</ul>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2289,0),(2299,'html','',2289,1),(2300,'html','',2289,2),(2301,'html','',2289,3),(2302,'html','',2289,4),(2303,'html','',2289,5),(2313,'html','<h2>Zuordnungsfragen</h2>\n\n<div>Bei Zuordnungsfragen unterst&uuml;tzen Sie zwei Modi bei der Fragenbeantwortung.</div>\n\n<div>Moduswechsel erfolgt mit Klick auf das Symbol<br/>\n[IMG1]<br/>\nam oberen Rand des Browserfensters.</div>\n\n<ol>\n	<li>Modus: klick - klick - Zuordnung</li>\n	<li>Modus: drag &amp; drop - Zuordnung<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>Testen Sie beide Modi durch Zuordnung der Gro&szlig;- zu ihren Kleinbuchstaben.<br/>\n	<br/>\n	[Q7]&nbsp;</li>\n</ul>',2306,0),(2316,'html','',2306,1),(2317,'html','',2306,2),(2318,'html','',2306,3),(2319,'html','',2306,4),(2320,'html','',2306,5),(2332,'html','<h1>Komplexe Zahlen</h1>\n\n<p>Sie k&ouml;nnen komplexe Zahlen in unterschiedlichsten Varianten am LeTTo-Server eingeben.</p>\n\n<p>Als Demo betrachten wir eine komplexe Zahl $\\underline z$ mit<br/>\n<br/>\n$\\underline z = {z,karti} = {z,kartj}= {z, poldeg}= {z, polrad}$<br/>\n&nbsp;</p>\n\n<h3>Zul&auml;ssige Eingabenformate der Zahl $\\underline z$ sind:</h3>\n\n<ol>\n	<li>&nbsp;$\\underline z=$ 3+4j</li>\n	<li>&nbsp;$\\underline z=$ 3+4i</li>\n	<li>&nbsp;$\\underline z=$ 3+j*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*j</li>\n	<li>&nbsp;$\\underline z=$ 3+i*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*i</li>\n	<li>&nbsp;$\\underline z=$ 5arg53.13°</li>\n	<li>&nbsp;$\\underline z=$ 5arg0.9273<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>Test Sie die unterschiedlichen Eingabeformate f&uuml;r $\\underline z$<br/>\n	<br/>\n	$\\underline z =$ [Q1]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<p><strong>TIPP</strong>: LeTTo interpretiert Winkeleingaben ohne dem Grad Symbol \" ° \" immer als Radiant. F&uuml;r die Eingabe eines Winkels in Radiant ist somit kein explizites Einheitensymbol notwendig.<br/>\n<br/>\n$ \\Longrightarrow&nbsp; \\alpha=30° \\neq \\alpha=30=-81.127°$</p>\n\n<p>&nbsp;</p>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2325,0),(2335,'html','',2325,1),(2336,'html','',2325,2),(2337,'html','',2325,3),(2338,'html','',2325,4),(2339,'html','',2325,5),(2349,'html','<h2>Physikalische Einheiten</h2>\n\n<ol>\n	<li>Ergebnisse sind immer mit Einheit anzugeben, au&szlig;er es steht explizit anders dabei.</li>\n	<li>Bei der Eingabe von Einheiten ist auf Gro&szlig;/Kleinschreibung zu achten!</li>\n	<li>Leerzeichen zwischen Zahl und Einheit st&ouml;ren nicht, sind aber auch nicht notwendig.</li>\n	<li>SI-Vorsilben werden unterst&uuml;tzt<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n</ul>\n\n<table align=\"left\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:356px; width:379px\">\n	<tbody>\n		<tr>\n			<td><strong>physikalische Gr&ouml;&szlig;e</strong></td>\n			<td><strong>physikalische Einheit</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>elektrische Spannung</td>\n			<td>Volt</td>\n			<td>V</td>\n		</tr>\n		<tr>\n			<td>elektrischer Strom</td>\n			<td>Ampere</td>\n			<td>A</td>\n		</tr>\n		<tr>\n			<td>elektrischer Widerstand</td>\n			<td>Ohm</td>\n			<td>Ohm</td>\n		</tr>\n		<tr>\n			<td>magnetischer Fluss</td>\n			<td>Volt-Sekunde</td>\n			<td>Vs</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Weber</td>\n			<td>Wb</td>\n		</tr>\n		<tr>\n			<td>(Kreis-) Frequenz / Drehzahl</td>\n			<td>pro Sekunde</td>\n			<td>s-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>min-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>Upm</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Hertz</td>\n			<td>Hz</td>\n		</tr>\n		<tr>\n			<td>Scheinleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Blindleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Wirkleistung</td>\n			<td>Watt</td>\n			<td>W</td>\n		</tr>\n		<tr>\n			<td>Drehmoment</td>\n			<td>Newton-Meter</td>\n			<td>Nm</td>\n		</tr>\n	</tbody>\n</table>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:179px; width:264px\">\n	<tbody>\n		<tr>\n			<td><strong>SI-Vorsilbe</strong></td>\n			<td><strong>Faktor</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>Giga</td>\n			<td>$10^9$</td>\n			<td>G</td>\n		</tr>\n		<tr>\n			<td>Mega</td>\n			<td>$10^6$</td>\n			<td>M</td>\n		</tr>\n		<tr>\n			<td>Kilo</td>\n			<td>$10^3$</td>\n			<td>k</td>\n		</tr>\n		<tr>\n			<td>Milli</td>\n			<td>$10^{-3}$</td>\n			<td>m</td>\n		</tr>\n		<tr>\n			<td>Mikro</td>\n			<td>$10^{-6}$</td>\n			<td>u</td>\n		</tr>\n		<tr>\n			<td>Nano</td>\n			<td>$10^{-9}$</td>\n			<td>n</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<h3><br/>\nZul&auml;ssige Eingabeformate einer elektrischen Spannung $U = {U}$ sind bspw.</h3>\n\n<ol>\n	<li>&nbsp; $U= $ 0.3V (bzw. $U= $ 0.3 V)</li>\n	<li>&nbsp;&nbsp;$U= $ 300mV</li>\n	<li>&nbsp;&nbsp;$U= $ 3e-1V</li>\n	<li>&nbsp; $U= $ 300e-3 V</li>\n	<li>&nbsp; $U= $ 3e5uV</li>\n	<li>&nbsp; $U= $ 0.0003kV</li>\n	<li>&nbsp; $U= $ 3e-4kV<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>&nbsp;Testen Sie die Eingabe f&uuml;r die elektrische Spannung $U={U}$.<br/>\n	<br/>\n	$U=$ [Q2]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Bei der Eingabe von elektrischen Widerst&auml;nden ist anstelle des Einheitensymbols $\\Omega$ das Wort Ohm zu verwenden (Bsp.: $R=$ 2200Ohm).Testen Sie die Eingabe f&uuml;r den elektrischen Wirkwiderstand $R={R}$.<br/>\n	<br/>\n	$R=$ [Q3]&nbsp;</li>\n</ul>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2342,0),(2351,'html','',2342,1),(2352,'html','',2342,2),(2353,'html','',2342,3),(2354,'html','',2342,4),(2355,'html','',2342,5),(2367,'html','<h2>Normierte Gr&ouml;&szlig;en</h2>\n\n<p>Verwenden Sie bei der Eingabe von normierten Gr&ouml;&szlig;en mindestens drei Nachkommastellen.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe der normierten elektrischen Spannung $u = {u}$<br/>\n	<br/>\n	$u=$ [Q4]&nbsp;</li>\n</ul>\n\n<p>&nbsp;\n<h2>&nbsp;</h2>\n</p>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2360,0),(2369,'html','',2360,1),(2370,'html','',2360,2),(2371,'html','',2360,3),(2372,'html','',2360,4),(2373,'html','',2360,5),(2383,'html','<h2>Eingabe analytischer L&ouml;sungen</h2>\n\n<p>LeTTo unterst&uuml;tzt analytische L&ouml;sungen. Machen Sie von der Ergebnisvorschau durch Doppelklick auf das Eingabefeld gebrauch.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe f&uuml;r $R=\\frac{ U}{ I}$<br/>\n	<br/>\n	$R= $ [Q5]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Testen Sie die Eingabe f&uuml;r $y(x)= \\frac{\\sin(x)}{ x}$<br/>\n	<br/>\n	$y(x) =$ [Q6]&nbsp;<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2376,0),(2385,'html','',2376,1),(2386,'html','',2376,2),(2387,'html','',2376,3),(2388,'html','',2376,4),(2389,'html','',2376,5),(2401,'html','<h1><strong>LeTTo-Onramp</strong></h1>\n\n<h2><strong>Herzlich Willkommen!</strong></h2>\n\n<p>In diesem interaktiven Tutorial werden</p>\n\n<ul>\n	<li>\n	<p>die Details zur Ergebniseingabe am LeTTo-Server veranschaulicht.</p>\n	</li>\n	<li>\n	<p>M&ouml;glichkeiten geboten Ergebniseingaben online zu testen.</p>\n	</li>\n</ul>\n\n<h2><br/>\nDas <strong>LeTTo-Team w&uuml;nscht viel Erfolg</strong> bei bevorstehenden Pr&uuml;fungen.</h2>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<h2>Zuordnungsfragen</h2>\n\n<div>Bei Zuordnungsfragen unterst&uuml;tzen Sie zwei Modi bei der Fragenbeantwortung.</div>\n\n<div>Moduswechsel erfolgt mit Klick auf das Symbol<br/>\n[IMG1]<br/>\nam oberen Rand des Browserfensters.</div>\n\n<ol>\n	<li>Modus: klick - klick - Zuordnung</li>\n	<li>Modus: drag &amp; drop - Zuordnung<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>Testen Sie beide Modi durch Zuordnung der Gro&szlig;- zu ihren Kleinbuchstaben.<br/>\n	<br/>\n	[Q7]&nbsp;</li>\n</ul>\n\n<h2><br/>\nDezimaltrennzeichen</h2>\n\n<p>Immer einen <strong>Punkt </strong>als Dezimaltrennzeichen verwenden!</p>\n\n<ul>\n	<li>Geben Sie die Zahl $x = {x}$ in das Ergebnisfeld ein.<br/>\n	<br/>\n	$x=$ [Q0]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>Hilfestellung bei der Eingabe - Vorschaufenster</h2>\n\n<p>Ein <strong>Doppelklick </strong>ins Eingabefeld aktiviert ein Vorschaufenster, das die Eingabe besonders &uuml;bersichtlich darstellt.</p>\n\n<ul>\n	<li>Testen Sie diese Hilfestellung durch Doppelklick auf das obige Eingabefeld.<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>Bilder-Zoom</h2>\n\n<p>Ein <strong>Doppelklick </strong>auf Graphiken innerhalb der Fragestellungen &ouml;ffnet eine vergr&ouml;&szlig;erte Ansicht der Graphik.</p>\n\n<ul>\n	<li>Testen Sie diese Hilfestellung durch Doppelklick auf das [IMG2]-Logo.</li>\n</ul>\n\n<h2>Komplexe Zahlen</h2>\n\n<p>Sie k&ouml;nnen komplexe Zahlen in unterschiedlichsten Varianten am LeTTo-Server eingeben.</p>\n\n<p>Als Demo betrachten wir eine komplexe Zahl $\\underline z$ mit<br/>\n<br/>\n$\\underline z = {z,karti} = {z,kartj}= {z, poldeg}= {z, polrad}$<br/>\n&nbsp;</p>\n\n<h3>Zul&auml;ssige Eingabenformate der Zahl $\\underline z$ sind:</h3>\n\n<ol>\n	<li>&nbsp;$\\underline z=$ 3+4j</li>\n	<li>&nbsp;$\\underline z=$ 3+4i</li>\n	<li>&nbsp;$\\underline z=$ 3+j*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*j</li>\n	<li>&nbsp;$\\underline z=$ 3+i*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*i</li>\n	<li>&nbsp;$\\underline z=$ 5arg53.13°</li>\n	<li>&nbsp;$\\underline z=$ 5arg0.9273<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>Test Sie die unterschiedlichen Eingabeformate f&uuml;r $\\underline z$<br/>\n	<br/>\n	$\\underline z =$ [Q1]&nbsp;</li>\n</ul>\n\n<p><strong>TIPP</strong>: LeTTo interpretiert Winkeleingaben ohne dem Grad Symbol \" ° \" immer als Radiant. F&uuml;r die Eingabe eines Winkels in Radiant ist somit kein explizites Einheitensymbol notwendig.<br/>\n<br/>\n$ \\Longrightarrow&nbsp; \\alpha=30° \\neq \\alpha=30=-81.127°$<br/>\n<br/>\n&nbsp;</p>\n\n<h2>Physikalische Einheiten</h2>\n\n<ol>\n	<li>Ergebnisse sind immer mit Einheit anzugeben, au&szlig;er es steht explizit anders dabei.</li>\n	<li>Bei der Eingabe von Einheiten ist auf Gro&szlig;/Kleinschreibung zu achten!</li>\n	<li>Leerzeichen zwischen Zahl und Einheit st&ouml;ren nicht, sind aber auch nicht notwendig.</li>\n	<li>SI-Vorsilben werden unterst&uuml;tzt<br/>\n	&nbsp;</li>\n</ol>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:179px; width:264px\">\n	<tbody>\n		<tr>\n			<td><strong>SI-Vorsilbe</strong></td>\n			<td><strong>Faktor</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>Giga</td>\n			<td>$10^9$</td>\n			<td>G</td>\n		</tr>\n		<tr>\n			<td>Mega</td>\n			<td>$10^6$</td>\n			<td>M</td>\n		</tr>\n		<tr>\n			<td>Kilo</td>\n			<td>$10^3$</td>\n			<td>k</td>\n		</tr>\n		<tr>\n			<td>Milli</td>\n			<td>$10^{-3}$</td>\n			<td>m</td>\n		</tr>\n		<tr>\n			<td>Mikro</td>\n			<td>$10^{-6}$</td>\n			<td>u</td>\n		</tr>\n		<tr>\n			<td>Nano</td>\n			<td>$10^{-9}$</td>\n			<td>n</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<h3><br/>\nZul&auml;ssige Eingabeformate einer elektrischen Spannung $U = {U}$ sind bspw.</h3>\n\n<ol>\n	<li>&nbsp; $U= $ 0.3V (bzw. $U= $ 0.3 V)</li>\n	<li>&nbsp;&nbsp;$U= $ 300mV</li>\n	<li>&nbsp;&nbsp;$U= $ 3e-1V</li>\n	<li>&nbsp; $U= $ 300e-3 V</li>\n	<li>&nbsp; $U= $ 3e5uV</li>\n	<li>&nbsp; $U= $ 0.0003kV</li>\n	<li>&nbsp; $U= $ 3e-4kV<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>&nbsp;Testen Sie die Eingabe f&uuml;r die elektrische Spannung $U={U}$.<br/>\n	<br/>\n	$U=$ [Q2]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Bei der Eingabe von elektrischen Widerst&auml;nden ist anstelle des Einheitensymbols $\\Omega$ das Wort Ohm zu verwenden (Bsp.: $R=$ 2200Ohm).Testen Sie die Eingabe f&uuml;r den elektrischen Wirkwiderstand $R={R}$.<br/>\n	<br/>\n	$R=$ [Q3]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h3>Zusammenfassung wichtiger Einheiten:<br/>\n&nbsp;</h3>\n\n<table align=\"left\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:356px; width:379px\">\n	<tbody>\n		<tr>\n			<td><strong>physikalische Gr&ouml;&szlig;e</strong></td>\n			<td><strong>physikalische Einheit</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>elektrische Spannung</td>\n			<td>Volt</td>\n			<td>V</td>\n		</tr>\n		<tr>\n			<td>elektrischer Strom</td>\n			<td>Ampere</td>\n			<td>A</td>\n		</tr>\n		<tr>\n			<td>elektrischer Widerstand</td>\n			<td>Ohm</td>\n			<td>Ohm</td>\n		</tr>\n		<tr>\n			<td>magnetischer Fluss</td>\n			<td>Volt-Sekunde</td>\n			<td>Vs</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Weber</td>\n			<td>Wb</td>\n		</tr>\n		<tr>\n			<td>(Kreis-) Frequenz / Drehzahl</td>\n			<td>pro Sekunde</td>\n			<td>s-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>min-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>Upm</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Hertz</td>\n			<td>Hz</td>\n		</tr>\n		<tr>\n			<td>Scheinleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Blindleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Wirkleistung</td>\n			<td>Watt</td>\n			<td>W</td>\n		</tr>\n		<tr>\n			<td>Drehmoment</td>\n			<td>Newton-Meter</td>\n			<td>Nm</td>\n		</tr>\n	</tbody>\n</table>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<h2>Normierte Gr&ouml;&szlig;en</h2>\n\n<p>Verwenden Sie bei der Eingabe von normierten Gr&ouml;&szlig;en mindestens drei Nachkommastellen.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe der normierten elektrischen Spannung $u = {u}$<br/>\n	<br/>\n	$u=$ [Q4]&nbsp;</li>\n</ul>\n\n<p>&nbsp;</p>\n\n<h2>Eingabe analytischer L&ouml;sungen</h2>\n\n<p>LeTTo unterst&uuml;tzt analytische L&ouml;sungen. Machen Sie von der Ergebnisvorschau durch Doppelklick auf das Eingabefeld gebrauch.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe f&uuml;r $R=\\frac{ U}{ I}$<br/>\n	<br/>\n	$R= $ [Q5]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Testen Sie die Eingabe f&uuml;r $y(x)= \\frac{\\sin(x)}{ x}$<br/>\n	<br/>\n	$y(x) =$ [Q6]&nbsp;<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2394,0),(2405,'html','',2394,1),(2406,'html','',2394,2),(2407,'html','',2394,3),(2408,'html','',2394,4),(2409,'html','',2394,5),(2435,'html','<h1><strong>LeTTo-Onramp</strong></h1>\n\n<h2><strong>Herzlich Willkommen!</strong></h2>\n\n<p>In diesem interaktiven Tutorial werden</p>\n\n<ul>\n	<li>\n	<p>die Details zur Ergebniseingabe am LeTTo-Server veranschaulicht.</p>\n	</li>\n	<li>\n	<p>M&ouml;glichkeiten geboten Ergebniseingaben online zu testen.</p>\n	</li>\n</ul>\n\n<h2><br/>\nDas <strong>LeTTo-Team w&uuml;nscht viel Erfolg</strong> bei bevorstehenden Pr&uuml;fungen.</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>Dezimaltrennzeichen</h2>\n\n<p>Immer einen <strong>Punkt </strong>als Dezimaltrennzeichen verwenden!</p>\n\n<ul>\n	<li>Geben Sie die Zahl $x = {x}$ in das Ergebnisfeld ein.<br/>\n	<br/>\n	$x=$ [Q0]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>Hilfestellung bei der Eingabe - Vorschaufenster</h2>\n\n<p>Ein <strong>Doppelklick </strong>ins Eingabefeld aktiviert ein Vorschaufenster, das die Eingabe besonders &uuml;bersichtlich darstellt.</p>\n\n<ul>\n	<li>Testen Sie diese Hilfestellung durch Doppelklick auf das obige Eingabefeld.<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>Komplexe Zahlen</h2>\n\n<p>Sie k&ouml;nnen komplexe Zahlen in unterschiedlichsten Varianten am LeTTo-Server eingeben.</p>\n\n<p>Als Demo betrachten wir eine komplexe Zahl $\\underline z$ mit<br/>\n<br/>\n$\\underline z = {z,karti} = {z,kartj}= {z, poldeg}= {z, polrad}$<br/>\n&nbsp;</p>\n\n<h3>Zul&auml;ssige Eingabenformate der Zahl $\\underline z$ sind:</h3>\n\n<ol>\n	<li>&nbsp;$\\underline z=$ 3+4j</li>\n	<li>&nbsp;$\\underline z=$ 3+4i</li>\n	<li>&nbsp;$\\underline z=$ 3+j*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*j</li>\n	<li>&nbsp;$\\underline z=$ 3+i*4</li>\n	<li>&nbsp;$\\underline z=$ 3+4*i</li>\n	<li>&nbsp;$\\underline z=$ 5arg53.13°</li>\n	<li>&nbsp;$\\underline z=$ 5arg0.9273<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>Test Sie die unterschiedlichen Eingabeformate f&uuml;r $\\underline z$<br/>\n	<br/>\n	$\\underline z =$ [Q1]&nbsp;</li>\n</ul>\n\n<p><strong>TIPP</strong>: LeTTo interpretiert Winkeleingaben ohne dem Grad Symbol \" ° \" immer als Radiant. F&uuml;r die Eingabe eines Winkels in Radiant ist somit kein explizites Einheitensymbol notwendig.<br/>\n<br/>\n$ \\Longrightarrow&nbsp; \\alpha=30° \\neq \\alpha=30=-81.127°$<br/>\n<br/>\n&nbsp;</p>\n\n<h2>Physikalische Einheiten</h2>\n\n<ol>\n	<li>Ergebnisse sind immer mit Einheit anzugeben, au&szlig;er es steht explizit anders dabei.</li>\n	<li>Bei der Eingabe von Einheiten ist auf Gro&szlig;/Kleinschreibung zu achten!</li>\n	<li>Leerzeichen zwischen Zahl und Einheit st&ouml;ren nicht, sind aber auch nicht notwendig.</li>\n	<li>SI-Vorsilben werden unterst&uuml;tzt<br/>\n	&nbsp;</li>\n</ol>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:179px; width:264px\">\n	<tbody>\n		<tr>\n			<td><strong>SI-Vorsilbe</strong></td>\n			<td><strong>Faktor</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>Giga</td>\n			<td>$10^9$</td>\n			<td>G</td>\n		</tr>\n		<tr>\n			<td>Mega</td>\n			<td>$10^6$</td>\n			<td>M</td>\n		</tr>\n		<tr>\n			<td>Kilo</td>\n			<td>$10^3$</td>\n			<td>k</td>\n		</tr>\n		<tr>\n			<td>Milli</td>\n			<td>$10^{-3}$</td>\n			<td>m</td>\n		</tr>\n		<tr>\n			<td>Mikro</td>\n			<td>$10^{-6}$</td>\n			<td>u</td>\n		</tr>\n		<tr>\n			<td>Nano</td>\n			<td>$10^{-9}$</td>\n			<td>n</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<h3><br/>\nZul&auml;ssige Eingabeformate einer elektrischen Spannung $U = {U}$ sind bspw.</h3>\n\n<ol>\n	<li>&nbsp; $U= $ 0.3V (bzw. $U= $ 0.3 V)</li>\n	<li>&nbsp;&nbsp;$U= $ 300mV</li>\n	<li>&nbsp;&nbsp;$U= $ 3e-1V</li>\n	<li>&nbsp; $U= $ 300e-3 V</li>\n	<li>&nbsp; $U= $ 3e5uV</li>\n	<li>&nbsp; $U= $ 0.0003kV</li>\n	<li>&nbsp; $U= $ 3e-4kV<br/>\n	&nbsp;</li>\n</ol>\n\n<ul>\n	<li>&nbsp;Testen Sie die Eingabe f&uuml;r die elektrische Spannung $U={U}$.<br/>\n	<br/>\n	$U=$ [Q2]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Bei der Eingabe von elektrischen Widerst&auml;nden ist anstelle des Einheitensymbols $\\Omega$ das Wort Ohm zu verwenden (Bsp.: $R=$ 2200Ohm).Testen Sie die Eingabe f&uuml;r den elektrischen Wirkwiderstand $R={R}$.<br/>\n	<br/>\n	$R=$ [Q3]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n</ul>\n\n<h3>Zusammenfassung wichtiger Einheiten:<br/>\n&nbsp;</h3>\n\n<table align=\"left\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:356px; width:379px\">\n	<tbody>\n		<tr>\n			<td><strong>physikalische Gr&ouml;&szlig;e</strong></td>\n			<td><strong>physikalische Einheit</strong></td>\n			<td><strong>LeTTo</strong></td>\n		</tr>\n		<tr>\n			<td>elektrische Spannung</td>\n			<td>Volt</td>\n			<td>V</td>\n		</tr>\n		<tr>\n			<td>elektrischer Strom</td>\n			<td>Ampere</td>\n			<td>A</td>\n		</tr>\n		<tr>\n			<td>elektrischer Widerstand</td>\n			<td>Ohm</td>\n			<td>Ohm</td>\n		</tr>\n		<tr>\n			<td>magnetischer Fluss</td>\n			<td>Volt-Sekunde</td>\n			<td>Vs</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Weber</td>\n			<td>Wb</td>\n		</tr>\n		<tr>\n			<td>(Kreis-) Frequenz / Drehzahl</td>\n			<td>pro Sekunde</td>\n			<td>s-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>min-1</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>pro Minute</td>\n			<td>Upm</td>\n		</tr>\n		<tr>\n			<td>&nbsp;</td>\n			<td>Hertz</td>\n			<td>Hz</td>\n		</tr>\n		<tr>\n			<td>Scheinleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Blindleistung</td>\n			<td>Volt-Ampere</td>\n			<td>VA</td>\n		</tr>\n		<tr>\n			<td>Wirkleistung</td>\n			<td>Watt</td>\n			<td>W</td>\n		</tr>\n		<tr>\n			<td>Drehmoment</td>\n			<td>Newton-Meter</td>\n			<td>Nm</td>\n		</tr>\n	</tbody>\n</table>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p><br/>\n<br/>\n&nbsp;</p>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<h2>Normierte Gr&ouml;&szlig;en</h2>\n\n<p>Verwenden Sie bei der Eingabe von normierten Gr&ouml;&szlig;en mindestens drei Nachkommastellen.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe der normierten elektrischen Spannung $u = {u}$<br/>\n	<br/>\n	$u=$ [Q4]&nbsp;</li>\n</ul>\n\n<p>&nbsp;</p>\n\n<h2>Eingabe analytischer L&ouml;sungen</h2>\n\n<p>LeTTo unterst&uuml;tzt analytische L&ouml;sungen. Machen Sie von der Ergebnisvorschau durch Doppelklick auf das Eingabefeld gebrauch.</p>\n\n<ul>\n	<li>Testen Sie die Eingabe f&uuml;r $R=\\frac{ U}{ I}$<br/>\n	<br/>\n	$R= $ [Q5]&nbsp;<br/>\n	&nbsp;</li>\n	<li>Testen Sie die Eingabe f&uuml;r $y(x)= \\frac{\\sin(x)}{ x}$<br/>\n	<br/>\n	$y(x) =$ [Q6]&nbsp;<br/>\n	&nbsp;</li>\n</ul>\n\n<h2>&nbsp;</h2>\n\n<p>&nbsp;</p>\n\n<h2>Hilfe zur Eingabe</h2>\n\n<p>Hilfe zur Eingabe finden Sie in der rechten oberen Ecke Ihres Browserfensters [IMG0]</p>',2428,0),(2437,'html','',2428,1),(2438,'html','',2428,2),(2439,'html','',2428,3),(2440,'html','',2428,4),(2441,'html','',2428,5),(2462,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - toarrow</h1>\n\n<ul>\n	<li>Geben sie einen Vektor mit Betrag 5 und einem Winkel von 45° ein</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2460,0),(2463,'html','',2460,1),(2464,'html','',2460,2),(2465,'html','',2460,3),(2466,'html','',2460,4),(2467,'html','',2460,5),(2475,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - topoint</h1>\n\n<ul>\n	<li>Zeichnen Sie mit der Anfangstangente die Zeitbasis der Funktion ein!</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2470,0),(2476,'html','',2470,1),(2477,'html','',2470,2),(2478,'html','',2470,3),(2479,'html','',2470,4),(2480,'html','',2470,5),(2486,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - point</h1>\n\n<ul>\n	<li>Geben Sie den Punkt {P}&nbsp;ein.</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>\n\n<p>&nbsp;</p>',2483,0),(2487,'html','',2483,1),(2488,'html','',2483,2),(2489,'html','',2483,3),(2490,'html','',2483,4),(2491,'html','',2483,5),(2499,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - points</h1>\n\n<ul>\n	<li>Geben Sie die Punkte {P},{P1},{P2} ein:</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2494,0),(2500,'html','',2494,1),(2501,'html','',2494,2),(2502,'html','',2494,3),(2503,'html','',2494,4),(2504,'html','',2494,5),(2511,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - measure</h1>\n\n<ul>\n	<li>Messen Sie den Punktabstand der beiden Punkte!</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2507,0),(2512,'html','',2507,1),(2513,'html','',2507,2),(2514,'html','',2507,3),(2515,'html','',2507,4),(2516,'html','',2507,5),(2524,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - polygon</h1>\n\n<ul>\n	<li>Zeichnen Sie ein Dreieck mit den Koordinaten $A = {A}$ $B = {B}$ $C = {C}$</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2519,0),(2525,'html','',2519,1),(2526,'html','',2519,2),(2527,'html','',2519,3),(2528,'html','',2519,4),(2529,'html','',2519,5),(2537,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - polygon</h1>\n\n<ul>\n	<li>Zeichnen Sie ein Rechteck mit den Eckpunkten&nbsp;$A = {A}$ $C&nbsp;= {=B}$ in horizontaler Lage.</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2532,0),(2538,'html','',2532,1),(2539,'html','',2532,2),(2540,'html','',2532,3),(2541,'html','',2532,4),(2542,'html','',2532,5),(2547,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - line</h1>\n\n<ul>\n	<li>Zeichnen Sie die Gerade {=G}</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2545,0),(2548,'html','',2545,1),(2549,'html','',2545,2),(2550,'html','',2545,3),(2551,'html','',2545,4),(2552,'html','',2545,5),(2557,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - lines</h1>\n\n<ul>\n	<li>Zeichnen Sie die Gerade {=G}</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2555,0),(2558,'html','',2555,1),(2559,'html','',2555,2),(2560,'html','',2555,3),(2561,'html','',2555,4),(2562,'html','',2555,5),(2567,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - function</h1>\n\n<ul>\n	<li>Zeichnen Sie die Funktion {=G} mit mindestens 5&nbsp;Punkten.</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2565,0),(2568,'html','',2565,1),(2569,'html','',2565,2),(2570,'html','',2565,3),(2571,'html','',2565,4),(2572,'html','',2565,5),(2577,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - points mit Funktion</h1>\n\n<ul>\n	<li>Zeichnen Sie die Funktion $y={=G}$ mit mindestens 5&nbsp;Punkten</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2575,0),(2578,'html','',2575,1),(2579,'html','',2575,2),(2580,'html','',2575,3),(2581,'html','',2575,4),(2582,'html','',2575,5),(2589,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - hline</h1>\n\n<ul>\n	<li>Zeichnen Sie den Spitzenwert der Spannung ein.</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2585,0),(2590,'html','',2585,1),(2591,'html','',2585,2),(2592,'html','',2585,3),(2593,'html','',2585,4),(2594,'html','',2585,5),(2601,'html','<h1>Plot Plugin - interaktive Eingabe - direkte Auswertung - vline</h1>\n\n<ul>\n	<li>Zeichnen Sie die erste Periodendauer $T$ der Schwingung ein!</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2597,0),(2602,'html','',2597,1),(2603,'html','',2597,2),(2604,'html','',2597,3),(2605,'html','',2597,4),(2606,'html','',2597,5),(2612,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - Vektoren</h1>\n\n<ul>\n	<li>Zeichnen Sie die Auflagerkr&auml;fte ein. Zeichnen Sie die Pfeilspitze der Kraft in den Lagerangriffspunkt! [Q1] [Q2]&nbsp;</li>\n</ul>\n\n<p>[Q0]</p>',2610,0),(2614,'html','',2610,1),(2615,'html','',2610,2),(2616,'html','',2610,3),(2617,'html','',2610,4),(2618,'html','',2610,5),(2630,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - points</h1>\n\n<ul>\n	<li>Zeichnen Sie die Nullstellen der Funktion ein!</li>\n</ul>\n\n<p>[Q0]&nbsp;&nbsp;[Q1]&nbsp; [Q2] [Q3]&nbsp;&nbsp;[Q4]&nbsp;&nbsp;</p>',2625,0),(2631,'html','',2625,1),(2632,'html','',2625,2),(2633,'html','',2625,3),(2634,'html','',2625,4),(2635,'html','',2625,5),(2652,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - toline</h1>\n\n<ul>\n	<li>Geben Sie eine Gerade mit einer Steigung von 2 ein</li>\n</ul>\n\n<p>[Q0]&nbsp;&nbsp;[Q1]</p>',2649,0),(2653,'html','',2649,1),(2654,'html','',2649,2),(2655,'html','',2649,3),(2656,'html','',2649,4),(2657,'html','',2649,5),(2668,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - Funktion</h1>\n\n<ul>\n	<li>Zeichnen Sie die angegebene Funktion m&ouml;glichst gut nach.</li>\n</ul>\n\n<p>[Q0]&nbsp;&nbsp;&nbsp;[Q1]&nbsp;</p>\n\n<p>&nbsp;</p>',2662,0),(2669,'html','',2662,1),(2670,'html','',2662,2),(2671,'html','',2662,3),(2672,'html','',2662,4),(2673,'html','',2662,5),(2683,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - Funktion</h1>\n\n<ul>\n	<li>Zeichnen Sie die angegebene Funktion m&ouml;glichst gut nach.</li>\n</ul>\n\n<p>[Q0]&nbsp;&nbsp;&nbsp;[Q1]&nbsp;</p>\n\n<p>&nbsp;</p>',2681,0),(2684,'html','',2681,1),(2685,'html','',2681,2),(2686,'html','',2681,3),(2687,'html','',2681,4),(2688,'html','',2681,5),(2698,'html','<h1>Plot Plugin - interaktive Eingabe - boolsche Auswertung - point</h1>\n\n<ul>\n	<li>Geben Sie einen beliebigen Punkt im 3. Quadranten ein</li>\n</ul>\n\n<p>[Q0]&nbsp;&nbsp;[Q1]&nbsp;</p>',2696,0),(2699,'html','',2696,1),(2700,'html','',2696,2),(2701,'html','',2696,3),(2702,'html','',2696,4),(2703,'html','',2696,5),(2709,'html','<h1>Plot-Plugin - interaktive Eingabe - point</h1>\n\n<ul>\n	<li>Geben Sie den Punkt {=P} an!</li>\n</ul>\n\n<p>[Q0] [Q1]</p>\n\n<ul>\n	<li>Geben Sie den Punkt {=P} an!</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]&nbsp;</p>',2708,0),(2710,'html','',2708,1),(2711,'html','',2708,2),(2712,'html','',2708,3),(2713,'html','',2708,4),(2714,'html','',2708,5),(2724,'html','<h1>Plot-Plugin - interaktive Eingabe - points</h1>\n\n<ul>\n	<li>Markieren Sie die Eckpunkte des Dreiecks!</li>\n</ul>\n\n<p>[Q0] [Q1]</p>\n\n<ul>\n	<li>Markieren Sie die Eckpunkte des Dreiecks!</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>',2723,0),(2725,'html','',2723,1),(2726,'html','',2723,2),(2727,'html','',2723,3),(2728,'html','',2723,4),(2729,'html','',2723,5),(2739,'html','<h1>Plot-Plugin - interaktive Eingabe - measure</h1>\n\n<ul>\n	<li>Messen Sie den Abstand der Punkte!</li>\n</ul>\n\n<p>[Q0] [Q1]</p>\n\n<ul>\n	<li>Messen Sie den Abstand der Punkte!</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]&nbsp;</p>',2738,0),(2740,'html','',2738,1),(2741,'html','',2738,2),(2742,'html','',2738,3),(2743,'html','',2738,4),(2744,'html','',2738,5),(2756,'html','<h1>Plot-Plugin - interaktive Eingabe - line</h1>\n\n<ul>\n	<li>Zeichnen Sie&nbsp;die Linie {=G}&nbsp;</li>\n</ul>\n\n<p>[Q0]</p>\n\n<ul>\n	<li>Zeichnen Sie&nbsp;die Linie {=G}&nbsp;</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]&nbsp;</p>',2753,0),(2757,'html','',2753,1),(2758,'html','',2753,2),(2759,'html','',2753,3),(2760,'html','',2753,4),(2761,'html','',2753,5),(2771,'html','<h1>Plot-Plugin - interaktive Eingabe - lines</h1>\n\n<ul>\n	<li>Zeichnen Sie&nbsp;zwei parallel Geraden&nbsp;</li>\n</ul>\n\n<p>[Q0]&nbsp;[Q1]&nbsp;</p>',2768,0),(2772,'html','',2768,1),(2773,'html','',2768,2),(2774,'html','',2768,3),(2775,'html','',2768,4),(2776,'html','',2768,5),(2782,'html','<h1>Plot-Plugin - interaktive Eingabe - hline</h1>\n\n<ul>\n	<li>Geben Sie&nbsp;die y-Koordinate y=3 an!</li>\n</ul>\n\n<p>[Q0] [Q1]</p>\n\n<ul>\n	<li>Geben Sie&nbsp;die y-Koordinate y=4 an!</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]&nbsp;</p>',2781,0),(2783,'html','',2781,1),(2784,'html','',2781,2),(2785,'html','',2781,3),(2786,'html','',2781,4),(2787,'html','',2781,5),(2797,'html','<h1>Plot-Plugin - interaktive Eingabe - vline</h1>\n\n<ul>\n	<li>Geben Sie&nbsp;die x-Koordinate x=3 an!</li>\n</ul>\n\n<p>[Q0] [Q1]</p>\n\n<ul>\n	<li>Geben Sie&nbsp;die x-Koordinate x=4 an!</li>\n</ul>\n\n<p>[Q2]&nbsp;&nbsp;[Q3]&nbsp;</p>',2796,0),(2798,'html','',2796,1),(2799,'html','',2796,2),(2800,'html','',2796,3),(2801,'html','',2796,4),(2802,'html','',2796,5),(2814,'html','<h1>Plot Plugin - stumme Karte</h1>\n\n<ul>\n	<li>Wo liegt der Inn?</li>\n</ul>\n\n<p>[Q0]&nbsp;</p>',2812,0),(2816,'html','',2812,1),(2817,'html','',2812,2),(2818,'html','',2812,3),(2819,'html','',2812,4),(2820,'html','',2812,5),(2825,'html','<h1>Plot Plugin - stumme Karte</h1>\n\n<ul>\n	<li>Markieren Sie die Lager der angegebenen Anordnung!</li>\n</ul>\n\n<p>[Q0]</p>\n\n<p>&nbsp;</p>',2823,0),(2827,'html','',2823,1),(2828,'html','',2823,2),(2829,'html','',2823,3),(2830,'html','',2823,4),(2831,'html','',2823,5),(2845,'html','<h1>Plot Plugin - stumme Karte dynamisch</h1>\n\n<ul>\n	<li>Markieren Sie den Tiefpunkt der Funktion $y(x)={=y}$</li>\n</ul>\n\n<p>[Q0]</p>',2834,0),(2846,'html','',2834,1),(2847,'html','',2834,2),(2848,'html','',2834,3),(2849,'html','',2834,4),(2850,'html','',2834,5),(2855,'html','<h1>M&ouml;gliche Cursor-Darstellungen im Plot-Plugin</h1>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\">\n	<tbody>\n		<tr>\n			<td>STANDARD:[PIG Plugin1/]</td>\n			<td>OFF: [PIG Plugin1 \"cursor=off\"/]</td>\n			<td>ON: [PIG Plugin1 \"cursor=on\"/]</td>\n		</tr>\n		<tr>\n			<td>NUMBERS: [PIG Plugin1 \"cursor=numbers\"/]</td>\n			<td>CNUM: [PIG Plugin1 \"cursor=cnum\"/]</td>\n			<td>CARG: [PIG Plugin1 \"cursor=carg\"/]</td>\n		</tr>\n		<tr>\n			<td>POINT: [PIG Plugin1 \"cursor=point\"/]</td>\n			<td>PNUM: [PIG Plugin1 \"cursor=pnum\"/]</td>\n			<td>PARG: [PIG Plugin1 \"cursor=parg\"/]</td>\n		</tr>\n		<tr>\n			<td>HLINE: [PIG Plugin1 \"cursor=hline\"/]</td>\n			<td>HNUM: [PIG Plugin1 \"cursor=hnum\"/]</td>\n			<td>PIXEL: [PIG Plugin1 \"cursor=pixel\"/]</td>\n		</tr>\n		<tr>\n			<td>VLINE: [PIG Plugin1 \"cursor=vline\"/]</td>\n			<td>VNUM: [PIG Plugin1 \"cursor=vnum\"/]</td>\n			<td>ALL: [PIG Plugin1 \"cursor=all\"/]</td>\n		</tr>\n		<tr>\n			<td>CREL: [PIG Plugin1 \"cursor=crel;input=points\"/]</td>\n			<td>&nbsp;</td>\n			<td>&nbsp;</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>',2853,0),(2856,'html','',2853,1),(2857,'html','',2853,2),(2858,'html','',2853,3),(2859,'html','',2853,4),(2860,'html','',2853,5),(2863,'html','<h1>Plot Plugin - Fl&auml;chenf&uuml;llung</h1>\n\n<p>[PIG Plugin1 \"w30h\"/]</p>\n\n<ul>\n	<li>Berechnen Sie die markierte Fl&auml;che $A$.<br/>\n	<br/>\n	$A=$ [Q0]&nbsp;</li>\n</ul>',2861,0),(2864,'html','',2861,1),(2865,'html','',2861,2),(2866,'html','',2861,3),(2867,'html','',2861,4),(2868,'html','',2861,5),(2875,'html','<h1>Plot Plugin - Bodediagramm interaktiv mit klassischer Auswertung</h1>\n\n<ul>\n	<li>Ermitteln Sie mittels der Tangentenmethode die beiden Zeitkonstanten der &Uuml;bertragungsfunktion!</li>\n</ul>\n\n<p>[PIG Plugin1 \"w50;input=lines\"/]</p>\n\n<p>Zeitkonstanten durch Beistrich getrennt eingeben: [Q0]&nbsp;</p>',2871,0),(2876,'html','',2871,1),(2877,'html','',2871,2),(2878,'html','',2871,3),(2879,'html','',2871,4),(2880,'html','',2871,5),(2892,'html','<h1>Plot Plugin - interaktive Eingabe - normale Auswertung</h1>\n\n<p>[PIG Plugin1 \"w50h;input=measure\"/]</p>\n\n<ul>\n	<li>Messen Sie den Absolutbetrag des Winkels AB/AC [Q0]<br/>\n	&nbsp;</li>\n	<li>Messe den Abstand BC [Q1]&nbsp;</li>\n</ul>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>',2884,0),(2893,'html','',2884,1),(2894,'html','',2884,2),(2895,'html','',2884,3),(2896,'html','',2884,4),(2897,'html','',2884,5),(2912,'html','<h1>Gemischte Br&uuml;che</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung\" target=\"_blank\">Zahlendarstellung-Wiki</a></p>\n\n<ul>\n	<li>Schreiben Sie das Ergebnis als gemischte Zahl (zB.: 3 2/5)</li>\n</ul>\n\n<p>{=B1,frac}+{=B2,frac} = [Q0]&nbsp;</p>',2904,0),(2913,'html','',2904,1),(2914,'html','',2904,2),(2915,'html','',2904,3),(2916,'html','',2904,4),(2917,'html','',2904,5),(2922,'html','<h1>Termdarstellung ohne Malpunkt</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung\" target=\"_blank\">Zahlendarstellung-Wiki</a></p>\n\n<p>Bei der vereinfachten Term-Darstellung werden alle Malpunkte zwischen Variablen und Zahlenwerten weggelassen.</p>\n\n<p>{=:f;term} = [Q0]&nbsp;</p>',2920,0),(2923,'html','',2920,1),(2924,'html','',2920,2),(2925,'html','',2920,3),(2926,'html','',2920,4),(2927,'html','',2920,5),(2932,'html','<h1>Nachkommastellen</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung\" target=\"_blank\">Zahlendarstellung-Wiki</a></p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>normale Darstellung</td>\n			<td>&nbsp;</td>\n			<td>{=x}</td>\n			<td>{=y}</td>\n		</tr>\n		<tr>\n			<td>Zahl mit maximal 4 f&uuml;hrenden Ziffern</td>\n			<td>;4</td>\n			<td>{=x;4}</td>\n			<td>{=y;4}</td>\n		</tr>\n		<tr>\n			<td>Gleitkommazahl mit maximal 4 f&uuml;hrenden Ziffern</td>\n			<td>;f4</td>\n			<td>{=x;f4}</td>\n			<td>{=y;f4}</td>\n		</tr>\n		<tr>\n			<td>Gleitkommazahl mit genau 4 f&uuml;hrenden Ziffern</td>\n			<td>;F4</td>\n			<td>{=x;F4}</td>\n			<td>{=y;F4}</td>\n		</tr>\n		<tr>\n			<td>Kommazahl mit maximal 4 f&uuml;hrenden Ziffern</td>\n			<td>;r4</td>\n			<td>{=x;r4}</td>\n			<td>{=y;r4}</td>\n		</tr>\n		<tr>\n			<td>Kommazahl mit genau 4 f&uuml;hrenden Ziffern</td>\n			<td>;R4</td>\n			<td>{=x;R4}</td>\n			<td>{=y;R4}</td>\n		</tr>\n		<tr>\n			<td>Kommazahl mit maximal 5 Nachkommastellen</td>\n			<td>;a5</td>\n			<td>{=x;a5}</td>\n			<td>{=y;a5}</td>\n		</tr>\n		<tr>\n			<td>Kommazahl mit genau 5 Nachkommastellen</td>\n			<td>;A5</td>\n			<td>{=x;A5}</td>\n			<td>{=y;A5}</td>\n		</tr>\n		<tr>\n			<td>Exponentialschreibweise mit maximal 5 Nachkommastellen</td>\n			<td>;e5</td>\n			<td>{=x;e5}</td>\n			<td>{=y;e5}</td>\n		</tr>\n		<tr>\n			<td>Exponentialschreibweise mit genau 5 Nachkommastellen</td>\n			<td>;E5</td>\n			<td>{=x;E5}</td>\n			<td>{=y;E5}</td>\n		</tr>\n	</tbody>\n</table>',2930,0),(2933,'html','',2930,1),(2934,'html','',2930,2),(2935,'html','',2930,3),(2936,'html','',2930,4),(2937,'html','',2930,5),(2942,'html','<h1>Vektoren</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung\" target=\"_blank\">Zahlendarstellung-Wiki</a></p>\n\n<p>Intern verwendet LeTTo f&uuml;r Mengen, Listen und Vektoren den gleichen Datentyp. Es ist deshalb m&ouml;glich, Mengen als Vektoren und umgekehrt darzustellen.</p>\n\n<p>normal: {=v}</p>\n\n<div>set: {=v;set}</div>\n\n<p>line: {=v;line}</p>\n\n<p>input: {=v;input}</p>\n\n<p>list: {=v;list}<br/>\n&nbsp;</p>\n\n<h1>Matrizen</h1>\n\n<p>normal: {=M}</p>\n\n<p>set: {=M;set}</p>\n\n<p>line: {=M;line}</p>\n\n<p>input: {=M;input}</p>',2940,0),(2943,'html','',2940,1),(2944,'html','',2940,2),(2945,'html','',2940,3),(2946,'html','',2940,4),(2947,'html','',2940,5),(2955,'html','<h1>Komplexe Zahlen</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/ZielEinheit\" target=\"_blank\">Zieleinheit-komplexe Zahlen-Wiki</a></p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pol</td>\n			<td>{a;pol}</td>\n			<td>{b;pol}</td>\n			<td>{c;pol}</td>\n			<td>{d;pol}</td>\n			<td>{e;pol}</td>\n		</tr>\n		<tr>\n			<td>poli</td>\n			<td>{a;poli}</td>\n			<td>{b;poli}</td>\n			<td>{c;poli}</td>\n			<td>{d;poli}</td>\n			<td>{e;poli}</td>\n		</tr>\n		<tr>\n			<td>polj</td>\n			<td>{a;polj}</td>\n			<td>{b;polj}</td>\n			<td>{c;polj}</td>\n			<td>{d;polj}</td>\n			<td>{e;polj}</td>\n		</tr>\n		<tr>\n			<td>polrad</td>\n			<td>{a;polrad}</td>\n			<td>{b;polrad}</td>\n			<td>{c;polrad}</td>\n			<td>{d;polrad}</td>\n			<td>{e;polrad}</td>\n		</tr>\n		<tr>\n			<td>poldeg</td>\n			<td>{a;polgrad}</td>\n			<td>{b;polgrad}</td>\n			<td>{c;polgrad}</td>\n			<td>{d;polgrad}</td>\n			<td>{e;polgrad}</td>\n		</tr>\n		<tr>\n			<td>kart</td>\n			<td>{a;kart}</td>\n			<td>{b;kart}</td>\n			<td>{c;kart}</td>\n			<td>{d;kart}</td>\n			<td>{e;kart}</td>\n		</tr>\n		<tr>\n			<td>karti</td>\n			<td>{a;karti}</td>\n			<td>{b;karti}</td>\n			<td>{c;karti}</td>\n			<td>{d;karti}</td>\n			<td>{e;karti}</td>\n		</tr>\n		<tr>\n			<td>kartj</td>\n			<td>{a;kartj}</td>\n			<td>{b;kartj}</td>\n			<td>{c;kartj}</td>\n			<td>{d;kartj}</td>\n			<td>{e;kartj}</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>',2948,0),(2956,'html','',2948,1),(2957,'html','',2948,2),(2958,'html','',2948,3),(2959,'html','',2948,4),(2960,'html','',2948,5),(2963,'html','<h1>Polynome</h1>\n\n<p>siehe dazu <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung#f.C3.BCr_Polynome_und_gebrochen_rationale_Funktionen_mit_numerischen_Koeffizienten_in_einer_Variablen_k.C3.B6nnen_folgende_Parameter_angegeben_werden\" target=\"_blank\">Polynome-Darstellung-Wiki</a></p>\n\n<p>M&ouml;gliche Darstellungen f&uuml;r das Polynom {=:p1}</p>\n\n<ul>\n	<li>Mit Pol- und Nullstellen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnPN1</td>\n			<td>{=p;pnPN1}&nbsp;</td>\n			<td>pnPN</td>\n			<td>{=p;pnPN}&nbsp;</td>\n		</tr>\n	</tbody>\n</table>\n\n<ul>\n	<li>Mit positiven Potenzen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnF1</td>\n			<td>{=p;pnF1}</td>\n			<td>pnFn</td>\n			<td>{=p;pnFn}</td>\n		</tr>\n		<tr>\n			<td>pnF1F</td>\n			<td>{=p;pnF1F}</td>\n			<td>pnFnF</td>\n			<td>{=p;pnFnF}</td>\n		</tr>\n		<tr>\n			<td>pnN1</td>\n			<td>{=p;pnN1}</td>\n			<td>pnNn</td>\n			<td>{=p;pnNn}</td>\n		</tr>\n		<tr>\n			<td>pnN1F</td>\n			<td>{=p;pnN1F}</td>\n			<td>pnNnF</td>\n			<td>{=p;pnNnF}</td>\n		</tr>\n		<tr>\n			<td>pnZ1</td>\n			<td>{=p;pnZ1}</td>\n			<td>pnZn</td>\n			<td>{=p;pnZn}</td>\n		</tr>\n		<tr>\n			<td>pnZ1F</td>\n			<td>{=p;pnZ1F}</td>\n			<td>pnZnF</td>\n			<td>{=p;pnZnF}</td>\n		</tr>\n	</tbody>\n</table>\n\n<ul>\n	<li>Mit negativen Potenzen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnF1i</td>\n			<td>{=p;pnF1i}</td>\n			<td>pnFni</td>\n			<td>{=p;pnFni}</td>\n		</tr>\n		<tr>\n			<td>pnF1Fi</td>\n			<td>{=p;pnF1Fi}</td>\n			<td>pnFnFi</td>\n			<td>{=p;pnFnFi}</td>\n		</tr>\n		<tr>\n			<td>pnN1i</td>\n			<td>{=p;pnN1i}</td>\n			<td>pnNni</td>\n			<td>{=p;pnNni}</td>\n		</tr>\n		<tr>\n			<td>pnN1Fi</td>\n			<td>{=p;pnN1Fi}</td>\n			<td>pnNnFi</td>\n			<td>{=p;pnNnFi}</td>\n		</tr>\n		<tr>\n			<td>pnZ1i</td>\n			<td>{=p;pnZ1i}</td>\n			<td>pnZni</td>\n			<td>{=p;pnZni}</td>\n		</tr>\n		<tr>\n			<td>pnZ1Fi</td>\n			<td>{=p;pnZ1Fi}</td>\n			<td>pnZnFi</td>\n			<td>{=p;pnZnFi}</td>\n		</tr>\n	</tbody>\n</table>',2961,0),(2964,'html','',2961,1),(2965,'html','',2961,2),(2966,'html','',2961,3),(2967,'html','',2961,4),(2968,'html','',2961,5),(2971,'html','<p>[PIG Plugin1 \"w40h\"/]</p>\n\n<p>Punktemenge: {=M}</p>\n\n<p>Punkte: {=vget(M,0)} {=vget(M,1)} {=vget(M,2)} {=vget(M,3)}</p>\n\n<p>Punkteanzahl: {=pvpoints(M)}</p>\n\n<p>Gerade1:</p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>Gerade1</td>\n			<td>{=pvline(M,0)}</td>\n			<td>k={=pvlinek(M,0)} d={=pvlined(M,0)}</td>\n		</tr>\n		<tr>\n			<td>Gerade2</td>\n			<td>{=pvline(M,1)}</td>\n			<td>k={=pvlinek(M,1)} d={=pvlined(M,1)}</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>L&auml;nge P0-P1 : {=pvlineabs(M,0)} Winkel: {=pvlinearg(M,0);=°}</p>\n\n<p>L&auml;nge P2-P3 : {=pvlineabs(M,1)} Winkel: {=pvlinearg(M,1);=°}</p>\n\n<p>Vektor aus P0-P1&nbsp; {=pvvect(M,0)}</p>\n\n<p>Vektor aus P2-P3&nbsp; {=pvvect(M,1)}</p>\n\n<p>Summe aller Betr&auml;ge der Strecken: {=pvforeachline(M,p,pvlineabs(p),\"+\")}</p>\n\n<p>Alle L&auml;ngen: {=pvlineabs(M);input}</p>\n\n<p>Alle Winkel: {=pvlinearg(M);input,°}</p>\n\n<p>Steigungen: {=pvlinek(M);input}</p>\n\n<p>d: {=pvlined(M);input}</p>\n\n<p>Geraden: {=pvline(M);input}</p>',2970,0),(2972,'html','',2970,1),(2973,'html','',2970,2),(2974,'html','',2970,3),(2975,'html','',2970,4),(2976,'html','',2970,5),(2978,'html','<p>[PIG Plugin1 \"w40h\"/]</p>\n\n<p>Punktemenge: {=M}</p>\n\n<p>2.Punkt {=get(M,1)}</p>\n\n<p>X-Koordinaten: {=pvgetx(M);line} 2.Punkt {=pvgetx(M,1)}</p>\n\n<p>Y-Koordinaten: {=pvgety(M);line} 2.Punkt {=pvgety(M,1)}</p>\n\n<p>Betr&auml;ge: {=pvabs(M);line} 2.Punkt {=pvabs(M,1)}</p>\n\n<p>Winkel:&nbsp;&nbsp; {=pvarg(M);line} 2.Punkt {=pvarg(M,1)}</p>',2977,0),(2979,'html','',2977,1),(2980,'html','',2977,2),(2981,'html','',2977,3),(2982,'html','',2977,4),(2983,'html','',2977,5),(2985,'html','<p>[PIG Plugin1 \"w40h\"/]</p>\n\n<p>Punktemenge: {=M;input}</p>\n\n<p>Sortiert nach x: {=pvsortx(M);input}</p>\n\n<p>Sortiert nach y: {=pvsorty(M);input}</p>\n\n<p>Sortiert nach Betrag: {=pvsortabs(M);input}</p>\n\n<p>Sortiert nach Winkel: {=pvsortarg(M);input}</p>\n\n<p>Sortiere nach Linien:</p>\n\n<p>Sortiert nach x: {=pvsortlinex(M);input}</p>\n\n<p>Sortiert nach y: {=pvsortliney(M);input}</p>\n\n<p>Sortiert nach Betrag: {=pvsortlineabs(M);input}</p>\n\n<p>Sortiert nach Winkel: {=pvsortlinearg(M);input}</p>',2984,0),(2986,'html','',2984,1),(2987,'html','',2984,2),(2988,'html','',2984,3),(2989,'html','',2984,4),(2990,'html','',2984,5),(2992,'html','<p>[PIG Plugin1 \"w40h\"/]</p>\n\n<p>M={=M;input}</p>\n\n<p>N={=N;input}</p>\n\n<p>M=N : {=pvequals(M,N,2%)}</p>\n\n<p>M=N Liniensortiert : {=pvequals(pvsortlinex(M),pvsortlinex(N),2%)}</p>',2991,0),(2993,'html','',2991,1),(2994,'html','',2991,2),(2995,'html','',2991,3),(2996,'html','',2991,4),(2997,'html','',2991,5),(3001,'html','<h1>Mengen Funktionen</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Berechnungen#Mengen-Funktionen\">Berechnungen-Mengen Funktionen-Wiki</a></p>\n\n<ul>\n	<li>Ausgangsmenge:<br/>\n	$M={=M;set}$<br/>\n	&nbsp;\n	<ul>\n		<li>Mengen-Funktionen:\n		<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:99%\">\n			<tbody>\n				<tr>\n					<td>setget</td>\n					<td>Liefert ein Element mit einem zero-based Index</td>\n					<td>setget(M,2)</td>\n					<td>{=setget(M,2)}</td>\n				</tr>\n				<tr>\n					<td>setgetmin</td>\n					<td>kleinstes Element</td>\n					<td>setgetmin(M)</td>\n					<td>{=setgetmin(M)}</td>\n				</tr>\n				<tr>\n					<td>setgetmax</td>\n					<td>gr&ouml;&szlig;tes Element</td>\n					<td>setgetmax(M)</td>\n					<td>{=setgetmax(M)}</td>\n				</tr>\n				<tr>\n					<td>setgetfirst</td>\n					<td>erstes Element</td>\n					<td>setgetfirst(M)</td>\n					<td>{=setgetfirst(M)}</td>\n				</tr>\n				<tr>\n					<td>setgetlast</td>\n					<td>letztes Element</td>\n					<td>setgetlast(M)</td>\n					<td>{=setgetlast(M)}</td>\n				</tr>\n				<tr>\n					<td>setsub</td>\n					<td>Teilmenge von Index bis Index</td>\n					<td>setsub(M,2,4)</td>\n					<td>{=setsub(M,2,4);set}</td>\n				</tr>\n				<tr>\n					<td>setset</td>\n					<td>setzt ein Element</td>\n					<td>setset(M,2,15)</td>\n					<td>{=setset(M,2,15);set}</td>\n				</tr>\n				<tr>\n					<td>setlength</td>\n					<td>liefert die Anzahl der Elemente</td>\n					<td>setlength(M)</td>\n					<td>{=setlength(M)}</td>\n				</tr>\n				<tr>\n					<td>setinsert</td>\n					<td>F&uuml;gt ein Element ein</td>\n					<td>setinsert(M,2,15)</td>\n					<td>{=setinsert(M,2,15);set}</td>\n				</tr>\n				<tr>\n					<td>setremove</td>\n					<td>l&ouml;scht ein Element</td>\n					<td>setremove(M,2)</td>\n					<td>{=setremove(M,2);set}</td>\n				</tr>\n				<tr>\n					<td>setremovefirst</td>\n					<td>l&ouml;scht das erste Element</td>\n					<td>setget(M,2)</td>\n					<td>{=setget(M,2)}</td>\n				</tr>\n				<tr>\n					<td>setremovelast</td>\n					<td>l&ouml;scht das letzte Element</td>\n					<td>setget(M,2)</td>\n					<td>{=setget(M,2)}</td>\n				</tr>\n				<tr>\n					<td>setnd</td>\n					<td>l&ouml;scht alle doppelten Elemente</td>\n					<td>setnd(M)</td>\n					<td>{=setnd(M);set}</td>\n				</tr>\n				<tr>\n					<td>setsort</td>\n					<td>sortiert die Menge</td>\n					<td>setsort(M)</td>\n					<td>{=setsort(M);set}</td>\n				</tr>\n				<tr>\n					<td>setsortnd</td>\n					<td>entfernt doppelte und sortiert die Menge</td>\n					<td>setsortnd(M)</td>\n					<td>{=setsortnd(M);set}</td>\n				</tr>\n				<tr>\n					<td>setreverse</td>\n					<td>dreht die Element-Reihenfolge um</td>\n					<td>setreverse(M)</td>\n					<td>{=setreverse(M);set}</td>\n				</tr>\n				<tr>\n					<td>setboxplot</td>\n					<td>Liefert die Werte des Boxplot einer Menge (Minimum, unteres Quartil, Median, oberes Quartil, Maximum) als Vektor</td>\n					<td>setboxplot(M)</td>\n					<td>{=setboxplot(M);set}</td>\n				</tr>\n				<tr>\n					<td>setcount</td>\n					<td>Bestimmt die Anzahl wie oft ein Element in einer Menge vorkommt.</td>\n					<td>setcount(M,5)</td>\n					<td>{=setcount(M,5)}</td>\n				</tr>\n				<tr>\n					<td>setmodus</td>\n					<td>Liefert das Element einer Menge, welches am &ouml;ftesten vorkommt oder die Elemente als Menge wenn mehrere Elemente gleich oft vorkommen</td>\n					<td>setmodus(M)</td>\n					<td>{=setmodus(M);set}</td>\n				</tr>\n				<tr>\n					<td>setmedian</td>\n					<td>Liefert den Median einer Menge</td>\n					<td>setmedian(M)</td>\n					<td>{=setmedian(M)}</td>\n				</tr>\n				<tr>\n					<td>setmittel</td>\n					<td>\n					<p>Bestimmt den arithmetischen Mittelwert einer Menge</p>\n\n					<p>$\\dfrac{1}{n}\\cdot\\sum_{i=1}^n{M_i}$</p>\n					</td>\n					<td>setmittel(M)</td>\n					<td>{=setmittel(M)}</td>\n				</tr>\n				<tr>\n					<td>setgeomittel</td>\n					<td>\n					<p>Bestimmt das geometrische Mittelwert einer Menge aus positiven reellen Zahlen</p>\n\n					<p>$\\sqrt[n]{\\prod_{i=1}^n{M_i}}$</p>\n					</td>\n					<td>setgeomittel([1,3,5])</td>\n					<td>{=setgeomittel([1,3,5])}</td>\n				</tr>\n				<tr>\n					<td>setquadratmittel</td>\n					<td>\n					<p>Bestimmt den quadratischen Mittelwert einer Menge</p>\n\n					<p>$\\sqrt{\\dfrac{1}{n}\\cdot\\sum_{i=1}^n{M_i^2}}$</p>\n					</td>\n					<td>setquadratmittel(M)</td>\n					<td>{=setquadratmittel(M)}</td>\n				</tr>\n				<tr>\n					<td>setvarianz</td>\n					<td>\n					<p>Bestimmt die empirische Varianz einer Menge</p>\n\n					<p>mit $MW=\\dfrac{1}{n}\\cdot\\sum_{i=1}^n{M_i}$</p>\n\n					<p>$\\dfrac{1}{n}\\cdot\\sum_{i=1}^n{(M_i-MW)^2}$</p>\n					</td>\n					<td>setvarianz(M)</td>\n					<td>{=setvarianz(M)}</td>\n				</tr>\n				<tr>\n					<td>setsum</td>\n					<td>\n					<p>Bestimmt die Summe aller Werte einer Menge</p>\n\n					<p>$\\sum_{i=1}^n{M_i}$</p>\n					</td>\n					<td>setsum(M)</td>\n					<td>{=setsum(M)}</td>\n				</tr>\n				<tr>\n					<td>setprod</td>\n					<td>\n					<p>Bestimmt das Produkt aller Werte einer Menge</p>\n\n					<p>$\\prod_{i=1}^n{M_i}$</p>\n					</td>\n					<td>setprod(M)</td>\n					<td>{=setprod(M)}</td>\n				</tr>\n				<tr>\n					<td>setunion</td>\n					<td>F&uuml;gt mehrere Mengen zu einer neuen Menge zusammen</td>\n					<td>setunion(M,[13,5,16,19])</td>\n					<td>{=setunion(M,[13,5,16,19]);set}</td>\n				</tr>\n				<tr>\n					<td>setunionnd</td>\n					<td>F&uuml;gt mehrere Mengen zu einer neuen Menge zusammen, sortiert diese und entfernt alle mehrfachen Elemente</td>\n					<td>setunionnd(M,[13,5,16,19])</td>\n					<td>{=setunionnd(M,[13,5,16,19]);set}</td>\n				</tr>\n				<tr>\n					<td>setcut</td>\n					<td>Bildet die Schnittmenge aus mehreren Mengen</td>\n					<td>setcut(M,[13,5,16,19])</td>\n					<td>{=setcut(M,[13,5,16,19]);set}</td>\n				</tr>\n				<tr>\n					<td>setcompare</td>\n					<td>vergleicht zwei Mengen miteinander, wobei die Reihenfolge egal ist</td>\n					<td>setcompare([1,2,3],[2,1,3])</td>\n					<td>{=setcompare([1,2,3],[2,1,3])}</td>\n				</tr>\n				<tr>\n					<td>setcomparend</td>\n					<td>vergleicht zwei Mengen miteinander, wobei die Reihenfolge egal ist und doppelte Werte als einfach behandelt werden</td>\n					<td>setcomparend([1,2,3,2],[2,3,1,3])</td>\n					<td>{=setcomparend([1,2,3,2],[2,3,1,3])}</td>\n				</tr>\n				<tr>\n					<td>setpartof</td>\n					<td>pr&uuml;ft ob die erste Menge eine Teilmenge der zweite Menge ist wobei die Reihenfolge egal ist aber mehrfache Werte ber&uuml;cksichtigt werden</td>\n					<td>&nbsp;</td>\n					<td>&nbsp;</td>\n				</tr>\n				<tr>\n					<td>setpartofnd</td>\n					<td>pr&uuml;ft ob die erste Menge eine Teilmenge der zweite Menge ist wobei die Reihenfolge und mehrfache Werte egal sind</td>\n					<td>&nbsp;</td>\n					<td>&nbsp;</td>\n				</tr>\n				<tr>\n					<td>setmakelist</td>\n					<td>setmakelist(f,x,start,stop) setzt in den Ausdruck f f&uuml;r x die Werte von start bis stop mit einer Schrittweite von 1 ein.</td>\n					<td>setmakelist(x^2,x,3,6)</td>\n					<td>{=setmakelist(x^2,x,3,6);set}</td>\n				</tr>\n				<tr>\n					<td>setapply(Variable,Menge,Ausdruck)</td>\n					<td>wendet einen Ausdruck oder Funktion auf alle Elemente einer Menge an.</td>\n					<td>setapply(y,M,y*2)</td>\n					<td>{=setapply(y,M,y*2);set}</td>\n				</tr>\n				<tr>\n					<td>setforeach(Menge,Variable,Ausdruck,\"Aggregat\")</td>\n					<td>F&uuml;hrt f&uuml;r jedes Element eine Berechnung aus und verbindet die Ergebnisse mit einem Infix-Operator als Aggregatsfunktion.</td>\n					<td>foreach(M,p,cabs(p),\"+\")</td>\n					<td>{=foreach(M,p,cabs(p),\"+\")}</td>\n				</tr>\n				<tr>\n					<td>setforeach(Menge,Variable,Ausdruck)</td>\n					<td>wie setapply, jedoch mit anderer Parameterreihenfolge.</td>\n					<td>foreach(M,y,y*2)</td>\n					<td>{=foreach(M,y,y*2);set}</td>\n				</tr>\n			</tbody>\n		</table>\n		</li>\n	</ul>\n	</li>\n</ul>',2999,0),(3002,'html','',2999,1),(3003,'html','',2999,2),(3004,'html','',2999,3),(3005,'html','',2999,4),(3006,'html','',2999,5),(3009,'html','<h1>setshuffle</h1>\n\n<p>Mit <em>setshuffle </em>k&ouml;nnen Mengen mittels eines ganzzahligen Datensatzes umsortiert (gemischt) werden wobei das Ergebnis direkt von der Ausgangsmenge und dem Mischfaktor abh&auml;ngt und somit reproduzierbar bleibt!</p>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Berechnungen#Mengen-Funktionen\" target=\"_blank\">Berechnungen-Mengen Funktionen-Wiki</a></p>\n\n<ul>\n	<li>Ausgangsmenge:<br/>\n	$M={=M;input}$<br/>\n	&nbsp;</li>\n	<li>Umsortiert mit setshuffle:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>setshuffle(M,0)</td>\n			<td>{=setshuffle(M,0);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,1)</td>\n			<td>{=setshuffle(M,1);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,2)</td>\n			<td>{=setshuffle(M,2);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,3)</td>\n			<td>{=setshuffle(M,3);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,4)</td>\n			<td>{=setshuffle(M,4);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,5)</td>\n			<td>{=setshuffle(M,5);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,6)</td>\n			<td>{=setshuffle(M,6);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,7)</td>\n			<td>{=setshuffle(M,7);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,8)</td>\n			<td>{=setshuffle(M,8);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,9)</td>\n			<td>{=setshuffle(M,9);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,10)</td>\n			<td>{=setshuffle(M,10);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,11)</td>\n			<td>{=setshuffle(M,11);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,12)</td>\n			<td>{=setshuffle(M,12);input}</td>\n		</tr>\n		<tr>\n			<td>setshuffle(M,13)</td>\n			<td>{=setshuffle(M,13);input}</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>',3007,0),(3010,'html','',3007,1),(3011,'html','',3007,2),(3012,'html','',3007,3),(3013,'html','',3007,4),(3014,'html','',3007,5),(3020,'html','<p>Berechne den Widerstand $R$, welcher an einer Spannung $U = {U}$ einen Strom von $I = {I}$ hervorruft.</p>\n\n<p>$R=$ [Q0]</p>\n\n<ul>\n	<li>Welchem Leitwert entspricht das? [Q1]&nbsp;</li>\n</ul>\n\n<p>Anmerkung 1:</p>\n\n<ul>\n	<li>Durch das Hakerl bei \"Vorberechnung\" werden die Datens&auml;tze vor der Maxima-Berechnung in Maxima eingesetzt und verlieren dadurch ihre Einheit. Als Zahlenwert wird der Zahlenwert bezogen auf die SI-Grundeinheiten verwendet. zB. wird statt 10mV der Wert 0.01 in Maxima verwendet.</li>\n	<li>Durch den Kommentar \"//unit(R*)=Ohm\" werden alle Maxima-Variable, welche mit R beginnen automatisch mit der Einheit Ohm erg&auml;nzt. Dies ist auch im Fragetext verwendbar.<br/>\n	(zB.: R={=R} )</li>\n	<li>Nat&uuml;rlich kann wie in Q1 auch &uuml;ber die Zieleinheit \"S\" die Einheit zugewiesen werden. Dies ist dann aber im Fragetext nicht verf&uuml;gbar .<br/>\n	(zB.: G={=G} nur l&ouml;sbar durch G={=G;S} )</li>\n</ul>\n\n<p>Anmerkung 2:</p>\n\n<ul>\n	<li>Verwendet man \"Vorberechnung\" und \"Parser\" so werden alle Einheiten korrekt berechnet, aber es wird das Maxima-Feld nur mit dem Parser gerechnet.&nbsp; Somit stehen nur die Funktionen zur Verf&uuml;gung, welche der Parser unterst&uuml;tzt. F&uuml;r technische Berechnungen wird das meist die bessere Wahl sein, f&uuml;r symbolische Mathematik wird eher Maxima empfohlen.</li>\n</ul>',3016,0),(3021,'html','',3016,1),(3022,'html','',3016,2),(3023,'html','',3016,3),(3024,'html','',3016,4),(3025,'html','',3016,5),(3032,'html','<h1>Polynome</h1>\n\n<p>siehe dazu <a href=\"https://www.letto.at/mediawiki/index.php/Zahlendarstellung#f.C3.BCr_Polynome_und_gebrochen_rationale_Funktionen_mit_numerischen_Koeffizienten_in_einer_Variablen_k.C3.B6nnen_folgende_Parameter_angegeben_werden\" target=\"_blank\">Polynome-Darstellung-Wiki</a></p>\n\n<p>M&ouml;gliche Darstellungen f&uuml;r das Polynom {=:p1}</p>\n\n<ul>\n	<li>Mit Pol- und Nullstellen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnPN1</td>\n			<td>{=p;pnPN1}&nbsp;</td>\n			<td>pnPN</td>\n			<td>{=p;pnPN}&nbsp;</td>\n		</tr>\n	</tbody>\n</table>\n\n<ul>\n	<li>Mit positiven Potenzen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnF1</td>\n			<td>{=p;pnF1}</td>\n			<td>pnFn</td>\n			<td>{=p;pnFn}</td>\n		</tr>\n		<tr>\n			<td>pnF1F</td>\n			<td>{=p;pnF1F}</td>\n			<td>pnFnF</td>\n			<td>{=p;pnFnF}</td>\n		</tr>\n		<tr>\n			<td>pnN1</td>\n			<td>{=p;pnN1}</td>\n			<td>pnNn</td>\n			<td>{=p;pnNn}</td>\n		</tr>\n		<tr>\n			<td>pnN1F</td>\n			<td>{=p;pnN1F}</td>\n			<td>pnNnF</td>\n			<td>{=p;pnNnF}</td>\n		</tr>\n		<tr>\n			<td>pnZ1</td>\n			<td>{=p;pnZ1}</td>\n			<td>pnZn</td>\n			<td>{=p;pnZn}</td>\n		</tr>\n		<tr>\n			<td>pnZ1F</td>\n			<td>{=p;pnZ1F}</td>\n			<td>pnZnF</td>\n			<td>{=p;pnZnF}</td>\n		</tr>\n	</tbody>\n</table>\n\n<ul>\n	<li>Mit negativen Potenzen:</li>\n</ul>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n	<tbody>\n		<tr>\n			<td>pnF1i</td>\n			<td>{=p;pnF1i}</td>\n			<td>pnFni</td>\n			<td>{=p;pnFni}</td>\n		</tr>\n		<tr>\n			<td>pnF1Fi</td>\n			<td>{=p;pnF1Fi}</td>\n			<td>pnFnFi</td>\n			<td>{=p;pnFnFi}</td>\n		</tr>\n		<tr>\n			<td>pnN1i</td>\n			<td>{=p;pnN1i}</td>\n			<td>pnNni</td>\n			<td>{=p;pnNni}</td>\n		</tr>\n		<tr>\n			<td>pnN1Fi</td>\n			<td>{=p;pnN1Fi}</td>\n			<td>pnNnFi</td>\n			<td>{=p;pnNnFi}</td>\n		</tr>\n		<tr>\n			<td>pnZ1i</td>\n			<td>{=p;pnZ1i}</td>\n			<td>pnZni</td>\n			<td>{=p;pnZni}</td>\n		</tr>\n		<tr>\n			<td>pnZ1Fi</td>\n			<td>{=p;pnZ1Fi}</td>\n			<td>pnZnFi</td>\n			<td>{=p;pnZnFi}</td>\n		</tr>\n	</tbody>\n</table>',3031,0),(3033,'html','',3031,1),(3034,'html','',3031,2),(3035,'html','',3031,3),(3036,'html','',3031,4),(3037,'html','',3031,5),(3042,'html','<h1>Polynomfunktionen</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Berechnungen#Polynome\" target=\"_blank\">Polynomfunktionen-Wiki</a></p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"height:79px; width:838px\">\n	<tbody>\n		<tr>\n			<td>Funktion</td>\n			<td>Beschreibung</td>\n			<td>Beispiel</td>\n			<td>Ergebnis</td>\n		</tr>\n		<tr>\n			<td>polynom</td>\n			<td>Erzeuge ein Polynom mit konstanten Faktoren</td>\n			<td>polynom((2+x)/(1+2*x))</td>\n			<td>{=polynom((2+x)/(1+2*x));pnN1}</td>\n		</tr>\n		<tr>\n			<td>polynom</td>\n			<td>Erzeuge ein Polynom mit Datens&auml;tzen</td>\n			<td>polynom((a+b*x)/(1+c*x),x)</td>\n			<td>{=polynom((a+b*x)/(1+c*x));pnN1}</td>\n		</tr>\n		<tr>\n			<td>polynom</td>\n			<td>Erzeuge ein Polynom mit Einheiten</td>\n			<td>polynom((2m+x)/(1m+2*x),x,\"m\")</td>\n			<td>{=polynom((2m+x)/(1m+2*x),x,\"m\");pnN1}</td>\n		</tr>\n		<tr>\n			<td>factfrompolynom</td>\n			<td>Erzeuge die Faktoren eines Polynoms</td>\n			<td>factfrompolynom(polynom((2+x)/(1+2*x)))</td>\n			<td>{=factfrompolynom(polynom((2+x)/(1+2*x)))}</td>\n		</tr>\n		<tr>\n			<td>polynomfromfact</td>\n			<td>Erzeuge aus einem Faktoren-Vektor das zugeh&ouml;rige Polynom</td>\n			<td>\n			<p>polynomfromfact([[1,0.5],[0.5,1],\"x\",\"\"])</p>\n\n			<p>polynomfromfact([1,0.5],[0.5,1],x,\"\"])</p>\n			</td>\n			<td>\n			<p>{=polynomfromfact([[1,0.5],[0.5,1],\"x\",\"\"]);pnN1}</p>\n\n			<p>{=polynomfromfact([1,0.5],[0.5,1],x,\"\");pnN1}</p>\n			</td>\n		</tr>\n		<tr>\n			<td>nullfrompolynom</td>\n			<td>Erzeuge die Nullstellen eines Polynoms</td>\n			<td>nullfrompolynom(polynom((2+x)/(1+2*x)))</td>\n			<td>{=nullfrompolynom(polynom((2+x)/(1+2*x)))}</td>\n		</tr>\n		<tr>\n			<td>polynomfromnull</td>\n			<td>Erzeuge aus einem Nullstellen-Vektor das zugeh&ouml;rige Polynom</td>\n			<td>\n			<p>polynomfromnull([0.5,[-2],[-0.5],x])</p>\n\n			<p>polynomfromnull(0.5,[-2],[-0.5],x)</p>\n			</td>\n			<td>\n			<p>{=polynomfromnull([0.5,[-2],[-0.5],x])}</p>\n\n			<p>{=polynomfromnull(0.5,[-2],[-0.5],x)}</p>\n			</td>\n		</tr>\n		<tr>\n			<td>polynomk</td>\n			<td>Bestimmt das Verh&auml;ltnis der Faktoren der h&ouml;chsten Potenz in Z&auml;hler und Nenner.</td>\n			<td>polynomk(polynom((2+x)/(1+2*x)))</td>\n			<td>\n			<p>{=polynomk(polynom((2+x)/(1+2*x)))}</p>\n\n			<p>siehe dazu {=p;pnPN}</p>\n			</td>\n		</tr>\n	</tbody>\n</table>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>',3038,0),(3043,'html','',3038,1),(3044,'html','',3038,2),(3045,'html','',3038,3),(3046,'html','',3038,4),(3047,'html','',3038,5),(3053,'html','<h1>Rechentoleranz bei und um Null</h1>\n\n<p>siehe auch <a href=\"https://youtu.be/1ZT9_P4aMWc\">Toleranz-Video</a><br/>\n<br/>\nGegeben sei ein rechtwinkeliges Dreieck $a = {a}$, $b = {b}$ $c={=c}$</p>\n\n<ul>\n	<li>Berechnen sie $a^2+b^2-c^2$ :</li>\n</ul>\n\n<p>[Q0] -&gt; Hier wird Null wegen der relativen Toleranz nicht als richtig gewertet</p>\n\n<p>[Q1] -&gt; Hier ist Null wegen der absoluten Toleranz nur richtig, wenn $a$ und $b$ gen&uuml;gend klein sind!<br/>\n(wechseln Sie dazu den Datensatz )</p>\n\n<p>[Q2] [Q3] -&gt; Hier funktioniert die absolute Toleranz durch eine boolsche Antwort auch bei gro&szlig;en Zahlenwerten!</p>',3049,0),(3055,'html','',3049,1),(3056,'html','',3049,2),(3057,'html','',3049,3),(3058,'html','',3049,4),(3059,'html','',3049,5),(3070,'html','<h1>Formatierung der Frage</h1>\n\n<p>Dies ist&nbsp;<strong>fett</strong>, dies ist&nbsp;<em>kursiv</em>, dies ist&nbsp;<u>unterstrichen</u>.</p>\n\n<ol>\n	<li>Auto</li>\n	<li>Haus&nbsp;</li>\n	<li>Boot</li>\n</ol>\n\n<p>Und nun mit Items:</p>\n\n<ul>\n	<li>Franz</li>\n	<li>Karl</li>\n	<li>Jutta</li>\n</ul>\n\n<p><a href=\"https://www.letto.at\">LeTTo</a>&nbsp;als Link.</p>\n\n<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\" summary=\"Der Inhalt\">\n	<caption>&Uuml;berschrift</caption>\n	<tbody>\n		<tr>\n			<td>A</td>\n			<td>B</td>\n		</tr>\n		<tr>\n			<td>C</td>\n			<td>D</td>\n		</tr>\n		<tr>\n			<td>E</td>\n			<td>F</td>\n		</tr>\n		<tr>\n			<td>G</td>\n			<td>H</td>\n		</tr>\n	</tbody>\n</table>\n\n<hr/>\n<p>Und nun ein Sonderzeichen:&nbsp;&#9658;&rarr;</p>\n\n<h1>&Uuml;berschrift 1</h1>\n\n<h2>&Uuml;berschrift 2</h2>\n\n<h3>&Uuml;berschrift 3</h3>\n\n<h4>&Uuml;berschrift 4</h4>\n\n<p>&Uuml;berschrift Normal</p>\n\n<h5>&Uuml;berschrift 5</h5>\n\n<h6>&Uuml;berschrift 6</h6>\n\n<pre>\nFormatiert     EINS\n</pre>\n\n<pre>\npublic static final String FormatPre     = \"{\\\\texttt \";\n</pre>\n\n<address>Adresse</address>\n\n<div>Normal</div>\n\n<div>Und nun ein <span style=\"color:#ff0000\">roter</span> Text mit <span style=\"background-color:#ffff00\">gelbem </span><span style=\"color:#ff0000\"><span style=\"background-color:#ffff00\">Hintergrund</span></span>.</div>\n\n<div>&nbsp;</div>\n\n<p>&nbsp;</p>',3068,0),(3071,'html','',3068,1),(3072,'html','',3068,2),(3073,'html','',3068,3),(3074,'html','',3068,4),(3075,'html','',3068,5),(3078,'html','<h1>Taschenrechner und Vorschau</h1>\n\n<ul>\n	<li>Geben Sie eine Berechnung ein, welche als Ergebnis 5 hat und klicken Sie mit Doppelklick in das Eingabefeld.<br/>\n	<br/>\n	[Q0]&nbsp;<br/>\n	<br/>\n	&nbsp;</li>\n	<li>Schreiben Sie den Satz des Pythagoras an und klicken Sie mit Doppelklick in das Eingabefeld um eine Vorschau zu erhalten.<br/>\n	<br/>\n	[Q1]&nbsp;</li>\n</ul>',3076,0),(3079,'html','',3076,1),(3080,'html','',3076,2),(3081,'html','',3076,3),(3082,'html','',3076,4),(3083,'html','',3076,5),(3090,'html','<h1>Lückentext normal</h1>\n\n<p>Ein [Q0] hat vier [Q1] und ein [Q2] hat 2 Räder.</p>\n\n<p><em>Anmerkung zur Korrektur:</em></p>\n\n<ul>\n	<li>Die drei Lücken haben eine Punktegewichtung von 2,1,2 die sich auf die Gesamtpunkteanzahl von 3 Punkten aufteilen. Somit kann mit der ersten Lücke {=:2/5*3=1.2} Punkte, mit der zweiten Lücke {=:1/5*3=0.6} Punkte und mit der dritten Lücke {=:2/5*3=1.2} Punkte erreicht werden.</li>\n	<li>Bei der dritten Lücke werden für \"fahrrad\" 50% der 1.2 Punkte und für \"farrad\" 30% der 1.2 Punkte vergeben.</li>\n	<li>Die Angabe von \"0:Haus\" hat nur im Drag and Drop Modus einen Sinn um Falschwerte in der Liste zu bekommen.</li>\n	<li>Beispiel 1: Für die Eingaben \"Auto\",\"Kalender\",\"fahrrad\" erhält man somit {=:1*1.2+0*0.6+0.5*1.2=1.8} Punkte</li>\n	<li>Beispiel 2: Für die Eingaben \"Auto\",\"Räder\",\"farrad\" erhält man somit {=:1*1.2+1*0.6+0.3*1.2=2.16} Punkte</li>\n</ul>',3088,0),(3091,'html','',3088,1),(3092,'html','',3088,2),(3093,'html','',3088,3),(3094,'html','',3088,4),(3095,'html','',3088,5),(3107,'html','<h1>Lückentext Drag and Drop</h1>\n\n<p>Ein [Q0] hat vier [Q1] und ein [Q2] hat 2 Räder.</p>\n\n<p><em>Anmerkung zur Korrektur:</em></p>\n\n<ul>\n	<li>Die drei Lücken haben eine Punktegewichtung von 2,1,2 die sich auf die Gesamtpunkteanzahl von 3 Punkten aufteilen. Somit kann mit der ersten Lücke {=:2/5*3=1.2} Punkte, mit der zweiten Lücke {=:1/5*3=0.6} Punkte und mit der dritten Lücke {=:2/5*3=1.2} Punkte erreicht werden.</li>\n	<li>Bei der dritten Lücke werden für \"fahrrad\" 50% der 1.2Punkte und für \"farrad\" 30% der 1.2Punkte vergeben.</li>\n	<li>Die Angabe von \"0:Haus\" hat nur im Drag and Drop Modus einen Sinn um Falschwerte in der Liste zu bekommen.</li>\n	<li>Beispiel 1: Für die Eingaben \"Auto\",\"Kalender\",\"fahrrad\" erhält man somit {=:1*1.2+0*0.6+0.5*1.2=1.8} Punkte</li>\n	<li>Beispiel 2: Für die Eingaben \"Auto\",\"Räder\",\"farrad\" erhält man somit {=:1*1.2+1*0.6+0.3*1.2=2.16} Punkte</li>\n</ul>',3105,0),(3108,'html','',3105,1),(3109,'html','',3105,2),(3110,'html','',3105,3),(3111,'html','',3105,4),(3112,'html','',3105,5),(3125,'html','<h1>Sonderzeichen</h1>\n\n<p><a href=\"https://www.letto.at/mediawiki/index.php/Editor_f%C3%BCr_den_Angabetext#Sonderzeichen\" target=\"_blank\">Wiki Sonderzeichen</a></p>\n\n<p>Das Dollar \\$ wird mit einem Backslash verblockt, auch in Formeln $\\$x$.</p>\n\n<p>Eine <strong>geschwungene</strong> Klammer { und } kann eigentlich ganz normal verwendet werden. In Formeln durch \\ verblockt $\\{a\\}+b$.</p>\n\n<p>Eine eckige Klammer [ und ] kann normal verwendet werden. In Formeln auch $[x]+y$</p>\n\n<p>Andere Zeichen:</p>\n\n<p>Im Text: &lt;&gt;|,._;:-#&#39;+*~\\x&sup2;x&sup3;!\"&sect;&amp;/()=?%</p>\n\n<p>In einer Formel $&lt;&gt;|,.\\_;:-\\#&#39;+*\\sim \\backslash x^2x^3!\"&sect;&amp;/()=?\\%$</p>',3122,0),(3126,'html','',3122,1),(3127,'html','',3122,2),(3128,'html','',3122,3),(3129,'html','',3122,4),(3130,'html','',3122,5),(3138,'html','<h1>Zeichenketten-Datens&auml;tze definieren</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Datens%C3%A4tze_definieren#Definition_der_Werte\" target=\"_blank\">Datens&auml;tze-Wiki</a></p>\n\n<ul>\n	<li>Zeichenkette durch Angabe aller m&ouml;glichen Worte definiert mit <strong>S:</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {a}<br/>\n	Datensatz: {=dataset(a),set}<br/>\n	Definition:\n	<pre>\nS:abc,x  zf,man,b\\,s,golf\n</pre>\n	</li>\n	<li>sortierte Zeichenkette definiert mit <strong>sS:</strong> liefert eine definierte Reihenfolge der Datens&auml;tze<br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(s),set}<br/>\n	Definition:\n	<pre>\nsS:abc,x  zf,man,b\\,s,golf\n</pre>\n	</li>\n	<li>zuf&auml;llige Zeichenfolgen&nbsp;mit zuf&auml;lliger L&auml;nge durch Verwendung von \"inversen regul&auml;ren Ausdr&uuml;cken\" definiert mit <strong>R:</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(r1),set}<br/>\n	Definition:\n	<pre>\n    R:[a-f0-9]+\n</pre>\n	</li>\n	<li>zuf&auml;llige Zeichenfolgen definierter L&auml;nge durch Verwendung von \"inversen regul&auml;ren Ausdr&uuml;cken\" definiert mit <strong>R</strong> und Stringl&auml;nge:<br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(r2),set}<br/>\n	Definition:\n	<pre>\n    R4:[a-z]+</pre>\n	</li>\n</ul>',3132,0),(3139,'html','',3132,1),(3140,'html','',3132,2),(3141,'html','',3132,3),(3142,'html','',3132,4),(3143,'html','',3132,5),(3154,'html','<h1>Datens&auml;tze definieren</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Datens%C3%A4tze_definieren#Definition_der_Werte\" target=\"_blank\">Datens&auml;tze-Wiki</a> und <a href=\"https://youtu.be/fZEv62EWVtE\">Datens&auml;tze-Video</a></p>\n\n<ul>\n	<li>Zahlen aus einer <span style=\"color:#ff0000\"><strong>Liste</strong></span> von Zahlen durch <strong>Wert,Wert,Wert</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {a}<br/>\n	Datensatz: {=dataset(a),set}<br/>\n	Definition:\n	<pre>\n4,6,2,8\n</pre>\n	</li>\n	<li>Zahlen aus einem <strong><span style=\"color:#ff0000\">Zahlenbereich</span></strong> durch <strong>Minimum - Maximum</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(b),set}<br/>\n	Definition:\n	<pre>\n2-20\n</pre>\n	</li>\n	<li>Zahlen aus einem <strong><span style=\"color:#ff0000\">Zahlenbereich f&uuml;r negative Zahlen</span></strong> durch <strong>-Minimum--Maximum</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(e),set}<br/>\n	Definition:\n	<pre>\n-20--2</pre>\n	</li>\n	<li>Zahlen aus einem Bereich mit <strong><span style=\"color:#ff0000\">definiertem Abstand</span></strong> durch <strong>ErsterWert : Abstand : MaximalWert</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(c),set}<br/>\n	Definition:\n	<pre>\n2:0.1:5\n</pre>\n	</li>\n	<li>Zahlen aus einem Bereich mit <strong><span style=\"color:#ff0000\">definiertem Multiplikator</span></strong> durch <strong>ErsterWert : Multiplikator : MaximalWert</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(f),set}<br/>\n	Definition:\n	<pre>\n3*2:100</pre>\n	</li>\n	<li>Zahlen aus einer <strong><span style=\"color:#ff0000\">Normreihe</span></strong> durch <strong><em>[Reihe]</em> : MinimalWert : MaximalWert</strong><br/>\n	Normreihen:\n	<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px\">\n		<tbody>\n			<tr>\n				<td>E3</td>\n				<td>{=e3;set}</td>\n			</tr>\n			<tr>\n				<td>E6</td>\n				<td>{=e6;set}</td>\n			</tr>\n			<tr>\n				<td>E12</td>\n				<td>{=e12;set}</td>\n			</tr>\n			<tr>\n				<td>E24</td>\n				<td>{=e24;set}</td>\n			</tr>\n			<tr>\n				<td>E48</td>\n				<td>{=e48;set}</td>\n			</tr>\n			<tr>\n				<td>D2</td>\n				<td>{=d2;set}</td>\n			</tr>\n			<tr>\n				<td>D5</td>\n				<td>{=d5;set}</td>\n			</tr>\n			<tr>\n				<td>D10</td>\n				<td>{=d10;set}</td>\n			</tr>\n			<tr>\n				<td>D20</td>\n				<td>{=d20;set}</td>\n			</tr>\n			<tr>\n				<td>D40</td>\n				<td>{=d40;set}</td>\n			</tr>\n		</tbody>\n	</table>\n	<br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(g),set}<br/>\n	Definition:\n	<pre>\nE12:10-80</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Einheitenvielfache</strong></span> durch Vorsetzen eines Einheitenvorsatzes <strong>m,u,n,p,f,a,k,M,G,T</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(h),set}<br/>\n	Definition:\n	<pre>\n2m,3k,4u,6M</pre>\n	</li>\n</ul>',3144,0),(3155,'html','',3144,1),(3156,'html','',3144,2),(3157,'html','',3144,3),(3158,'html','',3144,4),(3159,'html','',3144,5),(3168,'html','<h1>Datens&auml;tze Vektor-Matrix</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Datens%C3%A4tze_definieren#Definition_der_Werte\" target=\"_blank\">Datens&auml;tze-Wiki</a></p>\n\n<ul>\n	<li><span style=\"color:#ff0000\"><strong>Vektoren</strong></span> durch <em><strong>V</strong></em><em>[dimension]</em><strong>:</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {a}<br/>\n	Datensatz: {=dataset(a),set}<br/>\n	Definition:\n	<pre>\nV4:2-8\n</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Vektoren</strong></span> aus Ganzzahlen durch <em><strong>V</strong></em><em>[dimension]</em><strong>:<em>I</em></strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {b}<br/>\n	Datensatz: {=dataset(b),set}<br/>\n	Definition:\n	<pre>\nV4:I2-8</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Matrizen</strong></span> durch <em><strong>M</strong></em><em>[zeilen]</em><strong>x</strong><em>[spalten]</em><strong>:</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {c}<br/>\n	Datensatz: {=dataset(c),set}<br/>\n	Definition:\n	<pre>\nM3x4:2-8\n</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Matrizen</strong></span> aus Ganzzahlen durch <em><strong>M</strong></em><em>[zeilen]</em><strong>x</strong><em>[spalten]</em><strong>:<em>I</em></strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {d}<br/>\n	Datensatz: {=dataset(d),set}<br/>\n	Definition:\n	<pre>\nM3x2:I2-8</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Matrizen</strong></span> mit einer Determinante ungleich Null <em><strong>M</strong></em><em>[dimension]</em><strong>:</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {e}<br/>\n	Datensatz: {=dataset(e),set}<br/>\n	Definition:\n	<pre>\nM3:I2-8</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>Matrizen</strong></span> mit einer Determinante ungleich Null und Ganzzahlen <em><strong>M</strong></em><em>[dimension]</em><strong>:<em>I</em></strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {f}<br/>\n	Datensatz: {=dataset(f),set}<br/>\n	Definition:\n	<pre>\nM3:I3-8</pre>\n	</li>\n</ul>',3160,0),(3169,'html','',3160,1),(3170,'html','',3160,2),(3171,'html','',3160,3),(3172,'html','',3160,4),(3173,'html','',3160,5),(3186,'html','<h1>Datentypen f&uuml;r Zahlen</h1>\n\n<p>siehe auch <a href=\"https://www.letto.at/mediawiki/index.php/Datens%C3%A4tze_definieren#Definition_der_Werte\" target=\"_blank\">Datens&auml;tze-Wiki</a></p>\n\n<ul>\n	<li><span style=\"color:#ff0000\"><strong>Ganzzahlen </strong></span>durch <strong>I:</strong><br/>\n	Bsp:<br/>\n	Verwendung in der Frage liefert: {a}<br/>\n	Datensatz: {=dataset(a),set}<br/>\n	Definition:\n	<pre>\nI:2-10\n</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>sortierte Ganzzahlen</strong></span> deren Reihenfolge bleibt durch <strong>sI:Wert,Wert,Wert</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(b),set}<br/>\n	Definition:\n	<pre>\nsI:3,6,2,8,-3,5\n</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">Gleitkommazahlen</span></strong> durch <strong>F:</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(c),set}<br/>\n	Definition:\n	<pre>\nF:2,3-5,7\n</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">Gleitkommazahlen</span></strong> definierter Anzahl g&uuml;ltiger Ziffern durch <strong>F</strong><em>[ziffern]</em><strong>:</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(d),set}<br/>\n	Definition:\n	<pre>\nF3:3-20</pre>\n	</li>\n	<li>Zahlen aus einem Bereich mit <strong><span style=\"color:#ff0000\">definiertem Abstand</span></strong> durch <strong>ErsterWert : Abstand : LetzterWert</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(g),set}<br/>\n	Definition:\n	<pre>\n2:0.1:5</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">Gleitkommazahlen</span></strong> aus einer definierten Anzahl von &auml;quidistanten Werten durch <em>[ziffern]</em><strong>:</strong><em>[Startwert]</em><strong>:</strong><em>[Endwert]</em><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(e),set}<br/>\n	Definition: {=H,set}\n	<pre>\n6:2-5</pre>\n	</li>\n	<li><span style=\"color:#ff0000\"><strong>sortierte Gleitkommazahlen</strong></span> deren Reihenfolge bleibt durch <strong>sF:Wert,Wert,Wert</strong><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(f),set}<br/>\n	Definition:\n	<pre>\nsF:1.2,-5,2.3,8,0.03,12</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">komplexe Zahlen</span></strong> mit definiertem Betrag durch <strong>C</strong><em>[stellen]</em><strong>:</strong><em>[BetragVon]</em><strong>-</strong><em>[BetragBis]</em><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(h),set}<br/>\n	[PIG Plugin1 \"\"/]<br/>\n	Definition:\n	<pre>\nC2:2-4\n</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">komplexe Zahlen</span></strong> mit Betrag und Winkel in Grad&nbsp;durch <strong>C</strong><em>[stellen]</em><strong>:</strong><em>[BetragVon]</em><strong>-</strong><em>[BetragBis]</em><strong>arg</strong><em>[WinkelVon]</em><strong>-</strong><em>[WinkelBis]</em><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(i),set}<br/>\n	[PIG Plugin2 \"\"/]<br/>\n	Definition:\n	<pre>\nC2:2-4arg10-90</pre>\n	</li>\n	<li><strong><span style=\"color:#ff0000\">komplexe Zahlen</span></strong> mit Real und Imagin&auml;rteil durch <strong>C</strong><em>[stellen]</em><strong>:</strong><em>[RealVon]</em><strong>-</strong><em>[RealBis]</em><strong>j</strong><em>[Imagin&auml;rVon]</em><strong>-</strong><em>[Imagin&auml;rBis]</em><br/>\n	Bsp:<br/>\n	Datensatz: {=dataset(j);karti,set}<br/>\n	[PIG Plugin3 \"\"/]<br/>\n	Definition:\n	<pre>\nC2:2-4j-2-6</pre>\n	</li>\n</ul>',3174,0),(3187,'html','',3174,1),(3188,'html','',3174,2),(3189,'html','',3174,3),(3190,'html','',3174,4),(3191,'html','',3174,5);
/*!40000 ALTER TABLE `moodleText` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `noten`
--

DROP TABLE IF EXISTS `noten`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `noten` (
  `id` int NOT NULL AUTO_INCREMENT,
  `MAHNUNG` tinyint(1) DEFAULT '0',
  `NOTE` varchar(255) DEFAULT NULL,
  `SEMESTER` int DEFAULT NULL,
  `idLehrerKlasse` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  `noten_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_noten_idLehrerKlasse` (`idLehrerKlasse`),
  KEY `FK_noten_idUser` (`idUser`),
  CONSTRAINT `FK_noten_idLehrerKlasse` FOREIGN KEY (`idLehrerKlasse`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_noten_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `noten`
--

LOCK TABLES `noten` WRITE;
/*!40000 ALTER TABLE `noten` DISABLE KEYS */;
/*!40000 ALTER TABLE `noten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `noten_deskriptor`
--

DROP TABLE IF EXISTS `noten_deskriptor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `noten_deskriptor` (
  `negativeDeskriptoren_ID` int NOT NULL,
  `negativeNote_ID` int NOT NULL,
  PRIMARY KEY (`negativeDeskriptoren_ID`,`negativeNote_ID`),
  KEY `FK_noten_deskriptor_negativeNote_ID` (`negativeNote_ID`),
  CONSTRAINT `FK_noten_deskriptor_negativeDeskriptoren_ID` FOREIGN KEY (`negativeDeskriptoren_ID`) REFERENCES `deskriptor` (`id`),
  CONSTRAINT `FK_noten_deskriptor_negativeNote_ID` FOREIGN KEY (`negativeNote_ID`) REFERENCES `noten` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `noten_deskriptor`
--

LOCK TABLES `noten_deskriptor` WRITE;
/*!40000 ALTER TABLE `noten_deskriptor` DISABLE KEYS */;
/*!40000 ALTER TABLE `noten_deskriptor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `noten_lehrinhalt`
--

DROP TABLE IF EXISTS `noten_lehrinhalt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `noten_lehrinhalt` (
  `negativerLehrinhalt_ID` int NOT NULL,
  `negativeNote_ID` int NOT NULL,
  PRIMARY KEY (`negativerLehrinhalt_ID`,`negativeNote_ID`),
  KEY `FK_noten_lehrinhalt_negativeNote_ID` (`negativeNote_ID`),
  CONSTRAINT `FK_noten_lehrinhalt_negativeNote_ID` FOREIGN KEY (`negativeNote_ID`) REFERENCES `noten` (`id`),
  CONSTRAINT `FK_noten_lehrinhalt_negativerLehrinhalt_ID` FOREIGN KEY (`negativerLehrinhalt_ID`) REFERENCES `lehrinhalt` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `noten_lehrinhalt`
--

LOCK TABLES `noten_lehrinhalt` WRITE;
/*!40000 ALTER TABLE `noten_lehrinhalt` DISABLE KEYS */;
/*!40000 ALTER TABLE `noten_lehrinhalt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projekte`
--

DROP TABLE IF EXISTS `projekte`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projekte` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ANGABE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projekte`
--

LOCK TABLES `projekte` WRITE;
/*!40000 ALTER TABLE `projekte` DISABLE KEYS */;
/*!40000 ALTER TABLE `projekte` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `question`
--

DROP TABLE IF EXISTS `question`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `question` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `ABZUG` varchar(255) DEFAULT NULL,
  `ABZUGMAX` double DEFAULT NULL,
  `ADDDOCUMENTSPOSSIBLE` tinyint(1) DEFAULT '0',
  `ANSWERNUMBERING` varchar(20) DEFAULT NULL,
  `ATTACHMENTS` int DEFAULT NULL,
  `HIDDEN` int DEFAULT NULL,
  `IDUSER` bigint DEFAULT NULL,
  `KONSTANTEMITPROZENT` tinyint(1) DEFAULT '0',
  `LICENCEKEY` varchar(255) DEFAULT NULL,
  `MAXIMA` longtext,
  `MAXIMAANGABE` longtext,
  `MD5` varchar(200) DEFAULT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `NOAUTOCORRECT` int DEFAULT NULL,
  `PLUGINS` longtext,
  `PRECALC` tinyint(1) DEFAULT '0',
  `PUNKTE` double DEFAULT NULL,
  `QUESTIONINFO` longtext,
  `QUESTIONTYPE` int DEFAULT NULL,
  `RANDOMDATASET` tinyint(1) DEFAULT '0',
  `RESPONSEFIELDLINES` int DEFAULT NULL,
  `RESPONSEFORMAT` varchar(20) DEFAULT NULL,
  `revNr` int DEFAULT NULL,
  `SENDTOPARSER` tinyint(1) DEFAULT '0',
  `SHOWUNITS` int DEFAULT NULL,
  `SHUFFLEANSWERS` int DEFAULT NULL,
  `SINGLE` int DEFAULT NULL,
  `STRENG` tinyint(1) DEFAULT '0',
  `SYNCHRONIZE` int DEFAULT NULL,
  `TAG` varchar(200) DEFAULT NULL,
  `UNITGRADINGTYPE` int DEFAULT NULL,
  `UNITPENALTY` double DEFAULT NULL,
  `UNITS` longtext,
  `UNITSLEFT` int DEFAULT NULL,
  `USESYMBOLICMODE` tinyint(1) DEFAULT '0',
  `USECASE` int DEFAULT NULL,
  `idCategory` int DEFAULT NULL,
  `questionList_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_question_idCategory` (`idCategory`),
  CONSTRAINT `FK_question_idCategory` FOREIGN KEY (`idCategory`) REFERENCES `category` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `question`
--

LOCK TABLES `question` WRITE;
/*!40000 ALTER TABLE `question` DISABLE KEYS */;
INSERT INTO `question` VALUES (2275,'',0,0,'abc',3,0,19,1,'','\n',';::;','','000-LeTTo-Onramp: Intro ',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,0),(2289,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','001-LeTTo-Onramp: Dezimaltrennzeichen',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,1),(2306,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','002-LeTTo-Onramp: Zuordnungsfrage',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,2),(2325,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','003-LeTTo-Onramp: komplexe Zahlen',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,3),(2342,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','004-LeTTo-Onramp: physikalische Einheiten',0,'',0,2,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,4),(2360,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','005-LeTTo-Onramp:  normierte Größen',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,5),(2376,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','006-LeTTo-Onramp: analytische Lösungen',0,'',0,2,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2274,6),(2394,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','LeTTo-Onramp (Tutorial) full',0,'',0,8,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2273,0),(2428,'',0,0,'abc',3,0,19,1,'','erg:U/I\nerg2:sin(x)/x\n',';::;erg:U/I;erg2:sin(x)/x;','','LeTTo-Onramp (Tutorial) light',0,'',0,7,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2273,1),(2460,'',0,0,'abc',3,0,5,1,'','erg:[2,0]+[1,1]*5/sqrt(2)',';::;erg:[5/sqrt(2,2)+2,5/sqrt(2,2)];','','LP-PL-dA-010-toarrow',0,'[PI Plugin1 Plot \"input=toarrow(2,0);cursor=crel\"]',0,1,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,0),(2470,'',0,0,'abc',3,0,5,1,'','y:a-b*exp(-x/T)\nm:max(a-b,a)',';::;m:max(a,a-b);y:a-b*%e^-(x/T);','','LP-PL-dA-020-topoint',0,'[PI Plugin1 Plot \"y(x):=y;x:0,6*T;y:0,m*1.2;input=topoint(0,a-b);w50h;\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,1),(2483,'',0,0,'abc',3,0,5,1,'','P:[P_1,P_2]\n',';::;P:[P_1,P_2];','','LP-PL-dA-030-Punktb',0,'[PI Plugin1 Plot \"w30h\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,2),(2494,'',0,0,'abc',3,0,5,1,'','P2:[P2_1,P2_2]\nP1:[P1_1,P1_2]\nP:[P_1,P_2]\n',';::;P:[P_1,P_2];P1:[P1_1,P1_2];P2:[P2_1,P2_2];','','LP-PL-dA-040-Punkte',0,'[PI Plugin1 Plot \"w30h\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,3),(2507,'',0,0,'abc',3,0,5,1,'','P2:[P2_1,P2_2]\nP1:[P1_1,P1_2]\n',';::;P1:[P1_1,P1_2];P2:[P2_1,P2_2];','','LP-PL-dA-050-Messen',0,'[PI Plugin1 Plot \"w30h;point(vget(P1,0),vget(P1,1));point(vget(P2,0),vget(P2,1))\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,4),(2519,'',0,0,'abc',3,0,5,1,'','C:[C_1,C_2]\nB:[B_1,B_2]\nA:[A_1,A_2]\nD:[A,B,C]\n',';::;A:[A_1,A_2];B:[B_1,B_2];C:[C_1,C_2];D:matrix([A_1,A_2],[B_1,B_2],[C_1,C_2]);','','LP-PL-dA-060-Dreieck',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,5),(2532,'',0,0,'abc',3,0,5,1,'','A:[A_1,A_2]\nB:[A_1+b,A_2+h]\nD:[[A_1,A_2],[A_1,A_2+h],[A_1+b,A_2+h],[A_1+b,A_2]]\n',';::;A:[A_1,A_2];B:[b+A_1,h+A_2];D:matrix([A_1,A_2],[A_1,h+A_2],[b+A_1,h+A_2],[b+A_1,A_2]);','','LP-PL-dA-070-Rechteck',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,6),(2545,'',0,0,'abc',3,0,5,1,'','G:y=2*x-3\n',';::;G:y=2*x-3;','','LP-PL-dA-080-Gerade',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,7),(2555,'',0,0,'abc',3,0,5,1,'','G:y=2*x-3\n',';::;G:y=2*x-3;','','LP-PL-dA-090-Geraden',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,8),(2565,'',0,0,'abc',3,0,5,1,'','G:y=x^2-4\n',';::;G:y=x^2-4;','','LP-PL-dA-100-Polynomfunktion als Gleichung',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,9),(2575,'',0,0,'abc',3,0,5,1,'','G:x^2-4\n',';::;G:x^2-4;','','LP-PL-dA-110-Polynomfunktion',0,'[PI Plugin1 Plot \"\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,10),(2585,'',0,0,'abc',3,0,5,1,'','u:Us*sin(2*%pi*f*t)',';::;u:Us*sin(2*%pi*f*t);','','LP-PL-dA-120-hline',0,'[PI Plugin1 Plot \"U(t):=Us*sin(2*%pi*f*t);U:-Us*1.2,Us*1.2,name=u(t);t:0s,3/f;input=hline;cursor=hnum;w50h\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,11),(2597,'',0,0,'abc',3,0,5,1,'','u:Us*sin(2*%pi*f*t)',';::;u:Us*sin(2*%pi*f*t);','','LP-PL-dA-130-vline',0,'[PI Plugin1 Plot \"U(t):=Us*sin(2*%pi*f*t);U:-Us*1.2,Us*1.2,name=u(t);t:0s,3/f;input=vline;cursor=vnum;w50h\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2459,12),(2610,'',0,0,'abc',3,0,5,1,'','// richtige Lösung\nL1:[58,435]\nL2:[1204,435]\nk1:2\nk2:-2\n\n// Endpunkte der Vektoren sind korrekt\np1:lor(land(L1=vget(Q0,1),L2=vget(Q0,3)),land(L2=vget(Q0,1),L1=vget(Q0,3)))\n\n//Steigungen der Geraden\np2:wenn(vget(Q0,1,0)<vget(Q0,3,0), land(k1=pvlinek(Q0,0),k2=pvlinek(Q0,1)) , land(k1=pvlinek(Q0,1),k2=pvlinek(Q0,0)) )',';::;L1:[58,435];L2:[1204,435];k1:2;k2:-2;p1:lor(land([58,435]=vget(Q0,1),[1204,435]=vget(Q0,3)),land([1204,435]=vget(Q0,1),[58,435]=vget(Q0,3)));p2:wenn(vget(Q0,1,0)<vget(Q0,3,0),land(2=pvlinek(Q0,0),-2=pvlinek(Q0,1)),land(2=pvlinek(Q0,1),-2=pvlinek(Q0,0)));','','LP-PL-boolsch-010-Trägerberechnung',0,'[PI Plugin1 Plot \"baseimage(0);input=arrow\"]',0,2,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,0),(2625,'',0,0,'abc',3,0,5,1,'','x2:x1+dx2\nx3:x2+dx3\n\n// Polynom\np:(x-x1)*(x-x2)*(x-x3)\n\n//Nullstellen\nL:[[x1,0],[x2,0],[x3,0]]\n\n// Nullstellen korrekt\nq1a:pvhaspoint(Q0,[x1,0])\nq2a:pvhaspoint(Q0,[x2,0])\nq3a:pvhaspoint(Q0,[x3,0])\n\n// Anzahl der Nullstellen korrekt\nq4:pvpoints(Q0)=3\n\n// Nullstellen Position und Anzahl\nq1:land(q1a,q4)\nq2:land(q2a,q4)\nq3:land(q3a,q4)\n\n',';::;L:matrix([x1,0],[x1+dx2,0],[x1+dx3+dx2,0]);p:(x-x1)*((-x1)+x-dx2)*((-x1)+x-dx3-dx2);q1:land(pvhaspoint(Q0,[x1,0]),pvpoints(Q0)=3);q1a:pvhaspoint(Q0,[x1,0]);q2:land(pvhaspoint(Q0,[x1+dx2,0]),pvpoints(Q0)=3);q2a:pvhaspoint(Q0,[x1+dx2,0]);q3:land(pvhaspoint(Q0,[x1+dx3+dx2,0]),pvpoints(Q0)=3);q3a:pvhaspoint(Q0,[x1+dx3+dx2,0]);q4:pvpoints(Q0)=3;x2:x1+dx2;x3:x1+dx3+dx2;','','LP-PL-boolsch-020-Polynom-Nullstellen',0,'[PI Plugin1 Plot \"y(x):=p;y:-20,20;input=points\"]',0,3.5,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,1),(2649,'',0,0,'abc',3,0,5,1,'','P:[2,0]\nerg:P+[1,k]\n\nq1:k=(vget(Q0,0,1)-vget(P,1))/(vget(Q0,0,0)-vget(P,0))',';::;P:[2,0];erg:[3,k];q1:k=vget(Q0,0,1)/(-2+vget(Q0,0,0));','','LP-PL-boolsch-030-toline',0,'[PI Plugin1 Plot \"input=toline(2,0);w50\"]',0,1,'',22,0,10,'editor',1,1,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,2),(2662,'',0,0,'abc',3,0,5,1,'','y:tan(x)\nM:pvfunc(y,x,minx,maxx,(maxx-minx)/200)\n// Vergleich f\nq1:pvcompare(M,Q0,minx,maxx,miny,maxy)',';::;M:pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200);q1:pvcompare(pvfunc(tan(x),x,minx,maxx,(maxx-minx)/200),Q0,minx,maxx,miny,maxy);y:tan(x);','','LP-PL-boolsch-040-pvfunc-tan',0,'[PI Plugin1 Plot \"drawpoints(M,color=blue);x:minx,maxx;y:miny,maxy;y(x):=y;input=function\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,3),(2681,'',0,0,'abc',3,0,5,1,'','y:cos(x)\nM:pvfunc(y,x,0,10,0.1)\n// Vergleich\nq1:pvcompare(M,Q0,0,10,-2,2)',';::;M:pvfunc(cos(x),x,0,10,0.1);q1:pvcompare(pvfunc(cos(x),x,0,10,0.1),Q0,0,10,-2,2);y:cos(x);','','LP-PL-boolsch-050-pvfunc',0,'[PI Plugin1 Plot \"drawpoints(M,color=blue);x:0,10;y:-1.2,1.2;y(x):=y;input=function\"]',0,1,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,4),(2696,'',0,0,'abc',3,0,5,1,'','q1:land(vget(Q0,0)<0,vget(Q0,1)<0)',';::;q1:land(vget(Q0,0)<0,vget(Q0,1)<0);','','LP-PL-boolsch-060-input=point',0,'[PI Plugin1 Plot \"input=point\"]',0,1,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2609,5),(2708,'',0,0,'abc',3,0,5,1,'','P:[3,4]',';::;P:[3,4];','','LP-PL-IA-010-input=point',0,'[PI Plugin1 Plot \"input=point;w50\"]',0,3,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,0),(2723,'',0,0,'abc',3,0,5,1,'','A:[-2,-5]\nB:[6,1]\nC:[1,9]\nP:[A,B,C]\nq1:land(land(pvhaspoint(Q0,A),pvhaspoint(Q0,B)),pvhaspoint(Q0,C))\nq3:land(land(pvhaspoint(Q2,A),pvhaspoint(Q2,B)),pvhaspoint(Q2,C))',';::;A:[-2,-5];B:[6,1];C:[1,9];P:matrix([-2,-5],[6,1],[1,9]);q1:land(land(pvhaspoint(Q0,[-2,-5]),pvhaspoint(Q0,[6,1])),pvhaspoint(Q0,[1,9]));q3:land(land(pvhaspoint(Q2,[-2,-5]),pvhaspoint(Q2,[6,1])),pvhaspoint(Q2,[1,9]));','','LP-PL-IA-020-input=points',0,'[PI Plugin1 Plot \"input=points;polygon(P,color=blue);w50\"]',0,3,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,1),(2738,'',0,0,'abc',3,0,5,1,'','P1:[3,4]\nP2:[6,-2]\n// Punkte\nM:[P1,P2]',';::;M:matrix([3,4],[6,-2]);P1:[3,4];P2:[6,-2];','','LP-PL-IA-030-input=measure',0,'[PI Plugin1 Plot \"input=measure;w50;drawpoints(M)\"]',0,3,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,2),(2753,'',0,0,'abc',3,0,5,1,'','g:k*x+d\nP1:[0,ev(g,x=0)]\nP2:[2,ev(g,x=2)]\n// Punkte\nM:[P1,P2]\n// Gerade\nG:y=g\n// Korrektur\nq3:land(pvlinek(Q2,0)=k,pvlined(Q2,0)=d)',';::;G:y=k*x+d;M:matrix([0,d],[2,2*k+d]);P1:[0,d];P2:[2,2*k+d];g:k*x+d;q3:land(pvlinek(Q2,0)=k,pvlined(Q2,0)=d);','','LP-PL-IA-040-input=line',0,'[PI Plugin1 Plot \"input=line;w50\"]',0,2,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,3),(2768,'',0,0,'abc',3,0,5,1,'','// Berechnung ist nur für eine Demo-Lösung notwendig\ng1:k*x+d\ng2:k*x+d+2\nP1:[0,ev(g1,x=0)]\nP2:[2,ev(g1,x=2)]\nP3:[0,ev(g2,x=0)]\nP4:[2,ev(g2,x=2)]\nM:[P1,P2,P3,P4]\n \n// Korrektur - Linien Parallel\nq1:pvlinek(Q0,0)=pvlinek(Q0,1)\n',';::;M:matrix([0,d],[2,2*k+d],[0,d+2],[2,2*k+d+2]);P1:[0,d];P2:[2,2*k+d];P3:[0,d+2];P4:[2,2*k+d+2];g1:k*x+d;g2:k*x+d+2;q1:pvlinek(Q0,0)=pvlinek(Q0,1);','','LP-PL-IA-050-input=lines',0,'[PI Plugin1 Plot \"input=lines;w50\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,4),(2781,'',0,0,'abc',3,0,5,1,'','erg:3',';::;','','LP-PL-IA-060-input=hline',0,'[PI Plugin1 Plot \"input=hline;w50\"]',0,3,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,5),(2796,'',0,0,'abc',3,0,5,1,'','erg:3',';::;','','LP-PL-IA-070-input=vline',0,'[PI Plugin1 Plot \"input=vline;w50\"]',0,3,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2458,6),(2812,'',0,0,'abc',3,0,5,1,'','',';::;','','LP-PL-SK-010-Stumme Karte',0,'[PI Plugin1 Plot \"baseimage(0);input=mc([301.2,521.1],[551.1,512],[697,470],[988.9,280.3],[905,220.1],[751.7,537.5],[631.4,641.5],[968.8,537.5],[666,347.8],[806.5,349.6],[1008,406.2])\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2811,0),(2823,'',0,0,'abc',3,0,5,1,'','',';::;','','LP-PL-SK-020-MultipleChoice-Image',0,'[PI Plugin1 Plot \"// Hintergrundbild einfügen;baseimage(0);;// Multiple-Choice-Definition;input=mc([55.76,434.6],[266.2,312],[1212,432.6],[270.3,373.3],[376.6,338.6],[456.3,269.1],[630,97.44,36.84],[615.7,334.5,114.6],[889.5,336.5],[995.8,371.3],[950.8,281.4],[905.9,293.6],[354.1,291.6],[779.2,240.5,27.42],color=magenta,franzi=alt)\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2811,1),(2834,'',0,0,'abc',3,0,5,1,'','y:a*x^2+b*x+c\nys:diff(y,x)\nxtp:ev(x,solve(ys=0,x))\nytp:ev(y,x=xtp)\nTP:[xtp,ytp]\nP1:TP+[s1,s2]\nP2:TP+[s2,s3]\nP3:TP+[s3,s4]\nP4:TP+[s4,s5]\nP5:TP+[s5,s6]\nminx:min(-1,xtp  + min(-1,s1,s2,s3,s4,s5))\nmaxx:max(1,xtp + max(1,s1,s2,s3,s4,s5))\nminy:min(-1,ytp  + min(-1,s6,s2,s3,s4,s5))\nmaxy:max(1,ytp + max(1,s6,s2,s3,s4,s5))',';::;P1:[s1-b/(2*a),s2+c-b^2/(4*a)];P2:[s2-b/(2*a),s3+c-b^2/(4*a)];P3:[s3-b/(2*a),s4+c-b^2/(4*a)];P4:[s4-b/(2*a),s5+c-b^2/(4*a)];P5:[s5-b/(2*a),s6+c-b^2/(4*a)];TP:[-b/(2*a),c-b^2/(4*a)];maxx:max(1,max(1,s1,s2,s3,s4,s5)-b/(2*a));maxy:max(1,c-b^2/(4*a)+max(1,s2,s3,s4,s5,s6));minx:min(-1,min(-1,s1,s2,s3,s4,s5)-b/(2*a));miny:min(-1,c-b^2/(4*a)+min(-1,s2,s3,s4,s5,s6));xtp:-b/(2*a);y:a*x^2+b*x+c;ys:2*a*x+b;ytp:c-b^2/(4*a);','','LP-PL-SK-030-graphisch MC',0,'[PI Plugin1 Plot \"//y(x):=y;input=mcxy(TP,P1,P2,P3,P4,P5,P6);x:1.2*minx,1.2*maxx;y:1.2*miny,1.2*maxy;w50h\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2811,2),(2853,'',0,0,'abc',3,0,5,1,'','',';::;','','LP-Plot-010-Plot-Cursor',0,'[PI Plugin1 Plot \"x:-10,10;y:-10,10;line(-7,-8,6,7,color=red);size=400;;\"]',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2457,0),(2861,'',0,0,'abc',3,0,5,1,'','// Funktionen\ny:sin(x)\ny1:cos(x)\n\n// Fläche berechnen\nA:integrate(y1-y,x,-3*%pi/4,%pi/4)\n',';::;A:2^(3/2);y:sin(x);y1:cos(x);','','LP-PL-010-Fläche zwischen Kurven mit einer Legende',0,'[PI Plugin1 Plot \"y(x):=y;y1(x):=y1;fill:ch1<ch2;y:-1,1;y1:name=;x:-1pi,1pi\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2457,1),(2871,'',0,0,'abc',3,0,5,1,'','G:2/(1+s*T1)/(1+s*T2)',';::;G:2/((T1*s+1)*(T2*s+1));','','LP-PL-020-BodePlotEingabe',0,'[PI Plugin1 Plot \"G(s):=G;bode;cursor=all;w:0.1,100;abs:-40,10\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2457,2),(2884,'',0,0,'abc',3,0,5,1,'','A:[x1,y1]\nB:[x2,y2]\nC:[x3,y3]\nv1:B-A\nv2:C-A\nw:vin(v1,v2)/vabs(v1)/vabs(v2)\n',';::;A:[x1,y1];B:[x2,y2];C:[x3,y3];v1:[x2-x1,y2-y1];v2:[x3-x1,y3-y1];w:vin([x2-x1,y2-y1],[x3-x1,y3-y1])/(vabs([x2-x1,y2-y1])*vabs([x3-x1,y3-y1]));','','LP-PL-030-Plot mit Messung',0,'[PI Plugin1 Plot \"x:-10,10;y:-10,10;point(A,text=\"A\");point(B,text=\"B\");point(C,text=\"C\")\"]',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2457,3),(2904,'',0,0,'abc',3,0,5,1,'','B1:[g1,z1,n1]\nB2:[g2,z2,n2]\nb:frac(B1)+frac(B2)\nB:defracmix(b)',';::;B:defracmix(frac([g2,z2,n2])+frac([g1,z1,n1]));B1:[g1,z1,n1];B2:[g2,z2,n2];b:frac([g2,z2,n2])+frac([g1,z1,n1]);','','LP-ZD-010-gemischte Brüche-Addition',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,0),(2920,'',0,0,'abc',3,0,5,1,'','f:noopt(3*x^3*y+4*x^2+x*y^2)',';::;f:noopt(3*x^3*y+4*x^2+x*y^2);','','LP-ZD-020-vereinfachte Termdarstellung',0,'',0,1,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,1),(2930,'',0,0,'abc',3,0,5,1,'','x:0.034\ny:1234567.8',';::;x:0.034;y:1.2345678E6;','','LP-ZD-030-Nachkommastellen',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,2),(2940,'',0,0,'abc',3,0,5,1,'','v:[2,5,3,8,19]\nM:[[1,2,3],[4,5,6],[7,8,9]]',';::;M:matrix([1,2,3],[4,5,6],[7,8,9]);v:[2,5,3,8,19];','','LP-ZD-040-Vektor-Mengen Darstellung',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,3),(2948,'',0,0,'abc',3,0,5,1,'','','','','LP-ZD-050-komplexe Zahlen',0,'',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,4),(2961,'',0,0,'abc',3,0,5,1,'','p1:(3+2*x)^2*(1+5*x)/(4+2*x^2)\np:polynom(p1)',';::;p:polynom(2.25*(1+6.33333333333*x+7.11111111111*x^2+2.22222222222*x^3)/(1+0.5*x^2),x);p1:((2*x+3)^2*(5*x+1))/(2*x^2+4);','','LP-ZD-060-Polynom Darstellung',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2903,5),(2970,'',0,0,'abc',3,0,5,1,'','M:[[2,3],[4,5],[6,3],[-2,4]]',';::;M:matrix([2,3],[4,5],[6,3],[-2,4]);','','LP-PV-010-Strecken',0,'[PI Plugin1 Plot \"drawline(M,color=red,pointstyle=\".-.\");x:-10,10;y:-10,10\"]',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2969,0),(2977,'',0,0,'abc',3,0,5,1,'','M:[[2,3],[4,5],[6,3],[-2,4]]',';::;M:matrix([2,3],[4,5],[6,3],[-2,4]);','','LP-PV-020-Punkte',0,'[PI Plugin1 Plot \"f(x,y):=M;point(f);x:-10,10;y:-10,10\"]',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2969,1),(2984,'',0,0,'abc',3,0,5,1,'','M:[[2,3],[4,5],[6,3],[-2,4],[-3,5],[-7,-9]]',';::;M:matrix([2,3],[4,5],[6,3],[-2,4],[-3,5],[-7,-9]);','','LP-PV-030-Sortierung',0,'[PI Plugin1 Plot \"f(x,y):=M;point(f);x:-10,10;y:-10,10\"]',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2969,2),(2991,'',0,0,'abc',3,0,5,1,'','M:[[2,3],[4,5],[6,3],[-2,4],[-3,5],[-7,-9]]\nN:[[6,3],[-2.01,4],[2.01,3],[4.01,5],[-3,5],[-7,-9]]',';::;M:matrix([2,3],[4,5],[6,3],[-2,4],[-3,5],[-7,-9]);N:matrix([6,3],[-2.01,4],[2.01,3],[4.01,5],[-3,5],[-7,-9]);','','LP-PV-040-Vergleich',0,'[PI Plugin1 Plot \"f(x,y):=M;point(f);x:-10,10;y:-10,10\"]',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2969,3),(2999,'',0,0,'abc',3,0,5,1,'','M:[2,-3,5,-6,2,4,5]',';::;M:[2,-3,5,-6,2,4,5];','','LP-MV-010-Mengenfunktionen',0,'',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2998,0),(3007,'',0,0,'abc',3,0,5,1,'','M:[1,2,3,4]',';::;M:[1,2,3,4];','','LP-MV-020-SetShuffle',0,'',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,2998,1),(3016,'',0,0,'abc',3,0,5,1,'','R:U/I\nG:1/R\n\n//unit(R*)=Ohm',';::;G:1/4;I:4A;R:4Ohm;U:16V;','','LP-VB-010-VorBerechnung Demo',0,'',1,2,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3015,0),(3031,'',0,0,'abc',3,0,5,1,'','p1:(3+2*x)^2*(1+5*x)/(4+2*x^2)\np:polynom(p1)',';::;p:polynom(2.25*(1+6.33333333333*x+7.11111111111*x^2+2.22222222222*x^3)/(1+0.5*x^2),x);p1:((2*x+3)^2*(5*x+1))/(2*x^2+4);','','LP-PN-010-Polynom Darstellung',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3030,0),(3038,'',0,0,'abc',3,0,5,1,'','p:polynom((2+x)/(1+2*x))\nf:factfrompolynom(p)\nn:nullfrompolynom(p)',';::;f:factfrompolynom(polynom(2*(1+0.5*x)/(1+2*x),x));n:nullfrompolynom(polynom(2*(1+0.5*x)/(1+2*x),x));p:polynom(2*(1+0.5*x)/(1+2*x),x);','','LP-PN-020-Polynom-Funktionen',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3030,1),(3049,'',0,0,'abc',3,0,5,1,'','c:cround(sqrt(a^2+b^2),4)\nn:a^2+b^2-c^2',';::;c:cround(sqrt(b^2+a^2,2),4);n:(-cround(sqrt(b^2+a^2,2),4)^2)+b^2+a^2;','','LT-FG-010-Rechentoleranz bei und um Null',0,'',0,3,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3048,0),(3068,'',0,0,'abc',3,0,5,1,'','','','','LT-FG-020-Formatierungen HTML',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3048,2),(3076,'',0,0,'abc',3,0,5,1,'','erg:5',';::;','','LT-FG-030-Taschenrechner und Vorschau',0,'',0,2,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3048,3),(3088,'',0,0,'abc',3,0,5,1,'','','','','LT-FT-010-Lückentext Normal',0,'',0,3,'',19,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3048,1),(3105,'',0,0,'abc',3,0,5,1,'','','','','LT-FT-011-Lückentext Drag and Drop',0,'',0,3,'',19,0,10,'editor',1,0,0,1,3,0,0,'',2,0.1,'',0,0,0,3048,4),(3122,'',0,0,'abc',3,0,5,1,'','','','','LT-FG-021-Sonderzeichen',0,'',0,0,'',22,0,10,'editor',0,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3048,5),(3132,'',0,0,'abc',3,0,5,1,'','',';::;','','LeTTo-DS-010-Zeichenketten',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3131,0),(3144,'',0,0,'abc',3,0,5,1,'','e3:[1,2,5]\ne6:[1,1.5,2.2,3.3,4.7,6.8]\ne12:[1,1.2,1.5,1.8,2.2,2.7,3.3,3.9,4.7,5.6,6.8,8.2]\ne24:[1,1.1,1.2,1.3,1.5,1.6,1.8,2.0,2.2,2.4,2.7,3.0,3.3,3.6,3.9,4.3,4.7,5.1,5.6,6.2,6.8,7.5,8.2,9.1]\ne48:[1,1.05,1.1,1.15,1.21,1.27,1.33,1.40,1.47,1.54,1.62,1.69,1.78,1.87,1.96,2.05,2.15,2.26,2.37,2.49,2.61,2.74,2.87,3.01,3.16,3.32,3.48,3.65,3.83,4.02,4.22,4.42,4.64,4.87,5.11,5.36,5.62,5.9,6.19,6.49,6.81,7.15,7.5,7.87,8.25,8.66,9.09,9.53]\nd2:[1,5]\nd5:[1,2,4,6,8]\nd10:[1,2,3,4,5,6,7,8,9]\nd20:[1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5]\nd40:[1,1.1,1.2,1.3,1.4,1.5,1.6,1.7,1.8,1.9,2,2.1,2.2,2.3,2.4,2.5,2.6,2.8,3,3.2,3.4,3.5,3.6,3.8,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5]',';::;d10:[1,2,3,4,5,6,7,8,9];d2:[1,5];d20:[1,1.5,2,2.5,3,3.5,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5];d40:[1,1.1,1.2,1.3,1.4,1.5,1.6,1.7,1.8,1.9,2,2.1,2.2,2.3,2.4,2.5,2.6,2.8,3,3.2,3.4,3.5,3.6,3.8,4,4.5,5,5.5,6,6.5,7,7.5,8,8.5,9,9.5];d5:[1,2,4,6,8];e12:[1,1.2,1.5,1.8,2.2,2.7,3.3,3.9,4.7,5.6,6.8,8.2];e24:[1,1.1,1.2,1.3,1.5,1.6,1.8,2,2.2,2.4,2.7,3,3.3,3.6,3.9,4.3,4.7,5.1,5.6,6.2,6.8,7.5,8.2,9.1];e3:[1,2,5];e48:[1,1.05,1.1,1.15,1.21,1.27,1.33,1.4,1.47,1.54,1.62,1.69,1.78,1.87,1.96,2.05,2.15,2.26,2.37,2.49,2.61,2.74,2.87,3.01,3.16,3.32,3.48,3.65,3.83,4.02,4.22,4.42,4.64,4.87,5.11,5.36,5.62,5.9,6.19,6.49,6.81,7.15,7.5,7.87,8.25,8.66,9.09,9.53];e6:[1,1.5,2.2,3.3,4.7,6.8];','','LeTTo-DS-020-Datensätze definieren',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3131,1),(3160,'',0,0,'abc',3,0,5,1,'','',';::;','','LeTTo-DS-030-Datensätze Vektor-Matrix',0,'',0,0,'',22,0,10,'editor',1,0,0,1,2,0,0,'',2,0.1,'',0,0,0,3131,2),(3174,'',0,0,'abc',3,0,5,1,'','H:foreach(dataset(h),c,[realpart(c),imagpart(c)])\nI:foreach(dataset(i),c,[realpart(c),imagpart(c)])\nJ:foreach(dataset(j),c,[realpart(c),imagpart(c)])\nln:[[2*cos(10°),2*sin(10°)],[4*cos(10°),4*sin(10°)]]\n',';::;H:matrix([2.45933947885,-1.53676586628],[-2.4248711306,1.4],[-2.59540657903,-0.744220860706],[-3.4,0],[2.14492444073,-1.79980530712],[-2.65292023218,1.78941729111],[2.45933947885,-1.53676586628],[3.46410161514,-2],[-2.4248711306,1.4],[-2.75803763762,2.15481516364],[-2.66295824563,-0.86524758425],[2.45933947885,-1.53676586628],[-3.37749907476,-1.95],[2.05724838302,2.83155948031],[3,0],[-2.08849598027,0.219509772862],[2.54414428847,-1.5897577927],[2.05724838302,2.83155948031],[-2.46201938253,-0.434120444167],[1.12866647297,-3.10098564859],[-3.28192225472,0.344943928783],[2.08397511138,-2.15801940102],[0.698811421777,2.60799973098],[-2.29813332936,1.92836282906],[-1.11246117975,-3.42380345866],[2.05724838302,2.83155948031],[2.18742998748,0.710739087062],[-2.26505783193,-0.399390808634],[-2.65292023218,1.78941729111],[-2.26505783193,-0.399390808634],[-2.66295824563,-0.86524758425],[-1.60071983585,2.04882795938],[2.30374895898,-2.07430487971],[-2.46201938253,-0.434120444167],[2.14492444073,-1.79980530712],[-2.588854382,1.88091280734],[-1.76190221917,1.47841150228],[-2.46201938253,-0.434120444167],[-2.26505783193,-0.399390808634],[-2.75803763762,2.15481516364]);I:matrix([2.33143788437,1.88796117315],[0.786673846173,1.94708609459],[0.555674168534,3.15138480964],[1.88677395056,1.64014757248],[1.94286490364,1.57330097762],[2.48660258551,2.31879442421],[0.382025990867,2.16657705663],[0.139512947488,1.99512810052],[2.65979360424,2.85227943631],[2.29566374143,1.22062606324],[2.40915248052,1.95089321225],[0.382025990867,2.16657705663],[1.00343025873,2.61402519419],[3.17861133429,1.69009762603],[1.94286490364,1.57330097762],[2.56601257276,2.23060069857],[1.3485837363,3.33786187644],[1.84139557217,1.97465499437],[1.77808695269,2.5393713373],[1.23620175827,3.05970672007],[2.06901374284,3.06743901845],[2.40915248052,1.95089321225],[2.06901374284,3.06743901845],[0.64321775039,2.10387046312],[0.17439118436,2.49391012565],[3.47492544433,1.77056294898],[1.88677395056,1.64014757248],[3.17861133429,1.69009762603],[1.08635912091,2.68883317824],[0.697348268466,3.02054720083],[3.17861133429,1.69009762603],[1.3485837363,3.33786187644],[1.78941729111,2.65292023218],[0.209269421232,2.99269215078],[1.77808695269,2.5393713373],[0.555674168534,3.15138480964],[2.29566374143,1.22062606324],[1.40594789871,2.5363971507],[0.382025990867,2.16657705663],[2.48660258551,2.31879442421]);J:matrix([2.7,4],[2.8,1.5],[2.8,1.5],[2.9,5.7],[3,-0.8],[3.4,-0.71],[3.5,3.1],[3.1,5.7],[4,1.3],[3.5,3.1],[2.2,5.8],[3.7,2.1],[3.4,-0.7],[2.9,-1],[2.8,5.8],[3,-0.8],[3.1,3.6],[3.4,-0.7],[3.4,-0.71],[3.9,1.9],[3.9,3.3],[3.2,-1],[2.9,-1],[2.7,4],[2.9,-1],[2.1,2.7],[3.3,3.8],[3.9,1.9],[2.8,5],[3.1,3.6],[3.9,3.3],[3.9,3.3],[3.9,2.6],[3.1,0.69],[2.8,1.5],[4,1.3],[3.4,5.2],[2.8,1.5],[2.7,4],[3.1,3.6]);ln:matrix([1.96961550602,0.347296355334],[3.93923101205,0.694592710668]);','','LeTTo-DS-040-Datentypen für Zahlen',0,'[PI Plugin1 Plot \"w30;drawpoints(H,color=red);circle(0,0,2,color=blue);circle(0,0,4,color=blue)\"],[PI Plugin2 Plot \"w30;drawpoints(I,color=red);arc(0,0,2,10°,80°,color=blue);arc(0,0,4,10°,80°,color=blue);line(0,2,0,4,color=blue);drawline(ln,color=blue);\"],[PI Plugin3 Plot \"w30;drawpoints(J,color=red);rect(2,-2,4,6,color=blue)\"]',0,0,'',22,0,10,'editor',1,1,0,1,2,0,0,'',2,0.1,'',0,0,0,3131,3);
/*!40000 ALTER TABLE `question` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `questioncomment`
--

DROP TABLE IF EXISTS `questioncomment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `questioncomment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ICON` int DEFAULT NULL,
  `MESSAGE` longtext,
  `question_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_questioncomment_question_id` (`question_id`),
  CONSTRAINT `FK_questioncomment_question_id` FOREIGN KEY (`question_id`) REFERENCES `question` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3176 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `questioncomment`
--

LOCK TABLES `questioncomment` WRITE;
/*!40000 ALTER TABLE `questioncomment` DISABLE KEYS */;
INSERT INTO `questioncomment` VALUES (2276,1,'',2275),(2290,1,'',2289),(2307,1,'',2306),(2326,1,'',2325),(2343,1,'',2342),(2361,1,'',2360),(2377,1,'',2376),(2395,1,'',2394),(2429,1,'',2428),(2461,1,'',2460),(2471,1,'',2470),(2484,1,'',2483),(2495,1,'',2494),(2508,1,'',2507),(2520,1,'',2519),(2533,1,'',2532),(2546,1,'',2545),(2556,1,'',2555),(2566,1,'',2565),(2576,1,'',2575),(2586,1,'',2585),(2598,1,'',2597),(2611,1,'',2610),(2626,1,'',2625),(2650,1,'',2649),(2663,1,'',2662),(2682,1,'',2681),(2697,1,'',2696),(2813,1,'',2812),(2824,1,'',2823),(2835,1,'',2834),(2854,1,'',2853),(2862,1,'',2861),(2872,1,'',2871),(2885,1,'',2884),(2905,1,'',2904),(2921,1,'',2920),(2931,1,'',2930),(2941,1,'',2940),(2949,1,'',2948),(2962,1,'',2961),(3000,1,'',2999),(3008,1,'',3007),(3017,1,'',3016),(3050,1,'',3049),(3069,1,'',3068),(3077,1,'',3076),(3089,1,'',3088),(3106,1,'',3105),(3123,1,'',3122),(3133,1,'',3132),(3145,1,'',3144),(3161,1,'',3160),(3175,1,'',3174);
/*!40000 ALTER TABLE `questioncomment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `questiontexthistory`
--

DROP TABLE IF EXISTS `questiontexthistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `questiontexthistory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `IDQUESTION` int DEFAULT NULL,
  `INFOS` longtext,
  `TEXT` longtext,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `questiontexthistory`
--

LOCK TABLES `questiontexthistory` WRITE;
/*!40000 ALTER TABLE `questiontexthistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `questiontexthistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schuelerKlasse`
--

DROP TABLE IF EXISTS `schuelerKlasse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schuelerKlasse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `KatNr` int DEFAULT NULL,
  `MAHNUNGSEM1` tinyint(1) DEFAULT '0',
  `MAHNUNGSEM2` tinyint(1) DEFAULT '0',
  `idKlasse` int DEFAULT NULL,
  `idUser` int NOT NULL,
  `KURSKENNUNG` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_schuelerKlasse_idKlasse` (`idKlasse`),
  KEY `FK_schuelerKlasse_idUser` (`idUser`),
  CONSTRAINT `FK_schuelerKlasse_idKlasse` FOREIGN KEY (`idKlasse`) REFERENCES `klasse` (`id`),
  CONSTRAINT `FK_schuelerKlasse_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schuelerKlasse`
--

LOCK TABLES `schuelerKlasse` WRITE;
/*!40000 ALTER TABLE `schuelerKlasse` DISABLE KEYS */;
/*!40000 ALTER TABLE `schuelerKlasse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schuelerKlasse_deskriptor`
--

DROP TABLE IF EXISTS `schuelerKlasse_deskriptor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schuelerKlasse_deskriptor` (
  `SchuelerKlasse_ID` int NOT NULL,
  `negativeDeskriptoren_ID` int NOT NULL,
  PRIMARY KEY (`SchuelerKlasse_ID`,`negativeDeskriptoren_ID`),
  KEY `schuelerKlasse_deskriptor_negativeDeskriptoren_ID` (`negativeDeskriptoren_ID`),
  CONSTRAINT `FK_schuelerKlasse_deskriptor_SchuelerKlasse_ID` FOREIGN KEY (`SchuelerKlasse_ID`) REFERENCES `schuelerKlasse` (`id`),
  CONSTRAINT `schuelerKlasse_deskriptor_negativeDeskriptoren_ID` FOREIGN KEY (`negativeDeskriptoren_ID`) REFERENCES `deskriptor` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schuelerKlasse_deskriptor`
--

LOCK TABLES `schuelerKlasse_deskriptor` WRITE;
/*!40000 ALTER TABLE `schuelerKlasse_deskriptor` DISABLE KEYS */;
/*!40000 ALTER TABLE `schuelerKlasse_deskriptor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schuelergruppe`
--

DROP TABLE IF EXISTS `schuelergruppe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schuelergruppe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GRUPPENNAME` varchar(255) DEFAULT NULL,
  `GEGENSTAND_ID` int DEFAULT NULL,
  `SCHUELERKLASSE_ID` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_schuelergruppe_SCHUELERKLASSE_ID` (`SCHUELERKLASSE_ID`),
  KEY `FK_schuelergruppe_GEGENSTAND_ID` (`GEGENSTAND_ID`),
  CONSTRAINT `FK_schuelergruppe_GEGENSTAND_ID` FOREIGN KEY (`GEGENSTAND_ID`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `FK_schuelergruppe_SCHUELERKLASSE_ID` FOREIGN KEY (`SCHUELERKLASSE_ID`) REFERENCES `schuelerKlasse` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schuelergruppe`
--

LOCK TABLES `schuelergruppe` WRITE;
/*!40000 ALTER TABLE `schuelergruppe` DISABLE KEYS */;
/*!40000 ALTER TABLE `schuelergruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schule`
--

DROP TABLE IF EXISTS `schule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schule` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ADRESSE` varchar(100) DEFAULT NULL,
  `ANSPRECHPARTNER` varchar(255) DEFAULT NULL,
  `DIREKTOR` varchar(100) DEFAULT NULL,
  `EMAIL` varchar(100) DEFAULT NULL,
  `INFO` varchar(100) DEFAULT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `SCHULKENNZAHL` varchar(100) DEFAULT NULL,
  `SEMESTRIERUNG` int DEFAULT NULL,
  `TELEFON` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `UNGERADEWINTERSEMESTER` tinyint(1) DEFAULT '0',
  `USEALLCATEGORIES` tinyint(1) DEFAULT '0',
  `WEB` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schule`
--

LOCK TABLES `schule` WRITE;
/*!40000 ALTER TABLE `schule` DISABLE KEYS */;
INSERT INTO `schule` VALUES (1,NULL,'Ansprechpartner',NULL,'a@b',NULL,'Schule',NULL,NULL,'1234',1,1,NULL);
/*!40000 ALTER TABLE `schule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schule_category`
--

DROP TABLE IF EXISTS `schule_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schule_category` (
  `categories_ID` int NOT NULL,
  `schulen_ID` int NOT NULL,
  PRIMARY KEY (`categories_ID`,`schulen_ID`),
  KEY `FK_schule_category_schulen_ID` (`schulen_ID`),
  CONSTRAINT `FK_schule_category_categories_ID` FOREIGN KEY (`categories_ID`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_schule_category_schulen_ID` FOREIGN KEY (`schulen_ID`) REFERENCES `schule` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schule_category`
--

LOCK TABLES `schule_category` WRITE;
/*!40000 ALTER TABLE `schule_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `schule_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schule_schultyp`
--

DROP TABLE IF EXISTS `schule_schultyp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schule_schultyp` (
  `schulen_ID` int NOT NULL,
  `schulTypen_ID` int NOT NULL,
  PRIMARY KEY (`schulen_ID`,`schulTypen_ID`),
  KEY `FK_schule_schultyp_schulTypen_ID` (`schulTypen_ID`),
  CONSTRAINT `FK_schule_schultyp_schulen_ID` FOREIGN KEY (`schulen_ID`) REFERENCES `schule` (`id`),
  CONSTRAINT `FK_schule_schultyp_schulTypen_ID` FOREIGN KEY (`schulTypen_ID`) REFERENCES `schultyp` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schule_schultyp`
--

LOCK TABLES `schule_schultyp` WRITE;
/*!40000 ALTER TABLE `schule_schultyp` DISABLE KEYS */;
/*!40000 ALTER TABLE `schule_schultyp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schuljahr`
--

DROP TABLE IF EXISTS `schuljahr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schuljahr` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BIS` date DEFAULT NULL,
  `IMMERGUELTIG` tinyint(1) DEFAULT '0',
  `NAME` varchar(40) NOT NULL,
  `SEMESTER` date DEFAULT NULL,
  `VON` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schuljahr`
--

LOCK TABLES `schuljahr` WRITE;
/*!40000 ALTER TABLE `schuljahr` DISABLE KEYS */;
INSERT INTO `schuljahr` VALUES (1,'2022-08-31',0,'2021/22','2022-02-10','2021-09-01'),(2264,'2023-08-31',0,'2022/23','2023-02-10','2022-09-01');
/*!40000 ALTER TABLE `schuljahr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schultyp`
--

DROP TABLE IF EXISTS `schultyp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schultyp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ABK` varchar(255) DEFAULT NULL,
  `BESCHREIBUNG` varchar(100) DEFAULT NULL,
  `STARTSCHULSTUFE` int DEFAULT NULL,
  `TYP` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2130509 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schultyp`
--

LOCK TABLES `schultyp` WRITE;
/*!40000 ALTER TABLE `schultyp` DISABLE KEYS */;
INSERT INTO `schultyp` VALUES (2130500,NULL,NULL,0,'Gymnasium Unterstufe'),(2130501,NULL,NULL,0,'Gymnasium Oberstufe'),(2130502,NULL,NULL,0,'Abendschule'),(2130503,NULL,NULL,0,'Fachschule'),(2130504,NULL,NULL,0,'Höhere'),(2130505,NULL,NULL,0,'Mittelschule'),(2130506,NULL,NULL,0,'Berufsschule'),(2130507,NULL,NULL,0,'Hochschule'),(2130508,NULL,NULL,0,'Universität');
/*!40000 ALTER TABLE `schultyp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schultyp_gegenstand`
--

DROP TABLE IF EXISTS `schultyp_gegenstand`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schultyp_gegenstand` (
  `gegenstaende_ID` int NOT NULL,
  `schultypen_ID` int NOT NULL,
  PRIMARY KEY (`gegenstaende_ID`,`schultypen_ID`),
  KEY `FK_schultyp_gegenstand_schultypen_ID` (`schultypen_ID`),
  CONSTRAINT `FK_schultyp_gegenstand_gegenstaende_ID` FOREIGN KEY (`gegenstaende_ID`) REFERENCES `gegenstand` (`id`),
  CONSTRAINT `FK_schultyp_gegenstand_schultypen_ID` FOREIGN KEY (`schultypen_ID`) REFERENCES `schultyp` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schultyp_gegenstand`
--

LOCK TABLES `schultyp_gegenstand` WRITE;
/*!40000 ALTER TABLE `schultyp_gegenstand` DISABLE KEYS */;
/*!40000 ALTER TABLE `schultyp_gegenstand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subquestion`
--

DROP TABLE IF EXISTS `subquestion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subquestion` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `GRADE` double DEFAULT NULL,
  `MAXIMA` longtext,
  `MODE` int DEFAULT NULL,
  `NAME` varchar(80) DEFAULT NULL,
  `PLUGININFO` longtext,
  `SCHWIERIGKEIT` int DEFAULT NULL,
  `SHUFFLEANSWERS` int DEFAULT NULL,
  `PARENT_ID` bigint DEFAULT NULL,
  `subQuestions_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_subquestion_PARENT_ID` (`PARENT_ID`),
  CONSTRAINT `FK_subquestion_PARENT_ID` FOREIGN KEY (`PARENT_ID`) REFERENCES `question` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subquestion`
--

LOCK TABLES `subquestion` WRITE;
/*!40000 ALTER TABLE `subquestion` DISABLE KEYS */;
INSERT INTO `subquestion` VALUES (2287,1,'',3,'Q1','',3,1,2275,0),(2304,1,'',4,'Q0','',0,1,2289,0),(2321,1,'',8,'Q7','',0,1,2306,0),(2340,1,'',4,'Q1','',0,1,2325,0),(2356,1,'',4,'Q2','',0,1,2342,0),(2358,1,'',4,'Q3','',0,1,2342,1),(2374,1,'',4,'Q4','',0,1,2360,0),(2390,1,'',4,'Q5','',0,1,2376,0),(2392,1,'',4,'Q6','',0,1,2376,1),(2410,1,'',4,'Q0','',0,1,2394,0),(2412,1,'',4,'Q1','',0,1,2394,1),(2414,1,'',4,'Q2','',0,1,2394,2),(2416,1,'',4,'Q3','',0,1,2394,3),(2418,1,'',4,'Q4','',0,1,2394,4),(2420,1,'',4,'Q5','',0,1,2394,5),(2422,1,'',4,'Q6','',0,1,2394,6),(2424,1,'',8,'Q7','',1,1,2394,7),(2442,1,'',4,'Q0','',0,1,2428,0),(2444,1,'',4,'Q1','',0,1,2428,1),(2446,1,'',4,'Q2','',0,1,2428,2),(2448,1,'',4,'Q3','',0,1,2428,3),(2450,1,'',4,'Q4','',0,1,2428,4),(2452,1,'',4,'Q5','',0,1,2428,5),(2454,1,'',4,'Q6','',0,1,2428,6),(2468,1,'',6,'Q0','Plugin1:',0,1,2460,0),(2481,1,'',6,'Q0','Plugin1:',0,1,2470,0),(2492,1,'',6,'Q0','Plugin1:input=point',0,1,2483,0),(2505,1,'',6,'Q0','Plugin1:input=points',0,1,2494,0),(2517,1,'',6,'Q0','Plugin1:input=measure;cursor=all',0,1,2507,0),(2530,1,'',6,'Q0','Plugin1:w40h;input=polygon',0,1,2519,0),(2543,1,'',6,'Q0','Plugin1:w40h;input=polygon',0,1,2532,0),(2553,1,'',6,'Q0','Plugin1:w40h;input=line;cursor=all',0,1,2545,0),(2563,1,'',6,'Q0','Plugin1:w40h;input=lines',0,1,2555,0),(2573,1,'',6,'Q0','Plugin1:w40h;input=function;inputcounter=5',0,1,2565,0),(2583,1,'',6,'Q0','Plugin1:w40h;input=points;inputcounter=5',0,1,2575,0),(2595,1,'',6,'Q0','Plugin1:',0,1,2585,0),(2607,1,'',6,'Q0','Plugin1:',0,1,2597,0),(2619,0,'',6,'Q0','Plugin1:',0,1,2610,0),(2621,1,'',5,'Q1','',0,1,2610,1),(2623,1,'',5,'Q2','',0,1,2610,2),(2636,0,'',6,'Q0','Plugin1:',0,1,2625,0),(2638,1,'',5,'Q1','',0,1,2625,1),(2641,1,'',5,'Q2','',0,1,2625,2),(2644,1,'',5,'Q3','',0,1,2625,3),(2647,0.5,'',5,'Q4','',0,1,2625,4),(2658,0,'',6,'Q0','Plugin1:',0,1,2649,0),(2660,1,'',5,'Q1','',0,1,2649,1),(2674,0,'',6,'Q0','Plugin1:',0,1,2662,0),(2676,1,'',5,'Q1','',0,1,2662,1),(2689,0,'',6,'Q0','Plugin1:',0,1,2681,0),(2691,1,'',5,'Q1','',0,1,2681,1),(2704,0,'',6,'Q0','Plugin1:',0,1,2696,0),(2706,1,'',5,'Q1','',0,1,2696,1),(2715,1,'',6,'Q0','Plugin1:',0,1,2708,0),(2717,1,'',5,'Q1','',0,1,2708,1),(2719,0,'',6,'Q2','Plugin1:',0,1,2708,2),(2721,1,'',5,'Q3','',0,1,2708,3),(2730,1,'',6,'Q0','Plugin1:',0,1,2723,0),(2732,1,'',5,'Q1','',0,1,2723,1),(2734,0,'',6,'Q2','Plugin1:',0,1,2723,2),(2736,1,'',5,'Q3','',0,1,2723,3),(2745,1,'',6,'Q0','Plugin1:',0,1,2738,0),(2747,1,'',5,'Q1','',0,1,2738,1),(2749,0,'',6,'Q2','Plugin1:',0,1,2738,2),(2751,1,'',5,'Q3','',0,1,2738,3),(2762,1,'',6,'Q0','Plugin1:',0,1,2753,0),(2764,0,'',6,'Q2','Plugin1:',0,1,2753,1),(2766,1,'',5,'Q3','',0,1,2753,2),(2777,0,'',6,'Q0','Plugin1:',0,1,2768,0),(2779,1,'',5,'Q1','',0,1,2768,1),(2788,1,'',6,'Q0','Plugin1:',0,1,2781,0),(2790,1,'',5,'Q1','',0,1,2781,1),(2792,0,'',6,'Q2','Plugin1:',0,1,2781,2),(2794,1,'',5,'Q3','',0,1,2781,3),(2803,1,'',6,'Q0','Plugin1:',0,1,2796,0),(2805,1,'',5,'Q1','',0,1,2796,1),(2807,0,'',6,'Q2','Plugin1:',0,1,2796,2),(2809,1,'',5,'Q3','',0,1,2796,3),(2821,1,'',6,'Q0','Plugin1:',0,1,2812,0),(2832,1,'',6,'Q0','Plugin1:',0,1,2823,0),(2851,1,'',6,'Q0','Plugin1:',0,1,2834,0),(2869,1,'',4,'Q0','',0,1,2861,0),(2881,1,'',4,'Q0','',0,1,2871,0),(2898,0,'',4,'Q0','',0,1,2884,0),(2900,1,'',4,'Q1','',0,1,2884,1),(2918,1,'',4,'Q0','',0,1,2904,0),(2928,1,'',4,'Q0','',0,1,2920,0),(2938,0,'',4,'Q0','',0,1,2930,0),(3026,1,'',4,'Q0','',0,1,3016,0),(3028,1,'',4,'Q1','',0,1,3016,1),(3060,1,'',4,'Q0','',0,1,3049,0),(3062,1,'',4,'Q1','',0,1,3049,1),(3064,0,'',4,'Q2','',0,1,3049,2),(3066,1,'',5,'Q3','',0,1,3049,3),(3084,1,'',4,'Q0','',0,1,3076,0),(3086,1,'',4,'Q1','',0,1,3076,1),(3096,2,'',1,'Q0','',0,1,3088,0),(3098,1,'',1,'Q1','',0,1,3088,1),(3100,2,'',1,'Q2','',0,1,3088,2),(3113,2,'',1,'Q0','',0,1,3105,0),(3115,1,'',1,'Q1','',0,1,3105,1),(3117,2,'',1,'Q2','',0,1,3105,2);
/*!40000 ALTER TABLE `subquestion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscription`
--

DROP TABLE IF EXISTS `subscription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscription` (
  `id` int NOT NULL AUTO_INCREMENT,
  `BIS` date DEFAULT NULL,
  `VON` date DEFAULT NULL,
  `idThema` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_subscription_idThema` (`idThema`),
  KEY `FK_subscription_idUser` (`idUser`),
  CONSTRAINT `FK_subscription_idThema` FOREIGN KEY (`idThema`) REFERENCES `lehrerKlasse` (`id`),
  CONSTRAINT `FK_subscription_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscription`
--

LOCK TABLES `subscription` WRITE;
/*!40000 ALTER TABLE `subscription` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `symbolicrexexp`
--

DROP TABLE IF EXISTS `symbolicrexexp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `symbolicrexexp` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `HELP` longtext,
  `NAME` varchar(40) NOT NULL,
  `REXEXP` varchar(250) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `symbolicrexexp`
--

LOCK TABLES `symbolicrexexp` WRITE;
/*!40000 ALTER TABLE `symbolicrexexp` DISABLE KEYS */;
INSERT INTO `symbolicrexexp` VALUES (1,NULL,'Einfachbruch','regexp Einfachbruch'),(2,NULL,'Keine Klammern','regExp keine Klammern');
/*!40000 ALTER TABLE `symbolicrexexp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testAnswerSubQuestion`
--

DROP TABLE IF EXISTS `testAnswerSubQuestion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testAnswerSubQuestion` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ANSWER` longtext,
  `IST` double DEFAULT NULL,
  `LEHRERSCORED` tinyint(1) DEFAULT '0',
  `ORIGIST` double DEFAULT NULL,
  `SCOREANZAHL` int DEFAULT NULL,
  `SCOREINFO` longtext,
  `SCORETEXT` longtext,
  `SCORED` int DEFAULT NULL,
  `SOLL` double DEFAULT NULL,
  `SUBQUEST` varchar(255) DEFAULT NULL,
  `idTestAntwort` int DEFAULT NULL,
  `idSubQuestion` bigint DEFAULT NULL,
  `antwortenSubquestions_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testAnswerSubQuestion_idSubQuestion` (`idSubQuestion`),
  KEY `FK_testAnswerSubQuestion_idTestAntwort` (`idTestAntwort`),
  CONSTRAINT `FK_testAnswerSubQuestion_idSubQuestion` FOREIGN KEY (`idSubQuestion`) REFERENCES `subquestion` (`id`),
  CONSTRAINT `FK_testAnswerSubQuestion_idTestAntwort` FOREIGN KEY (`idTestAntwort`) REFERENCES `testAntwort` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testAnswerSubQuestion`
--

LOCK TABLES `testAnswerSubQuestion` WRITE;
/*!40000 ALTER TABLE `testAnswerSubQuestion` DISABLE KEYS */;
/*!40000 ALTER TABLE `testAnswerSubQuestion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testAntwort`
--

DROP TABLE IF EXISTS `testAntwort`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testAntwort` (
  `id` int NOT NULL AUTO_INCREMENT,
  `Bewertung` int DEFAULT NULL,
  `EINGABE` longtext,
  `MANELLSCORED` tinyint(1) DEFAULT '0',
  `Points` double DEFAULT NULL,
  `TIMESTAMP` datetime DEFAULT NULL,
  `USERRESCORE` int DEFAULT NULL,
  `idTestDetail` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testAntwort_idTestDetail` (`idTestDetail`),
  CONSTRAINT `FK_testAntwort_idTestDetail` FOREIGN KEY (`idTestDetail`) REFERENCES `testDetails` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testAntwort`
--

LOCK TABLES `testAntwort` WRITE;
/*!40000 ALTER TABLE `testAntwort` DISABLE KEYS */;
/*!40000 ALTER TABLE `testAntwort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testDetails`
--

DROP TABLE IF EXISTS `testDetails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testDetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `DATASET` longtext,
  `FILESFORDETAIL` longtext,
  `individualFeedback` longtext,
  `Selektor` int DEFAULT NULL,
  `TESTANTWORTJSON` longtext,
  `question` int DEFAULT NULL,
  `idTestVersuch` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  `documentId` int DEFAULT NULL,
  `testDetails_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testDetails_idTestVersuch` (`idTestVersuch`),
  KEY `FK_testDetails_idUser` (`idUser`),
  KEY `FK_testDetails_documentId` (`documentId`),
  KEY `FK_testDetails_question` (`question`),
  CONSTRAINT `FK_testDetails_documentId` FOREIGN KEY (`documentId`) REFERENCES `dokumente` (`id`),
  CONSTRAINT `FK_testDetails_idTestVersuch` FOREIGN KEY (`idTestVersuch`) REFERENCES `testVersuch` (`id`),
  CONSTRAINT `FK_testDetails_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`),
  CONSTRAINT `FK_testDetails_question` FOREIGN KEY (`question`) REFERENCES `testFrage` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testDetails`
--

LOCK TABLES `testDetails` WRITE;
/*!40000 ALTER TABLE `testDetails` DISABLE KEYS */;
/*!40000 ALTER TABLE `testDetails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testFrage`
--

DROP TABLE IF EXISTS `testFrage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testFrage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `FRAGENGRUPPE` int DEFAULT NULL,
  `POINTS` double DEFAULT NULL,
  `GRUPPEVONFRAGEN_ID` int DEFAULT NULL,
  `idQuestion` bigint DEFAULT NULL,
  `idTestGruppe` int DEFAULT NULL,
  `testFragen_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testFrage_GRUPPEVONFRAGEN_ID` (`GRUPPEVONFRAGEN_ID`),
  KEY `FK_testFrage_idTestGruppe` (`idTestGruppe`),
  KEY `FK_testFrage_idQuestion` (`idQuestion`),
  CONSTRAINT `FK_testFrage_GRUPPEVONFRAGEN_ID` FOREIGN KEY (`GRUPPEVONFRAGEN_ID`) REFERENCES `fragengruppe` (`id`),
  CONSTRAINT `FK_testFrage_idQuestion` FOREIGN KEY (`idQuestion`) REFERENCES `question` (`id`),
  CONSTRAINT `FK_testFrage_idTestGruppe` FOREIGN KEY (`idTestGruppe`) REFERENCES `testGruppe` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testFrage`
--

LOCK TABLES `testFrage` WRITE;
/*!40000 ALTER TABLE `testFrage` DISABLE KEYS */;
/*!40000 ALTER TABLE `testFrage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testGruppe`
--

DROP TABLE IF EXISTS `testGruppe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testGruppe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `GRUPPENNAME` varchar(100) DEFAULT NULL,
  `PROZENTBEREICH` double DEFAULT NULL,
  `PROZENTFORPOSITIV` double DEFAULT NULL,
  `PARENT_ID` int DEFAULT NULL,
  `idTest` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testGruppe_PARENT_ID` (`PARENT_ID`),
  KEY `FK_testGruppe_idTest` (`idTest`),
  CONSTRAINT `FK_testGruppe_idTest` FOREIGN KEY (`idTest`) REFERENCES `tests` (`id`),
  CONSTRAINT `FK_testGruppe_PARENT_ID` FOREIGN KEY (`PARENT_ID`) REFERENCES `testGruppe` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testGruppe`
--

LOCK TABLES `testGruppe` WRITE;
/*!40000 ALTER TABLE `testGruppe` DISABLE KEYS */;
/*!40000 ALTER TABLE `testGruppe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testVersuch`
--

DROP TABLE IF EXISTS `testVersuch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testVersuch` (
  `id` int NOT NULL AUTO_INCREMENT,
  `FINISHED` tinyint(1) DEFAULT '0',
  `FOCUSLOST` tinyint(1) DEFAULT '0',
  `FOCUSLOSTCLEARED` tinyint(1) DEFAULT '0',
  `FOCUSLOSTPROTOKOLL` longtext,
  `INDEXSTARTQUESTION` varchar(50) DEFAULT NULL,
  `OPENTESTTIME` int DEFAULT NULL,
  `PUNKTEIST` double DEFAULT NULL,
  `PUNKTESOLL` double DEFAULT NULL,
  `REIHENFOLGE` longtext,
  `REMAININGTIME` int DEFAULT NULL,
  `Startdatum` timestamp NULL DEFAULT NULL,
  `STOPDATUM` timestamp NULL DEFAULT NULL,
  `USEDFORKATALOG` tinyint(1) DEFAULT '0',
  `idGruppe` int DEFAULT NULL,
  `idTest` int DEFAULT NULL,
  `idUser` int DEFAULT NULL,
  `idAnonym` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_testVersuch_idTest` (`idTest`),
  KEY `FK_testVersuch_idAnonym` (`idAnonym`),
  KEY `FK_testVersuch_idGruppe` (`idGruppe`),
  KEY `FK_testVersuch_idUser` (`idUser`),
  CONSTRAINT `FK_testVersuch_idAnonym` FOREIGN KEY (`idAnonym`) REFERENCES `testVersuch` (`id`),
  CONSTRAINT `FK_testVersuch_idGruppe` FOREIGN KEY (`idGruppe`) REFERENCES `testGruppe` (`id`),
  CONSTRAINT `FK_testVersuch_idTest` FOREIGN KEY (`idTest`) REFERENCES `tests` (`id`),
  CONSTRAINT `FK_testVersuch_idUser` FOREIGN KEY (`idUser`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testVersuch`
--

LOCK TABLES `testVersuch` WRITE;
/*!40000 ALTER TABLE `testVersuch` DISABLE KEYS */;
/*!40000 ALTER TABLE `testVersuch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tests`
--

DROP TABLE IF EXISTS `tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tests` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ABZUGBEIMEHRFACHANTWORT` tinyint(1) DEFAULT '0',
  `ANTWORTMISCHEN` tinyint(1) DEFAULT '0',
  `BEGRENZUNG` tinyint(1) DEFAULT '0',
  `BESCHREIBUNG` varchar(200) DEFAULT NULL,
  `DAUER` int DEFAULT NULL,
  `DONTLEAVE` tinyint(1) DEFAULT '0',
  `FEEDBACK` int DEFAULT NULL,
  `FIXREIHENFOLGE` tinyint(1) DEFAULT '0',
  `FOCUSLOSTONSIZECHANGE` tinyint(1) DEFAULT '0',
  `FRAGENMISCHEN` tinyint(1) DEFAULT '0',
  `GEWICHTUNG` double DEFAULT NULL,
  `GLOBALUNITS` tinyint(1) DEFAULT '0',
  `MODUS` int DEFAULT NULL,
  `ONRAMP` tinyint(1) DEFAULT '0',
  `PASSWORD` varchar(255) DEFAULT NULL,
  `PDFFORSTUDENT` tinyint(1) DEFAULT '0',
  `PUNKTE` int DEFAULT NULL,
  `SHOWUNITS` int DEFAULT NULL,
  `START` tinyint(1) DEFAULT '0',
  `STOP` tinyint(1) DEFAULT '0',
  `TESTDATUM` datetime DEFAULT NULL,
  `TESTNR` int DEFAULT NULL,
  `TESTRESULTS` int DEFAULT NULL,
  `TESTSTART` datetime DEFAULT NULL,
  `TESTSTOP` datetime DEFAULT NULL,
  `UNITGRADINGTYPE` int DEFAULT NULL,
  `UNITPENALTY` double DEFAULT NULL,
  `UNITSLEFT` int DEFAULT NULL,
  `BEURTEILUNGSART_ID` int DEFAULT NULL,
  `idGruppierung` int DEFAULT NULL,
  `MODE_ID` int DEFAULT NULL,
  `tests_ORDER` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_tests_MODE_ID` (`MODE_ID`),
  KEY `FK_tests_BEURTEILUNGSART_ID` (`BEURTEILUNGSART_ID`),
  KEY `FK_tests_idGruppierung` (`idGruppierung`),
  CONSTRAINT `FK_tests_BEURTEILUNGSART_ID` FOREIGN KEY (`BEURTEILUNGSART_ID`) REFERENCES `beurteilungsart` (`id`),
  CONSTRAINT `FK_tests_idGruppierung` FOREIGN KEY (`idGruppierung`) REFERENCES `gruppierung` (`id`),
  CONSTRAINT `FK_tests_MODE_ID` FOREIGN KEY (`MODE_ID`) REFERENCES `beurteilungsartGlobal` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tests`
--

LOCK TABLES `tests` WRITE;
/*!40000 ALTER TABLE `tests` DISABLE KEYS */;
/*!40000 ALTER TABLE `tests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` int NOT NULL AUTO_INCREMENT,
  `IDABTEILUNG` int DEFAULT NULL,
  `SVNR` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `ACTIVEDIRECTORYNAME` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `BIRTHDATE` date DEFAULT NULL,
  `CHANGEABOSPOSSIBLE` tinyint(1) DEFAULT '0',
  `DISABLED` tinyint(1) DEFAULT '0',
  `EMAIL` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `HTLID` int DEFAULT NULL,
  `ISADMIN` tinyint(1) DEFAULT '0',
  `ISEXTERN` tinyint(1) DEFAULT '0',
  `ISGLOBAL` tinyint(1) DEFAULT '0',
  `ISMANN` tinyint(1) DEFAULT '0',
  `ISSTUDENT` tinyint(1) DEFAULT '0',
  `ISTEACHER` tinyint(1) DEFAULT '0',
  `LICENCE` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `MULTIPLELOGIN` tinyint(1) DEFAULT '0',
  `NACHNAME` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `NAME` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `PASSWORD` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `PASSWORT` varchar(40) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  `PAYINGSTUDENT` tinyint(1) DEFAULT '0',
  `PERSNO` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `SASSID` bigint DEFAULT NULL,
  `SOKRATESID` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `SVNPASSWORT` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `TEL` varchar(40) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `TEMPPASSWORT` varchar(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `USEABOSCATEGORY` tinyint(1) DEFAULT '0',
  `USEABOSUSERS` tinyint(1) DEFAULT '0',
  `USECURRENTYEAR` tinyint(1) DEFAULT '0',
  `USESCHOOLLICENCE` tinyint(1) DEFAULT '0',
  `VORNAME` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `idSchule` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_user_idSchule` (`idSchule`),
  CONSTRAINT `FK_user_idSchule` FOREIGN KEY (`idSchule`) REFERENCES `schule` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` VALUES (1,0,NULL,'',NULL,0,0,NULL,0,0,0,1,0,0,0,NULL,0,NULL,'admin',NULL,'21232f297a57a5a743894ae4a801fc3',0,NULL,0,NULL,'XBCyKZtA2iDaCv9',NULL,'',0,0,0,0,NULL,NULL),(2,0,'','',NULL,0,0,'',0,1,0,0,0,0,1,NULL,0,'adminschule','adminschule','','cb6836d9565bb285785ba9461ace3524',0,NULL,0,'','6scdOxY6itCnZPH',NULL,'adminschule',0,0,0,0,'',1);
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_category`
--

DROP TABLE IF EXISTS `user_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_category` (
  `User_ID` int NOT NULL,
  `aboCategories_ID` int NOT NULL,
  PRIMARY KEY (`User_ID`,`aboCategories_ID`),
  KEY `FK_user_category_aboCategories_ID` (`aboCategories_ID`),
  CONSTRAINT `FK_user_category_aboCategories_ID` FOREIGN KEY (`aboCategories_ID`) REFERENCES `category` (`id`),
  CONSTRAINT `FK_user_category_User_ID` FOREIGN KEY (`User_ID`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_category`
--

LOCK TABLES `user_category` WRITE;
/*!40000 ALTER TABLE `user_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_user`
--

DROP TABLE IF EXISTS `user_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_user` (
  `bookedAboUsers_ID` int NOT NULL,
  `aboUsers_ID` int NOT NULL,
  PRIMARY KEY (`bookedAboUsers_ID`,`aboUsers_ID`),
  KEY `FK_user_user_aboUsers_ID` (`aboUsers_ID`),
  CONSTRAINT `FK_user_user_aboUsers_ID` FOREIGN KEY (`aboUsers_ID`) REFERENCES `user` (`id`),
  CONSTRAINT `FK_user_user_bookedAboUsers_ID` FOREIGN KEY (`bookedAboUsers_ID`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_user`
--

LOCK TABLES `user_user` WRITE;
/*!40000 ALTER TABLE `user_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_user` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-10-01  9:46:27
