/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setup.dto.ajax.AjaxCmdOutputResult;
import at.letto.setup.dto.ajax.AjaxEditSchoolSetButtonsDto;
import at.letto.setup.dto.ajax.AjaxWelcomeInfo;
import at.letto.setupservice.beans.SchoolEditBean;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LoginService;
import at.letto.tools.Datum;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.sql.Connection;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Ajax Controller", description="Ajax-Anfagen vom Setup-Service")
public class AjaxController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DatabaseService databaseService;
    @Autowired
    private LoginService loginService;
    @Resource(name="schoolEditBean")
    SchoolEditBean schoolEditBean;

    @Operation(summary="Liefert die Ergebnisse der letzten Systemanalyse wenn das Service in einem Docker-Container l\u00e4uft.", parameters={@Parameter(description="keine Parameter")}, hidden=true, externalDocs=@ExternalDocumentation(url="../doc/javadoc-client/index.html", description="JavaDOC"))
    @GetMapping(value={"/config/open/ajax/analyzedocker"})
    public String analyzeDockerDocker() {
        return this.analyzeDocker();
    }

    @Operation(summary="Liefert die Ergebnisse der letzten Systemanalyse wenn das Service in lokal l\u00e4uft.", parameters={@Parameter(description="keine Parameter")}, hidden=true, externalDocs=@ExternalDocumentation(url="../doc/javadoc-client/index.html", description="JavaDOC"))
    @GetMapping(value={"/setup/open/ajax/analyzedocker"})
    public String analyzeDocker() {
        this.loginService.updateSessionToken();
        String ret = "" + this.dockerService.isAnalyzeRunning();
        return ret;
    }

    @Operation(summary="Liefert die Ergebnisse der letzten Systemanalyse wenn das Service in einem Docker-Container l\u00e4uft.", hidden=true, externalDocs=@ExternalDocumentation(url="../doc/javadoc-client/at/letto/setup/dto/AjaxEditSchoolSetButtonsDto.html", description="Result JavaDOC"), security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/session/admin/ajax/editschoolsetbuttons"})
    public ResponseEntity<AjaxEditSchoolSetButtonsDto> editschoolSetButtonsDocker(@RequestParam String school, @RequestParam String importfile, @RequestParam String mysqlhost, @RequestParam String mysqldb, @RequestParam String mysqluser, @RequestParam String mysqlpw) {
        return this.editschoolSetButtons(school, importfile, mysqlhost, mysqldb, mysqluser, mysqlpw);
    }

    @Operation(summary="Liefert die Ergebnisse der letzten Systemanalyse wenn das Service lokal l\u00e4uft.", hidden=true, externalDocs=@ExternalDocumentation(url="../doc/javadoc-client/at/letto/setup/dto/AjaxEditSchoolSetButtonsDto.html", description="Result JavaDOC"), security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/session/admin/ajax/editschoolsetbuttons"})
    public ResponseEntity<AjaxEditSchoolSetButtonsDto> editschoolSetButtons(@RequestParam String school, @RequestParam String importfile, @RequestParam String mysqlhost, @RequestParam String mysqldb, @RequestParam String mysqluser, @RequestParam String mysqlpw) {
        Connection con;
        this.loginService.updateSessionToken();
        AjaxEditSchoolSetButtonsDto resultDto = new AjaxEditSchoolSetButtonsDto();
        String string = school = school == null ? "" : school.trim();
        if (this.schoolEditBean.isEdit() && school.length() == 0) {
            school = this.schoolEditBean.getSchool();
        }
        String string2 = mysqlhost = mysqlhost == null ? "" : mysqlhost.trim();
        if (mysqlhost.length() == 0) {
            mysqlhost = "letto-mysql.nw-letto";
        }
        Object object = mysqldb = mysqldb == null ? "" : ((String)mysqldb).trim();
        if (((String)mysqldb).length() == 0) {
            mysqldb = "letto_" + school;
        }
        mysqluser = mysqluser == null ? "" : mysqluser.trim();
        mysqlpw = mysqlpw == null ? "" : mysqlpw.trim();
        boolean useImportFile = importfile != null && importfile.trim().length() > 0;
        boolean isSchoolOk = school.length() > 1;
        boolean existDb = false;
        boolean isDbLoginOk = false;
        for (Object s : this.dockerService.getSchulen()) {
            if (!s.getShortname().equals(school)) continue;
            isSchoolOk = false;
            if (!this.schoolEditBean.isAdd()) continue;
            resultDto.setMsgNeuSchoolExist(true);
        }
        boolean existBackup = false;
        for (FileInfoDto dto : this.dockerService.getDatabaseDumpFiles()) {
            if (!dto.getFilename().equals("letto_" + school + ".sql")) continue;
            existBackup = true;
        }
        isDbLoginOk = this.databaseService.checkConnection(mysqlhost, mysqluser, mysqlpw);
        resultDto.setMsgLoginFail(!isDbLoginOk);
        if (isDbLoginOk && (con = this.databaseService.getConnection(mysqlhost, (String)mysqldb, mysqluser, mysqlpw)) != null) {
            if (this.databaseService.existsDatabase(con, (String)mysqldb) && this.databaseService.countTables(con) > 0) {
                existDb = true;
                if (this.schoolEditBean.isAdd()) {
                    resultDto.setMsgNeuExistDb(true);
                }
            }
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.schoolEditBean.isAdd()) {
            resultDto.setButtonNeuAnlegen(isSchoolOk && !existDb && !useImportFile);
            resultDto.setButtonNeuDeleteDb(isSchoolOk && existDb && !useImportFile);
            resultDto.setButtonNeuUseDb(isSchoolOk && existDb && !useImportFile);
            resultDto.setButtonNeuImportDb(isSchoolOk && useImportFile);
            resultDto.setViewSchoolData(isSchoolOk && !useImportFile);
        }
        if (this.schoolEditBean.isEdit()) {
            resultDto.setButtonImportLastBackup(existDb && !useImportFile && existBackup);
            resultDto.setButtonImportDb(existDb && useImportFile);
            resultDto.setViewSchoolData(!useImportFile);
        }
        return ResponseEntity.ok((Object)resultDto);
    }

    @Operation(summary="WelcomeInfo wenn das Service in Docker l\u00e4uft.", hidden=true, security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/session/admin/ajax/welcomeinfo"})
    public ResponseEntity<AjaxWelcomeInfo> welcomeInfoDocker() {
        return this.welcomeInfo();
    }

    @Operation(summary="WelcomeInfo wenn das Service lokal l\u00e4uft.", hidden=true, security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/session/admin/ajax/welcomeinfo"})
    public ResponseEntity<AjaxWelcomeInfo> welcomeInfo() {
        this.loginService.updateSessionToken();
        AjaxWelcomeInfo resultDto = new AjaxWelcomeInfo();
        resultDto.setHtmlRevision(this.dockerService.htmlRevision());
        resultDto.setHtmlAnalyzeInfo(this.dockerService.isAnalyzeRunning() ? "Analyzing Docker" : "");
        resultDto.setHtmlLizenzserver(this.dockerService.isLicensServerAvailable() ? "<span style='color:green;'>OK</span>" : "<span style='color:red;'>FAIL</span>");
        resultDto.setHtmlDiskUsage(this.dockerService.htmlDiskUsage());
        resultDto.setHtmlJavaMemory(this.dockerService.htmlJavaMemoryUsage());
        resultDto.setHtmlCpuUsage(this.dockerService.htmlCpuUsage());
        resultDto.setHtmlMemory(this.dockerService.htmlMemoryUsage());
        resultDto.setHtmlSwap(this.dockerService.htmlSwapMemoryUsage());
        resultDto.setHtmlServices(this.dockerService.htmlServiceStatus());
        resultDto.setHtmlRunningTasks(this.analyzeService.runningTasks());
        resultDto.setHtmlInfoDockerPfade(this.dockerService.dockerPathOk());
        resultDto.setHtmlInfoMysqlDocker(this.dockerService.mysqlDockerStatus());
        resultDto.setRevLettoMysql(this.dockerService.rev("letto-mysql"));
        resultDto.setHtmlInfoSetupDocker(this.dockerService.setupDockerStatus());
        resultDto.setRevSetupDocker(this.dockerService.rev("letto-setup"));
        resultDto.setHtmlInfoLettoDocker(this.dockerService.lettoDockerStatus());
        resultDto.setRevLettoDocker("Login-" + this.dockerService.rev("letto-login") + ",Proxy-" + this.dockerService.rev("letto-proxy"));
        for (String service : this.dockerService.getInstalledServices()) {
            resultDto.getServices().add(new AjaxWelcomeInfo.AjaxServiceInfo(service, this.dockerService.serviceStatus(service), this.dockerService.rev("letto-" + service)));
        }
        resultDto.setHtmlInfoHttpsCertificate(this.dockerService.certInfo());
        resultDto.setHtmlInfoMysqlDatabase(this.dockerService.checkDockerDatabase());
        resultDto.setHtmlInfoMysqlLti(this.dockerService.checkDockerLTI());
        resultDto.setHtmlInfoLettoProxy(this.dockerService.dockerProxyOk());
        resultDto.setHtmlInfoRedirection(this.dockerService.baseRedirection());
        for (SchuleEnv schuleEnv : this.dockerService.getSchulenEnv()) {
            String school = schuleEnv.school;
            resultDto.getSchulen().add(new AjaxWelcomeInfo.AjaxWelcomeSchuleInfo(school, this.dockerService.checkDockerSchool(school), this.dockerService.licenseInfo(schuleEnv), this.dockerService.rev("letto-server-" + school), this.dockerService.rev("letto-data-" + school), this.dockerService.getHTMLschoolCpuLetto(school), this.dockerService.getHTMLschoolMemLetto(school), this.dockerService.getHTMLschoolCpuData(school), this.dockerService.getHTMLschoolMemData(school)));
        }
        resultDto.setServertime(Datum.formatDateTime((LocalDateTime)Datum.nowLocalDateTime()));
        return ResponseEntity.ok((Object)resultDto);
    }

    @Operation(summary="Cmd-Output wenn das Service in Docker l\u00e4uft.", hidden=true, security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/session/admin/ajax/cmdoutput"})
    public ResponseEntity<AjaxCmdOutputResult> cmdOutputDocker(@RequestParam String id) {
        return this.cmdOutputLocal(id);
    }

    @Operation(summary="Cmd-Output wenn das Service lokal l\u00e4uft.", hidden=true, security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/setup/session/admin/ajax/cmdoutput"})
    public ResponseEntity<AjaxCmdOutputResult> cmdOutputLocal(@RequestParam String id) {
        this.loginService.updateSessionToken();
        AjaxCmdOutputResult resultDto = new AjaxCmdOutputResult();
        CmdThread cmdThread = this.cmdService.getThread(id);
        if (id != null && cmdThread != null) {
            resultDto.setHtmlOutput(cmdThread.getHtmlOutput());
            resultDto.setHtmlThreadStatus(cmdThread.getThreadStatus().toString());
            resultDto.setHtmlTimeInfo(cmdThread.getTimeInfoHTML());
            resultDto.setFinished(cmdThread.isFinished());
        } else {
            resultDto.setError(true);
        }
        return ResponseEntity.ok((Object)resultDto);
    }
}

