/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.databaseclient.modelMongo.login.LeTToSession;
import at.letto.databaseclient.modelMongo.login.LeTToUser;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.security.LettoToken;
import at.letto.setupservice.config.MicroServiceConfiguration;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class SetupUserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(SetupUserDetailsService.class);
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    LettoUserLoginService lettoUserLoginService;
    @Value(value="${ADMIN_PASSWORD:}")
    private String setupAdminPassword;
    @Value(value="${ADMIN_PASSWORD_ENCRYPTED:}")
    protected String setupAdminPasswordEncrypted;
    @Value(value="${letto.user.admin.password:}")
    private String setupLocalAdminPassword;

    public LettoToken checkSetupUsernamePassword(String username, String password, String fingerprint, String clientIpAddress, String service, String infos, String userAgent) {
        if (username.equals("admin") && new BCryptPasswordEncoder().matches((CharSequence)password, this.setupAdminPasswordEncrypted)) {
            ArrayList<String> roles = new ArrayList<String>();
            String[] rolesArray = "gast,user,admin,global".trim().split(",");
            roles.add("global");
            roles.add("admin");
            roles.add("teacher");
            roles.add("student");
            String school = this.microServiceConfiguration.isSetupDocker() ? "config" : "setup";
            int idschool = this.microServiceConfiguration.isSetupDocker() ? -1 : -2;
            String sessionID = this.lettoUserLoginService.newSessionID();
            LeTToUser leTToUser = this.lettoUserLoginService.getUser(school, username);
            if (leTToUser == null) {
                leTToUser = new LeTToUser();
            }
            LettoToken lettoToken = new LettoToken(this.microServiceConfiguration.getJwtSecret(), "LeTTo-Setup", "LeTTo", Long.valueOf(this.microServiceConfiguration.getJwtExpiration()), username, "", username, "", "", "de", Integer.valueOf(0), Integer.valueOf(idschool), school, "", "", sessionID, roles);
            this.lettoUserLoginService.createLeTToSession(sessionID, leTToUser, fingerprint, clientIpAddress, lettoToken, service, infos, userAgent);
            return lettoToken;
        }
        return null;
    }

    public LettoToken updateToken(LettoToken lettoToken) {
        LettoToken newLettoToken = lettoToken.refreshToken(this.microServiceConfiguration.getJwtSecret(), this.microServiceConfiguration.getJwtExpiration());
        if (newLettoToken != null) {
            LeTToUser leTToUser = this.lettoUserLoginService.getUser(newLettoToken);
            LeTToSession leTToSession = this.lettoUserLoginService.getSession(newLettoToken);
            if (leTToUser == null || leTToSession == null) {
                logger.error("Token konnte nicht erneuert werden, da User oder Session nicht gefunden wurde: " + lettoToken.getUsername());
                return newLettoToken;
            }
            leTToUser.setCurrentlyLoggedIn(true);
            if (this.lettoUserLoginService.addToken(leTToUser, leTToSession, newLettoToken)) {
                return newLettoToken;
            }
        }
        logger.error("Token konnte nicht erneuert werden f\u00fcr User " + lettoToken.getUsername());
        return lettoToken;
    }

    @Generated
    public String getSetupAdminPassword() {
        return this.setupAdminPassword;
    }

    @Generated
    public void setSetupAdminPassword(String setupAdminPassword) {
        this.setupAdminPassword = setupAdminPassword;
    }

    @Generated
    public String getSetupAdminPasswordEncrypted() {
        return this.setupAdminPasswordEncrypted;
    }

    @Generated
    public void setSetupAdminPasswordEncrypted(String setupAdminPasswordEncrypted) {
        this.setupAdminPasswordEncrypted = setupAdminPasswordEncrypted;
    }

    @Generated
    public String getSetupLocalAdminPassword() {
        return this.setupLocalAdminPassword;
    }

    @Generated
    public void setSetupLocalAdminPassword(String setupLocalAdminPassword) {
        this.setupLocalAdminPassword = setupLocalAdminPassword;
    }
}

