/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.basespringboot.cmd.CmdDto;
import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.controller.Msg;
import at.letto.setupservice.controller.MsgType;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.UpdateService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CommandController {
    @Autowired
    private SetupConfiguration setupConfiguration;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DockerService dockerService;

    @RequestMapping(value={"/config/session/admin/cmd"})
    public String cmdDocker(@ModelAttribute CmdDto cmdDto, HttpServletRequest request, Model model) {
        return this.cmd(cmdDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/cmd"})
    public String cmdLocal(@ModelAttribute CmdDto cmdDto, HttpServletRequest request, Model model) {
        return this.cmd(cmdDto, request, model);
    }

    public String cmd(@ModelAttribute CmdDto cmdDto, HttpServletRequest request, Model model) {
        model.addAttribute("cmdControl", (Object)this);
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = cmdDto.getUserAction();
        if (button != null) {
            CmdThread cmdThread;
            CmdThread cmdThread2;
            if (button.equals("ok")) {
                Object cmd = "";
                if (cmdDto.getCmdline() != null && cmdDto.getCmdline().length() > 0) {
                    cmd = (String)cmd + cmdDto.getCmdline();
                }
                if (cmdDto.getCmd() != null && cmdDto.getCmd().length() > 0) {
                    cmd = (String)cmd + (((String)cmd).length() > 0 ? "\n" : "") + cmdDto.getCmd();
                }
                if (((String)cmd).length() > 0) {
                    cmdThread2 = this.cmdService.cmdScriptBackgroundTL(this.dockerService.cmdEP(), "cmd", cmdDto.getHomedir(), new String[]{cmd});
                    model.addAttribute("cmdDto", (Object)cmdDto);
                    if (cmdThread2 != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread2);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        model.addAttribute("action", (Object)this.dockerService.cmdOutputEP());
                        model.addAttribute("cmdControl", (Object)this);
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)("Command konnte nicht durchgef\u00fchrt werden! " + (String)cmd), (String)"");
                }
            }
            if (button.equals("back")) {
                return "redirect:" + this.dockerService.welcomeEP();
            }
            Matcher m = Pattern.compile("^open(\\d+)$").matcher(button);
            if (m.find() && (cmdThread = this.cmdService.getThread(m.group(1))) != null) {
                cmdThread.backlink(this.dockerService.cmdEP());
                cmdThread.template("");
                return this.cmdService.opencmd(model, this.dockerService.cmdEP(), cmdThread);
            }
            m = Pattern.compile("^stop(\\d+)$").matcher(button);
            if (m.find() && (cmdThread = this.cmdService.getThread(m.group(1))) != null) {
                cmdThread.stop();
            }
            if ((m = Pattern.compile("^remove(\\d+)$").matcher(button)).find() && (cmdThread = this.cmdService.getThread(m.group(1))) != null) {
                this.cmdService.removeThread(cmdThread);
            }
            if (button.equals("stop.all")) {
                for (int i = 0; i < this.cmdService.getThreads().size(); ++i) {
                    cmdThread2 = (CmdThread)this.cmdService.getThreads().get(i);
                    cmdThread2.stop();
                }
            }
            if (button.equals("remove.finished")) {
                for (int i = 0; i < this.cmdService.getThreads().size(); ++i) {
                    cmdThread2 = (CmdThread)this.cmdService.getThreads().get(i);
                    if (cmdThread2.isFinished()) {
                        this.cmdService.removeThread(cmdThread2);
                    }
                    --i;
                }
            }
            if (button.equals("remove.all")) {
                while (this.cmdService.getThreads().size() > 0) {
                    this.cmdService.removeThread((CmdThread)this.cmdService.getThreads().get(0));
                }
            }
        } else {
            cmdDto.setCmd("");
            cmdDto.setHomedir(this.analyzeService.getUserDir());
        }
        model.addAttribute("cmdDto", (Object)cmdDto);
        model.addAttribute("threads", (Object)this.cmdService.getThreads());
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "cmd";
    }

    @RequestMapping(value={"/config/session/admin/cmdoutput"})
    public String cmdoutputDocker(@ModelAttribute CmdDto cmdDto, Model model) {
        return this.cmdoutput(cmdDto, model);
    }

    @RequestMapping(value={"/setup/session/admin/cmdoutput"})
    public String cmdoutputLocal(@ModelAttribute CmdDto cmdDto, Model model) {
        return this.cmdoutput(cmdDto, model);
    }

    private String cmdoutput(@ModelAttribute CmdDto cmdDto, Model model) {
        model.addAttribute("cmdControl", (Object)this);
        CmdThread cmdThread = this.cmdService.getThread(cmdDto.getId());
        String button = cmdDto.getUserAction();
        if (button != null) {
            switch (button) {
                case "ok": {
                    if (cmdThread == null || cmdThread.getBacklink() == null || cmdThread.getBacklink().length() < 1 && cmdThread.getTemplate().length() < 1) {
                        return "redirect:" + this.dockerService.welcomeEP();
                    }
                    if (cmdThread.getTemplate().length() > 1) {
                        model.addAttribute("cmdDto", (Object)cmdDto);
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        model.addAttribute("config", (Object)this.setupConfiguration.getConf());
                        model.addAttribute("analyzeService", (Object)this.analyzeService);
                        model.addAttribute("updateService", (Object)this.updateService);
                        model.addAttribute("dockerService", (Object)this.dockerService);
                        model.addAttribute("dockerConfiguration", (Object)this.dockerConfiguration);
                        return cmdThread.getTemplate();
                    }
                    return "redirect:" + cmdThread.getBacklink();
                }
                case "refreshButton": {
                    break;
                }
                case "stop": {
                    cmdThread.htmlErr("try to stop process");
                    cmdThread.stop();
                    if (cmdThread.isFinished()) {
                        cmdThread.htmlErr("process stopped by user");
                        break;
                    }
                    cmdThread.htmlErr("cannot stop process");
                }
            }
        } else {
            cmdDto.setCmd("");
            cmdDto.setHomedir(this.analyzeService.getUserDir());
        }
        model.addAttribute("cmdDto", (Object)cmdDto);
        model.addAttribute("cmdThread", (Object)cmdThread);
        model.addAttribute("cmdControl", (Object)this);
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "cmdoutput";
    }

    public String getCmdOutputTemplate(Model model, CmdThread cmdThread) {
        model.addAttribute("cmdDto", (Object)cmdThread.getCmdDto());
        model.addAttribute("cmdThread", (Object)cmdThread);
        model.addAttribute("threads", (Object)this.cmdService.getThreads());
        model.addAttribute("cmdControl", (Object)this);
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "cmdoutput";
    }
}

