/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.beans.FileEditBean;
import at.letto.setupservice.controller.FileEditController;
import at.letto.setupservice.controller.FileViewController;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.model.ExplorerModel;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.UploadService;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ExplorerController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private FileEditController fileEditController;
    @Autowired
    private FileViewController fileViewController;
    @Autowired
    private UploadService uploadService;
    @Resource(name="fileEditBean")
    FileEditBean fileEditBean;
    private ExplorerModel explorerModel = null;

    public ExplorerModel loadExplorerModel(String dir) {
        File f = new File(dir);
        return this.loadExplorerModel(f);
    }

    public ExplorerModel loadExplorerModel(File folder) {
        File[] listOfFiles;
        ExplorerModel em = new ExplorerModel();
        em.setDirectoryName(folder.getAbsolutePath());
        if (folder.exists() && (listOfFiles = folder.listFiles()) != null) {
            for (File file : listOfFiles) {
                if (file.isFile()) {
                    em.getFileList().add(new FileInfoDto(file));
                    continue;
                }
                if (!file.isDirectory()) continue;
                em.getDirectoryList().add(new FileInfoDto(file));
            }
        }
        String[] dirs = folder.getAbsolutePath().split("[\\\\\\/]");
        Object actdir = "";
        for (int i = 0; i < dirs.length; ++i) {
            String d = dirs[i];
            actdir = i == 0 ? d + "/" : (String)actdir + d + "/";
            File f = new File((String)actdir);
            FileInfoDto fileInfoDto = new FileInfoDto(f);
            if (em.getParentList().size() == 0 && fileInfoDto.getFilename().length() == 0) {
                fileInfoDto.setFilename(d);
            }
            em.getParentList().add(fileInfoDto);
        }
        Collections.sort(em.getFileList());
        Collections.sort(em.getDirectoryList());
        return em;
    }

    public String redirectExplorer(String dir, Model model) {
        File f = new File(dir);
        return this.redirectExplorer(f, model);
    }

    public String redirectExplorer(File dir, Model model) {
        this.explorerModel = this.loadExplorerModel(dir);
        return this.explorerLocal(this.explorerModel, model);
    }

    @RequestMapping(value={"/config/session/admin/explorer"})
    public String explorerDocker(@ModelAttribute ExplorerModel explorerModel, Model model) {
        return this.explorerLocal(explorerModel, model);
    }

    @RequestMapping(value={"/setup/session/admin/explorer"})
    public String explorerLocal(@ModelAttribute ExplorerModel explorerModel, Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("action", (Object)this.dockerService.explorerEP());
        model.addAttribute("actionupload", (Object)this.dockerService.explorerUploadEP());
        Object msg = "";
        String button = explorerModel.getUserAction();
        String commitedAction = explorerModel.getCommitedAction();
        if (commitedAction != null && commitedAction.trim().length() > 0) {
            button = commitedAction;
        }
        explorerModel.setCommitedAction(null);
        if (button == null) {
            if (explorerModel.getDirectoryName() == null || explorerModel.getDirectoryName().trim().length() == 0) {
                explorerModel = this.explorerModel.getDirectoryName() == null || this.explorerModel.getDirectoryName().trim().length() == 0 ? this.loadExplorerModel(this.dockerService.getDockerPath()) : this.loadExplorerModel(this.explorerModel.getDirectoryName());
            }
        } else {
            String dirName;
            if (button.contains(",")) {
                button = button.split(",")[0];
            }
            if ((dirName = explorerModel.getDirectoryName()) != null && dirName.contains(",")) {
                dirName = dirName.split(",")[0];
            }
            block11 : switch (button) {
                case "refresh": {
                    break;
                }
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "deletedir": {
                    File f = new File(dirName);
                    FileInfoDto fileInfoDto = new FileInfoDto(f);
                    try {
                        Files.delete(f.toPath());
                        dirName = f.getParentFile().getAbsolutePath();
                        explorerModel.setDirectoryName(dirName);
                    }
                    catch (Exception ex) {
                        msg = "cannot delete directory " + f.getAbsolutePath();
                    }
                    break;
                }
                case "createdir": {
                    File f = new File(dirName + "/" + explorerModel.getNewDir());
                    try {
                        f.mkdirs();
                        dirName = f.getAbsolutePath();
                        explorerModel.setDirectoryName(dirName);
                    }
                    catch (Exception ex) {
                        msg = "cannot create directory " + f.getAbsolutePath();
                    }
                    break;
                }
                case "createfile": {
                    File f = new File(dirName + "/" + explorerModel.getNewFile());
                    try {
                        f.createNewFile();
                    }
                    catch (Exception ex) {
                        msg = "cannot create file " + f.getAbsolutePath();
                    }
                    break;
                }
                default: {
                    Matcher m = Pattern.compile("^([a-zA-Z]+)-(.*)$").matcher(button);
                    if (!m.find()) break;
                    String command = m.group(1);
                    String filename = m.group(2);
                    switch (command) {
                        case "parent": {
                            String template = this.redirectExplorer(filename, model);
                            if (template == null || template.length() == 0) {
                                msg = "Cannot open directory " + filename;
                                break block11;
                            }
                            return template;
                        }
                        case "diropen": {
                            String template = this.redirectExplorer(dirName + "/" + filename, model);
                            if (template == null || template.length() == 0) {
                                msg = "Cannot open directory " + filename;
                                break block11;
                            }
                            return template;
                        }
                        case "dirdelete": {
                            File f = new File(dirName + "/" + filename);
                            if (!f.exists()) break block11;
                            f.delete();
                            break block11;
                        }
                        case "filedownload": {
                            File f = new File(dirName + "/" + filename);
                            if (f.exists()) {
                                DownloadFile df = this.downloadService.newDownloadGlobal(f);
                                return "redirect:" + this.dockerService.globalDownloadEP() + "/" + df.getId();
                            }
                            msg = "File " + filename + " not found!";
                            break block11;
                        }
                        case "filedelete": {
                            File f = new File(dirName + "/" + filename);
                            if (!f.exists()) break block11;
                            f.delete();
                            break block11;
                        }
                        case "filecopydump": {
                            File f = new File(dirName + "/" + filename);
                            File target = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                            try {
                                Files.copy(f.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                msg = "OK: Datei " + filename + " erfolgreich kopiert nach " + target.getAbsolutePath();
                            }
                            catch (IOException e) {
                                msg = "cannot copy to " + target.getAbsolutePath();
                            }
                            break block11;
                        }
                        case "fileview": {
                            File f = new File(dirName + "/" + filename);
                            return this.fileViewController.viewFile(f, model, this.dockerService.explorerEP());
                        }
                        case "fileedit": {
                            File f = new File(dirName + "/" + filename);
                            FileInfoDto fileInfoDto = new FileInfoDto(f);
                            return this.fileEditController.editFile(f, model, this.dockerService.explorerEP());
                        }
                    }
                }
            }
            explorerModel = this.loadExplorerModel(dirName);
        }
        model.addAttribute("msg", msg);
        model.addAttribute("explorerModel", (Object)explorerModel);
        this.explorerModel = explorerModel;
        return "explorer";
    }

    @PostMapping(value={"/config/session/admin/explorerupload"})
    public String uploadFileDocker(Model model, @RequestParam MultipartFile file, @RequestParam String uploadDirectory, @RequestParam String uploadFilename) {
        return this.uploadFile(model, file, uploadDirectory, uploadFilename);
    }

    @PostMapping(value={"/setup/session/admin/explorerupload"})
    public String uploadFileLocal(Model model, @RequestParam MultipartFile file, @RequestParam String uploadDirectory, @RequestParam String uploadFilename) {
        return this.uploadFile(model, file, uploadDirectory, uploadFilename);
    }

    public String uploadFile(Model model, MultipartFile multipartFile, String uploadDirectory, String uploadFilename) {
        String msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("action", (Object)this.dockerService.explorerEP());
        model.addAttribute("actionupload", (Object)this.dockerService.explorerUploadEP());
        try {
            File file = this.uploadService.handleUpload(multipartFile, uploadDirectory, uploadFilename);
        }
        catch (Exception e) {
            msg = "cannot upload file!";
        }
        this.explorerModel = this.loadExplorerModel(uploadDirectory);
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("explorerModel", (Object)this.explorerModel);
        return "explorer";
    }
}

