/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.security.MessageService;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.login.dto.CheckLoginADResponseDto;
import at.letto.setupservice.beans.LdapBean;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.controller.http.UserInfoController;
import at.letto.setupservice.model.LdapModel;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LdapConfigController {
    private Logger logger = LoggerFactory.getLogger(UserInfoController.class);
    @Autowired
    private DockerService dockerService;
    @Autowired
    private LettoUserLoginService lettoUserLoginService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Resource(name="sessionBean")
    SessionBean sessionBean;
    @Resource(name="ldapBean")
    LdapBean ldapBean;

    public void loadLdapBean() {
        String doLogin;
        String doLogging;
        String domain;
        String ldapServer;
        String adServer;
        Integer mode;
        LettoEnvFile lettoEnvFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        this.ldapBean.setLdapMode(0);
        if (lettoEnvFile.containsKey("LDAP_MODE") && (mode = lettoEnvFile.getVarInteger("LDAP_MODE")) != null) {
            this.ldapBean.setLdapMode(mode.intValue());
        }
        this.ldapBean.setAdServer("");
        if (lettoEnvFile.containsKey("LDAP_AD_SERVER") && (adServer = lettoEnvFile.getVar("LDAP_AD_SERVER")) != null) {
            this.ldapBean.setAdServer(adServer);
        }
        this.ldapBean.setLdapServer("");
        if (lettoEnvFile.containsKey("LDAP_SERVER") && (ldapServer = lettoEnvFile.getVar("LDAP_SERVER")) != null) {
            this.ldapBean.setLdapServer(ldapServer);
        }
        this.ldapBean.setDomain("");
        if (lettoEnvFile.containsKey("LDAP_DOMAIN") && (domain = lettoEnvFile.getVar("LDAP_DOMAIN")) != null) {
            this.ldapBean.setDomain(domain);
        }
        this.ldapBean.setDoLogging(false);
        if (lettoEnvFile.containsKey("LDAP_LOGGING") && (doLogging = lettoEnvFile.getVar("LDAP_LOGGING")) != null) {
            switch (doLogging = doLogging.trim().toLowerCase()) {
                case "on": 
                case "true": 
                case "1": {
                    this.ldapBean.setDoLogging(true);
                    break;
                }
            }
        }
        this.ldapBean.setDoLdapLogin(false);
        if (lettoEnvFile.containsKey("LDAP_LOGIN") && (doLogin = lettoEnvFile.getVar("LDAP_LOGIN")) != null) {
            switch (doLogin = doLogin.trim().toLowerCase()) {
                case "on": 
                case "true": 
                case "1": {
                    this.ldapBean.setDoLdapLogin(true);
                    break;
                }
            }
        }
    }

    public void saveLdapBean() {
        LettoEnvFile lettoEnvFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        lettoEnvFile.setVar("LDAP_MODE", Integer.valueOf(this.ldapBean.getLdapMode()));
        lettoEnvFile.setVar("LDAP_AD_SERVER", this.ldapBean.getAdServer());
        lettoEnvFile.setVar("LDAP_SERVER", this.ldapBean.getLdapServer());
        lettoEnvFile.setVar("LDAP_DOMAIN", this.ldapBean.getDomain());
        lettoEnvFile.setVar("LDAP_LOGGING", this.ldapBean.isDoLogging() ? "on" : "off");
        lettoEnvFile.setVar("LDAP_LOGIN", this.ldapBean.isDoLdapLogin() ? "on" : "off");
    }

    public void loadLdapModel(LdapModel ldapModel) {
        String doLogin;
        String doLogging;
        String domain;
        String ldapServer;
        String adServer;
        Integer mode;
        LettoEnvFile lettoEnvFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        ldapModel.setLdapMode(0);
        if (lettoEnvFile.containsKey("LDAP_MODE") && (mode = lettoEnvFile.getVarInteger("LDAP_MODE")) != null) {
            ldapModel.setLdapMode(mode.intValue());
        }
        ldapModel.setAdServer("");
        if (lettoEnvFile.containsKey("LDAP_AD_SERVER") && (adServer = lettoEnvFile.getVar("LDAP_AD_SERVER")) != null) {
            ldapModel.setAdServer(adServer);
        }
        ldapModel.setLdapServer("");
        if (lettoEnvFile.containsKey("LDAP_SERVER") && (ldapServer = lettoEnvFile.getVar("LDAP_SERVER")) != null) {
            ldapModel.setLdapServer(ldapServer);
        }
        ldapModel.setDomain("");
        if (lettoEnvFile.containsKey("LDAP_DOMAIN") && (domain = lettoEnvFile.getVar("LDAP_DOMAIN")) != null) {
            ldapModel.setDomain(domain);
        }
        ldapModel.setDoLogging(false);
        if (lettoEnvFile.containsKey("LDAP_LOGGING") && (doLogging = lettoEnvFile.getVar("LDAP_LOGGING")) != null) {
            switch (doLogging = doLogging.trim().toLowerCase()) {
                case "on": 
                case "true": 
                case "1": {
                    ldapModel.setDoLogging(true);
                    break;
                }
            }
        }
        ldapModel.setDoLdapLogin(false);
        if (lettoEnvFile.containsKey("LDAP_LOGIN") && (doLogin = lettoEnvFile.getVar("LDAP_LOGIN")) != null) {
            switch (doLogin = doLogin.trim().toLowerCase()) {
                case "on": 
                case "true": 
                case "1": {
                    ldapModel.setDoLdapLogin(true);
                    break;
                }
            }
        }
    }

    public void saveLdapModel(LdapModel ldapModel) {
        LettoEnvFile lettoEnvFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        lettoEnvFile.setVar("LDAP_MODE", Integer.valueOf(ldapModel.getLdapMode()));
        lettoEnvFile.setVar("LDAP_AD_SERVER", ldapModel.getAdServer());
        lettoEnvFile.setVar("LDAP_SERVER", ldapModel.getLdapServer());
        lettoEnvFile.setVar("LDAP_DOMAIN", ldapModel.getDomain());
        lettoEnvFile.setVar("LDAP_LOGGING", ldapModel.isDoLogging() ? "on" : "off");
        lettoEnvFile.setVar("LDAP_LOGIN", ldapModel.isDoLdapLogin() ? "on" : "off");
    }

    @RequestMapping(value={"/config/session/admin/ldap"})
    public String users(@ModelAttribute LdapModel ldapModel, Model model) {
        String msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("action", (Object)"/config/session/admin/ldap");
        model.addAttribute("loginmsg", (Object)"");
        String button = ldapModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return "redirect:/config/session/admin/users";
                }
                case "save": {
                    this.saveLdapModel(ldapModel);
                    return "redirect:/config/session/admin/users";
                }
                case "reload": {
                    this.loadLdapModel(ldapModel);
                    break;
                }
                case "login": {
                    CheckLoginADResponseDto response = this.lettoService.getLoginService().checkUserPasswordAD(ldapModel.getUsername(), ldapModel.getPassword(), ldapModel.getAdServer(), ldapModel.getLdapServer(), ldapModel.getDomain(), Integer.valueOf(ldapModel.getLdapMode()));
                    String loginmsg = "Login " + (response.isSuccess() ? "OK" : "FAIL") + " ";
                    loginmsg = loginmsg + response.getConnectionInfo();
                    loginmsg = loginmsg + " SCHOOL:" + response.getSchool();
                    model.addAttribute("loginmsg", (Object)response.getHtmlInfo());
                }
            }
        } else {
            this.loadLdapModel(ldapModel);
        }
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("model", (Object)ldapModel);
        return "ldapconfig";
    }
}

