/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.service.microservice.AdminInfoDto;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.tools.ServerStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Tag(name="Info Controller", description="Informationen \u00fcber das Setup-Service und ping ")
public class InfoController {
    private final ApplicationContext applicationContext;
    private final TomcatConfiguration tomcatConfiguration;

    public InfoController(ApplicationContext applicationContext, TomcatConfiguration tomcatConfiguration) {
        this.applicationContext = applicationContext;
        this.tomcatConfiguration = tomcatConfiguration;
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/config/open/ping"})
    public ResponseEntity<String> pingPostOld() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/config/open/ping"})
    public ResponseEntity<String> pingGetOld() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/open/ping"})
    public ResponseEntity<String> pingPostLocalOld() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/setup/open/ping"})
    public ResponseEntity<String> pingGetLocalOld() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup als User, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/auth/user/ping"})
    public ResponseEntity<String> pingUL() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup als User, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/setup/auth/user/ping"})
    public ResponseEntity<String> pingULg() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup als Admin, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/auth/admin/ping"})
    public ResponseEntity<String> pingAL() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup als Admin, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/setup/auth/admin/ping"})
    public ResponseEntity<String> pingALg() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/config/ping"})
    public ResponseEntity<String> pingPost() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/ping"})
    public ResponseEntity<String> pingPostLocal() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'")
    @GetMapping(value={"/config/ping"})
    public ResponseEntity<String> pingGet() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'")
    @GetMapping(value={"/setup/ping"})
    public ResponseEntity<String> pingGetLocal() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/config/pingp"})
    public ResponseEntity<String> pingP(@RequestBody String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/pingp"})
    public ResponseEntity<String> pingPLocal(@RequestBody String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/config/pingg"})
    public ResponseEntity<String> pingG(@RequestParam String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @Operation(summary="externer Ping auf das lokale Setup, liefert immer 'pong'", hidden=true)
    @GetMapping(value={"/setup/pingg"})
    public ResponseEntity<String> pingGLocal(@RequestParam String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @Operation(summary="externer Ping auf das Setup im Docker Container als Admin, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/config/api/admin/ping"})
    public ResponseEntity<String> pingAdmin() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="externer Ping auf das lokale Setup als Admin, liefert immer 'pong'", hidden=true)
    @PostMapping(value={"/setup/api/admin/ping"})
    public ResponseEntity<String> pingAdminLocal() {
        return ResponseEntity.ok((Object)"pong");
    }

    @Operation(summary="liefert die Version des Setup-Services")
    @GetMapping(value={"/config/open/version"})
    public ResponseEntity<String> version() {
        return ResponseEntity.ok((Object)ServerStatus.getRevision());
    }

    @Operation(summary="liefert einen String als Info \u00fcber das Setup-Service")
    @GetMapping(value={"/config/open/info"})
    public ResponseEntity<String> info() {
        String applicationname = this.applicationContext.getId();
        String msg = "Application: " + applicationname;
        return ResponseEntity.ok((Object)msg);
    }

    @Operation(summary="Information f\u00fcr LeTTo", description="Liefert Information \u00fcber das Service f\u00fcr LeTTo <br>Result: [AdminInfoDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/service/microservice/AdminInfoDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/letto/infoletto"})
    public ResponseEntity<AdminInfoDto> lettoinfo() {
        return null;
    }

    @Operation(summary="Information f\u00fcr den Admin", description="Liefert Information \u00fcber das Service f\u00fcr den Admin <br>Result: [AdminInfoDto](https://build.letto.at/pluginuhr/open/javadoc/at/letto/service/microservice/AdminInfoDto.html)", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/config/auth/admin/info"})
    public ResponseEntity<AdminInfoDto> admininfo() {
        String pid = new ApplicationPid().toString();
        String applicationname = this.applicationContext.getId();
        String applicationhome = new ApplicationHome().toString();
        long uptime = System.currentTimeMillis() - this.applicationContext.getStartupDate();
        Object serverversion = ServerStatus.getServerVersion();
        serverversion = "Spring Boot " + SpringVersion.getVersion() + (String)(serverversion != null && ((String)serverversion).length() > 0 ? " , " + (String)serverversion : "");
        AdminInfoDto ret = new AdminInfoDto(applicationname, pid, applicationhome, this.applicationContext.getStartupDate(), uptime, ServerStatus.getRevision(), new Date().toString(), ServerStatus.getBetriebssystem(), ServerStatus.getIP(), ServerStatus.getEncoding(), ServerStatus.getFileEncoding(), ServerStatus.getFileSeparator(), ServerStatus.getJavaSpecificationVersion(), ServerStatus.getJavaVendor(), ServerStatus.getJavaVersion(), ServerStatus.getJavaVersionNumber(), ServerStatus.getHostname(), ServerStatus.getLanguage(), ServerStatus.getLinuxDescription(), ServerStatus.getLinuxDistribution(), ServerStatus.getLinuxRelease(), ServerStatus.getServerUsername(), (String)serverversion, ServerStatus.getSystemHome(), ServerStatus.isLinux(), ServerStatus.isUbuntu(), ServerStatus.isWindows(), this.tomcatConfiguration.getHttpPort(), this.tomcatConfiguration.getAjpPort(), this.tomcatConfiguration.getHttpsPort());
        return ResponseEntity.ok((Object)ret);
    }
}

