/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service.setupStorage;

import at.letto.setup.dto.config.ConfigServiceDto;
import at.letto.setupservice.service.DockerService;
import at.letto.tools.Cmd;
import at.letto.tools.FileMethods;
import at.letto.tools.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SetupStorageService {
    private DockerService dockerService;
    private static final String SETUP_FILE_PATH = "/opt/letto/docker/storage/setup";
    private static final String SERVICES_FILE = "/opt/letto/docker/storage/setup/services.json";
    private static final String CONFIG_FILE = "/opt/letto/docker/storage/setup/setup.conf";
    private static final long CHECK_INTERVAL_MS = 1000L;
    private long configFileLastModified = 0L;
    private long servicesFileLastModified = 0L;
    private HashMap<String, String> data = new HashMap();
    private Vector<ConfigServiceDto> services = new Vector();
    private long configLastCheck = 0L;
    private long servicesLastCheck = 0L;

    public SetupStorageService() {
        this.loadConfigFile();
        this.loadServicesFile();
        this.servicesFileLastModified = new File(SERVICES_FILE).lastModified();
        this.configFileLastModified = new File(CONFIG_FILE).lastModified();
    }

    private void checkConfigFile() {
        if (this.configLastCheck >= System.currentTimeMillis() - 1000L) {
            return;
        }
        if (this.configFileLastModified != new File(CONFIG_FILE).lastModified()) {
            this.loadConfigFile();
        }
    }

    private void loadConfigFile() {
        try {
            this.data = FileMethods.loadConfigFile((File)new File(CONFIG_FILE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.configFileLastModified = new File(CONFIG_FILE).lastModified();
    }

    private synchronized boolean writeConfigFile() {
        try {
            FileMethods.writeConfigFile((HashMap)this.data, (File)new File(CONFIG_FILE));
            this.configFileLastModified = new File(CONFIG_FILE).lastModified();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getConfig(String key) {
        this.checkConfigFile();
        return (String)this.data.get(key);
    }

    public Set<String> keysConfig() {
        this.checkConfigFile();
        return this.data.keySet();
    }

    public void putConfig(String key, String value) {
        this.data.put(key, value);
        this.writeConfigFile();
    }

    private synchronized void checkServicesFile() {
        if (this.servicesLastCheck >= System.currentTimeMillis() - 1000L) {
            return;
        }
        if (this.servicesFileLastModified != new File(SERVICES_FILE).lastModified()) {
            this.loadServicesFile();
        }
    }

    private void loadServicesFile() {
        try {
            Vector<ConfigServiceDto> services = new Vector<ConfigServiceDto>();
            for (String line : FileMethods.readFileInList((String)SERVICES_FILE)) {
                try {
                    ConfigServiceDto service = (ConfigServiceDto)JSON.jsonToObj((String)line, ConfigServiceDto.class);
                    services.add(service);
                }
                catch (Exception exception) {}
            }
            this.services = services;
            this.servicesFileLastModified = new File(SERVICES_FILE).lastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized boolean writeServicesFile() {
        try {
            Vector ls = this.services;
            Vector<String> data = new Vector<String>();
            for (ConfigServiceDto service : ls) {
                String line = JSON.objToJson((Object)service);
                line = line.replaceAll("\n", "");
                data.add(line);
            }
            Cmd.writelnfile(data, (File)new File(SERVICES_FILE));
            this.servicesFileLastModified = new File(SERVICES_FILE).lastModified();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean addUpdateService(ConfigServiceDto service) {
        return this.addUpdateRemoveService(service, false);
    }

    public boolean removeService(ConfigServiceDto service) {
        return this.addUpdateRemoveService(service, true);
    }

    private synchronized boolean addUpdateRemoveService(ConfigServiceDto service, boolean remove) {
        this.checkServicesFile();
        for (int i = 0; i < this.services.size(); ++i) {
            ConfigServiceDto s = (ConfigServiceDto)this.services.get(i);
            if ((service.getDockerName() == null || service.getDockerName().trim().length() <= 0 || s.getDockerName() == null || !service.getDockerName().trim().equals(s.getDockerName().trim())) && (service.getUriExtern() == null || service.getUriExtern().trim().length() <= 0 || s.getUriExtern() == null || !service.getUriExtern().trim().equals(s.getUriExtern().trim()))) continue;
            if (remove) {
                this.services.remove(i);
            } else {
                this.services.set(i, service);
            }
            this.writeServicesFile();
            return true;
        }
        if (service.getDockerName() != null && service.getDockerName().trim().length() > 0 || service.getUriExtern() != null && service.getUriExtern().trim().length() > 0) {
            this.services.add(service);
            this.writeServicesFile();
            return false;
        }
        throw new RuntimeException("Service hat weder Dockername noch externe URI und kann deshalb nicht angelegt oder gel\u00f6scht werden!");
    }

    public ConfigServiceDto getServiceByDockerName(String name) {
        this.checkServicesFile();
        Vector ls = this.services;
        for (ConfigServiceDto service : ls) {
            if (!service.getDockerName().equals(name)) continue;
            return service;
        }
        return null;
    }

    public List<ConfigServiceDto> getServicesByName(String name) {
        this.checkServicesFile();
        ArrayList<ConfigServiceDto> services = new ArrayList<ConfigServiceDto>();
        Vector ls = this.services;
        for (ConfigServiceDto service : ls) {
            if (!service.getName().equals(name)) continue;
            services.add(service);
        }
        return services;
    }

    public List<ConfigServiceDto> getPlugins() {
        this.checkServicesFile();
        ArrayList<ConfigServiceDto> services = new ArrayList<ConfigServiceDto>();
        Vector ls = this.services;
        for (ConfigServiceDto service : ls) {
            if (!service.isPlugin()) continue;
            services.add(service);
        }
        return services;
    }

    public List<ConfigServiceDto> getServices() {
        this.checkServicesFile();
        ArrayList<ConfigServiceDto> services = new ArrayList<ConfigServiceDto>();
        Vector ls = this.services;
        for (ConfigServiceDto service : ls) {
            services.add(service);
        }
        return services;
    }

    @Generated
    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }
}

