/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.service.BackupService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.CrontabService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DockerStatsService;
import at.letto.setupservice.service.LogFileService;
import at.letto.setupservice.service.LoginService;
import at.letto.setupservice.service.WatchdogService;
import at.letto.tools.Cmd;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
public class CrontabConfiguration {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private LogFileService logFileService;
    @Autowired
    private WatchdogService watchdogService;
    @Autowired
    private DockerStatsService dockerStatsService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private CrontabService crontabService;
    private Logger logger = LoggerFactory.getLogger(CrontabConfiguration.class);
    private volatile boolean everyMinuteRunning = false;
    private int lastMinute = -1;
    private volatile boolean checkSessionsRunning = false;
    private HashMap<CmdThread, Boolean> cmdFinished = new HashMap();

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(8);
        scheduler.setThreadNamePrefix("ScheduledTask-");
        scheduler.initialize();
        return scheduler;
    }

    @Scheduled(cron="0 0/30 * * * ?")
    public void every30Minutes() {
    }

    @Scheduled(cron="0 0 5 * * ?")
    public void everyMorning() {
        this.logger.info(this.dockerService.isMainSetupService() ? "Running as MAIN-Setup" : "Running as SLAVE-Setup");
        this.logger.info("Check Harddisk and Database-Dump");
        this.crontabService.checkHarddiskMemory();
        this.crontabService.checkDatabaseDump();
    }

    @Scheduled(cron="0 0 4 * * ?")
    public void backEnvFilesCronjob() {
        if (this.dockerService.isDockerRunning()) {
            this.backupService.backupEnvFiles();
        }
    }

    @Scheduled(cron="0/1 * * * * ?")
    public void everySecond() {
        this.dockerService.calcCpuUsage();
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void everyMinuteAnalyseCronjob() {
        try {
            if (this.everyMinuteRunning) {
                this.logger.info("every-minute cronjob still running - job not started");
                return;
            }
            this.everyMinuteRunning = true;
            Date actualDate = new Date();
            this.dockerService.analyzeFirst();
            this.dockerService.checkMainSetupService();
            Calendar cal = Calendar.getInstance();
            cal.setTime(actualDate);
            int m = cal.get(12);
            if (this.dockerService.isDockerRunning()) {
                m += 5;
            }
            if (m % 10 == 0) {
                Thread thread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                thread.start();
            }
            int timeMinute = cal.get(12) + cal.get(11) * 60;
            if (this.lastMinute > -1 && timeMinute < this.lastMinute) {
                try {
                    this.logFileService.archiveLogFiles();
                }
                catch (Exception e) {
                    this.logger.error("Exception beim Archivieren der Logfiles");
                    e.printStackTrace();
                }
                catch (Error er) {
                    this.logger.error("ERROR beim Archivieren der Logfiles");
                    er.printStackTrace();
                }
            }
            this.lastMinute = timeMinute;
            try {
                this.saveCmdLogFiles();
            }
            catch (Exception e) {
                this.logger.error("Exception beim Speichern der Logfiles");
                e.printStackTrace();
            }
            catch (Error er) {
                this.logger.error("ERROR beim Speichern der Logfiles");
                er.printStackTrace();
            }
            try {
                if (this.dockerService.isDockerRunning()) {
                    this.logFileService.logSystemStatus();
                }
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
        }
        catch (Exception e) {
            this.logger.error("Exception beim Start min\u00fctlichen Cronjob");
            e.printStackTrace();
        }
        catch (Error er) {
            this.logger.error("ERROR beim Start des min\u00fctlichen Cronjob");
            er.printStackTrace();
        }
        this.everyMinuteRunning = false;
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void backupCronjob() {
        try {
            this.backupService.cronEveryMinute();
        }
        catch (Exception e) {
            this.logger.error("Exception beim Start des Backup-Services");
            e.printStackTrace();
        }
        catch (Error er) {
            this.logger.error("ERROR beim Start des Backup-Services");
            er.printStackTrace();
        }
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void watchdogCronjob() {
        try {
            this.watchdogService.watchdog();
        }
        catch (Exception e) {
            this.logger.error("Exception beim Start des Watchdog-Services");
            e.printStackTrace();
        }
        catch (Error er) {
            this.logger.error("ERROR beim Start des Watchdog-Services");
            er.printStackTrace();
        }
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void checkSessionsAlive() {
        try {
            if (this.checkSessionsRunning) {
                this.logger.info("check sessions alive cronjob still running - job not started");
                return;
            }
            this.checkSessionsRunning = true;
            this.loginService.checkSessionsAlive();
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.checkSessionsRunning = false;
    }

    private boolean saveCmdThread(CmdThread cmdThread) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String filename = simpleDateFormat.format(cmdThread.getStartdate()) + "_" + (this.dockerService.isDockerRunning() ? "DOCKER_" : "HOST_") + Cmd.renameFile((String)cmdThread.getCommand()) + ".html";
            File file = new File(this.dockerService.getLogDirectoryPath() + "/setup/cmd");
            if (!file.exists()) {
                file.mkdirs();
            }
            file = new File(this.dockerService.getLogDirectoryPath() + "/setup/cmd/" + filename);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<h1>Background-Command</h1>command: " + cmdThread.getCommand() + "<br>\n");
            fileWriter.write("Status: <strong>" + String.valueOf(cmdThread.getThreadStatus()) + "</strong> " + cmdThread.getTimeInfoHTML() + "<br>\n");
            fileWriter.write("ID: " + cmdThread.getId() + "<br>\n<hr>\n");
            fileWriter.write(cmdThread.getHtmlOutput());
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void saveCmdLogFiles() {
        HashMap<CmdThread, Boolean> finished = new HashMap<CmdThread, Boolean>();
        for (CmdThread cmdThread : this.cmdService.getThreads()) {
            if (this.cmdFinished.containsKey(cmdThread)) {
                if (((Boolean)this.cmdFinished.get(cmdThread)).booleanValue()) continue;
                this.saveCmdThread(cmdThread);
                if (!cmdThread.isFinished()) continue;
                finished.put(cmdThread, true);
                continue;
            }
            this.saveCmdThread(cmdThread);
            finished.put(cmdThread, cmdThread.isFinished());
        }
        this.cmdFinished = finished;
    }
}

