/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.setupservice.beans.SchoolConfigBean;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.model.SchoolConfigDto;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerInstallService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LizenzService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SchoolConfigController {
    private Logger logger = LoggerFactory.getLogger(SchoolConfigController.class);
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DockerInstallService dockerInstallService;
    @Autowired
    private CommandController commandController;
    @Autowired
    private LizenzService lizenzService;
    @Autowired
    private DatabaseService databaseService;
    @Resource(name="schoolConfigBean")
    SchoolConfigBean schoolConfigBean;

    private void loadSchoolConfigDto() {
        SchoolConfigDto schoolConfigDto = new SchoolConfigDto();
        this.schoolConfigBean.setSchoolConfigDto(schoolConfigDto);
        this.schoolConfigBean.setLicenseKey(this.lizenzService.toLicenseKey(schoolConfigDto.getLizenz()));
    }

    public String load(Model model, int idSchool) {
        SchuleEnv schule = this.dockerService.getSchuleEnv(idSchool);
        SchoolConfigDto schoolConfigDto = new SchoolConfigDto();
        schoolConfigDto.setSchule(schule);
        schoolConfigDto.setSchulkuerzel(schule.school);
        schoolConfigDto.setSchulname(schule.schulname);
        schoolConfigDto.setLizenz(schule.licence);
        this.schoolConfigBean.setSchoolConfigDto(schoolConfigDto);
        this.schoolConfigBean.setLicenseKey(this.lizenzService.toLicenseKey(schoolConfigDto.getLizenz()));
        model.addAttribute("action", (Object)this.dockerService.schoolConfigEP());
        model.addAttribute("lizenz", (Object)this.schoolConfigBean.getLicenseKey());
        model.addAttribute("msg", (Object)"");
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("schoolConfigBean", (Object)this.schoolConfigBean);
        model.addAttribute("schoolConfigDto", (Object)schoolConfigDto);
        return "";
    }

    @RequestMapping(value={"/config/session/admin/schoolconfig"})
    public String schoolConfigDocker(@ModelAttribute SchoolConfigDto schoolConfigDto, HttpServletRequest request, Model model) {
        return this.schoolConfig(schoolConfigDto, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/schoolconfig"})
    public String schoolConfigLocal(@ModelAttribute SchoolConfigDto schoolConfigDto, HttpServletRequest request, Model model) {
        return this.schoolConfig(schoolConfigDto, request, model);
    }

    private String schoolConfig(@ModelAttribute SchoolConfigDto schoolConfigDto, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)this.dockerService.schoolConfigEP());
        model.addAttribute("lizenz", (Object)this.lizenzService.toLicenseKey(schoolConfigDto.getLizenz()));
        model.addAttribute("msg", (Object)"");
        model.addAttribute("dockerService", (Object)this.dockerService);
        String button = schoolConfigDto.getUserAction();
        String commitedAction = schoolConfigDto.getCommitedAction();
        if (commitedAction != null && commitedAction.trim().length() > 0) {
            button = commitedAction;
        }
        schoolConfigDto.setCommitedAction(null);
        String msg = "";
        Object cmdThread = null;
        String kzl = schoolConfigDto.getSchulkuerzel();
        if (kzl != null) {
            kzl = kzl.trim();
        }
        if (button != null) {
            switch (button) {
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "refresh": {
                    break;
                }
                case "neu_dbdelete": {
                    msg = "bestehende Datenbank l\u00f6schen und Schule neu anlegen noch nicht realisiert";
                    break;
                }
            }
        }
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("schoolConfigDto", (Object)schoolConfigDto);
        return "schoolconfig";
    }
}

